/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.plugin;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.HybridMobileStatus;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.config.Plugin;
import org.eclipse.thym.core.internal.cordova.CordovaProjectCLI;
import org.eclipse.thym.core.internal.util.EngineUtils;
import org.eclipse.thym.core.internal.util.XMLUtil;
import org.eclipse.thym.core.plugin.CordovaPlugin;
import org.eclipse.thym.core.plugin.CordovaPluginXMLHelper;
import org.eclipse.thym.core.plugin.PluginJavaScriptModule;
import org.eclipse.thym.core.plugin.PluginMessagesCLIResult;
import org.eclipse.thym.core.plugin.registry.CordovaPluginRegistryMapper;
import org.eclipse.thym.core.plugin.registry.plugin.CordovaRegistryPluginVersion;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;

public class CordovaPluginManager {
    private final HybridProject project;
    private List<CordovaPlugin> installedPlugins = new ArrayList<CordovaPlugin>();

    public CordovaPluginManager(HybridProject project) {
        this.project = project;
    }

    public void installPlugin(File directory, IProgressMonitor monitor) throws CoreException {
        this.readPluginXML(directory);
        this.installPlugin(directory.toString(), monitor, true);
    }

    public void installPlugin(CordovaRegistryPluginVersion version, IProgressMonitor monitor) throws CoreException {
        String pluginCoords = String.valueOf(version.getName()) + "@" + version.getVersion();
        this.installPlugin(pluginCoords, monitor, true);
    }

    public void installPlugin(Plugin plugin, IProgressMonitor monitor, boolean save) throws CoreException {
        if (this.isPluginInstalled(plugin.getName())) {
            return;
        }
        String pluginVersion = EngineUtils.getExactVersion(plugin.getSpec());
        String pluginCoords = String.valueOf(plugin.getName()) + "@" + pluginVersion;
        this.installPlugin(pluginCoords, monitor, save);
    }

    public void installPlugin(URI uri, IProgressMonitor monitor) throws CoreException {
        this.installPlugin(uri.toString(), monitor, true);
    }

    private void installPlugin(String plugin, IProgressMonitor monitor, boolean save) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        subMonitor.setTaskName("Installing plugin: " + plugin);
        String options = "";
        options = save ? "--save" : "--nosave";
        IStatus status = this.project.getProjectCLI().plugin(CordovaProjectCLI.Command.ADD, (IProgressMonitor)subMonitor.split(90), plugin, options).convertTo(PluginMessagesCLIResult.class).asStatus();
        this.project.getProject().refreshLocal(2, (IProgressMonitor)subMonitor.split(10, 7));
        if (!status.isOK()) {
            throw new CoreException(status);
        }
    }

    private Document readPluginXML(File directory) throws CoreException {
        File pluginFile = new File(directory, "plugin.xml");
        if (!pluginFile.exists()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", NLS.bind((String)"plugin.xml can not be located at {0}", (Object)pluginFile.toString())));
        }
        Document doc = null;
        try {
            doc = XMLUtil.loadXML(pluginFile, false);
        }
        catch (CoreException e) {
            if (e.getCause() != null && e.getCause() instanceof SAXParseException) {
                HybridMobileStatus hms = new HybridMobileStatus(4, "org.eclipse.thym.core", 423, e.getStatus().getMessage(), e.getCause());
                e = new CoreException((IStatus)hms);
            }
            throw e;
        }
        return doc;
    }

    private void unInstallPlugin(String id, IProgressMonitor monitor, boolean save) throws CoreException {
        IFolder dir;
        File pluginFile;
        if (id == null || !this.isPluginInstalled(id)) {
            return;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (!(pluginFile = new File((dir = this.getPluginHomeFolder(id)).getLocation().toFile(), "plugin.xml")).exists()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Not a valid plugin id , no plugin.xml exists"));
        }
        if (monitor.isCanceled()) {
            return;
        }
        String options = "";
        options = save ? "--save" : "--nosave";
        IStatus status = this.project.getProjectCLI().plugin(CordovaProjectCLI.Command.REMOVE, monitor, id, options).convertTo(PluginMessagesCLIResult.class).asStatus();
        this.project.getProject().refreshLocal(2, monitor);
        this.resetInstalledPlugins();
        if (!status.isOK()) {
            throw new CoreException(status);
        }
    }

    public void unInstallPlugin(String id, IProgressMonitor monitor) throws CoreException {
        this.unInstallPlugin(id, monitor, true);
    }

    public void unInstallPlugin(Plugin plugin, IProgressMonitor monitor, boolean save) throws CoreException {
        this.unInstallPlugin(plugin.getName(), monitor, save);
    }

    private void resetInstalledPlugins() {
        this.installedPlugins.clear();
    }

    public List<CordovaPlugin> getInstalledPlugins() throws CoreException {
        this.updatePluginList();
        return Collections.unmodifiableList(this.installedPlugins);
    }

    public boolean isPluginInstalled(String pluginId) {
        if (pluginId == null) {
            return false;
        }
        try {
            IFolder pluginHome = this.getPluginHomeFolder(pluginId);
            if (pluginHome != null) {
                IFile pluginxml = pluginHome.getFile("plugin.xml");
                return pluginxml.getLocation() != null && pluginHome.getLocation().toFile().exists();
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public String getCordovaPluginJSContent(String platformId) throws CoreException {
        JsonArray moduleObjects = new JsonArray();
        List<CordovaPlugin> plugins = this.getInstalledPlugins();
        for (CordovaPlugin cordovaPlugin : plugins) {
            List<PluginJavaScriptModule> modules = cordovaPlugin.getModules();
            for (PluginJavaScriptModule pluginJavaScriptModule : modules) {
                if (platformId != null && pluginJavaScriptModule.getPlatform() != null && !pluginJavaScriptModule.getPlatform().equals(platformId)) continue;
                JsonObject obj = new JsonObject();
                obj.addProperty("file", new Path("plugins").append(cordovaPlugin.getId()).append(pluginJavaScriptModule.getSource()).toString());
                obj.addProperty("id", pluginJavaScriptModule.getName());
                if (pluginJavaScriptModule.isRuns()) {
                    obj.addProperty("runs", Boolean.valueOf(true));
                }
                if (pluginJavaScriptModule.getClobbers() != null) {
                    List<String> clobbers = pluginJavaScriptModule.getClobbers();
                    JsonArray clobbersArray = new JsonArray();
                    for (String string : clobbers) {
                        clobbersArray.add((JsonElement)new JsonPrimitive(string));
                    }
                    obj.add("clobbers", (JsonElement)clobbersArray);
                }
                if (pluginJavaScriptModule.getMerges() != null) {
                    List<String> merges = pluginJavaScriptModule.getMerges();
                    JsonArray mergesArray = new JsonArray();
                    for (String string : merges) {
                        mergesArray.add((JsonElement)new JsonPrimitive(string));
                    }
                    obj.add("merges", (JsonElement)mergesArray);
                }
                moduleObjects.add((JsonElement)obj);
            }
        }
        StringBuilder finalContents = new StringBuilder();
        finalContents.append("cordova.define('cordova/plugin_list', function(require, exports, module) {\n");
        Gson gson = new Gson();
        finalContents.append("module.exports = ").append(gson.toJson((JsonElement)moduleObjects)).append("\n});");
        return finalContents.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePluginList() throws CoreException {
        long start = System.currentTimeMillis();
        if (this.installedPlugins == null || this.installedPlugins.isEmpty()) {
            HybridCore.trace("Really updating the installed plugin list");
            IResourceVisitor visitor = new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    IFolder folder;
                    IFile file;
                    if (resource.getType() == 2 && (file = (folder = (IFolder)resource.getAdapter(IFolder.class)).getFile("plugin.xml")).exists()) {
                        CordovaPluginManager.this.addInstalledPlugin(file);
                    }
                    return resource.getName().equals("plugins");
                }
            };
            IFolder plugins = this.project.getProject().getFolder("plugins");
            if (plugins != null && plugins.exists()) {
                List<CordovaPlugin> list = this.installedPlugins;
                synchronized (list) {
                    plugins.accept(visitor, 1, false);
                }
            }
        }
        HybridCore.trace(NLS.bind((String)"Updated plugin list in {0} ms", (Object)(System.currentTimeMillis() - start)));
    }

    private void addInstalledPlugin(IFile pluginxml) throws CoreException {
        CordovaPlugin plugin = CordovaPluginXMLHelper.createCordovaPlugin(pluginxml.getContents());
        int index = this.installedPlugins.indexOf(plugin);
        if (index > -1) {
            this.installedPlugins.set(index, plugin);
        } else {
            this.installedPlugins.add(plugin);
        }
    }

    private IFolder getPluginHomeFolder(String id) throws CoreException {
        if (id == null) {
            return null;
        }
        IFolder plugins = this.getPluginsFolder();
        if (!plugins.exists()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Plugin folder does not exist"));
        }
        IFolder pluginHome = plugins.getFolder(id);
        IPath location = pluginHome.getLocation();
        if (pluginHome.exists() && location != null && location.toFile().isDirectory()) {
            return pluginHome;
        }
        String alternateId = CordovaPluginRegistryMapper.alternateID(id);
        if (alternateId != null) {
            pluginHome = plugins.getFolder(alternateId);
            location = pluginHome.getLocation();
            if (pluginHome.exists() && location != null && location.toFile().isDirectory()) {
                return pluginHome;
            }
        }
        return null;
    }

    private IFolder getPluginsFolder() {
        IFolder plugins = this.project.getProject().getFolder("plugins");
        return plugins;
    }
}

