/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.plugin.registry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.IncomingFileTransferException;
import org.eclipse.ecf.filetransfer.identity.FileCreateException;
import org.eclipse.ecf.filetransfer.identity.FileIDFactory;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.filetransfer.service.IRetrieveFileTransfer;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.internal.util.HttpUtil;
import org.eclipse.thym.core.plugin.registry.PluginReceiver;
import org.eclipse.thym.core.plugin.registry.plugin.CordovaRegistryPlugin;
import org.eclipse.thym.core.plugin.registry.plugin.CordovaRegistryPluginVersion;
import org.eclipse.thym.core.plugin.registry.plugin.PluginVersionDeserializer;
import org.eclipse.thym.core.plugin.registry.repo.CordovaRegistry;
import org.eclipse.thym.core.plugin.registry.repo.CordovaRegistrySearchPlugin;

public class CordovaPluginRegistryManager {
    private static final String REGISTRY_URL = "http://registry.npmjs.org/";
    private static final String SEARCH_URL = "http://npmsearch.com/";
    private static final String PLUGIN_LIST_URL = "query?fields=name,keywords,description,author&q=keywords:%22ecosystem:cordova%22&sort=rating:desc&size=";
    private final File cacheHome;
    private HashMap<String, CordovaRegistryPlugin> detailedPluginInfoCache = new HashMap();

    public CordovaPluginRegistryManager() {
        this.cacheHome = new File(FileUtils.getUserDirectory(), ".plugman" + File.separator + "cache");
    }

    public CordovaRegistryPlugin getCordovaPluginInfo(String name) throws CoreException {
        CordovaRegistryPlugin plugin = this.detailedPluginInfoCache.get(name);
        if (plugin != null) {
            return plugin;
        }
        JsonReader reader = null;
        try {
            InputStream stream = HttpUtil.getHttpStream(REGISTRY_URL + name);
            reader = new JsonReader((Reader)new InputStreamReader(stream));
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.registerTypeAdapter(new TypeToken<List<CordovaRegistryPluginVersion>>(){}.getType(), (Object)new PluginVersionDeserializer());
            Gson gson = gsonBuilder.create();
            plugin = (CordovaRegistryPlugin)gson.fromJson(reader, CordovaRegistryPlugin.class);
            this.detailedPluginInfoCache.put(name, plugin);
            CordovaRegistryPlugin cordovaRegistryPlugin = plugin;
            return cordovaRegistryPlugin;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Can not retrieve plugin information for " + name, (Throwable)e));
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    HybridCore.log(4, "Error occured when closing json reader", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getInstallationDirectory(CordovaRegistryPlugin plugin, IProgressMonitor monitor) {
        File pluginDir;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((pluginDir = this.getFromCache(plugin)) != null) {
            return pluginDir;
        }
        File newCacheDir = this.calculateCacheDir(plugin);
        IRetrieveFileTransfer transfer = HybridCore.getDefault().getFileTransferService();
        try {
            IFileID remoteFileID = FileIDFactory.getDefault().createFileID(transfer.getRetrieveNamespace(), plugin.getVersions().get(0).getDist().getTarball());
            Object lock = new Object();
            PluginReceiver receiver = new PluginReceiver(newCacheDir, monitor, lock);
            Object object = lock;
            synchronized (object) {
                transfer.sendRetrieveRequest(remoteFileID, (IFileTransferListener)receiver, null);
                lock.wait();
            }
        }
        catch (InterruptedException | IncomingFileTransferException | FileCreateException e) {
            HybridCore.log(4, "Cordova plugin fetch error", e);
        }
        return new File(newCacheDir, "package");
    }

    private File getFromCache(CordovaRegistryPlugin plugin) {
        File cachedPluginDir = this.calculateCacheDir(plugin);
        File packageDir = new File(cachedPluginDir, "package");
        if (!packageDir.isDirectory()) {
            return null;
        }
        File pluginxml = new File(packageDir, "plugin.xml");
        if (cachedPluginDir.isDirectory() && pluginxml.exists()) {
            return packageDir;
        }
        return null;
    }

    private File calculateCacheDir(CordovaRegistryPlugin plugin) {
        File cachedPluginDir = new File(this.cacheHome, String.valueOf(plugin.getName()) + File.separator + plugin.getVersions().get(0));
        return cachedPluginDir;
    }

    public List<CordovaRegistrySearchPlugin> retrievePluginInfos(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("Retrieve plug-in registry catalog", 10);
        Object reader = null;
        try {
            if (monitor.isCanceled()) {
                return null;
            }
            CordovaRegistry registry = this.getRegistry(1);
            monitor.worked(1);
            registry = this.getRegistry(registry.getTotal());
            monitor.worked(7);
            List<CordovaRegistrySearchPlugin> list = registry.getCordovaPlugins();
            return list;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Can not retrieve plugin catalog", (Throwable)e));
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    HybridCore.log(4, "Error occured when closing json reader", e);
                }
            }
            monitor.done();
        }
    }

    private CordovaRegistry getRegistry(int size) throws IOException {
        InputStream stream = HttpUtil.getHttpStream("http://npmsearch.com/query?fields=name,keywords,description,author&q=keywords:%22ecosystem:cordova%22&sort=rating:desc&size=" + size);
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(stream));
        CordovaRegistry registry = (CordovaRegistry)new Gson().fromJson(reader, CordovaRegistry.class);
        return registry;
    }
}

