/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ios.core.xcode;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.internal.util.ExternalProcessUtility;
import org.eclipse.thym.core.platform.AbstractNativeBinaryBuildDelegate;
import org.eclipse.thym.ios.core.xcode.XCodeSDK;

public class XCodeBuild
extends AbstractNativeBinaryBuildDelegate {
    public static final String MIN_REQUIRED_VERSION = "6.0.0";
    private ILaunchConfiguration launchConfiguration;

    public void buildNow(IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return;
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)"Build project for iOS", (int)100);
        try {
            HybridProject hybridProject = HybridProject.getHybridProject((IProject)this.getProject());
            if (hybridProject == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.ios.core", "Not a hybrid mobile project, can not generate files"));
            }
            String buildType = "--emulator";
            if (this.isRelease()) {
                buildType = "--device";
            }
            if (sm.isCanceled()) {
                return;
            }
            hybridProject.build((IProgressMonitor)sm.split(90), new String[]{"ios", buildType});
            String name = hybridProject.getAppName();
            IFolder buildFolder = hybridProject.getProject().getFolder("platforms/ios/build");
            IFolder artifactFolder = null;
            artifactFolder = this.isRelease() ? buildFolder.getFolder("device") : buildFolder.getFolder("emulator");
            this.setBuildArtifact(new File(artifactFolder.getLocation().toFile(), String.valueOf(name) + ".app"));
            if (!this.getBuildArtifact().exists()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.ios.core", "xcodebuild has failed: build artifact does not exist"));
            }
        }
        finally {
            sm.done();
        }
    }

    public ILaunchConfiguration getLaunchConfiguration() {
        return this.launchConfiguration;
    }

    public void setLaunchConfiguration(ILaunchConfiguration launchConfiguration) {
        this.launchConfiguration = launchConfiguration;
    }

    public List<XCodeSDK> showSdks() throws CoreException {
        ExternalProcessUtility processUtility = new ExternalProcessUtility();
        SDKListParser parser = new SDKListParser();
        processUtility.execSync("xcodebuild -showsdks ", null, (IStreamListener)parser, (IStreamListener)parser, (IProgressMonitor)new NullProgressMonitor(), null, null);
        return parser.getSDKList();
    }

    public String version() throws CoreException {
        ExternalProcessUtility processUtility = new ExternalProcessUtility();
        XCodeVersionParser parser = new XCodeVersionParser();
        processUtility.execSync("xcodebuild -version", null, (IStreamListener)parser, (IStreamListener)parser, (IProgressMonitor)new NullProgressMonitor(), null, null);
        return parser.getVersion();
    }

    private static class SDKListParser
    implements IStreamListener {
        private StringBuffer buffer = new StringBuffer();

        private SDKListParser() {
        }

        public void streamAppended(String text, IStreamMonitor monitor) {
            this.buffer.append(text);
        }

        ArrayList<XCodeSDK> getSDKList() {
            ArrayList<XCodeSDK> sdkList = new ArrayList<XCodeSDK>(5);
            if (this.buffer.indexOf("-sdk") > 0) {
                String[] sdks;
                String text = this.buffer.toString();
                text = text.replaceAll("[ a-zA-Z1-9.1-9]*:", "");
                text = text.replaceAll("-sdk [a-z]*[0-9]*.[0-9]*", "");
                String[] stringArray = sdks = text.split("\n");
                int n = sdks.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    String clean = string.trim();
                    if (!clean.isEmpty()) {
                        sdkList.add(new XCodeSDK(clean));
                    }
                    ++n2;
                }
            }
            return sdkList;
        }
    }

    private static class XCodeVersionParser
    implements IStreamListener {
        private static final int START_LOC = "XCode".length() + 1;
        private StringBuffer buffer = new StringBuffer();

        private XCodeVersionParser() {
        }

        public void streamAppended(String text, IStreamMonitor monitor) {
            this.buffer.append(text);
        }

        public String getVersion() {
            if (this.buffer.length() < START_LOC) {
                return "";
            }
            return this.buffer.substring(START_LOC, this.buffer.indexOf("\n"));
        }
    }
}

