/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.internal.engine;

import com.github.zafarkhaja.semver.Version;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.engine.HybridMobileEngine;
import org.eclipse.thym.core.engine.internal.cordova.CordovaEngineProvider;
import org.eclipse.thym.core.extensions.PlatformSupport;
import org.eclipse.thym.core.internal.util.EngineUtils;
import org.eclipse.thym.ui.HybridUI;
import org.eclipse.thym.ui.PlatformImage;
import org.eclipse.thym.ui.internal.engine.EngineAddDialog;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.services.IEvaluationService;

public class AvailableCordovaEnginesSection
implements ISelectionProvider {
    private static final int TREE_HEIGHT = 250;
    private static final int TREE_WIDTH = 500;
    private ListenerList<ISelectionChangedListener> selectionListeners;
    private ListenerList<EngineListChangeListener> engineChangeListeners;
    private CheckboxTreeViewer engineList;
    private ISelection prevSelection = new StructuredSelection();
    private Button removeBtn;
    private FormToolkit formToolkit = null;
    private boolean fireSelectionChanged = true;

    public AvailableCordovaEnginesSection() {
        this.selectionListeners = new ListenerList();
        this.engineChangeListeners = new ListenerList();
    }

    public AvailableCordovaEnginesSection(FormToolkit formToolkit) {
        this();
        this.formToolkit = formToolkit;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)composite);
        Label tableLbl = new Label(composite, 0);
        tableLbl.setText("Available Engines: ");
        GridDataFactory.generate((Control)tableLbl, (int)2, (int)1);
        Tree tree = new Tree(composite, 65568);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).minSize(new Point(500, 250)).applyTo((Control)tree);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        TreeColumn col_0 = new TreeColumn(tree, 16384);
        col_0.setText("Engine");
        col_0.setWidth(250);
        col_0.setMoveable(false);
        TreeColumn col_1 = new TreeColumn(tree, 16384);
        col_1.setText("Location");
        col_1.setWidth(250);
        col_1.setMoveable(false);
        this.engineList = new CheckboxTreeViewer(tree);
        this.engineList.setContentProvider((IContentProvider)new CordovaEnginesContentProvider());
        this.engineList.setLabelProvider((IBaseLabelProvider)new CordovaEngineLabelProvider());
        this.engineList.setComparator((ViewerComparator)new EngineVersionComparator(true));
        this.engineList.setUseHashlookup(true);
        this.engineList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object[] checked;
                if (event.getChecked()) {
                    ITreeContentProvider cp = (ITreeContentProvider)AvailableCordovaEnginesSection.this.engineList.getContentProvider();
                    if (event.getElement() instanceof PlatformSupport) {
                        AvailableCordovaEnginesSection.this.engineList.setChecked(event.getElement(), false);
                        HybridMobileEngine[] children = (HybridMobileEngine[])cp.getChildren(event.getElement());
                        if (children != null && children.length > 0) {
                            Arrays.sort(children, new EngineVersionComparator(true));
                            AvailableCordovaEnginesSection.this.engineList.setChecked((Object)children[0], true);
                            int i = 1;
                            while (i < children.length) {
                                AvailableCordovaEnginesSection.this.engineList.setChecked((Object)children[i], false);
                                ++i;
                            }
                        }
                    } else {
                        Object[] siblings = cp.getChildren(cp.getParent(event.getElement()));
                        int i = 0;
                        while (i < siblings.length) {
                            if (siblings[i] != event.getElement()) {
                                AvailableCordovaEnginesSection.this.engineList.setChecked(siblings[i], false);
                            }
                            ++i;
                        }
                    }
                }
                if ((checked = AvailableCordovaEnginesSection.this.engineList.getCheckedElements()) != null && checked.length > 0) {
                    AvailableCordovaEnginesSection.this.setSelection((ISelection)new StructuredSelection(checked));
                } else {
                    AvailableCordovaEnginesSection.this.setSelection((ISelection)new StructuredSelection());
                }
            }
        });
        this.engineList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AvailableCordovaEnginesSection.this.updateButtons();
            }
        });
        Composite buttonsContainer = new Composite(composite, 0);
        GridDataFactory.fillDefaults().align(1, 4).applyTo((Control)buttonsContainer);
        GridLayoutFactory.fillDefaults().spacing(0, 3).numColumns(1).applyTo(buttonsContainer);
        Button downloadBtn = new Button(buttonsContainer, 8);
        downloadBtn.setText("Add...");
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)downloadBtn);
        downloadBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                EngineAddDialog downloadDialog = new EngineAddDialog(AvailableCordovaEnginesSection.this.engineList.getControl().getShell());
                int status = downloadDialog.open();
                if (status == 0) {
                    AvailableCordovaEnginesSection.this.updateAvailableEngines(downloadDialog.getEngines());
                }
            }
        });
        this.removeBtn = new Button(buttonsContainer, 8);
        this.removeBtn.setText("Remove");
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)this.removeBtn);
        this.removeBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AvailableCordovaEnginesSection.this.handleRemoveEngine();
            }
        });
        this.updateAvailableEngines(null);
        this.updateButtons();
        if (this.formToolkit != null) {
            this.formToolkit.adapt(composite);
            this.formToolkit.paintBordersFor(composite);
            this.formToolkit.adapt((Control)tree, true, false);
            this.formToolkit.adapt(buttonsContainer);
            this.formToolkit.adapt((Control)downloadBtn, true, false);
            this.formToolkit.adapt((Control)this.removeBtn, true, false);
        }
    }

    private void updateButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.engineList.getSelection();
        this.removeBtn.setEnabled(!selection.isEmpty() && selection.getFirstElement() instanceof HybridMobileEngine);
    }

    public void updateAvailableEngines(Set<HybridMobileEngine> additionalUserEngines) {
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        List selected = selection.toList();
        CordovaEngineProvider provider = CordovaEngineProvider.getInstance();
        Set engines = provider.getAvailableEngines();
        if (additionalUserEngines != null) {
            engines.addAll(additionalUserEngines);
        }
        this.engineList.setInput((Object)engines);
        this.prevSelection = null;
        this.setSelection((ISelection)new StructuredSelection(selected));
        this.fireEngineListChanged();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add((Object)listener);
    }

    public void addEngineListChangeListener(EngineListChangeListener listener) {
        this.engineChangeListeners.add((Object)listener);
    }

    public void removeEngineListChangeListener(EngineListChangeListener listener) {
        this.engineChangeListeners.remove((Object)listener);
    }

    public ISelection getSelection() {
        return new StructuredSelection(this.engineList.getCheckedElements());
    }

    public List<HybridMobileEngine> getListedEngines() {
        Object o = this.engineList.getInput();
        if (o == null) {
            return null;
        }
        return (List)o;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(this.selectionListeners);
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.equals(this.prevSelection)) {
            this.prevSelection = selection;
            if (selection.isEmpty()) {
                this.engineList.setCheckedElements(new Object[0]);
            } else {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                List checkedEngines = structuredSelection.toList();
                for (HybridMobileEngine engine : structuredSelection) {
                    this.engineList.reveal((Object)engine);
                }
                this.engineList.setCheckedElements(checkedEngines.toArray());
            }
            this.engineList.refresh(true);
            this.fireSelectionChanged();
        }
    }

    public void disableSelectionChangedFire() {
        this.fireSelectionChanged = false;
    }

    public void enableSelectionCHangedFire() {
        this.fireSelectionChanged = true;
    }

    private void fireSelectionChanged() {
        if (this.fireSelectionChanged) {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
            Object[] listeners = this.selectionListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ISelectionChangedListener listener = (ISelectionChangedListener)listeners[i];
                listener.selectionChanged(event);
                ++i;
            }
        }
    }

    private void fireEngineListChanged() {
        Object[] listeners = this.engineChangeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            EngineListChangeListener l = (EngineListChangeListener)listeners[i];
            l.listChanged();
            ++i;
        }
    }

    private void handleRemoveEngine() {
        IStructuredSelection selection = (IStructuredSelection)this.engineList.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object selectedObject = selection.getFirstElement();
        if (!(selectedObject instanceof HybridMobileEngine)) {
            return;
        }
        HybridMobileEngine selectedEngine = (HybridMobileEngine)selectedObject;
        boolean deleteConfirm = MessageDialog.openConfirm((Shell)this.engineList.getTree().getShell(), (String)"Confirm Delete", (String)NLS.bind((String)"Remove {0} {1} ?", (Object[])new String[]{selectedEngine.getName(), selectedEngine.getSpec()}));
        if (deleteConfirm) {
            CordovaEngineProvider.getInstance().deleteEngine(selectedEngine);
            this.updateAvailableEngines(null);
            ISelection cSelection = this.getSelection();
            HybridMobileEngine checkedEngine = null;
            if (cSelection != null && !cSelection.isEmpty()) {
                IStructuredSelection css = (IStructuredSelection)cSelection;
                checkedEngine = (HybridMobileEngine)css.getFirstElement();
            }
            if (checkedEngine != null && checkedEngine == selectedEngine) {
                this.setSelection((ISelection)new StructuredSelection());
            }
        }
    }

    private class CordovaEngineLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider {
        private Font boldFont;

        private CordovaEngineLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof PlatformSupport) {
                PlatformSupport platform = (PlatformSupport)element;
                return PlatformImage.getImageFor("platformSupport", platform.getID());
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof PlatformSupport) {
                PlatformSupport platform = (PlatformSupport)element;
                return platform.getPlatform();
            }
            if (element instanceof HybridMobileEngine) {
                HybridMobileEngine engine = (HybridMobileEngine)element;
                String identifier = EngineUtils.getExactVersion((String)engine.getSpec());
                return NLS.bind((String)"{0}@{1}", (Object[])new String[]{engine.getName(), identifier});
            }
            return null;
        }

        private String getLocationText(Object element) {
            if (element instanceof HybridMobileEngine) {
                HybridMobileEngine engine = (HybridMobileEngine)element;
                return engine.getSpec();
            }
            return null;
        }

        public Font getFont(Object element) {
            if (!AvailableCordovaEnginesSection.this.engineList.getChecked(element)) {
                return null;
            }
            if (this.boldFont == null) {
                FontDescriptor fontDescriptor = JFaceResources.getDialogFontDescriptor();
                fontDescriptor = fontDescriptor.setStyle(1);
                this.boldFont = fontDescriptor.createFont((Device)Display.getCurrent());
            }
            return this.boldFont;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.getText(element);
                }
                case 1: {
                    return this.getLocationText(element);
                }
            }
            return "invalid";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.getImage(element);
            }
            return null;
        }
    }

    private static class CordovaEnginesContentProvider
    implements ITreeContentProvider {
        private Set<HybridMobileEngine> engines;
        private PlatformSupport[] platforms;

        private CordovaEnginesContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.engines = (Set)newInput;
        }

        public Object[] getElements(Object inputElement) {
            if (this.platforms == null) {
                List allPlatforms = HybridCore.getPlatformSupports();
                ArrayList<PlatformSupport> elements = new ArrayList<PlatformSupport>();
                IEvaluationService service = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
                for (PlatformSupport generator : allPlatforms) {
                    try {
                        if (!generator.isEnabled(service.getCurrentState())) continue;
                        elements.add(generator);
                    }
                    catch (CoreException e) {
                        HybridUI.log(4, "Error filtering objects", e);
                    }
                }
                this.platforms = elements.toArray(new PlatformSupport[elements.size()]);
            }
            return this.platforms;
        }

        public Object[] getChildren(Object parentElement) {
            if (this.engines == null || !(parentElement instanceof PlatformSupport)) {
                return null;
            }
            PlatformSupport platform = (PlatformSupport)parentElement;
            ArrayList<HybridMobileEngine> platformEngines = new ArrayList<HybridMobileEngine>();
            for (HybridMobileEngine hybridMobileEngine : this.engines) {
                if (!hybridMobileEngine.getName().equals(platform.getPlatformId())) continue;
                platformEngines.add(hybridMobileEngine);
            }
            return platformEngines.toArray(new HybridMobileEngine[platformEngines.size()]);
        }

        public Object getParent(Object element) {
            if (this.platforms != null && element instanceof HybridMobileEngine) {
                HybridMobileEngine engine = (HybridMobileEngine)element;
                PlatformSupport[] platformSupportArray = this.platforms;
                int n = this.platforms.length;
                int n2 = 0;
                while (n2 < n) {
                    PlatformSupport platformSupport = platformSupportArray[n2];
                    if (engine.getName().equals(platformSupport.getPlatformId())) {
                        return platformSupport;
                    }
                    ++n2;
                }
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof PlatformSupport;
        }
    }

    public static interface EngineListChangeListener {
        public void listChanged();
    }

    private static class EngineVersionComparator
    extends ViewerComparator
    implements Comparator<HybridMobileEngine> {
        private boolean descending = true;

        public EngineVersionComparator(boolean isDescending) {
            this.descending = isDescending;
        }

        public int compare(Viewer viewer, Object o1, Object o2) {
            if (!(o1 instanceof HybridMobileEngine)) {
                return 1;
            }
            HybridMobileEngine e1 = (HybridMobileEngine)o1;
            HybridMobileEngine e2 = (HybridMobileEngine)o2;
            return this.compare(e1, e2);
        }

        @Override
        public int compare(HybridMobileEngine o1, HybridMobileEngine o2) {
            try {
                Version version1 = Version.valueOf((String)o1.getSpec());
                Version version2 = Version.valueOf((String)o2.getSpec());
                if (this.descending) {
                    return version2.compareTo(version1);
                }
                return version1.compareTo(version2);
            }
            catch (Exception exception) {
                return 1;
            }
        }
    }
}

