/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.internal.engine;

import com.github.zafarkhaja.semver.Version;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.engine.HybridMobileEngine;
import org.eclipse.thym.core.engine.HybridMobileEngineLocator;
import org.eclipse.thym.core.engine.internal.cordova.CordovaEngineProvider;
import org.eclipse.thym.core.engine.internal.cordova.DownloadableCordovaEngine;
import org.eclipse.thym.core.extensions.PlatformSupport;
import org.eclipse.thym.ui.HybridUI;
import org.eclipse.thym.ui.PlatformImage;
import org.eclipse.thym.ui.internal.status.StatusManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.services.IEvaluationService;

public class EngineAddDialog
extends TitleAreaDialog {
    private static final int TREE_WIDTH = 450;
    private static final int TREE_HEIGHT = 175;
    private CheckboxTreeViewer platformList;
    private CordovaEngineProvider engineProvider;
    private Set<HybridMobileEngine> engines;
    private Button nightlyBuilds;
    private Set<HybridMobileEngine> newEngines;
    private Text customEngineLocation;
    private CheckboxTreeViewer customEnginesList;
    private Set<HybridMobileEngine> customEngines = new HashSet<HybridMobileEngine>();

    public EngineAddDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10000000);
        this.newEngines = new LinkedHashSet<HybridMobileEngine>();
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.toggleOKButton(false);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Add Hybrid Mobile Engine");
        this.setMessage("Add a new engine version");
        parent.getShell().setText("Add Hybrid Mobile Engine");
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).spacing(LayoutConstants.getSpacing()).numColumns(1).applyTo(composite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)composite);
        Group downloadableGroup = new Group(composite, 0);
        downloadableGroup.setText("Downloadable engines");
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).spacing(LayoutConstants.getSpacing()).numColumns(1).applyTo((Composite)downloadableGroup);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)downloadableGroup);
        Tree tree = new Tree((Composite)downloadableGroup, 67616);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).minSize(new Point(450, 175)).applyTo((Control)tree);
        tree.setHeaderVisible(false);
        tree.setLinesVisible(true);
        this.platformList = new CheckboxTreeViewer(tree);
        final DownloadableVersionsContentProvider provider = new DownloadableVersionsContentProvider();
        this.platformList.setContentProvider((IContentProvider)provider);
        this.platformList.setLabelProvider((IBaseLabelProvider)new DownloadableEngineLabelProvider());
        this.platformList.setComparator((ViewerComparator)new DownloadableEngineComparator());
        this.platformList.addFilter((ViewerFilter)new InstalledVersionsFilter());
        this.platformList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getElement() instanceof PlatformSupport) {
                    EngineAddDialog.this.platformList.setChecked(event.getElement(), false);
                }
                EngineAddDialog.this.validate();
            }
        });
        this.nightlyBuilds = new Button((Composite)downloadableGroup, 32);
        this.nightlyBuilds.setText("Show nightly builds");
        this.nightlyBuilds.setSelection(false);
        this.nightlyBuilds.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                provider.showNightlyBuilds(EngineAddDialog.this.nightlyBuilds.getSelection());
                EngineAddDialog.this.platformList.refresh();
                EngineAddDialog.this.validate();
            }
        });
        ExpandableComposite ex = new ExpandableComposite(composite, 98);
        ex.setText("Local engines");
        GridLayoutFactory.fillDefaults().applyTo((Composite)ex);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)ex);
        ex.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                EngineAddDialog.this.initializeBounds();
            }
        });
        Group customEngineGroup = new Group((Composite)ex, 0);
        customEngineGroup.setText("Local engines");
        ex.setClient((Control)customEngineGroup);
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).spacing(LayoutConstants.getSpacing()).numColumns(1).applyTo((Composite)customEngineGroup);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)customEngineGroup);
        this.customEngineLocation = new Text((Composite)customEngineGroup, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.customEngineLocation);
        this.customEngineLocation.setMessage("Type location or use Browse button");
        Composite customEnginesComposite = new Composite((Composite)customEngineGroup, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(customEnginesComposite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)customEnginesComposite);
        Button browseBtn = new Button(customEnginesComposite, 8);
        browseBtn.setText("Browse...");
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)browseBtn);
        browseBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DirectoryDialog directoryDialog = new DirectoryDialog(EngineAddDialog.this.getShell());
                directoryDialog.setMessage("Select the directory in which to search for hybrid mobile engines");
                directoryDialog.setText("Search for Hybrid Mobile Engines");
                String pathStr = directoryDialog.open();
                EngineAddDialog.this.handleSearch(pathStr);
            }
        });
        Button refreshBtn = new Button(customEnginesComposite, 8);
        refreshBtn.setText("Refresh");
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)browseBtn);
        refreshBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                EngineAddDialog.this.handleSearch(EngineAddDialog.this.customEngineLocation.getText());
            }
        });
        Tree customEnginesTree = new Tree(customEnginesComposite, 67616);
        GridDataFactory.fillDefaults().align(4, 4).span(2, 1).grab(true, true).minSize(new Point(450, 175)).applyTo((Control)customEnginesTree);
        customEnginesTree.setHeaderVisible(false);
        customEnginesTree.setLinesVisible(true);
        this.customEnginesList = new CheckboxTreeViewer(customEnginesTree);
        this.customEnginesList.setContentProvider((IContentProvider)new CustomEngineContentProvider());
        this.customEnginesList.setLabelProvider((IBaseLabelProvider)new CustomEngineLabelProvider());
        this.customEnginesList.setInput(this.customEngines);
        this.customEnginesList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                HybridMobileEngine engine = (HybridMobileEngine)event.getElement();
                if (event.getChecked()) {
                    EngineAddDialog.this.newEngines.add(engine);
                } else {
                    EngineAddDialog.this.newEngines.remove(engine);
                }
                EngineAddDialog.this.validate();
            }
        });
        this.engineProvider = CordovaEngineProvider.getInstance();
        try {
            this.platformList.setInput((Object)this.engineProvider.getDownloadableEngines());
        }
        catch (CoreException e) {
            this.platformList.setInput(new Object());
            this.setErrorMessage(e.getMessage());
            HybridUI.log(4, "Unable to retrieve the downloadable versions list", e);
        }
        return composite;
    }

    private void handleSearch(String pathStr) {
        if (pathStr == null) {
            return;
        }
        Path path = new Path(pathStr);
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        dialog.setBlockOnOpen(false);
        dialog.setCancelable(true);
        dialog.open();
        HybridMobileEngineLocator.EngineSearchListener listener = new HybridMobileEngineLocator.EngineSearchListener(){

            public void engineFound(final HybridMobileEngine engine) {
                EngineAddDialog.this.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        EngineAddDialog.this.customEngines.add(engine);
                        EngineAddDialog.this.customEnginesList.refresh();
                        EngineAddDialog.this.validate();
                    }
                });
            }
        };
        IRunnableWithProgress runnable = new IRunnableWithProgress((IPath)path, listener){
            private final /* synthetic */ IPath val$path;
            private final /* synthetic */ HybridMobileEngineLocator.EngineSearchListener val$listener;
            {
                this.val$path = iPath;
                this.val$listener = engineSearchListener;
            }

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                List locators = HybridCore.getEngineLocators();
                for (HybridMobileEngineLocator locator : locators) {
                    locator.searchForRuntimes(this.val$path, this.val$listener, monitor);
                }
            }
        };
        try {
            dialog.run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null) {
                if (e.getTargetException() instanceof CoreException) {
                    StatusManager.handle((CoreException)e.getTargetException());
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)"Local Engine Search Error", null, (IStatus)new Status(4, "org.eclipse.thym.ui", "Error when searching for local hybrid mobile engines", e.getTargetException()));
                }
            }
        }
        catch (InterruptedException e) {
            HybridUI.log(4, "Search for Cordova Engines error", e);
        }
    }

    private boolean isInstalled(String version, String platformId) {
        if (version == null || platformId == null) {
            return false;
        }
        if (this.engines == null) {
            this.engines = this.engineProvider.getAvailableEngines();
        }
        for (HybridMobileEngine engine : this.engines) {
            if (!engine.getSpec().equals(version) || !engine.getName().equals(platformId)) continue;
            return true;
        }
        return false;
    }

    private void validate() {
        this.toggleOKButton(false);
        this.setErrorMessage(null);
        Object[] checked = this.platformList.getCheckedElements();
        if (checked != null && checked.length > 0) {
            this.toggleOKButton(true);
            return;
        }
        checked = this.customEnginesList.getCheckedElements();
        if (checked != null && checked.length > 0) {
            this.toggleOKButton(true);
            return;
        }
    }

    private void toggleOKButton(boolean state) {
        Button ok = this.getButton(0);
        if (ok != null && !ok.isDisposed()) {
            ok.setEnabled(state);
        }
    }

    public Set<HybridMobileEngine> getEngines() {
        return this.newEngines;
    }

    protected void okPressed() {
        DownloadableCordovaEngine[] downloads = this.getDownloadsList();
        CordovaEngineProvider engineProvider = CordovaEngineProvider.getInstance();
        DownloadableCordovaEngine[] downloadableCordovaEngineArray = downloads;
        int n = downloads.length;
        int n2 = 0;
        while (n2 < n) {
            DownloadableCordovaEngine e = downloadableCordovaEngineArray[n2];
            HybridMobileEngine engine = engineProvider.createEngine(e.getPlatformId(), e.getVersion());
            this.newEngines.add(engine);
            ++n2;
        }
        super.okPressed();
    }

    private DownloadableCordovaEngine[] getDownloadsList() {
        Object[] checked = this.platformList.getCheckedElements();
        DownloadableCordovaEngine[] downloads = new DownloadableCordovaEngine[checked.length];
        int i = 0;
        while (i < checked.length) {
            DownloadableCordovaEngine dce;
            downloads[i] = dce = (DownloadableCordovaEngine)checked[i];
            ++i;
        }
        return downloads;
    }

    private class CustomEngineContentProvider
    implements ITreeContentProvider {
        private CustomEngineContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return EngineAddDialog.this.customEngines.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    private class CustomEngineLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private CustomEngineLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof HybridMobileEngine) {
                HybridMobileEngine engine = (HybridMobileEngine)element;
                return String.valueOf(engine.getName()) + "@" + engine.getSpec();
            }
            return null;
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }
    }

    private class DownloadableEngineComparator
    extends ViewerComparator
    implements Comparator<DownloadableCordovaEngine> {
        private DownloadableEngineComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof DownloadableCordovaEngine && e2 instanceof DownloadableCordovaEngine) {
                DownloadableCordovaEngine o1 = (DownloadableCordovaEngine)e1;
                DownloadableCordovaEngine o2 = (DownloadableCordovaEngine)e2;
                return this.compare(o1, o2);
            }
            return 1;
        }

        @Override
        public int compare(DownloadableCordovaEngine o1, DownloadableCordovaEngine o2) {
            Version v1 = Version.valueOf((String)o1.getVersion());
            Version v2 = Version.valueOf((String)o2.getVersion());
            return v2.compareTo(v1);
        }
    }

    private class DownloadableEngineLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private DownloadableEngineLabelProvider() {
        }

        public Image getImage(Object element) {
            return this.getColumnImage(element, 0);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof PlatformSupport) {
                PlatformSupport platform = (PlatformSupport)element;
                return PlatformImage.getImageFor("platformSupport", platform.getID());
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof PlatformSupport) {
                return ((PlatformSupport)element).getPlatform();
            }
            if (element instanceof DownloadableCordovaEngine) {
                return ((DownloadableCordovaEngine)element).getVersion();
            }
            return null;
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }
    }

    private class DownloadableVersionsContentProvider
    implements ITreeContentProvider {
        private DownloadableCordovaEngine[] downloadables;
        private PlatformSupport[] platforms;
        private boolean nightlyBuilds = false;

        private DownloadableVersionsContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput != null && newInput instanceof List) {
                List list = (List)newInput;
                this.downloadables = list.toArray(new DownloadableCordovaEngine[list.size()]);
            } else {
                this.downloadables = null;
            }
        }

        public Object[] getElements(Object inputElement) {
            if (this.platforms == null) {
                List allPlatforms = HybridCore.getPlatformSupports();
                ArrayList<PlatformSupport> elements = new ArrayList<PlatformSupport>();
                IEvaluationService service = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
                for (PlatformSupport generator : allPlatforms) {
                    try {
                        if (!generator.isEnabled(service.getCurrentState())) continue;
                        elements.add(generator);
                    }
                    catch (CoreException e) {
                        HybridUI.log(4, "Error filtering objects", e);
                    }
                }
                this.platforms = elements.toArray(new PlatformSupport[elements.size()]);
            }
            return this.platforms;
        }

        public Object[] getChildren(Object parentElement) {
            if (this.downloadables == null || !this.hasChildren(parentElement)) {
                return null;
            }
            PlatformSupport platform = (PlatformSupport)parentElement;
            ArrayList<DownloadableCordovaEngine> platformDownloadables = new ArrayList<DownloadableCordovaEngine>();
            DownloadableCordovaEngine[] downloadableCordovaEngineArray = this.downloadables;
            int n = this.downloadables.length;
            int n2 = 0;
            while (n2 < n) {
                DownloadableCordovaEngine engine = downloadableCordovaEngineArray[n2];
                if (engine.getPlatformId().equals(platform.getPlatformId())) {
                    if (this.nightlyBuilds) {
                        platformDownloadables.add(engine);
                    } else if (!engine.isNightlyBuild()) {
                        platformDownloadables.add(engine);
                    }
                }
                ++n2;
            }
            return platformDownloadables.toArray(new DownloadableCordovaEngine[platformDownloadables.size()]);
        }

        public Object getParent(Object element) {
            if (this.platforms != null && element instanceof DownloadableCordovaEngine) {
                DownloadableCordovaEngine engine = (DownloadableCordovaEngine)element;
                PlatformSupport[] platformSupportArray = this.platforms;
                int n = this.platforms.length;
                int n2 = 0;
                while (n2 < n) {
                    PlatformSupport platformSupport = platformSupportArray[n2];
                    if (engine.getPlatformId().equals(platformSupport.getPlatformId())) {
                        return platformSupport;
                    }
                    ++n2;
                }
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof PlatformSupport;
        }

        public void showNightlyBuilds(boolean nightlyBuilds) {
            this.nightlyBuilds = nightlyBuilds;
        }
    }

    private class InstalledVersionsFilter
    extends ViewerFilter {
        private InstalledVersionsFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof DownloadableCordovaEngine) {
                DownloadableCordovaEngine e = (DownloadableCordovaEngine)element;
                return !EngineAddDialog.this.isInstalled(e.getVersion(), e.getPlatformId());
            }
            return true;
        }
    }
}

