/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.internal.project;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.thym.core.HybridProject;

public class RestoreProjectListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta[] projectDeltas;
        IResourceDelta[] iResourceDeltaArray = projectDeltas = event.getDelta().getAffectedChildren();
        int n = projectDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            HybridProject hybridProject;
            IProject project;
            IResourceDelta delta = iResourceDeltaArray[n2];
            if (delta.getResource().getType() == 4 && (delta.getKind() == 4 || delta.getKind() == 1) && (delta.getFlags() & 0x4000) != 0 && (project = delta.getResource().getProject()).isOpen() && (hybridProject = HybridProject.getHybridProject((IProject)project)) != null) {
                RestoreProjectJob job = new RestoreProjectJob(project);
                ISchedulingRule rule = ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule((IResource)project);
                job.setRule(rule);
                job.schedule();
            }
            ++n2;
        }
    }

    private class RestoreProjectJob
    extends Job {
        private IProject project;

        public RestoreProjectJob(IProject project) {
            super("Prepare cordova project job");
            this.project = project;
        }

        public IStatus run(IProgressMonitor monitor) {
            HybridProject hybridProject = HybridProject.getHybridProject((IProject)this.project);
            if (hybridProject != null) {
                try {
                    if (hybridProject.getEngineManager().hasActiveEngine()) {
                        hybridProject.prepare(monitor, new String[0]);
                    }
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
            }
            return Status.OK_STATUS;
        }
    }
}

