/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.platforms.navigator.internal;

import java.util.ArrayList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.engine.HybridMobileEngine;
import org.eclipse.thym.ui.HybridUI;
import org.eclipse.thym.ui.platforms.navigator.internal.HybridPlatformFolder;

public class PlatformContentProvider
implements ITreeContentProvider,
IResourceChangeListener {
    private Viewer viewer;

    public PlatformContentProvider() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
    }

    public Object[] getElements(Object inputElement) {
        return null;
    }

    public Object[] getChildren(Object parentElement) {
        if (!(parentElement instanceof IFolder)) {
            return new Object[0];
        }
        IFolder folder = (IFolder)parentElement;
        if (folder.getProjectRelativePath().segmentCount() > 1) {
            return new Object[0];
        }
        ArrayList<HybridPlatformFolder> platformFolders = new ArrayList<HybridPlatformFolder>();
        try {
            HybridProject project = HybridProject.getHybridProject((IProject)folder.getProject());
            IResource[] iResourceArray = folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                if (member instanceof IFolder) {
                    IFolder platformFolder = (IFolder)member;
                    platformFolders.add(new HybridPlatformFolder((IFolder)member, this.getPlatform(project, platformFolder.getName())));
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            HybridUI.log(4, "Error reading cordova platforms", e);
        }
        return platformFolders.toArray();
    }

    private HybridMobileEngine getPlatform(HybridProject project, String name) {
        HybridMobileEngine[] engines;
        HybridMobileEngine[] hybridMobileEngineArray = engines = project.getEngineManager().getEngines();
        int n = engines.length;
        int n2 = 0;
        while (n2 < n) {
            HybridMobileEngine engine = hybridMobileEngineArray[n2];
            if (engine.getName().equals(name)) {
                return engine;
            }
            ++n2;
        }
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (!(element instanceof IFolder)) {
            return false;
        }
        IFolder folder = (IFolder)element;
        if (folder.getProjectRelativePath().segmentCount() > 1) {
            return false;
        }
        try {
            return folder.members().length > 0;
        }
        catch (CoreException e) {
            HybridUI.log(4, "Error reading cordova platforms", e);
            return false;
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (this.viewer == null || delta == null) {
            return;
        }
        IResourceDelta[] deltas = delta.getAffectedChildren();
        int i = 0;
        while (i < deltas.length) {
            if (deltas[i].findMember((IPath)new Path("platforms")) != null) {
                this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PlatformContentProvider.this.viewer.refresh();
                    }
                });
                return;
            }
            ++i;
        }
    }
}

