/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.plugins.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.plugin.registry.repo.CordovaRegistrySearchPlugin;

public class CordovaPluginCatalogViewer
extends Composite {
    private CheckboxTreeViewer pluginTreeViewer;
    private TreeViewerColumn installedColumn;
    private TreeViewerColumn nameColumn;
    private Text descriptionText;
    private Button installedButton;
    private Composite parent;
    private PluginsFilter pluginsFilter = new PluginsFilter();
    private CordovaPluginViewerComparator pluginsComparator = new CordovaPluginViewerComparator();
    private HybridProject project;
    private List<CordovaRegistrySearchPlugin> pluginsToInstall = new ArrayList<CordovaRegistrySearchPlugin>();

    public CordovaPluginCatalogViewer(Composite parent, int style) {
        super(parent, style);
    }

    public void createControl(Composite container) {
        this.parent = new Composite(container, 0);
        this.parent.setLayout((Layout)new GridLayout(2, false));
        Text filterText = new Text(this.parent, 0);
        filterText.setFocus();
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)filterText);
        filterText.setMessage("filter plug-ins");
        filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                String filter = ((Text)ke.widget).getText();
                if (filter.trim().isEmpty()) {
                    CordovaPluginCatalogViewer.this.pluginsFilter.setSearchString("");
                } else {
                    CordovaPluginCatalogViewer.this.pluginsFilter.setSearchString(filter);
                }
                CordovaPluginCatalogViewer.this.pluginTreeViewer.refresh();
            }
        });
        this.installedButton = new Button(this.parent, 32);
        GridDataFactory.fillDefaults().grab(false, false).span(1, 1).applyTo((Control)this.installedButton);
        this.installedButton.setText("Show Installed");
        this.installedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = ((Button)e.getSource()).getSelection();
                CordovaPluginCatalogViewer.this.pluginsFilter.showInstalled(selected);
                CordovaPluginCatalogViewer.this.pluginTreeViewer.refresh();
            }
        });
        Composite treeViewerComposite = new Composite(this.parent, 0);
        this.pluginTreeViewer = new CheckboxTreeViewer(treeViewerComposite, 66304);
        this.pluginTreeViewer.addFilter((ViewerFilter)this.pluginsFilter);
        this.pluginTreeViewer.setComparator((ViewerComparator)this.pluginsComparator);
        Tree tree = this.pluginTreeViewer.getTree();
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        this.pluginTreeViewer.setUseHashlookup(true);
        GridDataFactory.fillDefaults().grab(true, true).hint(100, 200).span(2, 3).applyTo((Control)treeViewerComposite);
        this.installedColumn = new TreeViewerColumn((TreeViewer)this.pluginTreeViewer, 0);
        this.installedColumn.getColumn().setText("Installed");
        this.nameColumn = new TreeViewerColumn((TreeViewer)this.pluginTreeViewer, 0);
        this.nameColumn.getColumn().setText("Plug-in name");
        CordovaPluginInfoContentProvider provider = new CordovaPluginInfoContentProvider();
        CordovaPluginInfoLabelProvider labelProvider = new CordovaPluginInfoLabelProvider();
        this.pluginTreeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.pluginTreeViewer.setContentProvider((IContentProvider)provider);
        this.pluginTreeViewer.setCheckStateProvider((ICheckStateProvider)labelProvider);
        this.pluginTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object obj;
                if (CordovaPluginCatalogViewer.this.isPluginInstalled((CordovaRegistrySearchPlugin)event.getElement()) && (obj = event.getSource()) instanceof CheckboxTreeViewer) {
                    ((CheckboxTreeViewer)obj).setChecked(event.getElement(), true);
                }
                if (event.getChecked()) {
                    CordovaPluginCatalogViewer.this.pluginsToInstall.add((CordovaRegistrySearchPlugin)event.getElement());
                } else {
                    CordovaPluginCatalogViewer.this.pluginsToInstall.remove((CordovaRegistrySearchPlugin)event.getElement());
                }
            }
        });
        this.pluginTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() != null && ((IStructuredSelection)event.getSelection()).getFirstElement() != null) {
                    String desc = ((CordovaRegistrySearchPlugin)((IStructuredSelection)event.getSelection()).getFirstElement()).getDescription();
                    if (desc != null && !desc.isEmpty()) {
                        CordovaPluginCatalogViewer.this.descriptionText.setText(desc.trim());
                    } else {
                        CordovaPluginCatalogViewer.this.descriptionText.setText("Plug-in has no description");
                    }
                } else {
                    CordovaPluginCatalogViewer.this.descriptionText.setText("Select plug-in to see description");
                }
            }
        });
        TreeColumnLayout columnLayout = new TreeColumnLayout();
        columnLayout.setColumnData((Widget)this.installedColumn.getColumn(), (ColumnLayoutData)new ColumnPixelData(60));
        columnLayout.setColumnData((Widget)this.nameColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, 150));
        treeViewerComposite.setLayout((Layout)columnLayout);
        Group descGroup = new Group(this.parent, 16);
        descGroup.setText("Plug-in description");
        GridDataFactory.fillDefaults().span(2, 1).hint(100, 50).applyTo((Control)descGroup);
        descGroup.setLayout((Layout)new GridLayout());
        this.descriptionText = new Text((Composite)descGroup, 16777800);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.descriptionText);
        this.descriptionText.setText("Select plug-in to see description");
    }

    public List<CordovaRegistrySearchPlugin> getPluginsToInstall() {
        return this.pluginsToInstall;
    }

    public void setProject(HybridProject project) {
        this.project = project;
    }

    public void setInput(Object[] input) {
        this.pluginTreeViewer.setInput((Object)input);
    }

    public Object getInput() {
        return this.pluginTreeViewer.getInput();
    }

    public Control getControl() {
        return this.parent;
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        this.pluginTreeViewer.addCheckStateListener(listener);
    }

    private boolean isPluginInstalled(CordovaRegistrySearchPlugin plugin) {
        return this.project != null && this.project.getPluginManager().isPluginInstalled(plugin.getName());
    }

    private class CordovaPluginInfoContentProvider
    implements ITreeContentProvider {
        private Object[] pluginsInfo;

        private CordovaPluginInfoContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.pluginsInfo = (Object[])newInput;
        }

        public Object[] getElements(Object inputElement) {
            return this.pluginsInfo;
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    private class CordovaPluginInfoLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ICheckStateProvider {
        private CordovaPluginInfoLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return null;
                }
                case 1: {
                    if (element instanceof CordovaRegistrySearchPlugin) {
                        return ((CordovaRegistrySearchPlugin)element).getName();
                    }
                    return (String)element;
                }
            }
            return null;
        }

        public boolean isChecked(Object element) {
            return CordovaPluginCatalogViewer.this.isPluginInstalled((CordovaRegistrySearchPlugin)element) || CordovaPluginCatalogViewer.this.pluginsToInstall.contains(element);
        }

        public boolean isGrayed(Object element) {
            if (CordovaPluginCatalogViewer.this.pluginsFilter.isShowInstalled()) {
                CordovaRegistrySearchPlugin plugin = (CordovaRegistrySearchPlugin)element;
                return CordovaPluginCatalogViewer.this.isPluginInstalled(plugin);
            }
            return false;
        }
    }

    class CordovaPluginViewerComparator
    extends ViewerComparator {
        private static final String CORDOVA_NAMESPACE = "cordova-plugin";
        private static final int CATEGORY_INSTALLED = 0;
        private static final int CATEGORY_CORDOVA = 1;
        private static final int CATEGORY_OTHER = 2;

        CordovaPluginViewerComparator() {
        }

        public int category(Object element) {
            CordovaRegistrySearchPlugin info = (CordovaRegistrySearchPlugin)element;
            if (CordovaPluginCatalogViewer.this.pluginsFilter.isShowInstalled() && CordovaPluginCatalogViewer.this.isPluginInstalled(info)) {
                return 0;
            }
            if (info.getName().startsWith(CORDOVA_NAMESPACE)) {
                return 1;
            }
            return 2;
        }
    }

    class PluginsFilter
    extends ViewerFilter {
        private String searchString;
        private boolean showInstalled;

        PluginsFilter() {
        }

        public void setSearchString(String s) {
            this.searchString = ".*" + s + ".*";
        }

        public void showInstalled(boolean installed) {
            this.showInstalled = installed;
        }

        public boolean isShowInstalled() {
            return this.showInstalled;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.searchString == null || this.searchString.length() == 0) {
                if (!this.showInstalled) {
                    CordovaRegistrySearchPlugin plugin = (CordovaRegistrySearchPlugin)element;
                    return !CordovaPluginCatalogViewer.this.isPluginInstalled(plugin);
                }
                return true;
            }
            try {
                Pattern pattern = Pattern.compile(this.searchString, 2);
                CordovaRegistrySearchPlugin plugin = (CordovaRegistrySearchPlugin)element;
                boolean matchesPattern = pattern.matcher(plugin.getName()).matches();
                if (!this.showInstalled) {
                    return matchesPattern && !CordovaPluginCatalogViewer.this.isPluginInstalled(plugin);
                }
                return matchesPattern;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                return false;
            }
        }
    }
}

