/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.plugins.internal;

import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.thym.core.plugin.registry.plugin.CordovaRegistryPlugin;
import org.eclipse.thym.core.plugin.registry.plugin.CordovaRegistryPluginVersion;
import org.eclipse.thym.ui.plugins.internal.ControlListItem;
import org.eclipse.thym.ui.plugins.internal.CordovaPluginViewer;
import org.eclipse.thym.ui.plugins.internal.CordovaPluginWizardResources;

public class CordovaPluginItem
extends ControlListItem<CordovaRegistryPlugin> {
    private static final int MAX_DESCRIPTION_LENGTH = 162;
    private final CordovaPluginViewer viewer;
    private final CordovaPluginWizardResources resources;
    private Label description;
    private Label nameLabel;
    private Label licenseLbl;
    private CordovaRegistryPluginVersion currentSelectedVersion;
    private ComboViewer versionComboViewer;

    public CordovaPluginItem(Composite parent, int style, CordovaRegistryPlugin element, CordovaPluginWizardResources resources, CordovaPluginViewer viewer) {
        super(parent, 0, element);
        this.viewer = viewer;
        this.resources = resources;
    }

    @Override
    protected void refresh() {
        if (this.nameLabel == null) {
            this.createContent();
        }
    }

    private void createContent() {
        GridLayout layout = new GridLayout(3, false);
        layout.marginLeft = 7;
        layout.marginTop = 2;
        layout.marginBottom = 2;
        this.setLayout((Layout)layout);
        Composite versionContainer = new Composite((Composite)this, 0);
        GridDataFactory.swtDefaults().align(0x1000000, 1).span(1, 2).applyTo((Control)versionContainer);
        GridLayoutFactory.fillDefaults().spacing(1, 1).numColumns(2).applyTo(versionContainer);
        Combo versionCombo = new Combo(versionContainer, 8);
        this.versionComboViewer = new ComboViewer(versionCombo);
        this.versionComboViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                List versions = ((CordovaRegistryPlugin)CordovaPluginItem.this.getData()).getVersions();
                return versions.toArray();
            }
        });
        this.versionComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                CordovaRegistryPluginVersion ver = (CordovaRegistryPluginVersion)element;
                return ver.getVersion();
            }
        });
        this.versionComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                CordovaRegistryPluginVersion selectedVersion = (CordovaRegistryPluginVersion)selection.getFirstElement();
                CordovaPluginItem.this.modifyVersionSelection(selectedVersion);
            }
        });
        this.versionComboViewer.setInput((Object)((CordovaRegistryPlugin)this.getData()).getVersions());
        this.versionComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.getLatestCordovaRegistryPluginVersion()));
        GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).applyTo((Control)versionCombo);
        this.modifyVersionSelection(null);
        this.nameLabel = new Label((Composite)this, 0);
        GridDataFactory.fillDefaults().grab(true, false).align(1, 0x1000000).applyTo((Control)this.nameLabel);
        this.nameLabel.setFont(this.resources.getSmallHeaderFont());
        this.nameLabel.setText(((CordovaRegistryPlugin)this.getData()).getName());
        this.description = new Label((Composite)this, 64);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).hint(100, -1).applyTo((Control)this.description);
        Composite detailsContainer = new Composite((Composite)this, 0);
        GridDataFactory.swtDefaults().align(4, 0x1000000).span(3, 1).applyTo((Control)detailsContainer);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(detailsContainer);
        this.licenseLbl = new Label(detailsContainer, 0);
        this.licenseLbl.setFont(this.resources.getSubTextFont());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.licenseLbl);
        this.setDescriptionText(((CordovaRegistryPlugin)this.getData()).getDescription());
        this.licenseLbl.setText("License:" + ((CordovaRegistryPlugin)this.getData()).getLatestVersion().getLicense());
        Label separator = new Label((Composite)this, 258);
        GridDataFactory.fillDefaults().indent(0, 2).grab(true, false).span(3, 1).align(4, 1).applyTo((Control)separator);
    }

    private void modifyVersionSelection(CordovaRegistryPluginVersion selectedVersion) {
        if (selectedVersion == null) {
            selectedVersion = this.getLatestCordovaRegistryPluginVersion();
        }
        if (this.currentSelectedVersion != null) {
            this.viewer.modifySelection(this.currentSelectedVersion, true);
        }
        this.currentSelectedVersion = selectedVersion;
        this.viewer.modifySelection(this.currentSelectedVersion, false);
    }

    private CordovaRegistryPluginVersion getLatestCordovaRegistryPluginVersion() {
        CordovaRegistryPlugin plugin = (CordovaRegistryPlugin)this.getData();
        return plugin.getLatestVersion();
    }

    private void setDescriptionText(String descriptionText) {
        if (descriptionText == null) {
            descriptionText = "";
        }
        if (descriptionText.length() > 162) {
            descriptionText = descriptionText.substring(0, 162);
        }
        this.description.setText(descriptionText.replaceAll("(\\r\\n)|\\n|\\r", " "));
    }
}

