/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.plugins.internal;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.plugin.CordovaPluginManager;
import org.eclipse.thym.core.plugin.registry.plugin.CordovaRegistryPluginVersion;
import org.eclipse.thym.ui.HybridUI;
import org.eclipse.thym.ui.internal.status.StatusManager;
import org.eclipse.thym.ui.plugins.internal.CordovaPluginSelectionPage;
import org.eclipse.thym.ui.plugins.internal.ICordovaPluginWizard;
import org.eclipse.thym.ui.plugins.internal.RegistryConfirmPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class CordovaPluginWizard
extends Wizard
implements IWorkbenchWizard,
ICordovaPluginWizard {
    static final String IMAGE_WIZBAN = "/icons/wizban/cordova_plugin_wiz.png";
    private static final String DIALOG_SETTINGS_KEY = "CordovaPluginWizard";
    private CordovaPluginSelectionPage pageOne;
    private RegistryConfirmPage pageTwo;
    private IStructuredSelection initialSelection;
    private HybridProject fixedProject;
    private int initialSource;

    public CordovaPluginWizard() {
        this.setWindowTitle("Cordova Plug-in Discovery");
        this.setNeedsProgressMonitor(true);
        IDialogSettings workbenchSettings = HybridUI.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(DIALOG_SETTINGS_KEY);
        this.setDialogSettings(section);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.initialSelection = selection;
    }

    public void init(HybridProject project, int initialSourceTab) {
        this.fixedProject = project;
        this.initialSource = initialSourceTab;
    }

    public boolean performFinish() {
        HybridProject project = HybridProject.getHybridProject((String)this.pageOne.getProjectName());
        if (project == null) {
            return false;
        }
        CordovaPluginManager pm = new CordovaPluginManager(project);
        PluginInstallOperation op = null;
        switch (this.pageOne.getPluginSourceType()) {
            case 3: {
                File directory = new File(this.pageOne.getSelectedDirectory());
                op = new PluginInstallOperation(directory, pm);
                break;
            }
            case 2: {
                URI uri = URI.create(this.pageOne.getSpecifiedGitURL());
                op = new PluginInstallOperation(uri, pm);
                break;
            }
            case 1: {
                List<CordovaRegistryPluginVersion> plugins = this.pageTwo.getSelectedPluginVersions();
                op = new PluginInstallOperation(plugins, pm);
                break;
            }
            default: {
                Assert.isTrue((boolean)false, (String)"No valid plugin source can be determined");
            }
        }
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null) {
                if (e.getTargetException() instanceof CoreException) {
                    StatusManager.handle((CoreException)e.getTargetException());
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)"Plug-in installation problem", null, (IStatus)new Status(4, "org.eclipse.thym.ui", "Errors occured during plug-in installation", e.getTargetException()));
                    return false;
                }
            }
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        this.savePageSettings();
        return true;
    }

    public void addPages() {
        this.pageOne = this.fixedProject == null ? new CordovaPluginSelectionPage(this.initialSelection) : new CordovaPluginSelectionPage(this.fixedProject, this.initialSource);
        this.addPage((IWizardPage)this.pageOne);
        this.pageTwo = new RegistryConfirmPage();
        this.addPage((IWizardPage)this.pageTwo);
    }

    @Override
    public WizardPage getRegistryConfirmPage() {
        return this.pageTwo;
    }

    HybridProject getFixedProject() {
        return this.fixedProject;
    }

    private void savePageSettings() {
        IDialogSettings workbenchSettings = HybridUI.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(DIALOG_SETTINGS_KEY);
        if (section == null) {
            section = workbenchSettings.addNewSection(DIALOG_SETTINGS_KEY);
        }
        this.setDialogSettings(section);
        this.pageOne.saveWidgetValues();
    }

    @Override
    public boolean isPluginSelectionOptional() {
        return false;
    }

    private class PluginInstallOperation
    extends WorkspaceModifyOperation {
        private CordovaPluginManager pm;
        private int opType;
        private File dir;
        private URI gitRepo;
        private List<CordovaRegistryPluginVersion> plugins;

        private PluginInstallOperation(CordovaPluginManager pm) {
            this.pm = pm;
        }

        public PluginInstallOperation(File directory, CordovaPluginManager pm) {
            this(pm);
            this.dir = directory;
            this.opType = 3;
        }

        public PluginInstallOperation(URI gitRepo, CordovaPluginManager pm) {
            this(pm);
            this.gitRepo = gitRepo;
            this.opType = 2;
        }

        public PluginInstallOperation(List<CordovaRegistryPluginVersion> plugins, CordovaPluginManager pm) {
            this(pm);
            this.plugins = plugins;
            this.opType = 1;
        }

        protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
            switch (this.opType) {
                case 3: {
                    this.pm.installPlugin(this.dir, monitor);
                    break;
                }
                case 2: {
                    this.pm.installPlugin(this.gitRepo, monitor);
                    break;
                }
                case 1: {
                    for (CordovaRegistryPluginVersion cordovaRegistryPluginVersion : this.plugins) {
                        this.pm.installPlugin(cordovaRegistryPluginVersion, monitor);
                    }
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false, (String)"No valid plugin source can be determined");
                }
            }
        }
    }
}

