/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.internal.project;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.engine.HybridMobileEngine;
import org.eclipse.thym.ui.internal.project.AbstractCordovaHandler;
import org.eclipse.thym.ui.platforms.internal.PlatformRemovalAction;
import org.eclipse.thym.ui.platforms.navigator.internal.HybridPlatformFolder;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class RemovePlatformHandler
extends AbstractCordovaHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = this.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        ArrayList<HybridMobileEngine> platformsToRemove = new ArrayList<HybridMobileEngine>();
        HybridProject project = null;
        for (Object o : selection) {
            if (!(o instanceof HybridPlatformFolder)) continue;
            HybridPlatformFolder folder = (HybridPlatformFolder)((Object)o);
            platformsToRemove.add(folder.getPlatform());
            project = HybridProject.getHybridProject((IProject)folder.getFolder().getProject());
        }
        new PlatformRemovalAction(project, platformsToRemove).run();
        return null;
    }

    private IStructuredSelection getSelection() {
        ISelection selection;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (selection = window.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }
}

