/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.internal.wizard.imports;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.config.Widget;
import org.eclipse.thym.core.config.WidgetModel;
import org.eclipse.thym.ui.HybridUI;
import org.eclipse.thym.ui.internal.status.StatusManager;
import org.eclipse.thym.ui.wizard.project.HybridProjectCreator;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class HybridProjectImportPage
extends WizardPage
implements IOverwriteQuery {
    private static final String SETTINGSKEY_DIRECTORIES = "HybridProjectImportPage.DIRECTORIES";
    private static final String SETTINGSKEY_COPY = "HybridProjectImportPage.COPY";
    private Combo directoryPathField;
    private String previouslyBrowsedDirectory = "";
    private ProjectCandidate[] candidates;
    private CheckboxTreeViewer projectList;
    private Button copyCheckbox;
    private boolean copyFiles;

    protected HybridProjectImportPage() {
        super("HybridProjectImportPage");
        this.setTitle("Cordova Project Import");
        this.setDescription("Select a directory to search for Cordova projects");
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        GridLayoutFactory.fillDefaults().applyTo(workArea);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)workArea);
        this.createProjectRoot(workArea);
        this.createProjectsList(workArea);
        this.createOptionsGroup(workArea);
        this.restoreFromHistory();
        this.setPageComplete(this.validatePage());
        Dialog.applyDialogFont((Control)workArea);
    }

    private void createProjectsList(Composite workArea) {
        Label projectsLabel = new Label(workArea, 0);
        projectsLabel.setText("Projects:");
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)projectsLabel);
        Composite projectListGroup = new Composite(workArea, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)projectListGroup);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(projectListGroup);
        this.projectList = new CheckboxTreeViewer(projectListGroup);
        PixelConverter pc = new PixelConverter(this.projectList.getControl());
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).hint(pc.convertWidthInCharsToPixels(25), pc.convertHeightInCharsToPixels(10)).applyTo(this.projectList.getControl());
        this.projectList.setLabelProvider((IBaseLabelProvider)new ProjectCandidateLabelProvider());
        this.projectList.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                if (HybridProjectImportPage.this.candidates == null) {
                    return new ProjectCandidate[0];
                }
                return HybridProjectImportPage.this.candidates;
            }

            public Object[] getChildren(Object parentElement) {
                return null;
            }
        });
        this.projectList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ProjectCandidate candidate = (ProjectCandidate)event.getElement();
                if (candidate.exists()) {
                    HybridProjectImportPage.this.projectList.setChecked((Object)candidate, false);
                    return;
                }
                HybridProjectImportPage.this.updateConflicts(candidate, event.getChecked());
                HybridProjectImportPage.this.projectList.refresh(true);
                HybridProjectImportPage.this.setPageComplete(HybridProjectImportPage.this.validatePage());
            }
        });
        Composite selectButtonGroup = new Composite(projectListGroup, 0);
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)selectButtonGroup);
        GridLayoutFactory.fillDefaults().applyTo(selectButtonGroup);
        Button selectAll = new Button(selectButtonGroup, 8);
        selectAll.setText("Select All");
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)selectAll);
        Button deselectAll = new Button(selectButtonGroup, 8);
        deselectAll.setText("Deselect All");
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)deselectAll);
        Button refresh = new Button(selectButtonGroup, 8);
        refresh.setText("Refresh");
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)refresh);
        selectAll.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (HybridProjectImportPage.this.candidates != null) {
                    ProjectCandidate[] projectCandidateArray = HybridProjectImportPage.this.candidates;
                    int n = projectCandidateArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ProjectCandidate candie = projectCandidateArray[n2];
                        if (!candie.conflicts && !candie.exists()) {
                            HybridProjectImportPage.this.projectList.setChecked((Object)candie, true);
                            HybridProjectImportPage.this.updateConflicts(candie, true);
                        }
                        ++n2;
                    }
                }
                HybridProjectImportPage.this.setPageComplete(HybridProjectImportPage.this.validatePage());
            }
        });
        deselectAll.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (HybridProjectImportPage.this.candidates != null) {
                    ProjectCandidate[] projectCandidateArray = HybridProjectImportPage.this.candidates;
                    int n = projectCandidateArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ProjectCandidate candie = projectCandidateArray[n2];
                        HybridProjectImportPage.this.projectList.setChecked((Object)candie, false);
                        HybridProjectImportPage.this.updateConflicts(candie, false);
                        ++n2;
                    }
                }
                HybridProjectImportPage.this.setPageComplete(false);
            }
        });
        refresh.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                HybridProjectImportPage.this.updateProjectsList(HybridProjectImportPage.this.directoryPathField.getText());
            }
        });
        this.projectList.setInput((Object)this);
    }

    private void createProjectRoot(Composite workArea) {
        Composite projectRootGroup = new Composite(workArea, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(0, 10).applyTo(projectRootGroup);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 4).applyTo((Control)projectRootGroup);
        Label directoryLabel = new Label(projectRootGroup, 0);
        directoryLabel.setText("Select root directory:");
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)directoryLabel);
        this.directoryPathField = new Combo(projectRootGroup, 2048);
        PixelConverter pixelConverter = new PixelConverter((Control)this.directoryPathField);
        GridDataFactory.fillDefaults().grab(true, false).hint(pixelConverter.convertWidthInCharsToPixels(25), -1).applyTo((Control)this.directoryPathField);
        Button browseDirectoriesButton = new Button(projectRootGroup, 8);
        browseDirectoriesButton.setText("Browse...");
        GridDataFactory.fillDefaults().applyTo((Control)browseDirectoriesButton);
        browseDirectoriesButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                HybridProjectImportPage.this.handleBrowseButtonPressed();
            }
        });
        this.directoryPathField.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                HybridProjectImportPage.this.updateProjectsList(HybridProjectImportPage.this.directoryPathField.getText());
            }
        });
    }

    private void handleBrowseButtonPressed() {
        DirectoryDialog dialog = new DirectoryDialog(this.directoryPathField.getShell(), 0x10000000);
        dialog.setMessage("Select search directory");
        String dirName = this.directoryPathField.getText().trim();
        if (dirName.isEmpty()) {
            dirName = this.previouslyBrowsedDirectory;
        }
        if (dirName.isEmpty()) {
            dialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
        } else {
            File path = new File(dirName);
            if (path.exists()) {
                dialog.setFilterPath(new Path(dirName).toOSString());
            }
        }
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            this.previouslyBrowsedDirectory = selectedDirectory;
            this.directoryPathField.setText(this.previouslyBrowsedDirectory);
            this.updateProjectsList(selectedDirectory);
        }
    }

    private void updateConflicts(ProjectCandidate candidate, boolean checked) {
        ProjectCandidate[] projectCandidateArray = this.candidates;
        int n = this.candidates.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectCandidate elem = projectCandidateArray[n2];
            Widget w1 = elem.getWidget();
            Widget w2 = candidate.getWidget();
            if (w1.getId().equals(w2.getId()) && w1.getName().equals(w2.getName()) && !elem.configLocation.equals(candidate.configLocation)) {
                if (this.projectList.getChecked((Object)elem)) {
                    this.projectList.setChecked((Object)candidate, false);
                } else {
                    elem.conflicts = checked;
                }
            }
            ++n2;
        }
    }

    private void updateProjectsList(String selectedDirectory) {
        if (selectedDirectory == null || selectedDirectory.isEmpty()) {
            this.candidates = null;
            this.projectList.refresh(true);
            return;
        }
        final File directory = new File(selectedDirectory);
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (directory.isDirectory()) {
                        ArrayList<ProjectCandidate> candies = new ArrayList<ProjectCandidate>();
                        HybridProjectImportPage.this.collectProjectCandidates(candies, directory, monitor);
                        HybridProjectImportPage.this.candidates = candies.toArray(new ProjectCandidate[candies.size()]);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null) {
                if (e.getTargetException() instanceof CoreException) {
                    StatusManager.handle((CoreException)e.getTargetException());
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)"Error finding projects to import", null, (IStatus)new Status(4, "org.eclipse.thym.ui", "Error while searching for projects to import", e.getTargetException()));
                }
            }
        }
        catch (InterruptedException e) {
            HybridUI.log(4, "Error searchig projects to import", e);
        }
        this.projectList.refresh(true);
    }

    protected void collectProjectCandidates(List<ProjectCandidate> candidates, File directory, IProgressMonitor monitor) {
        File[] dirs;
        if (monitor.isCanceled()) {
            return;
        }
        File[] configXMLs = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return "config.xml".equals(name);
            }
        });
        if (configXMLs == null) {
            return;
        }
        File[] fileArray = configXMLs;
        int n = configXMLs.length;
        int n2 = 0;
        while (n2 < n) {
            File config = fileArray[n2];
            File parent = config.getParentFile();
            ProjectCandidate candidate = null;
            if (config.isFile()) {
                if (parent.getName().equals("www")) {
                    candidate = new ProjectCandidate(parent, config);
                } else {
                    File sameLevelWWW = new File(parent, "www");
                    if (sameLevelWWW.isDirectory()) {
                        candidate = new ProjectCandidate(sameLevelWWW, config);
                    }
                }
            }
            if (candidate != null) {
                candidates.add(candidate);
                return;
            }
            ++n2;
        }
        File[] fileArray2 = dirs = directory.listFiles();
        int n3 = dirs.length;
        n = 0;
        while (n < n3) {
            File dir = fileArray2[n];
            this.collectProjectCandidates(candidates, dir, monitor);
            ++n;
        }
    }

    private void createOptionsGroup(Composite workArea) {
        Group optionsGroup = new Group(workArea, 0);
        optionsGroup.setText("Options:");
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo((Composite)optionsGroup);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 4).applyTo((Control)optionsGroup);
        this.copyCheckbox = new Button((Composite)optionsGroup, 32);
        this.copyCheckbox.setText("Copy into workspace");
        GridDataFactory.fillDefaults().align(4, 4);
        this.copyCheckbox.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                HybridProjectImportPage.this.copyFiles = HybridProjectImportPage.this.copyCheckbox.getSelection();
                HybridProjectImportPage.this.setPageComplete(HybridProjectImportPage.this.validatePage());
            }
        });
    }

    private void restoreFromHistory() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings == null) {
            return;
        }
        String[] sourceNames = settings.getArray(SETTINGSKEY_DIRECTORIES);
        if (sourceNames == null) {
            return;
        }
        String[] stringArray = sourceNames;
        int n = sourceNames.length;
        int n2 = 0;
        while (n2 < n) {
            String dirname = stringArray[n2];
            this.directoryPathField.add(dirname);
            ++n2;
        }
        this.copyFiles = settings.getBoolean(SETTINGSKEY_COPY);
        this.copyCheckbox.setSelection(this.copyFiles);
    }

    private void saveInHistroy() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(SETTINGSKEY_DIRECTORIES);
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            ArrayList<String> l = new ArrayList<String>(Arrays.asList(sourceNames));
            l.remove(this.directoryPathField.getText());
            l.add(0, this.directoryPathField.getText());
            sourceNames = l.toArray(new String[l.size()]);
            settings.put(SETTINGSKEY_DIRECTORIES, sourceNames);
            settings.put(SETTINGSKEY_COPY, this.copyCheckbox.getSelection());
        }
    }

    boolean createProjects() {
        this.saveInHistroy();
        final Object[] selectedCandidates = this.projectList.getCheckedElements();
        WorkspaceModifyOperation wop = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("", selectedCandidates.length);
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                try {
                    try {
                        int i = 0;
                        while (i < selectedCandidates.length) {
                            ProjectCandidate pc = (ProjectCandidate)selectedCandidates[i];
                            IProject prj = HybridProjectImportPage.this.doCreateProject(pc, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            HybridProject.getHybridProject((IProject)prj);
                            ++i;
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)wop);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null) {
                if (e.getTargetException() instanceof CoreException) {
                    StatusManager.handle((CoreException)e.getTargetException());
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)"Error importing project", null, (IStatus)new Status(4, "org.eclipse.thym.ui", "Project import error", e.getTargetException()));
                }
            }
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
        return true;
    }

    private IProject doCreateProject(ProjectCandidate pc, IProgressMonitor monitor) throws CoreException, InterruptedException {
        HybridProjectCreator projectCreator = new HybridProjectCreator();
        Widget w = pc.getWidget();
        String projectName = pc.getProjectName();
        URI location = null;
        if (!this.copyFiles) {
            location = pc.wwwLocation.getParentFile().toURI();
        }
        IProject project = projectCreator.createProject(projectName, location, w.getName(), w.getId(), null, monitor);
        if (this.copyFiles) {
            ImportOperation operation;
            block5: {
                operation = new ImportOperation(project.getFullPath(), (Object)pc.wwwLocation.getParentFile(), (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, (IOverwriteQuery)this);
                operation.setContext(this.getShell());
                operation.setOverwriteResources(true);
                operation.setCreateContainerStructure(false);
                try {
                    operation.run(monitor);
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() == null || !(e.getCause() instanceof CoreException)) break block5;
                    CoreException corex = (CoreException)e.getCause();
                    throw corex;
                }
            }
            IStatus status = operation.getStatus();
            if (!status.isOK()) {
                throw new CoreException(status);
            }
        }
        return project;
    }

    private boolean validatePage() {
        Object[] selectedCandidates = this.projectList.getCheckedElements();
        if (selectedCandidates.length < 1) {
            String msg = null;
            if (this.candidates != null) {
                ProjectCandidate[] projectCandidateArray = this.candidates;
                int n = this.candidates.length;
                int n2 = 0;
                while (n2 < n) {
                    ProjectCandidate candie = projectCandidateArray[n2];
                    if (candie.exists()) {
                        msg = "Some projects cannot be imported because they already exist in the workspace";
                    }
                    ++n2;
                }
            }
            this.setMessage(msg, 2);
            this.setErrorMessage(null);
            return false;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        int i = 0;
        while (i < selectedCandidates.length) {
            File[] files;
            IStatus locationStatus;
            ProjectCandidate pc = (ProjectCandidate)selectedCandidates[i];
            IStatus nameStatus = workspace.validateName(pc.getProjectName(), 4);
            if (!nameStatus.isOK()) {
                this.setErrorMessage(nameStatus.getMessage());
                return false;
            }
            IProject handle = workspace.getRoot().getProject(pc.getProjectName());
            if (handle.exists()) {
                this.setErrorMessage(NLS.bind((String)"Project {0} already exists in the workspace", (Object)pc.getProjectName()));
                return false;
            }
            IPath projectLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(pc.getProjectName());
            if (projectLocation.toFile().exists()) {
                try {
                    String canonicalPath = projectLocation.toFile().getCanonicalPath();
                    projectLocation = new Path(canonicalPath);
                }
                catch (IOException e) {
                    HybridUI.log(2, "Error getting canonical path", e);
                }
                String existingName = projectLocation.lastSegment();
                if (!existingName.equals(pc.getProjectName())) {
                    this.setErrorMessage(NLS.bind((String)"Project name {0} already exists on the workspace", (Object)existingName));
                    return false;
                }
            }
            Path projectPath = null;
            if (!this.copyFiles) {
                projectPath = new Path(pc.wwwLocation.getParentFile().toString());
            }
            if (!(locationStatus = workspace.validateProjectLocation(handle, projectPath)).isOK()) {
                this.setErrorMessage(locationStatus.getMessage());
                return false;
            }
            File[] fileArray = files = pc.wwwLocation.getParentFile().listFiles();
            int n = files.length;
            int n3 = 0;
            while (n3 < n) {
                File file = fileArray[n3];
                if (file.isFile() && ".project".equals(file.getName())) {
                    this.setMessage(NLS.bind((String)"A project description for {0} already exists and will be replaced, use existing project import to restore the project", (Object)pc.getProjectName()), 2);
                    return false;
                }
                ++n3;
            }
            ++i;
        }
        this.setMessage(null);
        this.setErrorMessage(null);
        return true;
    }

    public String queryOverwrite(String pathString) {
        return "ALL";
    }

    private class ProjectCandidate {
        private Widget widget;
        File wwwLocation;
        File configLocation;
        boolean conflicts;

        public ProjectCandidate(File www, File config) {
            this.configLocation = config;
            this.wwwLocation = www;
        }

        String getLabel() {
            if (this.getWidget() == null) {
                return NLS.bind((String)"INVALID {0}", (Object)this.wwwLocation.toString());
            }
            String appName = this.getProjectName();
            return NLS.bind((String)"{0} ({1})", (Object[])new String[]{appName, this.wwwLocation.toString()});
        }

        String getProjectName() {
            String projectName = this.getWidget().getId();
            if (this.widget.getName() != null) {
                projectName = this.getWidget().getName();
            }
            return projectName;
        }

        boolean exists() {
            if (this.getWidget() == null) {
                return true;
            }
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            String projectName = this.getProjectName();
            IPath wsPath = root.getLocation();
            IPath localProjectPath = wsPath.append(projectName);
            IProject project = root.getProject(projectName);
            return project.exists() || localProjectPath.toFile().exists();
        }

        Widget getWidget() {
            if (this.widget == null) {
                try {
                    this.widget = WidgetModel.parseToWidget((File)this.configLocation);
                }
                catch (CoreException e) {
                    HybridUI.log(4, "Error parsing the config.xml for import project", e);
                }
            }
            return this.widget;
        }
    }

    private final class ProjectCandidateLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private ProjectCandidateLabelProvider() {
        }

        public String getText(Object element) {
            return ((ProjectCandidate)element).getLabel();
        }

        public Color getForeground(Object element) {
            ProjectCandidate candie = (ProjectCandidate)element;
            if (candie.conflicts || candie.exists()) {
                return HybridProjectImportPage.this.getShell().getDisplay().getSystemColor(16);
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }
}

