/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.platforms.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.ui.wizard.project.EngineConfigurationPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

public class CordovaPlatformWizard
extends Wizard
implements IWorkbenchWizard {
    private HybridProject project;
    private EngineConfigurationPage enginePage;

    public CordovaPlatformWizard() {
        this.setWindowTitle("Cordova Platform Wizard");
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (selection != null && !selection.isEmpty()) {
            for (Object obj : selection) {
                IResource res;
                IProject project;
                HybridProject hybrid;
                if (!(obj instanceof IResource) || (hybrid = HybridProject.getHybridProject((IProject)(project = (res = (IResource)obj).getProject()))) == null) continue;
                this.project = hybrid;
            }
        }
    }

    public boolean performFinish() {
        try {
            this.project.getEngineManager().updateEngines(this.enginePage.getSelectedEngines());
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)"Hybrid Mobile Engine Update failed", (String)("Unable to update the active engine for the project " + this.project.getProject().getName()), (IStatus)e.getStatus());
            return false;
        }
        return true;
    }

    public void addPages() {
        this.enginePage = new EngineConfigurationPage(this.project);
        this.addPage((IWizardPage)this.enginePage);
    }
}

