/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.platforms.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.engine.HybridMobileEngine;
import org.eclipse.thym.ui.HybridUI;
import org.eclipse.ui.PlatformUI;

public class PlatformRemovalAction
extends Action {
    private List<HybridMobileEngine> platformsToRemove;
    private HybridProject project;
    private static final String UNINSTALL_ICON = "/icons/obj16/cordova_16.png";

    public PlatformRemovalAction(HybridProject project, List<HybridMobileEngine> platformsToRemove) {
        super("Remove Cordova Platform");
        this.project = project;
        this.platformsToRemove = platformsToRemove;
    }

    public void run() {
        if (this.platformsToRemove != null && !this.platformsToRemove.isEmpty()) {
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            for (HybridMobileEngine cordovaPlatform : PlatformRemovalAction.this.platformsToRemove) {
                                monitor.subTask(NLS.bind((String)"Uninstalling {0} platform", (Object)cordovaPlatform.getName()));
                                PlatformRemovalAction.this.project.getEngineManager().removeEngine(cordovaPlatform, monitor, true);
                            }
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                HybridUI.log(4, "Error while removing a Cordova platform ", e);
            }
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return HybridUI.getImageDescriptor("org.eclipse.thym.ui", UNINSTALL_ICON);
    }
}

