/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.plugins.navigator.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.plugin.CordovaPlugin;
import org.eclipse.thym.ui.HybridUI;
import org.eclipse.thym.ui.plugins.navigator.internal.HybridPluginFolder;

public class PluginContentProvider
implements ITreeContentProvider,
IResourceChangeListener {
    private Viewer viewer;

    public PluginContentProvider() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
    }

    public Object[] getElements(Object inputElement) {
        return null;
    }

    public Object[] getChildren(Object parentElement) {
        if (!(parentElement instanceof IFolder)) {
            return new Object[0];
        }
        IFolder folder = (IFolder)parentElement;
        if (folder.getProjectRelativePath().segmentCount() > 1) {
            return new Object[0];
        }
        ArrayList<HybridPluginFolder> plugins = new ArrayList<HybridPluginFolder>();
        HybridProject project = HybridProject.getHybridProject((IProject)folder.getProject());
        try {
            IResource[] iResourceArray = folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                if (member instanceof IFolder) {
                    IFolder pluginFolder = (IFolder)member;
                    plugins.add(new HybridPluginFolder(pluginFolder, this.getPlugin(pluginFolder.getName(), project)));
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            HybridUI.log(4, "Error retrieving the installed plugins", e);
        }
        return plugins.toArray();
    }

    private CordovaPlugin getPlugin(String name, HybridProject project) throws CoreException {
        for (CordovaPlugin plugin : project.getPluginManager().getInstalledPlugins()) {
            if (!plugin.getId().equals(name)) continue;
            return plugin;
        }
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (!(element instanceof IFolder)) {
            return false;
        }
        IFolder folder = (IFolder)element;
        if (folder.getProjectRelativePath().segmentCount() > 1) {
            return false;
        }
        HybridProject project = HybridProject.getHybridProject((IProject)folder.getProject());
        try {
            List plugins = project.getPluginManager().getInstalledPlugins();
            return plugins.isEmpty();
        }
        catch (CoreException e) {
            HybridUI.log(4, "Error determining the installed plugins", e);
            return false;
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (this.viewer == null || delta == null) {
            return;
        }
        IResourceDelta[] deltas = delta.getAffectedChildren();
        int i = 0;
        while (i < deltas.length) {
            if (deltas[i].findMember((IPath)new Path("plugins")) != null) {
                this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PluginContentProvider.this.viewer.refresh();
                    }
                });
                return;
            }
            ++i;
        }
    }
}

