/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.wizard.project;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.thym.core.HybridProjectConventions;
import org.eclipse.thym.core.internal.cordova.CordovaCLI;
import org.eclipse.thym.core.internal.cordova.ErrorDetectingCLIResult;
import org.eclipse.thym.ui.HybridUI;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.dialogs.WorkingSetGroup;
import org.osgi.framework.Version;

public class WizardNewHybridProjectCreationPage
extends WizardNewProjectCreationPage {
    private Text txtName;
    private Text txtID;
    private WorkingSetGroup workingSetGroup;
    private final PropertyModifyListener propertyModifyListener = new PropertyModifyListener();
    private IStructuredSelection currentSelection;
    private CordovaIsAvailableJob cordovaIsAvailableJob;
    private CLabel cordovaLabel;
    private Boolean cordovaFound = null;

    public WizardNewHybridProjectCreationPage(String pageName, IStructuredSelection selection) {
        super(pageName);
        this.currentSelection = selection;
        this.setTitle("Create Hybrid Mobile Application Project");
        this.setDescription("Create a hybrid mobile application using Apache Cordova for cross-platform mobile development");
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Group applicationGroup = new Group((Composite)this.getControl(), 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        applicationGroup.setLayout((Layout)layout);
        applicationGroup.setLayoutData((Object)new GridData(768));
        applicationGroup.setText("Mobile Application");
        Label lblName = new Label((Composite)applicationGroup, 0);
        lblName.setText("Name:");
        this.txtName = new Text((Composite)applicationGroup, 2048);
        this.txtName.addModifyListener((ModifyListener)this.propertyModifyListener);
        this.txtName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtName.setMessage("a friendly name");
        Label lblId = new Label((Composite)applicationGroup, 0);
        lblId.setText("ID:");
        this.txtID = new Text((Composite)applicationGroup, 2048);
        this.txtID.setMessage("com.mycom.app");
        this.txtID.addModifyListener((ModifyListener)this.propertyModifyListener);
        this.txtID.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.createWorkingSetGroup();
        Group cordovaGroup = new Group((Composite)this.getControl(), 0);
        cordovaGroup.setText("Cordova version");
        layout = new GridLayout();
        layout.numColumns = 1;
        cordovaGroup.setLayout((Layout)layout);
        cordovaGroup.setLayoutData((Object)new GridData(768));
        this.cordovaLabel = new CLabel((Composite)cordovaGroup, 0);
        this.cordovaLabel.setImage(JFaceResources.getImage((String)"dialog_messasge_warning_image"));
        this.cordovaLabel.setText("Checking cordova availability...");
        this.cordovaLabel.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setPageComplete(this.validatePage());
        Dialog.applyDialogFont((Control)this.getControl());
        this.checkCordovaIsAvailable();
    }

    protected boolean validatePage() {
        if (this.cordovaFound == null) {
            this.setMessage("Checking cordova availability...", 2);
            this.getContainer().updateMessage();
            return false;
        }
        if (!this.cordovaFound.booleanValue()) {
            this.setMessage("Cordova not found, please run 'npm install -g cordova' on a command line", 3);
            this.getContainer().updateMessage();
            return false;
        }
        boolean superValidate = super.validatePage();
        if (!superValidate || this.txtID == null || this.txtName == null) {
            return superValidate;
        }
        if (!this.propertyModifyListener.isNameOrIDChanged()) {
            String id = HybridProjectConventions.generateProjectID((String)this.getProjectName());
            String name = HybridProjectConventions.generateApplicationName((String)this.getProjectName());
            this.propertyModifyListener.setSkipValidation(true);
            if (id != null) {
                this.txtID.setText(id);
            }
            this.txtName.setText(name);
            this.propertyModifyListener.setSkipValidation(false);
        }
        IStatus status1 = HybridProjectConventions.validateApplicationName((String)this.txtName.getText());
        IStatus status2 = HybridProjectConventions.validateProjectID((String)this.txtID.getText());
        IStatus status = null;
        if (status1.matches(4)) {
            status = status1;
        }
        if (status2.matches(4)) {
            status = status2;
        }
        if (status1.matches(2)) {
            status = status1;
        }
        if (status2.matches(2)) {
            status = status2;
        }
        if (status == null) {
            this.setErrorMessage(null);
            this.setMessage(null);
            return true;
        }
        if (status.getSeverity() == 4) {
            this.setMessage(status.getMessage(), 3);
            this.getContainer().updateMessage();
            return false;
        }
        if (status.getSeverity() == 2) {
            this.setMessage(status.getMessage(), 2);
            this.getContainer().updateMessage();
            return true;
        }
        return true;
    }

    private void createWorkingSetGroup() {
        String[] workingSetIds = new String[]{"org.eclipse.ui.resourceWorkingSetPage", "org.eclipse.wst.jsdt.ui.JavaWorkingSetPage"};
        this.workingSetGroup = new WorkingSetGroup((Composite)this.getControl(), this.currentSelection, workingSetIds);
    }

    public String getApplicationName() {
        return this.txtName.getText();
    }

    public String getApplicationID() {
        return this.txtID.getText();
    }

    public IWorkingSet[] getSelectedWorkingSets() {
        return this.workingSetGroup.getSelectedWorkingSets();
    }

    private void checkCordovaIsAvailable() {
        this.cordovaIsAvailableJob = new CordovaIsAvailableJob();
        this.cordovaIsAvailableJob.setUser(true);
        this.cordovaIsAvailableJob.schedule();
        this.cordovaIsAvailableJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (!WizardNewHybridProjectCreationPage.this.getControl().isDisposed()) {
                    Display display = WizardNewHybridProjectCreationPage.this.getControl().getDisplay();
                    final int severity = event.getJob().getResult().getSeverity();
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (severity == 0) {
                                if (WizardNewHybridProjectCreationPage.this.cordovaIsAvailableJob.getCordovaVersion() != null) {
                                    this.updateCordovaLabel(WizardNewHybridProjectCreationPage.this.cordovaIsAvailableJob.getCordovaVersion(), null, null, true);
                                } else {
                                    this.updateCordovaLabel("Cordova not found, please run 'npm install -g cordova' on a command line", JFaceResources.getImage((String)"dialog_message_error_image"), WizardNewHybridProjectCreationPage.this.getControl().getDisplay().getSystemColor(3), false);
                                }
                            } else {
                                this.updateCordovaLabel("Unable to determine if cordova is available", JFaceResources.getImage((String)"dialog_messasge_warning_image"), null, true);
                            }
                        }

                        private void updateCordovaLabel(String text, Image image, Color foreground, boolean found) {
                            WizardNewHybridProjectCreationPage.this.cordovaLabel.setText(text);
                            WizardNewHybridProjectCreationPage.this.cordovaLabel.setImage(image);
                            WizardNewHybridProjectCreationPage.this.cordovaLabel.setForeground(foreground);
                            WizardNewHybridProjectCreationPage.this.cordovaFound = found;
                            WizardNewHybridProjectCreationPage.this.setPageComplete(WizardNewHybridProjectCreationPage.this.validatePage());
                        }
                    });
                }
            }
        });
    }

    class CordovaIsAvailableJob
    extends Job {
        private String cordovaVersion;

        public CordovaIsAvailableJob() {
            super("Checking cordova availability");
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                ErrorDetectingCLIResult result = (ErrorDetectingCLIResult)new CordovaCLI().version(monitor).convertTo(ErrorDetectingCLIResult.class);
                if (result.asStatus().getCode() == 501) {
                    return Status.OK_STATUS;
                }
                if (result.asStatus().isOK()) {
                    this.cordovaVersion = Version.parseVersion((String)result.getMessage()).toString();
                    return Status.OK_STATUS;
                }
            }
            catch (Exception e) {
                HybridUI.log(2, "Unable to determine if cordova is available", e);
            }
            return new Status(2, "org.eclipse.thym.ui", "");
        }

        public String getCordovaVersion() {
            return this.cordovaVersion;
        }
    }

    class PropertyModifyListener
    implements ModifyListener {
        private boolean skipValidation = false;
        private boolean changed = false;

        PropertyModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (!this.skipValidation) {
                if (!(this.changed || e.widget != WizardNewHybridProjectCreationPage.this.txtID && e.widget != WizardNewHybridProjectCreationPage.this.txtName)) {
                    this.changed = true;
                }
                WizardNewHybridProjectCreationPage.this.setPageComplete(WizardNewHybridProjectCreationPage.this.validatePage());
            }
        }

        public void setSkipValidation(boolean skipValidation) {
            this.skipValidation = skipValidation;
        }

        public boolean isNameOrIDChanged() {
            return this.changed;
        }
    }
}

