/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.win.core.build;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.platform.AbstractNativeBinaryBuildDelegate;
import org.eclipse.thym.win.internal.core.Messages;

public class WinBuild
extends AbstractNativeBinaryBuildDelegate {
    public static final String WIN = "windows";

    public void buildNow(IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return;
        }
        try {
            monitor.beginTask(Messages.WinBuild_BuildProjectTask, 10);
            SubMonitor generateMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
            if (monitor.isCanceled()) {
                return;
            }
            HybridProject hybridProject = HybridProject.getHybridProject((IProject)this.getProject());
            if (hybridProject == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.win.core", Messages.WinBuild_NoHybridError));
            }
            String buildType = "--debug";
            if (this.isRelease()) {
                buildType = "--release";
            }
            hybridProject.build((IProgressMonitor)generateMonitor.split(90), new String[]{WIN, buildType});
        }
        finally {
            monitor.done();
        }
    }
}

