/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.thym.core.config.Widget;
import org.eclipse.thym.core.config.WidgetModel;
import org.eclipse.thym.core.engine.HybridMobileEngineManager;
import org.eclipse.thym.core.internal.cordova.CordovaProjectCLI;
import org.eclipse.thym.core.internal.cordova.ErrorDetectingCLIResult;
import org.eclipse.thym.core.platform.PlatformConstants;
import org.eclipse.thym.core.plugin.CordovaPluginManager;

public class HybridProject
implements IAdaptable {
    private IProject kernelProject;
    private CordovaPluginManager pluginManager;
    private HybridMobileEngineManager engineManager;

    private HybridProject(IProject project) {
        this.kernelProject = project;
    }

    public IProject getProject() {
        return this.kernelProject;
    }

    public static HybridProject getHybridProject(IProject project) {
        if (project == null) {
            return null;
        }
        try {
            if (project.hasNature("org.eclipse.thym.core.HybridAppNature")) {
                return new HybridProject(project);
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public static HybridProject getHybridProject(String projectName) {
        if (projectName == null || projectName.isEmpty()) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null) {
            return null;
        }
        return HybridProject.getHybridProject(project);
    }

    public CordovaPluginManager getPluginManager() {
        if (this.pluginManager == null) {
            this.pluginManager = new CordovaPluginManager(this);
        }
        return this.pluginManager;
    }

    public void build(IProgressMonitor monitor, String ... buildOptions) throws CoreException {
        ISchedulingRule rule = ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule((IResource)this.getProject());
        try {
            Job.getJobManager().beginRule(rule, monitor);
            SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor);
            sm.setWorkRemaining(100);
            ErrorDetectingCLIResult status = this.getProjectCLI().build((IProgressMonitor)sm.newChild(70), buildOptions).convertTo(ErrorDetectingCLIResult.class);
            this.getProject().refreshLocal(2, (IProgressMonitor)sm.newChild(30));
            if (status.asStatus().getSeverity() == 4) {
                throw new CoreException(status.asStatus());
            }
        }
        finally {
            Job.getJobManager().endRule(rule);
        }
    }

    public void prepare(IProgressMonitor monitor, String ... options) throws CoreException {
        ISchedulingRule rule = ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule((IResource)this.getProject());
        try {
            Job.getJobManager().beginRule(rule, monitor);
            SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor);
            sm.setWorkRemaining(100);
            ErrorDetectingCLIResult status = this.getProjectCLI().prepare((IProgressMonitor)sm.newChild(70), options).convertTo(ErrorDetectingCLIResult.class);
            this.getProject().refreshLocal(2, (IProgressMonitor)sm.newChild(30));
            if (status.asStatus().getSeverity() == 4) {
                throw new CoreException(status.asStatus());
            }
        }
        finally {
            Job.getJobManager().endRule(rule);
        }
    }

    public void emulate(IProgressMonitor monitor, String ... options) throws CoreException {
        ErrorDetectingCLIResult status = this.getProjectCLI().emulate(monitor, options).convertTo(ErrorDetectingCLIResult.class);
        if (status.asStatus().getSeverity() == 4) {
            throw new CoreException(status.asStatus());
        }
    }

    public void run(IProgressMonitor monitor, String ... options) throws CoreException {
        ErrorDetectingCLIResult status = this.getProjectCLI().run(monitor, options).convertTo(ErrorDetectingCLIResult.class);
        if (status.asStatus().getSeverity() == 4) {
            throw new CoreException(status.asStatus());
        }
    }

    public CordovaProjectCLI getProjectCLI() {
        return CordovaProjectCLI.newCLIforProject(this);
    }

    public void updateDerivedFolders(IProgressMonitor monitor) throws CoreException {
        IFolder folder;
        String derivedFolder;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String[] stringArray = PlatformConstants.DERIVED_SUBFOLDERS;
        int n = PlatformConstants.DERIVED_SUBFOLDERS.length;
        int n2 = 0;
        while (n2 < n) {
            derivedFolder = stringArray[n2];
            folder = this.getProject().getFolder(derivedFolder);
            if (folder != null && folder.exists()) {
                IResource[] iResourceArray = folder.members();
                int n3 = iResourceArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IResource member = iResourceArray[n4];
                    if (member instanceof IFolder) {
                        IFolder subFolder = (IFolder)member;
                        this.setDerivedFolder(subFolder, monitor);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        stringArray = PlatformConstants.DERIVED_FOLDERS;
        n = PlatformConstants.DERIVED_FOLDERS.length;
        n2 = 0;
        while (n2 < n) {
            derivedFolder = stringArray[n2];
            folder = this.getProject().getFolder(derivedFolder);
            this.setDerivedFolder(folder, monitor);
            ++n2;
        }
    }

    private void setDerivedFolder(IFolder folder, IProgressMonitor monitor) throws CoreException {
        if (folder != null && folder.exists() && !folder.isDerived()) {
            folder.setDerived(true, monitor);
        }
    }

    public String getAppName() {
        String name = null;
        try {
            WidgetModel widgetModel = WidgetModel.getModel(this);
            Widget w = widgetModel.getWidgetForRead();
            if (w != null) {
                name = w.getName();
            }
        }
        catch (CoreException coreException) {}
        if (name == null || name.isEmpty()) {
            name = this.kernelProject.getName();
        }
        return name;
    }

    public String getBuildArtifactAppName() {
        String name = this.getAppName();
        name = name.replaceAll("\\W", "_");
        return name;
    }

    public IFile getConfigFile() {
        IPath[] iPathArray = PlatformConstants.CONFIG_PATHS;
        int n = PlatformConstants.CONFIG_PATHS.length;
        int n2 = 0;
        while (n2 < n) {
            IPath configPath = iPathArray[n2];
            IFile f = this.kernelProject.getFile(configPath);
            if (f.exists()) {
                return f;
            }
            ++n2;
        }
        return null;
    }

    public HybridMobileEngineManager getEngineManager() {
        if (this.engineManager == null) {
            this.engineManager = new HybridMobileEngineManager(this);
        }
        return this.engineManager;
    }

    public boolean equals(Object obj) {
        if (this.kernelProject == null) {
            return super.equals(obj);
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HybridProject)) {
            return false;
        }
        IProject prj = ((HybridProject)obj).getProject();
        return this.kernelProject.equals((Object)prj);
    }

    public int hashCode() {
        if (this.kernelProject == null) {
            return super.hashCode();
        }
        return this.kernelProject.hashCode();
    }

    public Object getAdapter(Class adapter) {
        if (this.kernelProject == null) {
            return null;
        }
        if (adapter.isInstance(IProject.class)) {
            return this.kernelProject;
        }
        return this.kernelProject.getAdapter(adapter);
    }
}

