/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.config;

import org.eclipse.thym.core.config.AbstractConfigObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class ImageResourceBase
extends AbstractConfigObject {
    private AbstractConfigObject.Property<String> src = new AbstractConfigObject.Property("src");
    private AbstractConfigObject.Property<Integer> width = new AbstractConfigObject.Property("width");
    private AbstractConfigObject.Property<Integer> height = new AbstractConfigObject.Property("height");
    private AbstractConfigObject.Property<String> platform = new AbstractConfigObject.Property("platform");
    private AbstractConfigObject.Property<String> density = new AbstractConfigObject.Property("density");

    ImageResourceBase(Node node) {
        Node parent;
        String platformString;
        this.itemNode = (Element)node;
        this.src.setValue(this.getNodeAttribute(node, null, "src"));
        String s = this.getNodeAttribute(node, null, "width");
        if (s != null) {
            this.width.setValue(Integer.parseInt(s));
        }
        if ((s = this.getNodeAttribute(node, null, "height")) != null) {
            this.height.setValue(Integer.parseInt(s));
        }
        if ((platformString = this.getNodeAttribute(node, null, "platform")) == null && (parent = this.itemNode.getParentNode()).getNodeName().equals("platform")) {
            platformString = this.getNodeAttribute(parent, null, "name");
        }
        this.platform.setValue(platformString);
        this.density.setValue(this.getNodeAttribute(node, null, "density"));
    }

    public String getSrc() {
        return this.src.getValue();
    }

    public int getWidth() {
        if (this.width.getValue() == null) {
            return -1;
        }
        return this.width.getValue();
    }

    public int getHeight() {
        if (this.height.getValue() == null) {
            return -1;
        }
        return this.height.getValue();
    }

    public String getPlatform() {
        return this.platform.getValue();
    }

    public String getDensity() {
        return this.density.getValue();
    }

    public void setSrc(String src) {
        this.src.setValue(src);
        this.setAttributeValue(this.itemNode, null, "src", src);
    }

    public void setWidth(int width) {
        this.width.setValue(width);
        this.setAttributeValue(this.itemNode, null, "width", Integer.toString(width));
    }

    public void setHeight(int height) {
        this.height.setValue(height);
        this.setAttributeValue(this.itemNode, null, "height", Integer.toString(height));
    }

    public void setPlatform(String platform) {
        this.platform.setValue(platform);
        this.setAttributeValue(this.itemNode, null, "platform", platform);
    }

    public void setDensity(String density) {
        this.density.setValue(density);
        this.setAttributeValue(this.itemNode, null, "density", density);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ImageResourceBase)) {
            return false;
        }
        ImageResourceBase that = (ImageResourceBase)obj;
        return this.equalField(that.getSrc(), this.getSrc());
    }

    public int hashCode() {
        if (this.getSrc() != null) {
            return this.getSrc().hashCode();
        }
        return super.hashCode();
    }

    public final boolean isDefault() {
        return (this.getDensity() == null || this.getDensity().isEmpty()) && this.getWidth() < 0 && this.getHeight() < 0;
    }
}

