/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.config.AbstractConfigObject;
import org.eclipse.thym.core.config.Access;
import org.eclipse.thym.core.config.Author;
import org.eclipse.thym.core.config.Content;
import org.eclipse.thym.core.config.Engine;
import org.eclipse.thym.core.config.Feature;
import org.eclipse.thym.core.config.Icon;
import org.eclipse.thym.core.config.License;
import org.eclipse.thym.core.config.Plugin;
import org.eclipse.thym.core.config.Preference;
import org.eclipse.thym.core.config.Splash;
import org.eclipse.thym.core.config.Widget;
import org.eclipse.thym.core.internal.util.EngineUtils;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.cleanup.CleanupProcessorXML;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class WidgetModel
implements IModelStateListener {
    private static Map<HybridProject, WidgetModel> widgetModels = new HashMap<HybridProject, WidgetModel>();
    private static ResourceChangeListener resourceChangeListener;
    public static final String[] ICON_EXTENSIONS;
    private File configFile;
    private Widget editableWidget;
    private Widget readonlyWidget;
    private long readonlyTimestamp;
    private Widget lastWidget;
    public IStructuredModel underLyingModel;

    static {
        ICON_EXTENSIONS = new String[]{"gif", "ico", "jpeg", "jpg", "png", "svg"};
    }

    private WidgetModel(HybridProject project) {
        this(WidgetModel.getConfigXml(project));
    }

    private WidgetModel(File file) {
        this.configFile = file;
        if (resourceChangeListener == null) {
            resourceChangeListener = new ResourceChangeListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final WidgetModel getModel(HybridProject project) {
        if (project == null) {
            throw new NullPointerException("Widget model can not be created because hybrid project is null");
        }
        if (!widgetModels.containsKey(project)) {
            Class<WidgetModel> clazz = WidgetModel.class;
            synchronized (WidgetModel.class) {
                WidgetModel wm = new WidgetModel(project);
                if (wm.configFile != null) {
                    widgetModels.put(project, wm);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return wm;
            }
        }
        return widgetModels.get(project);
    }

    public static final Widget parseToWidget(File file) throws CoreException {
        if (file.isFile()) {
            WidgetModel model = new WidgetModel(file);
            return model.getWidgetForRead();
        }
        throw new IllegalArgumentException(NLS.bind((String)"File {0} does not exist ", (Object)file.toString()));
    }

    public static final void shutdown() {
        Collection<WidgetModel> createdModels = widgetModels.values();
        for (WidgetModel widgetModel : createdModels) {
            widgetModel.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Widget getWidgetForRead() throws CoreException {
        long enter = System.currentTimeMillis();
        if (this.configFile == null || !this.configFile.exists()) {
            return null;
        }
        if (this.readonlyWidget == null || this.readonlyTimestamp != this.configFile.lastModified()) {
            WidgetModel widgetModel = this;
            synchronized (widgetModel) {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                dbf.setValidating(false);
                try {
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    Document configDocument = db.parse(this.configFile);
                    this.readonlyWidget = this.load(configDocument);
                    this.readonlyTimestamp = this.configFile.lastModified();
                }
                catch (ParserConfigurationException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Parser error when parsing config.xml", (Throwable)e));
                }
                catch (SAXException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Failed to parse config.xml", (Throwable)e));
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "IO error when parsing config.xml", (Throwable)e));
                }
            }
        }
        HybridCore.trace("Completed WidgetModel.getWidgetForRead it " + Long.toString(System.currentTimeMillis() - enter) + "ms");
        return this.readonlyWidget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Widget getWidgetForEdit() throws CoreException {
        long enter = System.currentTimeMillis();
        if (this.editableWidget == null) {
            WidgetModel widgetModel = this;
            synchronized (widgetModel) {
                IFile configXml;
                block8: {
                    configXml = this.configXMLtoIFile();
                    if (configXml != null) break block8;
                    return null;
                }
                IModelManager manager = StructuredModelManager.getModelManager();
                try {
                    this.underLyingModel = manager.getModelForEdit(configXml);
                    if (this.underLyingModel != null && this.underLyingModel instanceof IDOMModel) {
                        this.underLyingModel.addModelStateListener((IModelStateListener)this);
                        IDOMModel domModel = (IDOMModel)this.underLyingModel;
                        this.editableWidget = this.load((Document)domModel.getDocument());
                        this.lastWidget = this.load((Document)domModel.getDocument());
                    }
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Error creating widget model", (Throwable)e));
                }
            }
        }
        HybridCore.trace("Completed WidgetModel.getWidgetForEdit it " + Long.toString(System.currentTimeMillis() - enter) + "ms");
        return this.editableWidget;
    }

    protected IFile configXMLtoIFile() {
        if (this.configFile == null) {
            return null;
        }
        IFile[] configFileCandidates = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(this.configFile.toURI());
        if (configFileCandidates == null || configFileCandidates.length == 0) {
            return null;
        }
        return configFileCandidates[0];
    }

    private static File getConfigXml(HybridProject project) {
        IPath location;
        IFile configXml = project.getConfigFile();
        if (configXml != null && configXml.exists() && (location = configXml.getLocation()) != null) {
            return location.toFile();
        }
        return null;
    }

    private Widget load(Document document) {
        Assert.isNotNull((Object)document, (String)"null document can not init widget");
        Element el = document.getDocumentElement();
        Assert.isNotNull((Object)el, (String)"null document root can not init widget");
        return new Widget(el);
    }

    public void reloadEditableWidget() {
        if (this.underLyingModel != null) {
            IDOMModel dom = (IDOMModel)this.underLyingModel;
            IDOMDocument document = dom.getDocument();
            this.editableWidget.reload(document.getDocumentElement());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws CoreException {
        if (this.editableWidget != null && this.underLyingModel != null) {
            WidgetModel widgetModel = this;
            synchronized (widgetModel) {
                CleanupProcessorXML cp = new CleanupProcessorXML();
                try {
                    cp.cleanupModel(this.underLyingModel);
                    this.underLyingModel.save();
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Error saving changes to config.xml", (Throwable)e));
                }
            }
        }
    }

    public Author createAuthor(Widget widget) {
        return this.createObject(widget, "http://www.w3.org/ns/widgets", "author", Author.class);
    }

    public Content createContent(Widget widget) {
        return this.createObject(widget, "http://www.w3.org/ns/widgets", "content", Content.class);
    }

    public Preference createPreference(Widget widget) {
        return this.createObject(widget, "http://www.w3.org/ns/widgets", "preference", Preference.class);
    }

    public Feature createFeature(Widget widget) {
        return this.createObject(widget, "http://www.w3.org/ns/widgets", "feature", Feature.class);
    }

    public Access createAccess(Widget widget) {
        return this.createObject(widget, "http://www.w3.org/ns/widgets", "access", Access.class);
    }

    public Icon createIcon(Widget widget) {
        return this.createObject(widget, "http://www.w3.org/ns/widgets", "icon", Icon.class);
    }

    public Splash createSplash(Widget widget) {
        return this.createObject(widget, null, "splash", Splash.class);
    }

    public License createLicense(Widget widget) {
        return this.createObject(widget, "http://www.w3.org/ns/widgets", "license", License.class);
    }

    public Engine createEngine(Widget widget) {
        return this.createObject(widget, null, "engine", Engine.class);
    }

    private <T extends AbstractConfigObject> T createObject(Widget widget, String namespace, String tag, Class<T> clazz) {
        if (widget != this.editableWidget) {
            throw new IllegalArgumentException("Widget model is not editable");
        }
        Document doc = widget.itemNode.getOwnerDocument();
        if (doc == null) {
            throw new IllegalStateException("Widget is not properly constructed");
        }
        Element el = doc.createElementNS(namespace, tag);
        try {
            return (T)((AbstractConfigObject)clazz.getDeclaredConstructor(Node.class).newInstance(el));
        }
        catch (Exception e) {
            HybridCore.log(4, "Error invoking the Node constructor for config model object", e);
            return null;
        }
    }

    public synchronized void dispose() {
        if (this.underLyingModel != null) {
            this.underLyingModel.releaseFromEdit();
            this.underLyingModel = null;
        }
        this.editableWidget = null;
        this.readonlyWidget = null;
        this.lastWidget = null;
    }

    public HybridProject getProject() {
        return HybridProject.getHybridProject(this.configXMLtoIFile().getProject());
    }

    public void modelAboutToBeChanged(IStructuredModel model) {
    }

    public void modelChanged(IStructuredModel model) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
        if (!isDirty) {
            WidgetModel widgetModel = this;
            synchronized (widgetModel) {
                final HybridProject project = this.getProject();
                final IDOMModel domModel = (IDOMModel)model;
                Job updatePlugins = new Job("Synchronize project " + project.getProject().getName() + " with config.xml"){

                    protected IStatus run(IProgressMonitor monitor) {
                        if (project.getProject().exists()) {
                            WidgetModel.this.reloadEditableWidget();
                            Widget newWidget = WidgetModel.this.load((Document)domModel.getDocument());
                            WidgetModel.this.syncEngines(project, newWidget, monitor);
                            WidgetModel.this.syncPlugins(project, newWidget, monitor);
                        }
                        return Status.OK_STATUS;
                    }
                };
                updatePlugins.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        WidgetModel.this.lastWidget.reload(domModel.getDocument().getDocumentElement());
                        WidgetModel.this.reloadEditableWidget();
                        WidgetModel.this.readonlyWidget = null;
                        WidgetModel.this.readonlyTimestamp = -1L;
                    }
                });
                ISchedulingRule rule = ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule((IResource)project.getProject());
                updatePlugins.setRule(rule);
                updatePlugins.schedule();
            }
        }
    }

    private void syncEngines(HybridProject project, Widget newWidget, IProgressMonitor monitor) {
        List<Engine> oldEngines = this.lastWidget.getEngines();
        List<Engine> newEngines = newWidget.getEngines();
        if (oldEngines == null) {
            oldEngines = new ArrayList<Engine>();
        }
        if (newEngines == null) {
            newEngines = new ArrayList<Engine>();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        ArrayList<Engine> toInstall = new ArrayList<Engine>(newEngines);
        toInstall.removeAll(oldEngines);
        ArrayList<Engine> toUninstall = new ArrayList<Engine>(oldEngines);
        toUninstall.removeAll(newEngines);
        List<Engine> enginesToUpdate = this.getEnginesToUpdate(oldEngines, newEngines);
        subMonitor.setWorkRemaining(toInstall.size() + toUninstall.size() + enginesToUpdate.size() * 2);
        for (Engine uninstall : toUninstall) {
            try {
                project.getEngineManager().removeEngine(uninstall.getName(), (IProgressMonitor)subMonitor.split(1), false);
            }
            catch (CoreException e) {
                HybridCore.log(4, "Unable to remove engine " + uninstall.getName(), e);
            }
        }
        for (Engine install : toInstall) {
            try {
                project.getEngineManager().addEngine(install.getName(), install.getSpec(), (IProgressMonitor)subMonitor.split(1), false);
            }
            catch (CoreException e) {
                HybridCore.log(4, "Unable to add engine " + install.getName(), e);
            }
        }
        for (Engine engine : enginesToUpdate) {
            int index = newEngines.indexOf(engine);
            if (index == -1) continue;
            try {
                project.getEngineManager().removeEngine(newEngines.get(index).getName(), (IProgressMonitor)subMonitor.split(1), false);
                project.getEngineManager().addEngine(newEngines.get(index).getName(), newEngines.get(index).getSpec(), (IProgressMonitor)subMonitor.split(1), false);
            }
            catch (CoreException e) {
                HybridCore.log(4, "Unable to update engine " + engine.getName(), e);
            }
        }
    }

    private void syncPlugins(HybridProject project, Widget newWidget, IProgressMonitor monitor) {
        List<Plugin> oldPlugins = this.lastWidget.getPlugins();
        List<Plugin> newPlugins = newWidget.getPlugins();
        if (oldPlugins == null) {
            oldPlugins = new ArrayList<Plugin>();
        }
        if (newPlugins == null) {
            newPlugins = new ArrayList<Plugin>();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        ArrayList<Plugin> toInstall = new ArrayList<Plugin>(newPlugins);
        toInstall.removeAll(oldPlugins);
        ArrayList<Plugin> toUninstall = new ArrayList<Plugin>(oldPlugins);
        toUninstall.removeAll(newPlugins);
        List<Plugin> pluginsToUpdate = this.getPluginsToUpdate(oldPlugins, newPlugins);
        subMonitor.setWorkRemaining(toInstall.size() + toUninstall.size() + pluginsToUpdate.size() * 2);
        for (Plugin uninstall : toUninstall) {
            try {
                project.getPluginManager().unInstallPlugin(uninstall, (IProgressMonitor)subMonitor.split(1), false);
            }
            catch (CoreException e) {
                HybridCore.log(4, "Unable to uninstall plugin " + uninstall.getName(), e);
            }
        }
        for (Plugin install : toInstall) {
            try {
                project.getPluginManager().installPlugin(install, (IProgressMonitor)subMonitor.split(1), false);
            }
            catch (CoreException e) {
                HybridCore.log(4, "Unable to install plugin " + install.getName(), e);
            }
        }
        for (Plugin plugin : pluginsToUpdate) {
            int index = newPlugins.indexOf(plugin);
            if (index == -1) continue;
            try {
                project.getPluginManager().unInstallPlugin(plugin, (IProgressMonitor)subMonitor.split(1), false);
                project.getPluginManager().installPlugin(newPlugins.get(index), (IProgressMonitor)subMonitor.split(1), false);
            }
            catch (CoreException e) {
                HybridCore.log(4, "Unable to update plugin " + plugin.getName(), e);
            }
        }
    }

    private List<Plugin> getPluginsToUpdate(List<Plugin> oldPlugins, List<Plugin> newPlugins) {
        ArrayList<Plugin> pluginsToUpdate = new ArrayList<Plugin>();
        for (Plugin plugin : oldPlugins) {
            String newSpec;
            int index = newPlugins.indexOf(plugin);
            if (index == -1 || (newSpec = newPlugins.get(index).getSpec()).equals(plugin.getSpec())) continue;
            pluginsToUpdate.add(plugin);
        }
        return pluginsToUpdate;
    }

    private List<Engine> getEnginesToUpdate(List<Engine> oldEngines, List<Engine> newEngines) {
        ArrayList<Engine> enginesToUpdate = new ArrayList<Engine>();
        for (Engine engine : oldEngines) {
            String newSpec;
            int index = newEngines.indexOf(engine);
            if (index == -1 || EngineUtils.getExactVersion(newSpec = newEngines.get(index).getSpec()).equals(EngineUtils.getExactVersion(engine.getSpec()))) continue;
            enginesToUpdate.add(engine);
        }
        return enginesToUpdate;
    }

    public void modelResourceDeleted(IStructuredModel model) {
        this.dispose();
    }

    public void modelResourceMoved(IStructuredModel oldModel, IStructuredModel newModel) {
    }

    public void modelAboutToBeReinitialized(IStructuredModel structuredModel) {
    }

    public void modelReinitialized(IStructuredModel structuredModel) {
    }

    class ResourceChangeListener
    implements IResourceChangeListener {
        ResourceChangeListener() {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            workspace.addResourceChangeListener((IResourceChangeListener)this, 4);
        }

        public void resourceChanged(IResourceChangeEvent event) {
            WidgetModel model;
            HybridProject prj;
            IResource resource = event.getResource();
            if (resource instanceof IProject && (prj = HybridProject.getHybridProject(resource.getProject())) != null && (model = (WidgetModel)widgetModels.remove(prj)) != null) {
                model.dispose();
            }
        }
    }
}

