/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.engine;

import com.github.zafarkhaja.semver.Version;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.thym.core.engine.HybridMobileLibraryResolver;
import org.eclipse.thym.core.engine.internal.cordova.CordovaEngineProvider;
import org.eclipse.thym.core.engine.internal.cordova.DownloadableCordovaEngine;
import org.eclipse.thym.core.internal.util.EngineUtils;

public class HybridMobileEngine {
    private String name;
    private String spec;
    private HybridMobileLibraryResolver resolver;

    public HybridMobileEngine(String name, String spec, HybridMobileLibraryResolver resolver) {
        this.name = name;
        this.spec = spec;
        this.resolver = resolver;
    }

    public String getName() {
        return this.name;
    }

    public String getSpec() {
        return this.spec;
    }

    public Version getVersionSpec() {
        Version version;
        String exactVersion = EngineUtils.getExactVersion(this.spec);
        try {
            version = Version.valueOf((String)exactVersion);
        }
        catch (Exception exception) {
            return null;
        }
        return version;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValid() {
        if (this.spec == null) {
            return false;
        }
        File file = new File(this.spec);
        if (file.exists()) {
            return true;
        }
        String exactVersion = EngineUtils.getExactVersion(this.spec);
        Version version = null;
        try {
            version = Version.valueOf((String)exactVersion);
        }
        catch (Exception exception) {
            return false;
        }
        if (version == null) {
            return false;
        }
        try {
            DownloadableCordovaEngine dEngine;
            List<DownloadableCordovaEngine> downloadableEngines = CordovaEngineProvider.getInstance().getDownloadableEngines();
            Iterator<DownloadableCordovaEngine> iterator = downloadableEngines.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(dEngine = iterator.next()).getPlatformId().equals(this.name) || !dEngine.getVersion().equals(exactVersion));
            return true;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public HybridMobileLibraryResolver getResolver() {
        return this.resolver;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof HybridMobileEngine)) {
            return false;
        }
        HybridMobileEngine that = (HybridMobileEngine)obj;
        if (this.getName().equals(that.getName()) && EngineUtils.getExactVersion(this.getSpec()).equals(EngineUtils.getExactVersion(that.getSpec()))) {
            return true;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        if (this.getName() != null && this.getSpec() != null) {
            return this.getName().hashCode() + this.getSpec().hashCode();
        }
        return super.hashCode();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[ name: " + this.getName() + " spec: " + this.getSpec() + " ]";
    }
}

