/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.config.Engine;
import org.eclipse.thym.core.config.Widget;
import org.eclipse.thym.core.config.WidgetModel;
import org.eclipse.thym.core.engine.HybridMobileEngine;
import org.eclipse.thym.core.engine.internal.cordova.CordovaEngineProvider;
import org.eclipse.thym.core.internal.cordova.CordovaProjectCLI;
import org.eclipse.thym.core.internal.util.EngineUtils;
import org.eclipse.thym.core.plugin.PluginMessagesCLIResult;

public class HybridMobileEngineManager {
    private final HybridProject project;

    public HybridMobileEngineManager(HybridProject project) {
        if (project == null) {
            throw new IllegalArgumentException("No project specified");
        }
        this.project = project;
    }

    public HybridMobileEngine[] getEngines() {
        try {
            WidgetModel model = WidgetModel.getModel(this.project);
            Widget w = model.getWidgetForRead();
            if (w != null) {
                ArrayList<HybridMobileEngine> engines = new ArrayList<HybridMobileEngine>();
                List<Engine> configEngines = w.getEngines();
                if (configEngines != null) {
                    for (Engine e : configEngines) {
                        HybridMobileEngine engine = CordovaEngineProvider.getInstance().createEngine(e.getName(), EngineUtils.getExactVersion(e.getSpec()));
                        engines.add(engine);
                    }
                }
                return engines.toArray(new HybridMobileEngine[engines.size()]);
            }
        }
        catch (CoreException e) {
            HybridCore.log(2, "Engine information can not be read", e);
        }
        return new HybridMobileEngine[0];
    }

    public void removeEngine(HybridMobileEngine engine, IProgressMonitor monitor, boolean save) throws OperationCanceledException, CoreException {
        this.removeEngine(engine.getName(), monitor, save);
    }

    public void removeEngine(String engineName, IProgressMonitor monitor, boolean save) throws OperationCanceledException, CoreException {
        if (!this.isPlatformInstalled(engineName)) {
            return;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        subMonitor.setTaskName("Removing engine: " + engineName);
        String options = "";
        options = save ? "--save" : "--nosave";
        IStatus status = this.project.getProjectCLI().platform(CordovaProjectCLI.Command.REMOVE, (IProgressMonitor)subMonitor.split(90), engineName, options).convertTo(PluginMessagesCLIResult.class).asStatus();
        this.project.getProject().refreshLocal(2, (IProgressMonitor)subMonitor.split(10, 7));
        if (!status.isOK()) {
            throw new CoreException(status);
        }
    }

    public void addEngine(String engineName, String engineSpec, IProgressMonitor monitor, boolean save) throws OperationCanceledException, CoreException {
        if (this.isPlatformInstalled(engineName)) {
            return;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        String fullSpec = String.valueOf(engineName) + "@" + engineSpec;
        subMonitor.setTaskName("Adding engine: " + fullSpec);
        String options = "";
        options = save ? "--save" : "--nosave";
        IStatus status = this.project.getProjectCLI().platform(CordovaProjectCLI.Command.ADD, (IProgressMonitor)subMonitor.split(90), fullSpec, options).convertTo(PluginMessagesCLIResult.class).asStatus();
        this.project.getProject().refreshLocal(2, (IProgressMonitor)subMonitor.split(10, 7));
        if (!status.isOK()) {
            throw new CoreException(status);
        }
    }

    private boolean isPlatformInstalled(String platformName) {
        if (platformName == null) {
            return false;
        }
        try {
            IFolder platformHome = this.getPlatformHomeFolder(platformName);
            if (platformHome != null) {
                IFile platformJson = platformHome.getFile(String.valueOf(platformName) + ".json");
                return platformJson.getLocation() != null && platformJson.getLocation().toFile().exists();
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    private IFolder getPlatformHomeFolder(String platform) throws CoreException {
        if (platform == null) {
            return null;
        }
        IFolder platforms = this.getPlatformsFolder();
        if (!platforms.exists()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Platforms folder does not exist"));
        }
        IFolder platformHome = platforms.getFolder(platform);
        IPath location = platformHome.getLocation();
        if (platformHome.exists() && location != null && location.toFile().isDirectory()) {
            return platformHome;
        }
        return null;
    }

    private IFolder getPlatformsFolder() {
        IFolder platforms = this.project.getProject().getFolder("platforms");
        return platforms;
    }

    public void updateEngines(final HybridMobileEngine[] engines) throws CoreException {
        Assert.isLegal((engines != null ? 1 : 0) != 0, (String)"Engines can not be null");
        WorkspaceJob updateJob = new WorkspaceJob(NLS.bind((String)"Update Cordova Engines for {0}", (Object)this.project.getProject().getName())){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                boolean engineFound;
                HybridMobileEngine[] existingEngines = HybridMobileEngineManager.this.getEngines();
                List<HybridMobileEngine> newEngines = Arrays.asList(engines);
                List<HybridMobileEngine> oldEngines = Arrays.asList(existingEngines);
                ArrayList<HybridMobileEngine> toInstall = new ArrayList<HybridMobileEngine>();
                ArrayList<HybridMobileEngine> toUninstall = new ArrayList<HybridMobileEngine>();
                ArrayList<HybridMobileEngine> enginesToUpdate = new ArrayList<HybridMobileEngine>();
                for (HybridMobileEngine oldEngine : oldEngines) {
                    engineFound = false;
                    for (HybridMobileEngine newEngine : newEngines) {
                        if (!newEngine.getName().equals(oldEngine.getName())) continue;
                        if (!newEngine.getSpec().equals(oldEngine.getSpec())) {
                            enginesToUpdate.add(newEngine);
                        }
                        engineFound = true;
                        break;
                    }
                    if (engineFound) continue;
                    toUninstall.add(oldEngine);
                }
                for (HybridMobileEngine newEngine : newEngines) {
                    engineFound = false;
                    for (HybridMobileEngine oldEngine : oldEngines) {
                        if (!oldEngine.getName().equals(newEngine.getName())) continue;
                        engineFound = true;
                        break;
                    }
                    if (engineFound) continue;
                    toInstall.add(newEngine);
                }
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
                subMonitor.setWorkRemaining(toInstall.size() + toUninstall.size() + enginesToUpdate.size() * 2);
                for (HybridMobileEngine uninstall : toUninstall) {
                    try {
                        HybridMobileEngineManager.this.removeEngine(uninstall, (IProgressMonitor)subMonitor.split(1), true);
                    }
                    catch (CoreException e) {
                        HybridCore.log(4, "Unable to remove engine " + uninstall.getName(), e);
                    }
                }
                for (HybridMobileEngine install : toInstall) {
                    try {
                        HybridMobileEngineManager.this.addEngine(install.getName(), install.getSpec(), (IProgressMonitor)subMonitor.split(1), true);
                    }
                    catch (CoreException e) {
                        HybridCore.log(4, "Unable to add engine " + install.getName(), e);
                    }
                }
                for (HybridMobileEngine engineToUpdate : enginesToUpdate) {
                    try {
                        HybridMobileEngineManager.this.project.getEngineManager().removeEngine(engineToUpdate, (IProgressMonitor)subMonitor.split(1), true);
                        HybridMobileEngineManager.this.project.getEngineManager().addEngine(engineToUpdate.getName(), engineToUpdate.getSpec(), (IProgressMonitor)subMonitor.split(1), true);
                    }
                    catch (CoreException e) {
                        HybridCore.log(4, "Unable to update engine " + engineToUpdate.getName(), e);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        ISchedulingRule rule = ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule((IResource)this.project.getProject());
        updateJob.setRule(rule);
        updateJob.schedule();
    }

    public boolean hasActiveEngine() {
        return this.getEngines().length > 0;
    }
}

