/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.internal.cordova;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.internal.cordova.CordovaCLIResult;
import org.eclipse.thym.core.internal.cordova.CordovaCLIStreamListener;
import org.eclipse.thym.core.internal.util.ExternalProcessUtility;

public class CordovaCLI {
    private Map<String, String> additionalEnvProps = HybridCore.getEnvVariables();

    public CordovaCLIResult version(IProgressMonitor monitor) throws CoreException {
        CordovaCLIStreamListener streamListener = new CordovaCLIStreamListener();
        IProcess process = this.startShell(streamListener, monitor, this.getLaunchConfiguration("cordova -version"));
        String cordovaCommand = "cordova -version\n";
        this.sendCordovaCommand(process, cordovaCommand, monitor);
        CordovaCLIResult result = new CordovaCLIResult(streamListener.getMessage());
        return result;
    }

    public CordovaCLIResult nodeVersion(IProgressMonitor monitor) throws CoreException {
        CordovaCLIStreamListener streamListener = new CordovaCLIStreamListener();
        IProcess process = this.startShell(streamListener, monitor, this.getLaunchConfiguration("node -v"));
        String command = "node -v\n";
        this.sendCordovaCommand(process, command, monitor);
        CordovaCLIResult result = new CordovaCLIResult(streamListener.getMessage());
        return result;
    }

    protected void sendCordovaCommand(IProcess process, String cordovaCommand, IProgressMonitor monitor) throws CoreException {
        try {
            IStreamsProxy streamProxy = process.getStreamsProxy();
            streamProxy.write(cordovaCommand.toString());
            while (!process.isTerminated()) {
                try {
                    streamProxy.write("exit\n");
                }
                catch (IOException iOException) {}
                if (monitor.isCanceled()) {
                    process.terminate();
                    break;
                }
                Thread.sleep(50L);
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Fatal error invoking cordova CLI", (Throwable)e));
        }
        catch (InterruptedException e) {
            HybridCore.log(1, "Exception waiting for process to terminate", e);
        }
    }

    public IProcess startShell(IStreamListener listener, IProgressMonitor monitor, ILaunchConfiguration launchConfiguration) throws CoreException {
        ArrayList<String> commandList = new ArrayList<String>();
        if (this.isWindows()) {
            commandList.add("cmd");
        } else {
            commandList.add("/bin/bash");
            commandList.add("-l");
        }
        ExternalProcessUtility ep = new ExternalProcessUtility();
        IProcess process = ep.exec(commandList.toArray(new String[commandList.size()]), this.getWorkingDirectory(), monitor, null, launchConfiguration, listener, listener);
        return process;
    }

    protected boolean isWindows() {
        String OS = System.getProperty("os.name", "unknown");
        return OS.toLowerCase().indexOf("win") > -1;
    }

    protected ILaunchConfiguration getLaunchConfiguration(String label) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.ui.externaltools.ProgramLaunchConfigurationType");
        try {
            ILaunchConfigurationWorkingCopy cfg = type.newInstance(null, "cordova");
            ILaunchConfigurationWorkingCopy wc = cfg.getWorkingCopy();
            wc.setAttribute(IProcess.ATTR_PROCESS_LABEL, label);
            if (this.additionalEnvProps != null && !this.additionalEnvProps.isEmpty()) {
                wc.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, this.additionalEnvProps);
            }
            cfg = wc.doSave();
            return cfg;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected File getWorkingDirectory() {
        return null;
    }
}

