/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.internal.project;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.thym.core.HybridProject;

public class DerivedFoldersChangeListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta[] iResourceDeltaArray = event.getDelta().getAffectedChildren();
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            HybridProject hybridProject;
            IResourceDelta delta = iResourceDeltaArray[n2];
            if (delta.getResource().getType() == 4 && (hybridProject = HybridProject.getHybridProject((IProject)delta.getResource())) != null) {
                DerivedFoldersJob job = new DerivedFoldersJob(hybridProject);
                job.schedule();
            }
            ++n2;
        }
    }

    private class DerivedFoldersJob
    extends Job {
        private HybridProject project;

        public DerivedFoldersJob(HybridProject project) {
            super("Update Cordova derived folders");
            this.project = project;
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                this.project.updateDerivedFolders(monitor);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
            return Status.OK_STATUS;
        }
    }
}

