/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.android.core.adt;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.platform.AbstractNativeBinaryBuildDelegate;

public class BuildDelegate
extends AbstractNativeBinaryBuildDelegate {
    private static String[] outputFolders = new String[]{"android", "ant-build", "bin", "build", "outputs", "apk"};

    public void buildNow(IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return;
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)"Build project for Android", (int)100);
        try {
            HybridProject hybridProject = HybridProject.getHybridProject((IProject)this.getProject());
            if (hybridProject == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.android.core", "Not a hybrid mobile project, can not generate files"));
            }
            String buildType = "--debug";
            if (this.isRelease()) {
                buildType = "--release";
            }
            hybridProject.build((IProgressMonitor)sm.split(90), new String[]{"android", buildType});
            IFolder androidProject = hybridProject.getProject().getFolder("platforms/android");
            androidProject.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    switch (proxy.getType()) {
                        case 2: {
                            String[] stringArray = outputFolders;
                            int n = stringArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String folder = stringArray[n2];
                                if (folder.equals(proxy.getName())) {
                                    return true;
                                }
                                ++n2;
                            }
                            break;
                        }
                        case 1: {
                            if (BuildDelegate.this.isRelease() && proxy.getName().endsWith("-release-unsigned.apk")) {
                                BuildDelegate.this.setBuildArtifact(proxy.requestResource().getLocation().toFile());
                                return false;
                            }
                            if (!proxy.getName().endsWith("-debug.apk")) break;
                            BuildDelegate.this.setBuildArtifact(proxy.requestResource().getLocation().toFile());
                            return false;
                        }
                    }
                    return false;
                }
            }, 11);
            if (this.getBuildArtifact() == null || !this.getBuildArtifact().exists()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.android.core", "Build failed... Build artifact does not exist"));
            }
        }
        finally {
            sm.done();
        }
    }
}

