/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.wp.internal.ui.launch;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.wp.core.WPCore;
import org.eclipse.thym.wp.core.vstudio.WPEmulator;
import org.eclipse.thym.wp.internal.ui.Messages;
import org.eclipse.thym.wp.internal.ui.SDKLocationHelper;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class WPOptionsTab
extends AbstractLaunchConfigurationTab {
    private static final String DEFAULT_EMULATOR = Messages.WPOptionsTab_DefaultEmulator;
    private Text projectText;
    private Listener dirtyListener = new DirtyListener();
    private Combo devicesCombo;
    private Map<String, Integer> devices = new TreeMap<String, Integer>();

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        comp.setLayout((Layout)new GridLayout(1, false));
        Group projectGroup = new Group(comp, 0);
        projectGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        projectGroup.setText(Messages.WPOptionsTab_ProjectGroup);
        projectGroup.setLayout((Layout)new GridLayout(3, false));
        Label projectLabel = new Label((Composite)projectGroup, 0);
        projectLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        projectLabel.setText(Messages.WPOptionsTab_ProjectLabel);
        this.projectText = new Text((Composite)projectGroup, 2048);
        this.projectText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.projectText.addListener(24, this.dirtyListener);
        Button browseButton = new Button((Composite)projectGroup, 0);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(WPOptionsTab.this.getShell(), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
                dialog.setTitle(Messages.WPOptionsTab_ProjectSelection);
                dialog.setMessage(Messages.WPOptionsTab_SelectonDesc);
                dialog.setElements(HybridCore.getHybridProjects().toArray());
                if (dialog.open() == 0) {
                    HybridProject project = (HybridProject)dialog.getFirstResult();
                    WPOptionsTab.this.projectText.setText(project.getProject().getName());
                }
            }
        });
        browseButton.setText(Messages.WPOptionsTab_BrowseLabel);
        Group emulatorGroup = new Group(comp, 0);
        emulatorGroup.setLayout((Layout)new GridLayout(2, false));
        emulatorGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        emulatorGroup.setText(Messages.WPOptionsTab_EmulatorGroup);
        Label deviceLabel = new Label((Composite)emulatorGroup, 0);
        deviceLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        deviceLabel.setText(Messages.WPOptionsTab_DeviceName);
        this.devicesCombo = new Combo((Composite)emulatorGroup, 8);
        this.devicesCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.devicesCombo.addListener(13, this.dirtyListener);
        try {
            if (SDKLocationHelper.isSDKLocationDefined()) {
                WPEmulator emulator = new WPEmulator(WPCore.getSDKLocation());
                this.devices = emulator.getDevices();
                if (this.devices != null) {
                    Set<String> names = this.devices.keySet();
                    for (String name : names) {
                        this.devicesCombo.add(name);
                    }
                }
            }
        }
        catch (CoreException coreException) {
            this.devicesCombo.removeAll();
        }
        if (this.devices != null && !this.devices.isEmpty()) {
            this.devicesCombo.add(DEFAULT_EMULATOR);
        }
    }

    public String getName() {
        return Messages.WPOptionsTab_TabName;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            if (SDKLocationHelper.defineSDKLocationIfNecessary()) {
                this.setErrorMessage(Messages.WPOptionsTab_SDKNotDefinedError);
            }
            String projectName = null;
            projectName = configuration.getAttribute("org.eclipse.thym.core.ATTR_BUILD_SCOPE", null);
            if (projectName != null) {
                this.projectText.setText(projectName);
            }
            if (SDKLocationHelper.isSDKLocationDefined()) {
                try {
                    int deviceId = configuration.getAttribute("org.eclipse.thym.wp.core.ATTR_DEVICE_IDENTIFIER", 0);
                    if (deviceId != -1) {
                        Set<String> names = this.devices.keySet();
                        int index = 0;
                        for (String name : names) {
                            if (this.devices.get(name) == deviceId) break;
                            ++index;
                        }
                        this.devicesCombo.select(index);
                    } else {
                        this.devicesCombo.select(this.devicesCombo.indexOf(DEFAULT_EMULATOR));
                    }
                }
                catch (CoreException coreException) {}
            }
            this.setDirty(false);
        }
        catch (CoreException e) {
            WPCore.log((int)4, (String)"Could not initialize launch configuration for Windows Phone 8 Emulator", (Throwable)e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.thym.core.ATTR_BUILD_SCOPE", this.projectText.getText());
        String device = this.devicesCombo.getText();
        if (device != null && !device.isEmpty()) {
            int id = -1;
            if (!DEFAULT_EMULATOR.equals(device)) {
                id = this.devices.get(device);
            }
            configuration.setAttribute("org.eclipse.thym.wp.core.ATTR_DEVICE_IDENTIFIER", id);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        if (this.devices != null && !this.devices.isEmpty()) {
            this.devicesCombo.select(this.devicesCombo.indexOf(DEFAULT_EMULATOR));
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        if (!System.getProperty("os.name").toLowerCase().startsWith("win")) {
            this.setErrorMessage("Windows emulator can run only on Windows");
            return false;
        }
        try {
            return this.isTabValid() && WPCore.getSDKLocation() != null && super.isValid(launchConfig);
        }
        catch (CoreException e) {
            WPCore.log((int)4, (String)"Error during SDK location validation", (Throwable)e);
            return false;
        }
    }

    public boolean canSave() {
        return this.isTabValid();
    }

    private boolean isTabValid() {
        this.setMessage(Messages.WPOptionsTab_Description);
        this.setErrorMessage(null);
        if (this.devices.isEmpty()) {
            this.setErrorMessage(Messages.WPOptionsTab_NoEmulatorsError);
            return false;
        }
        String projectName = this.projectText.getText();
        if (projectName.isEmpty()) {
            return false;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!project.exists()) {
            return false;
        }
        String device = this.devicesCombo.getText();
        return !device.isEmpty();
    }

    private class DirtyListener
    implements Listener {
        private DirtyListener() {
        }

        public void handleEvent(Event event) {
            WPOptionsTab.this.setDirty(true);
            WPOptionsTab.this.updateLaunchConfigurationDialog();
        }
    }
}

