/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.wp.core;

import java.io.File;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.thym.wp.internal.core.WindowsRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class WPCore
implements BundleActivator {
    public static final String WP_LAUNCH_ID = "org.eclipse.thym.wp.core.WPLaunchConfigurationType";
    public static final String PLUGIN_ID = "org.eclipse.thym.wp.core";
    private static final String THYM_UI_ID = "org.eclipse.thym.ui";
    private static final String WINDOWS_PHONE_REG = "HKLM\\Software\\Wow6432Node\\Microsoft\\Microsoft SDKs\\WindowsPhone";
    private static final String INSTALL_PATH = "Install Path";
    private static BundleContext context;
    private static ILog logger;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        logger = Platform.getLog((Bundle)WPCore.getContext().getBundle());
    }

    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
    }

    public static void log(int status, String message, Throwable throwable) {
        logger.log((IStatus)new Status(status, PLUGIN_ID, message, throwable));
    }

    public static String getSDKLocation() throws CoreException {
        File location;
        if (!System.getProperty("os.name").toLowerCase().startsWith("win")) {
            return null;
        }
        String sdkLocation = Platform.getPreferencesService().getString(THYM_UI_ID, "windowsPhoneSDKLocation", null, null);
        if (sdkLocation == null && (location = WPCore.detectSDK()) != null && location.exists()) {
            sdkLocation = location.getAbsolutePath();
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(THYM_UI_ID);
            prefs.put("windowsPhoneSDKLocation", sdkLocation);
        }
        return sdkLocation;
    }

    private static File detectSDK() throws CoreException {
        Object[] versions = WindowsRegistry.getChildren(WINDOWS_PHONE_REG);
        if (versions.length > 0) {
            Arrays.sort(versions);
            String installPath = null;
            int i = versions.length - 1;
            while (i >= 0) {
                installPath = WindowsRegistry.readRegistry("HKLM\\Software\\Wow6432Node\\Microsoft\\Microsoft SDKs\\WindowsPhone\\" + (String)versions[i] + "\\" + INSTALL_PATH, INSTALL_PATH);
                if (installPath != null) break;
                --i;
            }
            if (installPath != null) {
                return new File(installPath);
            }
        }
        return null;
    }
}

