/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ios.ui;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.ios.core.simulator.IOSDevice;
import org.eclipse.thym.ios.core.simulator.IOSSimulator;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class IOSSimOptionsTab
extends AbstractLaunchConfigurationTab {
    private Text textProject;
    private Listener dirtyFlagListener = new DirtyListener();
    private Combo comboSDKVer;
    private ComboViewer comboViewer;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        comp.setLayout((Layout)new GridLayout(1, false));
        Group grpProject = new Group(comp, 0);
        grpProject.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        grpProject.setText("Project");
        grpProject.setLayout((Layout)new GridLayout(3, false));
        Label lblProject = new Label((Composite)grpProject, 0);
        lblProject.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblProject.setText("Project:");
        this.textProject = new Text((Composite)grpProject, 2048);
        this.textProject.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textProject.addListener(24, this.dirtyFlagListener);
        Button btnProjectBrowse = new Button((Composite)grpProject, 0);
        btnProjectBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementListSelectionDialog es = new ElementListSelectionDialog(IOSSimOptionsTab.this.getShell(), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
                es.setElements(HybridCore.getHybridProjects().toArray());
                es.setTitle("Project Selection");
                es.setMessage("Select a project to run");
                if (es.open() == 0) {
                    HybridProject project = (HybridProject)es.getFirstResult();
                    IOSSimOptionsTab.this.textProject.setText(project.getProject().getName());
                }
            }
        });
        btnProjectBrowse.setText("Browse...");
        Group grpSimulator = new Group(comp, 0);
        grpSimulator.setLayout((Layout)new GridLayout(2, false));
        grpSimulator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        grpSimulator.setText("Simulator");
        Label lblSdkVersion = new Label((Composite)grpSimulator, 0);
        lblSdkVersion.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblSdkVersion.setText("Device:");
        this.comboSDKVer = new Combo((Composite)grpSimulator, 8);
        this.comboSDKVer.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.comboSDKVer.addListener(13, this.dirtyFlagListener);
        this.comboViewer = new ComboViewer(this.comboSDKVer);
        this.comboViewer.setContentProvider((IContentProvider)new SDKContentProvider());
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                IOSDevice device = (IOSDevice)element;
                return NLS.bind((String)"{0} ({1})", (Object[])new String[]{device.getDeviceName(), device.getiOSName()});
            }
        });
        this.comboViewer.setInput((Object)this.getSimulatorDevices());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", true);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        String projectName = null;
        try {
            projectName = configuration.getAttribute("org.eclipse.thym.core.ATTR_BUILD_SCOPE", null);
        }
        catch (CoreException coreException) {}
        if (projectName != null) {
            this.textProject.setText(projectName);
        }
        try {
            String deviceId = configuration.getAttribute("org.eclipse.thym.ios.core.ATTR_DEVICE_IDENTIFIER", new String());
            SDKContentProvider contentProvider = (SDKContentProvider)this.comboViewer.getContentProvider();
            this.comboSDKVer.select(0);
            if (contentProvider.simulators != null) {
                IOSDevice[] iOSDeviceArray = contentProvider.simulators;
                int n = iOSDeviceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IOSDevice sim = iOSDeviceArray[n2];
                    if (sim.getDeviceId().equals(deviceId)) {
                        this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)sim));
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException coreException) {}
        this.setDirty(false);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        IStructuredSelection selection = (IStructuredSelection)this.comboViewer.getSelection();
        if (!selection.isEmpty()) {
            IOSDevice selectedDevice = (IOSDevice)selection.getFirstElement();
            configuration.setAttribute("org.eclipse.thym.ios.core.ATTR_DEVICE_IDENTIFIER", selectedDevice.getDeviceId());
        }
    }

    public String getName() {
        return "Simulator";
    }

    private IOSDevice[] getSimulatorDevices() {
        try {
            List devices = IOSSimulator.listDevices((IProgressMonitor)new NullProgressMonitor());
            return devices.toArray(new IOSDevice[devices.size()]);
        }
        catch (CoreException coreException) {
            return new IOSDevice[0];
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        if (!System.getProperty("os.name").toLowerCase().startsWith("mac")) {
            this.setErrorMessage("iOS simulator can run only on Mac OS X");
            return false;
        }
        return super.isValid(launchConfig);
    }

    private class DirtyListener
    implements Listener {
        private DirtyListener() {
        }

        public void handleEvent(Event event) {
            IOSSimOptionsTab.this.setDirty(true);
            IOSSimOptionsTab.this.updateLaunchConfigurationDialog();
        }
    }

    private final class SDKContentProvider
    implements IStructuredContentProvider {
        private IOSDevice[] simulators;

        private SDKContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.simulators = (IOSDevice[])newInput;
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (this.simulators == null) {
                return new Object[0];
            }
            return this.simulators;
        }
    }
}

