/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.internal.ui.importer;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.thym.core.platform.PlatformConstants;
import org.eclipse.thym.internal.ui.importer.ThymImporterActivator;
import org.eclipse.thym.ui.wizard.project.HybridProjectCreator;
import org.eclipse.ui.wizards.datatransfer.ProjectConfigurator;

public class CordovaProjectConfigurator
implements ProjectConfigurator {
    public boolean shouldBeAnEclipseProject(IContainer container, IProgressMonitor monitor) {
        boolean configExist = false;
        IPath[] iPathArray = PlatformConstants.CONFIG_PATHS;
        int n = PlatformConstants.CONFIG_PATHS.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path = iPathArray[n2];
            IFile config = container.getFile(path);
            if (config.exists()) {
                configExist = true;
                break;
            }
            ++n2;
        }
        IFolder wwwFile = container.getFolder((IPath)new Path("www"));
        return configExist && wwwFile.exists();
    }

    public boolean canConfigure(IProject project, Set<IPath> ignoredDirectories, IProgressMonitor monitor) {
        return this.shouldBeAnEclipseProject((IContainer)project, monitor);
    }

    public void configure(IProject project, Set<IPath> ignoredDirectories, IProgressMonitor monitor) {
        try {
            new HybridProjectCreator().convertProject(project, monitor);
        }
        catch (CoreException ex) {
            ThymImporterActivator.getDefault().getLog().log((IStatus)new Status(4, ThymImporterActivator.getDefault().getBundle().getSymbolicName(), ex.getMessage(), (Throwable)ex));
        }
    }

    public Set<File> findConfigurableLocations(File root, IProgressMonitor monitor) {
        HashSet<File> res = new HashSet<File>();
        LinkedList<File> directoriesToProcess = new LinkedList<File>();
        directoriesToProcess.addFirst(root);
        while (!directoriesToProcess.isEmpty()) {
            File current = (File)directoriesToProcess.pop();
            boolean configExist = false;
            IPath[] iPathArray = PlatformConstants.CONFIG_PATHS;
            int n = PlatformConstants.CONFIG_PATHS.length;
            int n2 = 0;
            while (n2 < n) {
                IPath path = iPathArray[n2];
                File config = new File(current, path.toString());
                if (config.isFile()) {
                    configExist = true;
                    break;
                }
                ++n2;
            }
            File wwwFolder = new File(current, "www");
            if (configExist && wwwFolder.isDirectory()) {
                res.add(current);
                continue;
            }
            if (!current.isDirectory()) continue;
            directoriesToProcess.addAll(Arrays.asList(current.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            })));
        }
        return res;
    }

    public Set<IFolder> getFoldersToIgnore(IProject project, IProgressMonitor monitor) {
        return Collections.emptySet();
    }
}

