/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.thym.core.config.AbstractConfigObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Feature
extends AbstractConfigObject {
    private AbstractConfigObject.Property<String> name = new AbstractConfigObject.Property("name");
    private AbstractConfigObject.Property<Boolean> required = new AbstractConfigObject.Property("required");
    private AbstractConfigObject.Property<HashMap<String, String>> params = new AbstractConfigObject.Property("param");

    Feature(Node node) {
        this.itemNode = (Element)node;
        this.name.setValue(this.getNodeAttribute(node, null, "name"));
        this.required.setValue(Boolean.parseBoolean(this.getNodeAttribute(node, null, "required")));
        Element el = (Element)node;
        NodeList nodes = el.getElementsByTagName("param");
        if (nodes.getLength() > 0) {
            HashMap<String, String> props = new HashMap<String, String>(nodes.getLength());
            int i = 0;
            while (i < nodes.getLength()) {
                String name = this.getNodeAttribute(nodes.item(i), null, "name");
                String value = this.getNodeAttribute(nodes.item(i), null, "value");
                props.put(name, value);
                ++i;
            }
            this.params.setValue(props);
        } else {
            this.params.setValue(null);
        }
    }

    public String getName() {
        return this.name.getValue();
    }

    public boolean getRequired() {
        if (this.required.getValue() == null) {
            return false;
        }
        return this.required.getValue();
    }

    public void setRequired(boolean required) {
        this.setAttributeValue(this.itemNode, null, "required", Boolean.toString(required));
        this.required.setValue(required);
    }

    public void setName(String name) {
        this.setAttributeValue(this.itemNode, null, "name", name);
        this.name.setValue(name);
    }

    public void addParam(String name, String value) {
        HashMap<String, String> props = new HashMap<String, String>();
        if (this.params.getValue() != null) {
            props.putAll((Map)this.params.getValue());
        }
        if (!props.containsKey(name)) {
            Document doc = this.itemNode.getOwnerDocument();
            Element el = doc.createElement("param");
            el.setAttribute("name", name);
            el.setAttribute("value", value);
            this.itemNode.appendChild(el);
        } else {
            Element paramElement = this.findParamElement(name);
            paramElement.setAttribute("value", value);
        }
        props.put(name, value);
        this.params.setValue(props);
    }

    public void removeParam(String name) {
        Element paramElement;
        if (!this.params.getValue().containsKey(name)) {
            return;
        }
        HashMap props = new HashMap();
        if (this.params.getValue() != null) {
            props.putAll(this.params.getValue());
        }
        if ((paramElement = this.findParamElement(name)) != null) {
            this.itemNode.removeChild(paramElement);
        }
        props.remove(name);
        this.params.setValue(props);
    }

    private Element findParamElement(String name) {
        Node child = this.itemNode.getFirstChild();
        while (child != null) {
            Element e;
            if (child.getNodeType() == 1 && name.equals((e = (Element)child).getAttribute("name"))) {
                return e;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public Map<String, String> getParams() {
        if (this.params.getValue() == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap((Map)this.params.getValue());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Feature)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Feature that = (Feature)obj;
        return this.equalField(that.getName(), this.getName());
    }

    public int hashCode() {
        if (this.getName() != null) {
            return this.getName().hashCode();
        }
        return super.hashCode();
    }
}

