/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.config;

import org.eclipse.thym.core.config.AbstractConfigObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Preference
extends AbstractConfigObject {
    private AbstractConfigObject.Property<String> name = new AbstractConfigObject.Property(this, "name");
    private AbstractConfigObject.Property<String> value = new AbstractConfigObject.Property(this, "value");
    private AbstractConfigObject.Property<Boolean> readonly = new AbstractConfigObject.Property(this, "readonly");

    Preference(Node node) {
        this.itemNode = (Element)node;
        this.name.setValue(this.getNodeAttribute(node, null, "name"));
        this.value.setValue(this.getNodeAttribute(node, null, "value"));
        this.readonly.setValue(Boolean.parseBoolean(this.getNodeAttribute(node, null, "readonly")));
    }

    public String getName() {
        return this.name.getValue();
    }

    public boolean getReadonly() {
        if (this.readonly.getValue() == null) {
            return false;
        }
        return this.readonly.getValue();
    }

    public void setReadonly(boolean readonly) {
        this.readonly.setValue(readonly);
        this.setAttributeValue(this.itemNode, null, "readonly", Boolean.toString(readonly));
    }

    public void setName(String name) {
        this.name.setValue(name);
        this.setAttributeValue(this.itemNode, null, "name", name);
    }

    public void setValue(String value) {
        this.value.setValue(value);
        this.setAttributeValue(this.itemNode, null, "value", value);
    }

    public String getValue() {
        return this.value.getValue();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Preference)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Preference that = (Preference)obj;
        return this.equalField(that.getName(), this.getName()) && this.equalField(that.getValue(), this.getValue());
    }

    public int hashCode() {
        int hash = super.hashCode();
        if (this.getName() != null) {
            hash *= this.getName().hashCode();
        }
        if (this.getValue() != null) {
            hash *= this.getValue().hashCode();
        }
        return hash;
    }

    public String toString() {
        return "Preference[name:" + this.getName() + " value:" + this.getValue() + " readonly:" + this.getReadonly() + "]";
    }
}

