/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.engine;

import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.config.Engine;
import org.eclipse.thym.core.config.Widget;
import org.eclipse.thym.core.config.WidgetModel;
import org.eclipse.thym.core.engine.HybridMobileEngine;
import org.eclipse.thym.core.engine.internal.cordova.CordovaEngineProvider;
import org.eclipse.thym.core.extensions.PlatformSupport;
import org.eclipse.thym.core.internal.cordova.CordovaCLI;
import org.eclipse.thym.core.internal.cordova.ErrorDetectingCLIResult;
import org.eclipse.thym.core.platform.PlatformConstants;
import org.osgi.framework.Version;

public class HybridMobileEngineManager {
    private final HybridProject project;

    public HybridMobileEngineManager(HybridProject project) {
        this.project = project;
    }

    public HybridMobileEngine[] getActiveEngines() {
        HybridMobileEngine[] platformJsonEngines = this.getActiveEnginesFromPlatformsJson();
        if (platformJsonEngines.length > 0) {
            return platformJsonEngines;
        }
        try {
            WidgetModel model = WidgetModel.getModel(this.project);
            Widget w = model.getWidgetForRead();
            List<Engine> engines = null;
            if (w != null) {
                engines = w.getEngines();
            }
            if (engines == null || engines.isEmpty()) {
                HybridCore.log(1, "No engine information exists on config.xml. Falling back to default engines", null);
                return HybridMobileEngineManager.defaultEngines();
            }
            CordovaEngineProvider engineProvider = new CordovaEngineProvider();
            ArrayList<HybridMobileEngine> activeEngines = new ArrayList<HybridMobileEngine>();
            List<HybridMobileEngine> availableEngines = engineProvider.getAvailableEngines();
            block2: for (Engine engine : engines) {
                for (HybridMobileEngine hybridMobileEngine : availableEngines) {
                    if (!this.engineMatches(engine, hybridMobileEngine)) continue;
                    activeEngines.add(hybridMobileEngine);
                    continue block2;
                }
            }
            return activeEngines.toArray(new HybridMobileEngine[activeEngines.size()]);
        }
        catch (CoreException e) {
            HybridCore.log(2, "Engine information can not be read", e);
            HybridCore.log(2, "Could not determine the engines used", null);
            return new HybridMobileEngine[0];
        }
    }

    private boolean engineMatches(Engine configEngine, HybridMobileEngine engine) {
        if (engine.isManaged()) {
            if (configEngine.getSpec() != null) {
                String spec = configEngine.getSpec();
                if (spec.startsWith("~") || spec.startsWith("^")) {
                    spec = spec.substring(1);
                }
                return configEngine.getName() != null && configEngine.getName().equals(engine.getId()) && spec.equals(engine.getVersion());
            }
            return false;
        }
        return engine.getLocation().isValidPath(configEngine.getSpec()) && engine.getLocation().equals((Object)new Path(configEngine.getSpec()));
    }

    public HybridMobileEngine[] getActiveEnginesFromPlatformsJson() {
        try {
            IFile file = this.project.getProject().getFile(PlatformConstants.PLATFORMS_JSON_PATH);
            if (!file.exists()) {
                return new HybridMobileEngine[0];
            }
            ArrayList<HybridMobileEngine> activeEngines = new ArrayList<HybridMobileEngine>();
            JsonParser parser = new JsonParser();
            JsonObject root = parser.parse((Reader)new InputStreamReader(file.getContents())).getAsJsonObject();
            for (PlatformSupport support : HybridCore.getPlatformSupports()) {
                HybridMobileEngine engine;
                String platform = support.getPlatformId();
                if (!root.has(platform) || (engine = this.getHybridMobileEngine(platform, root.get(platform).getAsString())) == null) continue;
                activeEngines.add(engine);
            }
            return activeEngines.toArray(new HybridMobileEngine[activeEngines.size()]);
        }
        catch (JsonIOException e) {
            HybridCore.log(2, "Error reading input stream from platforms.json", e);
        }
        catch (JsonSyntaxException e) {
            HybridCore.log(2, "platforms.json has errors", e);
        }
        catch (CoreException e) {
            HybridCore.log(2, "Error while opening platforms.json", e);
        }
        return new HybridMobileEngine[0];
    }

    private HybridMobileEngine getHybridMobileEngine(String name, String spec) {
        CordovaEngineProvider engineProvider = new CordovaEngineProvider();
        List<HybridMobileEngine> availableEngines = engineProvider.getAvailableEngines();
        for (HybridMobileEngine engine : availableEngines) {
            if (!(engine.isManaged() ? engine.getId().equals(name) && engine.getVersion().equals(spec) : engine.getId().equals(name) && engine.getLocation().toString().equals(spec))) continue;
            return engine;
        }
        return null;
    }

    public static HybridMobileEngine[] defaultEngines() {
        CordovaEngineProvider engineProvider = new CordovaEngineProvider();
        List<HybridMobileEngine> availableEngines = engineProvider.getAvailableEngines();
        if (availableEngines == null || availableEngines.isEmpty()) {
            return new HybridMobileEngine[0];
        }
        ArrayList<HybridMobileEngine> defaults = new ArrayList<HybridMobileEngine>();
        String pref = Platform.getPreferencesService().getString("org.eclipse.thym.ui", "default_engine", null, null);
        if (pref != null && !pref.isEmpty()) {
            String[] engineStrings;
            String[] stringArray = engineStrings = pref.split(",");
            int n = engineStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String engineString = stringArray[n2];
                String[] engineInfo = engineString.split(":");
                for (HybridMobileEngine hybridMobileEngine : availableEngines) {
                    if (hybridMobileEngine.isManaged()) {
                        if (!engineInfo[0].equals(hybridMobileEngine.getId()) || !engineInfo[1].equals(hybridMobileEngine.getVersion())) continue;
                        defaults.add(hybridMobileEngine);
                        continue;
                    }
                    if (!engineInfo[0].equals(hybridMobileEngine.getId()) || !engineInfo[1].equals(hybridMobileEngine.getLocation().toString())) continue;
                    defaults.add(hybridMobileEngine);
                }
                ++n2;
            }
        } else {
            HashMap<String, HybridMobileEngine> platforms = new HashMap<String, HybridMobileEngine>();
            for (HybridMobileEngine hybridMobileEngine : availableEngines) {
                if (platforms.containsKey(hybridMobileEngine.getId())) {
                    HybridMobileEngine existing = (HybridMobileEngine)platforms.get(hybridMobileEngine.getId());
                    try {
                        Version ev = Version.parseVersion((String)existing.getVersion());
                        Version hv = Version.parseVersion((String)hybridMobileEngine.getVersion());
                        if (hv.compareTo(ev) <= 0) continue;
                        platforms.put(hybridMobileEngine.getId(), hybridMobileEngine);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    continue;
                }
                platforms.put(hybridMobileEngine.getId(), hybridMobileEngine);
            }
            defaults.addAll(platforms.values());
        }
        return defaults.toArray(new HybridMobileEngine[defaults.size()]);
    }

    public void updateEngines(final HybridMobileEngine[] engines) throws CoreException {
        WorkspaceJob updateJob = new WorkspaceJob(NLS.bind((String)"Update Cordova Engines for {0}", (Object)this.project.getProject().getName())){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                WidgetModel model = WidgetModel.getModel(HybridMobileEngineManager.this.project);
                Widget w = model.getWidgetForEdit();
                List<Engine> existingEngines = w.getEngines();
                CordovaCLI cordova = CordovaCLI.newCLIforProject(HybridMobileEngineManager.this.project);
                SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                if (existingEngines != null) {
                    for (Engine existingEngine : existingEngines) {
                        if (HybridMobileEngineManager.this.isEngineRemoved(existingEngine, engines)) {
                            cordova.platform(CordovaCLI.Command.REMOVE, (IProgressMonitor)sm, existingEngine.getName());
                        }
                        w.removeEngine(existingEngine);
                    }
                }
                sm.worked(30);
                HybridMobileEngine[] hybridMobileEngineArray = engines;
                int n = engines.length;
                int n2 = 0;
                while (n2 < n) {
                    HybridMobileEngine engine = hybridMobileEngineArray[n2];
                    Engine e = model.createEngine(w);
                    e.setName(engine.getId());
                    if (!engine.isManaged()) {
                        e.setSpec(engine.getLocation().toString());
                    } else {
                        e.setSpec(engine.getVersion());
                    }
                    w.addEngine(e);
                    ++n2;
                }
                model.save();
                IStatus status = Status.OK_STATUS;
                status = cordova.prepare((IProgressMonitor)sm.newChild(40), "").convertTo(ErrorDetectingCLIResult.class).asStatus();
                HybridMobileEngineManager.this.project.getProject().refreshLocal(2, (IProgressMonitor)sm.newChild(30));
                sm.done();
                return status;
            }
        };
        ISchedulingRule rule = ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule((IResource)this.project.getProject());
        updateJob.setRule(rule);
        updateJob.schedule();
    }

    public void resyncWithConfigXml() {
        WorkspaceJob prepareJob = new WorkspaceJob(NLS.bind((String)"Updating project from config.xml for {0}", (Object)this.project.getProject().getName())){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                if (HybridMobileEngineManager.this.project == null) {
                    String err = "Updating from config.xml: Could not get HybridProject";
                    HybridCore.log(2, err, null);
                    return new Status(2, "org.eclipse.thym.core", err);
                }
                HybridMobileEngine[] activeEngines = HybridMobileEngineManager.this.project.getActiveEnginesFromPlatformsJson();
                CordovaCLI cordova = CordovaCLI.newCLIforProject(HybridMobileEngineManager.this.project);
                MultiStatus status = new MultiStatus("org.eclipse.thym.core", 0, "Errors updating engines from config.xml", null);
                IStatus subStatus = Status.OK_STATUS;
                SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                Widget widget = WidgetModel.getModel(HybridMobileEngineManager.this.project).getWidgetForEdit();
                if (widget != null) {
                    List<Engine> configEngines = widget.getEngines();
                    if (configEngines == null) {
                        return new Status(4, "org.eclipse.thym.core", "No engine found in config.xml");
                    }
                    SubMonitor loopMonitor = sm.newChild(70).setWorkRemaining(configEngines.size());
                    for (Engine e : configEngines) {
                        String platformSpec = String.valueOf(e.getName()) + "@" + e.getSpec();
                        subStatus = HybridMobileEngineManager.this.checkPlatformInstalled(activeEngines, e.getName()) ? cordova.platform(CordovaCLI.Command.UPDATE, (IProgressMonitor)loopMonitor.newChild(1), platformSpec).convertTo(ErrorDetectingCLIResult.class).asStatus() : cordova.platform(CordovaCLI.Command.ADD, (IProgressMonitor)loopMonitor.newChild(1), platformSpec).convertTo(ErrorDetectingCLIResult.class).asStatus();
                        status.add(subStatus);
                    }
                }
                HybridMobileEngineManager.this.project.getProject().refreshLocal(2, (IProgressMonitor)sm.newChild(30));
                return status;
            }
        };
        ISchedulingRule rule = ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule((IResource)this.project.getProject());
        prepareJob.setRule(rule);
        prepareJob.schedule();
    }

    private boolean checkPlatformInstalled(HybridMobileEngine[] activeEngines, String engineName) {
        HybridMobileEngine[] hybridMobileEngineArray = activeEngines;
        int n = activeEngines.length;
        int n2 = 0;
        while (n2 < n) {
            HybridMobileEngine engine = hybridMobileEngineArray[n2];
            if (engine.getId().equals(engineName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isEngineRemoved(Engine engine, HybridMobileEngine[] engines) {
        HybridMobileEngine[] hybridMobileEngineArray = engines;
        int n = engines.length;
        int n2 = 0;
        while (n2 < n) {
            HybridMobileEngine hybridMobileEngine = hybridMobileEngineArray[n2];
            if (hybridMobileEngine.getId().equals(engine.getName()) && hybridMobileEngine.getVersion().equals(engine.getSpec())) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

