/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.win.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.thym.core.engine.HybridMobileLibraryResolver;
import org.eclipse.thym.core.internal.util.FileUtils;
import org.eclipse.thym.win.core.WinCore;
import org.eclipse.thym.win.internal.core.Messages;

public class WinLibraryResolver
extends HybridMobileLibraryResolver {
    private static final String WIN = "windows";
    public static final String VERSION = "VERSION";
    public static final String WIN_PHONE_APP_MANIFEST = "package.phone.appxmanifest";
    public static final String WIN_APP_MANIFEST = "package.windows.appxmanifest";
    public static final String WIN_10_APP_MANIFEST = "package.windows10.appxmanifest";
    public static final String WIN_80_APP_MANIFEST = "package.windows80.appxmanifest";
    public static final String WIN_JSPROJ = "CordovaApp.Windows.jsproj";
    public static final String WIN_PHONE_JSPROJ = "CordovaApp.Phone.jsproj";
    public static final String WIN_10_JSPROJ = "CordovaApp.Windows10.jsproj";
    public static final String WIN_80_JSPROJ = "CordovaApp.Windows80.jsproj";
    public static final String WIN_APP_NAME = "CordovaApp";
    public static final String WIN_SLN_NAME = "CordovaApp.sln";
    private static final String TEMPLATE = "template";
    private static final String PROPERTIES = "Properties";
    private HashMap<IPath, URL> files = new HashMap();

    private void initFiles() {
        IPath templatePrjRoot = this.libraryRoot.append(TEMPLATE);
        this.files.put(PATH_CORDOVA_JS, this.getEngineFile(templatePrjRoot.append("www").append("cordova.js")));
        this.files.put((IPath)new Path("$appname"), this.getEngineFile(templatePrjRoot));
        this.files.put((IPath)new Path(VERSION), this.getEngineFile(this.libraryRoot.append(VERSION)));
        this.files.put((IPath)new Path(WIN_PHONE_APP_MANIFEST), this.getEngineFile(templatePrjRoot.append(WIN_PHONE_APP_MANIFEST)));
        this.files.put((IPath)new Path(WIN_APP_MANIFEST), this.getEngineFile(templatePrjRoot.append(WIN_APP_MANIFEST)));
        this.files.put((IPath)new Path(WIN_10_APP_MANIFEST), this.getEngineFile(templatePrjRoot.append(WIN_10_APP_MANIFEST)));
        this.files.put((IPath)new Path(WIN_80_APP_MANIFEST), this.getEngineFile(templatePrjRoot.append(WIN_80_APP_MANIFEST)));
        this.files.put((IPath)new Path(WIN_JSPROJ), this.getEngineFile(templatePrjRoot.append(WIN_JSPROJ)));
        this.files.put((IPath)new Path(WIN_PHONE_JSPROJ), this.getEngineFile(templatePrjRoot.append(WIN_PHONE_JSPROJ)));
        this.files.put((IPath)new Path(WIN_10_JSPROJ), this.getEngineFile(templatePrjRoot.append(WIN_10_JSPROJ)));
        this.files.put((IPath)new Path(WIN_80_JSPROJ), this.getEngineFile(templatePrjRoot.append(WIN_80_JSPROJ)));
        this.files.put((IPath)new Path(WIN_SLN_NAME), this.getEngineFile(templatePrjRoot.append(WIN_SLN_NAME)));
    }

    private URL getEngineFile(IPath path) {
        File file = path.toFile();
        if (!file.exists()) {
            WinCore.log(2, NLS.bind((String)Messages.WinLibraryResolver_MissingEngineError, (Object)file.toString()), null);
        }
        return FileUtils.toURL((File)file);
    }

    public IStatus isLibraryConsistent() {
        if (this.version == null) {
            return new Status(4, "org.eclipse.thym.core", "Library for Android platform is not compatible with this tool. File for path {0} is missing.");
        }
        if (this.files.isEmpty()) {
            this.initFiles();
        }
        for (IPath key : this.files.keySet()) {
            File file;
            URL url = this.files.get(key);
            if (url != null && (file = new File(url.getFile())).exists()) continue;
            return new Status(4, "org.eclipse.thym.core", NLS.bind((String)"Library for Windows Universal platform is not compatible with this tool. File for path {0} is missing.", (Object)key.toString()));
        }
        return Status.OK_STATUS;
    }

    public URL getTemplateFile(IPath destination) {
        if (this.files.isEmpty()) {
            this.initFiles();
        }
        Assert.isNotNull((Object)destination);
        Assert.isTrue((!destination.isAbsolute() ? 1 : 0) != 0);
        return this.files.get(destination);
    }

    public void preCompile(IProgressMonitor monitor) throws CoreException {
    }

    public boolean needsPreCompilation() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String detectVersion() {
        File versionFile = this.libraryRoot.append(VERSION).toFile();
        if (!versionFile.exists()) {
            WinCore.log(4, NLS.bind((String)Messages.WinLibraryResolver_NoVersionError, (Object)versionFile.toString()), null);
            return null;
        }
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new FileReader(versionFile));
                String version = reader.readLine();
                if (version == null) return null;
                String string = version.trim();
                return string;
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (IOException e) {
            WinCore.log(4, Messages.WinLibraryResolver_CannotDetectError, e);
            return null;
        }
    }
}

