/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.internal.preferences;

import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.thym.core.engine.HybridMobileEngine;
import org.eclipse.thym.core.engine.HybridMobileEngineManager;
import org.eclipse.thym.ui.HybridUI;
import org.eclipse.thym.ui.internal.engine.AvailableCordovaEnginesSection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class EnginePreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private AvailableCordovaEnginesSection engineSection;

    public EnginePreferencesPage() {
        this.setDescription("Add or remove Hybrid Mobile Engines. By default, checked engine is used for the newly created Hybrid Mobile projects.");
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite control = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(control);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)control);
        this.engineSection = new AvailableCordovaEnginesSection();
        this.engineSection.createControl(control);
        this.engineSection.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EnginePreferencesPage.this.setValid(EnginePreferencesPage.this.validate());
            }
        });
        this.engineSection.addEngineListChangeListener(new AvailableCordovaEnginesSection.EngineListChangeListener(){

            @Override
            public void listChanged() {
                EnginePreferencesPage.this.initDefaultEngine();
            }
        });
        this.noDefaultAndApplyButton();
        this.initDefaultEngine();
        this.setValid(this.validate());
        return control;
    }

    private void initDefaultEngine() {
        Object[] defaultEngines = HybridMobileEngineManager.defaultEngines();
        if (defaultEngines != null) {
            this.engineSection.setSelection((ISelection)new StructuredSelection(defaultEngines));
        } else {
            List<HybridMobileEngine> engines = this.engineSection.getListedEngines();
            if (engines != null && engines.size() == 1) {
                this.engineSection.setSelection((ISelection)new StructuredSelection((Object)engines.get(0)));
            }
        }
    }

    private boolean validate() {
        if (this.engineSection.getSelection().isEmpty()) {
            this.setErrorMessage("Default engine is not selected");
            return false;
        }
        this.setMessage(null);
        this.setErrorMessage(null);
        return true;
    }

    public boolean performOk() {
        IStructuredSelection sel = (IStructuredSelection)this.engineSection.getSelection();
        if (sel.isEmpty()) {
            this.getPreferenceStore().setToDefault("default_engine");
        } else {
            StringBuilder prefVal = new StringBuilder();
            Object[] selections = sel.toArray();
            int i = 0;
            while (i < selections.length) {
                HybridMobileEngine engine = (HybridMobileEngine)selections[i];
                prefVal.append(engine.getId());
                prefVal.append(":");
                if (engine.isManaged()) {
                    prefVal.append(engine.getVersion());
                } else {
                    prefVal.append(engine.getLocation());
                }
                prefVal.append(",");
                ++i;
            }
            this.getPreferenceStore().setValue("default_engine", prefVal.toString());
        }
        return true;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return HybridUI.getDefault().getPreferenceStore();
    }
}

