/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.wizard.project;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.config.Engine;
import org.eclipse.thym.core.config.Widget;
import org.eclipse.thym.core.config.WidgetModel;
import org.eclipse.thym.core.engine.HybridMobileEngine;
import org.eclipse.thym.core.extensions.PlatformSupport;
import org.eclipse.thym.core.internal.util.FileUtils;
import org.eclipse.thym.ui.HybridUI;
import org.eclipse.thym.ui.internal.project.CanConvertToHybridTester;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.osgi.framework.Bundle;

public class HybridProjectCreator {
    private static final String[] COMMON_PATHS = new String[]{".cordova", "merges", "plugins", "www"};

    public IProject createBasicTemplatedProject(String projectName, URI location, String appName, String appID, HybridMobileEngine[] engines, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IProject project = this.createProject(projectName, location, appName, appID, null, monitor);
        this.addTemplateFiles(project, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
        project.refreshLocal(2, monitor);
        this.updateConfig(project, appName, appID, engines, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        project.refreshLocal(2, monitor);
        return project;
    }

    public IProject createProject(String projectName, URI location, String appName, String appID, HybridMobileEngine[] engines, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IProject project = this.createHybridMobileProject(projectName, location, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.addCommonPaths(project, monitor);
        this.addPlatformPaths(project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.setUpJavaScriptProject(project, monitor);
        this.updateConfig(project, appName, appID, engines, monitor);
        return project;
    }

    public void convertProject(IProject project, IProgressMonitor monitor) throws CoreException {
        HybridProject hp;
        Assert.isNotNull((Object)project, (String)"Project is null");
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((hp = HybridProject.getHybridProject((IProject)project)) != null) {
            return;
        }
        if (!CanConvertToHybridTester.canConvert(project)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", NLS.bind((String)"Project {0} can not be converted to a hybrid mobile project", (Object)project.getName(), null)));
        }
        this.addCommonPaths(project, monitor);
        this.addPlatformPaths(project, monitor);
        this.addNature(project, monitor);
        this.setUpJavaScriptProject(project, monitor);
    }

    private IProject createHybridMobileProject(String projectName, URI location, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)projectName, (String)"Project name is null, can not create a project without a name");
        IProject project = this.createBasicProject(projectName, location, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
        this.addNature(project, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
        return project;
    }

    private void setUpJavaScriptProject(IProject project, IProgressMonitor monitor) throws JavaScriptModelException {
        IJavaScriptProject javascriptProject = JavaScriptCore.create((IProject)project);
        IIncludePathEntry[] entries = javascriptProject.getRawIncludepath();
        ArrayList<IIncludePathEntry> entryList = new ArrayList<IIncludePathEntry>();
        IIncludePathEntry[] iIncludePathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IIncludePathEntry aEntry = iIncludePathEntryArray[n2];
            if (3 != aEntry.getEntryKind() && !aEntry.getPath().segment(0).equals("org.eclipse.thym.core.CordovaContainerInitializer")) {
                entryList.add(aEntry);
            }
            ++n2;
        }
        IIncludePathEntry cordovaLibEntry = JavaScriptCore.newContainerEntry((IPath)new Path("org.eclipse.thym.core.CordovaContainerInitializer"));
        entryList.add(cordovaLibEntry);
        IIncludePathEntry wwwSrcEntry = JavaScriptCore.newSourceEntry((IPath)project.getFolder("www").getFullPath());
        entryList.add(wwwSrcEntry);
        javascriptProject.setRawIncludepath(entryList.toArray(new IIncludePathEntry[entryList.size()]), monitor);
    }

    private void updateConfig(IProject project, String appName, String appID, HybridMobileEngine[] engines, IProgressMonitor monitor) throws CoreException {
        HybridProject hybridProject = HybridProject.getHybridProject((IProject)project);
        try {
            WidgetModel model = WidgetModel.getModel((HybridProject)hybridProject);
            Widget w = model.getWidgetForEdit();
            if (w != null) {
                if (appID != null) {
                    w.setId(appID);
                }
                if (appName != null) {
                    w.setName(appName);
                }
                if (engines != null) {
                    List existingEngines = w.getEngines();
                    if (existingEngines != null) {
                        for (Engine engine : existingEngines) {
                            w.removeEngine(engine);
                        }
                    }
                    HybridMobileEngine[] hybridMobileEngineArray = engines;
                    int n = engines.length;
                    int n2 = 0;
                    while (n2 < n) {
                        HybridMobileEngine hybridMobileEngine = hybridMobileEngineArray[n2];
                        Engine e = model.createEngine(w);
                        e.setName(hybridMobileEngine.getId());
                        if (hybridMobileEngine.isManaged()) {
                            e.setSpec(hybridMobileEngine.getVersion());
                        } else {
                            e.setSpec(hybridMobileEngine.getLocation().toString());
                        }
                        w.addEngine(e);
                        ++n2;
                    }
                }
                model.save();
            }
        }
        catch (CoreException e) {
            HybridCore.log((int)4, (String)"Error updating application name and id to config.xml", (Throwable)e);
        }
    }

    private void addTemplateFiles(IProject project, IProgressMonitor monitor) throws CoreException {
        Bundle bundle = HybridUI.getDefault().getBundle();
        URL source = bundle.getEntry("/templates");
        try {
            FileUtils.directoryCopy((URL)source, (URL)FileUtils.toURL((File)project.getLocation().toFile()));
            monitor.done();
        }
        catch (MalformedURLException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.ui", "Error adding template files", (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.ui", "Error adding template files", (Throwable)e));
        }
    }

    private void addPlatformPaths(IProject project, IProgressMonitor monitor) throws CoreException {
        List platforms = HybridCore.getPlatformSupports();
        Path merges = new Path("merges");
        for (PlatformSupport platform : platforms) {
            IFolder folder = project.getFolder(merges.append(platform.getPlatformId()));
            if (folder.exists()) continue;
            this.createFolder(folder, monitor);
        }
        monitor.done();
    }

    private void addCommonPaths(IProject project, IProgressMonitor monitor) throws CoreException {
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, COMMON_PATHS.length);
        String[] stringArray = COMMON_PATHS;
        int n = COMMON_PATHS.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            IFolder folder = project.getFolder(path);
            if (!folder.exists()) {
                this.createFolder(folder, (IProgressMonitor)subMonitor);
            }
            subMonitor.worked(1);
            ++n2;
        }
        subMonitor.done();
    }

    private void createFolder(IFolder folder, IProgressMonitor monitor) throws CoreException {
        IContainer parent = folder.getParent();
        IFolder parentFolder = (IFolder)parent.getAdapter(IFolder.class);
        if (parentFolder != null) {
            this.createFolder(parentFolder, monitor);
        }
        if (!folder.exists()) {
            folder.create(false, true, monitor);
        }
    }

    private void addNature(IProject project, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] oldNatures = description.getNatureIds();
        ArrayList<String> natureList = new ArrayList<String>();
        natureList.addAll(Arrays.asList(oldNatures));
        if (!project.hasNature("org.eclipse.thym.core.HybridAppNature")) {
            natureList.add("org.eclipse.thym.core.HybridAppNature");
        }
        if (!project.hasNature("org.eclipse.wst.jsdt.core.jsNature")) {
            natureList.add("org.eclipse.wst.jsdt.core.jsNature");
        }
        description.setNatureIds(natureList.toArray(new String[natureList.size()]));
        project.setDescription(description, monitor);
    }

    private IProject createBasicProject(String name, URI location, IProgressMonitor monitor) throws CoreException {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject newProject = workspaceRoot.getProject(name);
        if (!newProject.exists()) {
            IProjectDescription description = newProject.getWorkspace().newProjectDescription(name);
            if (location != null) {
                description.setLocationURI(location);
            }
            newProject.create(description, monitor);
            if (!newProject.isOpen()) {
                newProject.open(monitor);
            }
        }
        return newProject;
    }
}

