/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.local.launch;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.tm.internal.terminal.local.LocalTerminalActivator;
import org.eclipse.tm.internal.terminal.local.LocalTerminalUtilities;
import org.eclipse.tm.internal.terminal.local.launch.ui.LocalTerminalStillRunningDialog;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchWindow;

public class LocalTerminalStillRunningListener
implements IWorkbenchListener {
    public boolean preShutdown(IWorkbench workbench, boolean forced) {
        if (forced) {
            return true;
        }
        IPreferenceStore store = LocalTerminalActivator.getDefault().getPreferenceStore();
        if (!store.getBoolean("CONFIRM_TERMINATE")) {
            return true;
        }
        String launchTypeID = "org.eclipse.tm.terminal.local.launch";
        ILaunchConfigurationType launchType = LocalTerminalUtilities.LAUNCH_MANAGER.getLaunchConfigurationType(launchTypeID);
        if (launchType == null) {
            return true;
        }
        ArrayList<ILaunch> notTerminated = new ArrayList<ILaunch>();
        ILaunch[] launches = LocalTerminalUtilities.LAUNCH_MANAGER.getLaunches();
        int launch = 0;
        while (launch < launches.length) {
            block8: {
                ILaunchConfigurationType configurationType;
                try {
                    ILaunchConfiguration configuration = launches[launch].getLaunchConfiguration();
                    if (configuration == null) break block8;
                    configurationType = configuration.getType();
                }
                catch (CoreException exception) {
                    Logger.logException((Exception)((Object)exception));
                    break block8;
                }
                if (configurationType.equals(launchType) && !launches[launch].isTerminated()) {
                    notTerminated.add(launches[launch]);
                }
            }
            ++launch;
        }
        if (!notTerminated.isEmpty()) {
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            ILaunch[] launch2 = notTerminated.toArray(new ILaunch[notTerminated.size()]);
            return LocalTerminalStillRunningDialog.openDialog(window.getShell(), launch2);
        }
        return true;
    }

    public void postShutdown(IWorkbench workbench) {
    }
}

