/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.clientserver.processes.handlers;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.rse.services.clientserver.processes.IHostProcess;
import org.eclipse.rse.services.clientserver.processes.IHostProcessFilter;
import org.eclipse.rse.services.clientserver.processes.handlers.ProcessComparator;
import org.eclipse.rse.services.clientserver.processes.handlers.UniversalAIXProcessHandler;
import org.eclipse.rse.services.clientserver.processes.handlers.UniversalServerProcessImpl;

public class UniversalSolarisProcessHandler
extends UniversalAIXProcessHandler {
    private static final String[] processAttributes = new String[]{"pid", "ppid", "comm", "uid", "user", "gid", "vsz", "s"};
    private static final String firstColumnHeader = "PID";

    public IHostProcess kill(IHostProcess process, String type) throws Exception {
        return super.kill(process, type);
    }

    public SortedSet lookupProcesses(IHostProcessFilter rpfs) throws Exception {
        TreeSet<UniversalServerProcessImpl> results = new TreeSet<UniversalServerProcessImpl>(new ProcessComparator());
        String cmdLine = "/usr/bin/ps -A -o ";
        int i = 0;
        while (i < processAttributes.length) {
            cmdLine = String.valueOf(cmdLine) + processAttributes[i];
            if (processAttributes.length - i > 1) {
                cmdLine = String.valueOf(cmdLine) + ",";
            }
            ++i;
        }
        Process ps = Runtime.getRuntime().exec(cmdLine);
        InputStreamReader isr = new InputStreamReader(ps.getInputStream());
        BufferedReader reader = new BufferedReader(isr);
        String nextLine = reader.readLine();
        if (nextLine != null && nextLine.trim().startsWith(firstColumnHeader)) {
            nextLine = reader.readLine();
        }
        while (nextLine != null) {
            String statusLine = "";
            HashMap psLineContents = this.getPSOutput(nextLine);
            if (psLineContents == null) {
                nextLine = reader.readLine();
                continue;
            }
            String pid = (String)psLineContents.get("pid");
            statusLine = String.valueOf(pid) + "|";
            String name = (String)psLineContents.get("comm");
            if (name == null) {
                name = " ";
            }
            statusLine = String.valueOf(statusLine) + name + "|";
            String state = (String)psLineContents.get("s");
            if (state == null) {
                state = " ";
            }
            String stateCode = this.convertToStateCode(state);
            statusLine = String.valueOf(statusLine) + stateCode + "|";
            String tgid = (String)psLineContents.get("tgid");
            if (tgid == null) {
                tgid = " ";
            }
            statusLine = String.valueOf(statusLine) + tgid + "|";
            String pPid = (String)psLineContents.get("ppid");
            if (pPid == null) {
                pPid = " ";
            }
            statusLine = String.valueOf(statusLine) + pPid + "|";
            String tracerpid = (String)psLineContents.get("tracerpid");
            if (tracerpid == null) {
                tracerpid = " ";
            }
            statusLine = String.valueOf(statusLine) + tracerpid + "|";
            String uid = (String)psLineContents.get("uid");
            if (uid == null) {
                uid = " ";
            }
            statusLine = String.valueOf(statusLine) + uid + "|";
            String username = (String)psLineContents.get("user");
            if (username == null) {
                username = " ";
            }
            statusLine = String.valueOf(statusLine) + username + "|";
            String gid = (String)psLineContents.get("gid");
            if (gid == null) {
                gid = " ";
            }
            statusLine = String.valueOf(statusLine) + gid + "|";
            String vmsize = (String)psLineContents.get("vsz");
            if (vmsize == null) {
                vmsize = " ";
            }
            statusLine = String.valueOf(statusLine) + vmsize + "|";
            String vmrss = " ";
            if (rpfs.allows(statusLine = String.valueOf(statusLine) + vmrss)) {
                UniversalServerProcessImpl usp = new UniversalServerProcessImpl(statusLine);
                results.add(usp);
            }
            nextLine = reader.readLine();
        }
        reader.close();
        isr.close();
        if (results.size() == 0) {
            return null;
        }
        return results;
    }
}

