/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.resources;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.SystemRemoteResourceSet;
import org.eclipse.rse.core.model.SystemWorkspaceResourceSet;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.files.ui.resources.SystemUniversalTempFileListener;
import org.eclipse.rse.internal.files.ui.Activator;
import org.eclipse.rse.internal.files.ui.FileResources;
import org.eclipse.rse.internal.files.ui.resources.SystemFileNameHelper;
import org.eclipse.rse.internal.files.ui.resources.SystemRemoteEditManager;
import org.eclipse.rse.internal.ui.dialogs.CopyRunnable;
import org.eclipse.rse.services.clientserver.SystemEncodingUtil;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.archiveutils.ISystemArchiveHandler;
import org.eclipse.rse.services.clientserver.archiveutils.VirtualChild;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.clientserver.messages.SystemUnsupportedOperationException;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.files.RemoteFileIOException;
import org.eclipse.rse.services.files.RemoteFileSecurityException;
import org.eclipse.rse.services.files.RemoteFolderNotEmptyException;
import org.eclipse.rse.subsystems.files.core.SystemIFileProperties;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IVirtualRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileSubSystem;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.dialogs.SystemRenameSingleDialog;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class UniversalFileTransferUtility {
    static final boolean doCompressedTransfer = true;
    static final String _rootPath = SystemRemoteEditManager.getInstance().getRemoteEditProjectLocation().makeAbsolute().toOSString();

    private static boolean doSuperTransfer(IRemoteFileSubSystem subsystem) {
        boolean doSuperTransferProperty = RSEUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.rse.subsystems.files.core.preferences.dosupertransfer") && subsystem.getParentRemoteFileSubSystemConfiguration().supportsArchiveManagement();
        return doSuperTransferProperty;
    }

    public static void transferRemoteResource(IRemoteFile srcFileOrFolder, IRemoteFile tgtFolder, IProgressMonitor monitor) {
        Object tempSrc = UniversalFileTransferUtility.downloadResourceToWorkspace(srcFileOrFolder, monitor);
        if (tempSrc instanceof IResource) {
            UniversalFileTransferUtility.uploadResourceFromWorkspace((IResource)tempSrc, tgtFolder, monitor);
        }
    }

    private static boolean tempFileAvailable(IFile tempFile, IRemoteFile remoteFile) {
        SystemIFileProperties properties;
        long storedModifiedStamp;
        if (tempFile.exists() && ((Resource)tempFile).getPropertyManager() != null && (storedModifiedStamp = (properties = new SystemIFileProperties((IResource)tempFile)).getRemoteFileTimeStamp()) > 0L) {
            long remoteModifiedStamp = remoteFile.getLastModified();
            boolean usedBin = properties.getUsedBinaryTransfer();
            boolean shouldUseBin = remoteFile.isBinary();
            String remoteEncoding = remoteFile.getEncoding();
            String lastEncoding = properties.getEncoding();
            if (storedModifiedStamp == remoteModifiedStamp && usedBin == shouldUseBin && remoteEncoding.equals(lastEncoding)) {
                return true;
            }
        }
        return false;
    }

    protected static IFile downloadFileToWorkspace(IRemoteFile srcFileOrFolder, IProgressMonitor monitor) {
        IRemoteFileSubSystem srcFS = srcFileOrFolder.getParentRemoteFileSubSystem();
        IResource tempResource = UniversalFileTransferUtility.getTempFileFor(srcFileOrFolder);
        IFile tempFile = (IFile)tempResource;
        boolean available = UniversalFileTransferUtility.tempFileAvailable(tempFile, srcFileOrFolder);
        if (available) {
            return tempFile;
        }
        try {
            SystemUniversalTempFileListener listener = SystemUniversalTempFileListener.getListener();
            listener.addIgnoreFile(tempFile);
            String remoteEncoding = srcFileOrFolder.getEncoding();
            srcFS.download(srcFileOrFolder, tempFile.getLocation().makeAbsolute().toOSString(), remoteEncoding, monitor);
            if (!tempFile.exists() && !tempFile.isSynchronized(0)) {
                try {
                    tempFile.refreshLocal(0, null);
                }
                catch (Exception exception) {}
            }
            if (tempFile.exists()) {
                SystemIFileProperties properties = new SystemIFileProperties((IResource)tempFile);
                boolean readOnly = !srcFileOrFolder.canWrite();
                UniversalFileTransferUtility.setReadOnly(tempFile, readOnly);
                properties.setRemoteFileTimeStamp(srcFileOrFolder.getLastModified());
                properties.setDownloadFileTimeStamp(tempFile.getLocation().toFile().lastModified());
                properties.setReadOnly(readOnly);
                properties.setDirty(false);
                if (remoteEncoding != null) {
                    if (srcFileOrFolder.isBinary()) {
                        if (!tempFile.isSynchronized(0)) {
                            tempFile.refreshLocal(0, null);
                        }
                        if (!tempFile.getCharset().equals(remoteEncoding)) {
                            tempFile.setCharset(remoteEncoding, null);
                        }
                    } else if (properties.getLocalEncoding() != null) {
                        String localEncoding = properties.getLocalEncoding();
                        tempFile.setCharset(localEncoding, null);
                    }
                }
            }
            listener.removeIgnoreFile(tempFile);
        }
        catch (SystemMessageException e) {
            UniversalFileTransferUtility.runInDisplayThread(new Runnable(){

                public void run() {
                    SystemMessageDialog dlg = new SystemMessageDialog(SystemBasePlugin.getActiveWorkbenchShell(), e.getSystemMessage());
                    dlg.open();
                }
            });
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return (IFile)tempResource;
    }

    protected static void setIFileProperties(IFile tempFile, IRemoteFile remoteFile, IRemoteFileSubSystem subSystem) {
        SystemIFileProperties properties = new SystemIFileProperties((IResource)tempFile);
        properties.setRemoteFileTimeStamp(remoteFile.getLastModified());
        properties.setDirty(false);
        String remotePath = remoteFile.getAbsolutePath();
        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
        String subSystemId = registry.getAbsoluteNameForSubSystem((ISubSystem)subSystem);
        properties.setRemoteFileSubSystem(subSystemId);
        properties.setRemoteFilePath(remotePath);
        properties.setEncoding(remoteFile.getEncoding());
        properties.setUsedBinaryTransfer(remoteFile.isBinary());
        properties.setDownloadFileTimeStamp(tempFile.getLocation().toFile().lastModified());
        boolean isMounted = UniversalFileTransferUtility.isRemoteFileMounted((ISubSystem)subSystem, remotePath);
        properties.setRemoteFileMounted(isMounted);
        if (isMounted) {
            String actualRemoteHost = UniversalFileTransferUtility.getActualHostFor(subSystem, remotePath);
            String actualRemotePath = UniversalFileTransferUtility.getWorkspaceRemotePath(subSystem, remotePath);
            properties.setResolvedMountedRemoteFileHost(actualRemoteHost);
            properties.setResolvedMountedRemoteFilePath(actualRemotePath);
        }
    }

    protected static void setIFileProperties(IFile tempFile, File remoteFile, String hostname, String userId) {
        SystemIFileProperties properties = new SystemIFileProperties((IResource)tempFile);
        properties.setRemoteFileTimeStamp(remoteFile.lastModified());
        properties.setDirty(false);
        String remotePath = remoteFile.getAbsolutePath();
        properties.setRemoteFilePath(remotePath);
        try {
            properties.setEncoding(tempFile.getCharset());
        }
        catch (CoreException coreException) {}
        properties.setDownloadFileTimeStamp(tempFile.getLocation().toFile().lastModified());
        boolean isMounted = UniversalFileTransferUtility.isRemoteFileMounted(hostname, remotePath, null);
        properties.setRemoteFileMounted(isMounted);
        if (isMounted) {
            String actualRemoteHost = UniversalFileTransferUtility.getActualHostFor(hostname, remotePath, null);
            String actualRemotePath = UniversalFileTransferUtility.getWorkspaceRemotePath(hostname, remotePath, null);
            properties.setResolvedMountedRemoteFileHost(actualRemoteHost);
            properties.setResolvedMountedRemoteFilePath(actualRemotePath);
        }
    }

    public static SystemWorkspaceResourceSet downloadResourcesToWorkspaceMultiple(SystemRemoteResourceSet remoteSet, IProgressMonitor monitor) {
        IContainer broadestContainer = null;
        SystemWorkspaceResourceSet resultSet = new SystemWorkspaceResourceSet();
        List set = remoteSet.getResourceSet();
        IRemoteFileSubSystem srcFS = (IRemoteFileSubSystem)remoteSet.getSubSystem();
        SystemUniversalTempFileListener listener = SystemUniversalTempFileListener.getListener();
        ArrayList<IRemoteFile> remoteFilesForDownload = new ArrayList<IRemoteFile>();
        ArrayList<IFile> tempFilesForDownload = new ArrayList<IFile>();
        ArrayList<String> remoteEncodingsForDownload = new ArrayList<String>();
        ArrayList<IResource> emptyFolders = new ArrayList<IResource>();
        int i = 0;
        while (i < set.size() && !resultSet.hasMessage()) {
            if (monitor != null && monitor.isCanceled()) {
                return resultSet;
            }
            IRemoteFile srcFileOrFolder = (IRemoteFile)set.get(i);
            if (!srcFileOrFolder.exists()) {
                String msgTxt = NLS.bind((String)FileResources.MSG_ERROR_FILE_NOTFOUND, (Object)srcFileOrFolder.getAbsolutePath(), (Object)srcFS.getHostAliasName());
                SimpleSystemMessage errorMessage = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEG1106", 4, msgTxt);
                resultSet.setMessage((SystemMessage)errorMessage);
            } else if (srcFileOrFolder.isFile()) {
                IResource tempResource = UniversalFileTransferUtility.getTempFileFor(srcFileOrFolder);
                IFile tempFile = (IFile)tempResource;
                boolean available = UniversalFileTransferUtility.tempFileAvailable(tempFile, srcFileOrFolder);
                if (available) {
                    resultSet.addResource((Object)tempFile);
                } else {
                    listener.addIgnoreFile(tempFile);
                    remoteFilesForDownload.add(srcFileOrFolder);
                    tempFilesForDownload.add(tempFile);
                    remoteEncodingsForDownload.add(srcFileOrFolder.getEncoding());
                    IContainer parent = tempFile.getParent();
                    if (broadestContainer == null || parent.contains((ISchedulingRule)broadestContainer)) {
                        broadestContainer = parent;
                    } else if (!broadestContainer.contains((ISchedulingRule)parent)) {
                        broadestContainer = broadestContainer.getParent();
                    }
                }
            } else if (srcFileOrFolder.isDirectory()) {
                IResource tempFolder = UniversalFileTransferUtility.getTempFileFor(srcFileOrFolder);
                try {
                    IRemoteFile[] children = srcFS.list(srcFileOrFolder, 0, monitor);
                    if (children == null || children.length == 0) {
                        emptyFolders.add(tempFolder);
                    }
                    if ((children = srcFS.list(srcFileOrFolder, 2, monitor)) != null && children.length != 0) {
                        ArrayList<IRemoteFile> fcs = new ArrayList<IRemoteFile>();
                        int c = 0;
                        while (c < children.length) {
                            IRemoteFile child = children[c];
                            if (!child.isArchive()) {
                                fcs.add(child);
                            }
                            ++c;
                        }
                        if (fcs.size() > 0) {
                            SystemRemoteResourceSet childSet = new SystemRemoteResourceSet((ISubSystem)srcFS, fcs);
                            SystemWorkspaceResourceSet childResults = UniversalFileTransferUtility.downloadResourcesToWorkspaceMultiple(childSet, monitor);
                            if (childResults.hasMessage()) {
                                resultSet.setMessage(childResults.getMessage());
                            }
                            resultSet.addResource((Object)tempFolder);
                        }
                    }
                }
                catch (SystemMessageException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        IRemoteFile[] sources = remoteFilesForDownload.toArray(new IRemoteFile[remoteFilesForDownload.size()]);
        String[] encodings = remoteEncodingsForDownload.toArray(new String[remoteEncodingsForDownload.size()]);
        String[] destinations = new String[remoteFilesForDownload.size()];
        int t = 0;
        while (t < tempFilesForDownload.size()) {
            destinations[t] = ((IFile)tempFilesForDownload.get(t)).getLocation().toOSString();
            ++t;
        }
        if (sources.length > 0) {
            try {
                srcFS.downloadMultiple(sources, destinations, encodings, monitor);
            }
            catch (SystemMessageException e) {
                resultSet.setMessage(e.getSystemMessage());
            }
        }
        try {
            if (broadestContainer != null && !broadestContainer.isSynchronized(2)) {
                broadestContainer.refreshLocal(2, null);
            }
        }
        catch (Exception exception) {}
        try {
            UniversalFileTransferUtility.createEmptyFolders(monitor, emptyFolders);
        }
        catch (CoreException e) {
            SimpleSystemMessage errorMessage = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEF1302", 4, FileResources.FILEMSG_CREATE_FILE_FAILED, (Throwable)e);
            resultSet.setMessage((SystemMessage)errorMessage);
        }
        if (!resultSet.hasMessage()) {
            int p = 0;
            while (p < remoteFilesForDownload.size()) {
                IRemoteFile srcFileOrFolder = (IRemoteFile)remoteFilesForDownload.get(p);
                IFile tempFile = (IFile)tempFilesForDownload.get(p);
                resultSet.addResource((Object)tempFile);
                String remoteEncoding = (String)remoteEncodingsForDownload.get(p);
                listener.removeIgnoreFile(tempFile);
                SystemIFileProperties properties = new SystemIFileProperties((IResource)tempFile);
                long storedTime = properties.getRemoteFileTimeStamp();
                long currentTime = srcFileOrFolder.getLastModified();
                String storedEncoding = properties.getEncoding();
                String currentEncoding = srcFileOrFolder.getEncoding();
                if ((storedTime != currentTime || storedEncoding == null || !storedEncoding.equals(currentEncoding)) && tempFile.exists()) {
                    if (storedEncoding == null || !storedEncoding.equals(currentEncoding)) {
                        boolean readOnly = !srcFileOrFolder.canWrite();
                        UniversalFileTransferUtility.setReadOnly(tempFile, readOnly);
                        try {
                            if (remoteEncoding != null) {
                                if (srcFileOrFolder.isBinary()) {
                                    if (!tempFile.isSynchronized(0)) {
                                        tempFile.refreshLocal(0, null);
                                    }
                                    if (!tempFile.getCharset().equals(remoteEncoding)) {
                                        tempFile.setCharset(remoteEncoding, null);
                                    }
                                } else if (properties.getLocalEncoding() != null) {
                                    String localEncoding = properties.getLocalEncoding();
                                    tempFile.setCharset(localEncoding, null);
                                }
                            }
                        }
                        catch (Exception e) {
                            SimpleSystemMessage errorMessage = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEG1066", 4, "", (Throwable)e);
                            resultSet.setMessage((SystemMessage)errorMessage);
                            return null;
                        }
                    }
                    try {
                        UniversalFileTransferUtility.setIFileProperties(tempFile, srcFileOrFolder, srcFS);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++p;
            }
        }
        return resultSet;
    }

    private static void createEmptyFolders(IProgressMonitor monitor, List emptyFolders) throws CoreException {
        boolean go = false;
        int i = 0;
        while (i < emptyFolders.size()) {
            IFolder emptyFolder;
            ArrayList<IContainer> emptyParent = new ArrayList<IContainer>();
            IContainer empty = (IContainer)emptyFolders.get(i);
            go = true;
            while (go) {
                if (!(empty = empty.getParent()).exists() && empty instanceof IFolder) {
                    emptyParent.add(empty);
                    continue;
                }
                go = false;
            }
            int j = emptyParent.size() - 1;
            while (j >= 0) {
                emptyFolder = (IFolder)emptyParent.get(j);
                if (!emptyFolder.exists()) {
                    emptyFolder.create(true, true, monitor);
                }
                --j;
            }
            emptyFolder = (IFolder)emptyFolders.get(i);
            if (!emptyFolder.exists()) {
                emptyFolder.create(true, true, monitor);
            }
            ++i;
        }
    }

    public static SystemWorkspaceResourceSet downloadResourcesToWorkspace(SystemRemoteResourceSet remoteSet, IProgressMonitor monitor) {
        boolean ok = true;
        SystemWorkspaceResourceSet resultSet = new SystemWorkspaceResourceSet();
        IRemoteFileSubSystem srcFS = (IRemoteFileSubSystem)remoteSet.getSubSystem();
        if (!srcFS.isConnected()) {
            return null;
        }
        boolean doSuperTransferProperty = UniversalFileTransferUtility.doSuperTransfer(srcFS);
        List set = remoteSet.getResourceSet();
        ArrayList<IResource> emptyFolders = new ArrayList<IResource>();
        int i = 0;
        while (i < set.size() && !resultSet.hasMessage()) {
            if (monitor != null && monitor.isCanceled()) {
                return resultSet;
            }
            IRemoteFile srcFileOrFolder = (IRemoteFile)set.get(i);
            if (!srcFileOrFolder.exists()) {
                String msgTxt = NLS.bind((String)FileResources.MSG_ERROR_FILE_NOTFOUND, (Object)srcFileOrFolder.getAbsolutePath(), (Object)srcFS.getHostAliasName());
                SimpleSystemMessage errorMessage = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEG1106", 4, msgTxt);
                resultSet.setMessage((SystemMessage)errorMessage);
            } else if (srcFileOrFolder.isFile()) {
                IFile tempFile = UniversalFileTransferUtility.downloadFileToWorkspace(srcFileOrFolder, monitor);
                resultSet.addResource((Object)tempFile);
            } else {
                IResource tempFolder = null;
                if (doSuperTransferProperty && !srcFileOrFolder.isRoot() && !srcFileOrFolder.getParentRemoteFileSubSystem().getHost().getSystemType().isLocal()) {
                    try {
                        tempFolder = UniversalFileTransferUtility.compressedDownloadToWorkspace(srcFileOrFolder, monitor);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ok = false;
                    }
                    boolean bl = ok = tempFolder != null;
                    if (ok) {
                        resultSet.addResource((Object)tempFolder);
                    }
                } else {
                    tempFolder = UniversalFileTransferUtility.getTempFileFor(srcFileOrFolder);
                    try {
                        SystemRemoteResourceSet childSet;
                        SystemWorkspaceResourceSet childResults;
                        Object[] children = srcFS.list(srcFileOrFolder, monitor);
                        if (children == null || children.length == 0) {
                            emptyFolders.add(tempFolder);
                        }
                        if ((childResults = UniversalFileTransferUtility.downloadResourcesToWorkspace(childSet = new SystemRemoteResourceSet((ISubSystem)srcFS, children), monitor)).hasMessage()) {
                            resultSet.setMessage(childResults.getMessage());
                        }
                        resultSet.addResource((Object)tempFolder);
                    }
                    catch (SystemMessageException e) {
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
        try {
            UniversalFileTransferUtility.createEmptyFolders(monitor, emptyFolders);
        }
        catch (CoreException e) {
            SimpleSystemMessage errorMessage = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEF1302", 4, FileResources.FILEMSG_CREATE_FILE_FAILED, (Throwable)e);
            resultSet.setMessage((SystemMessage)errorMessage);
        }
        int r = 0;
        while (r < resultSet.size()) {
            IResource tempResource = (IResource)resultSet.get(r);
            IRemoteFile rmtFile = (IRemoteFile)remoteSet.get(r);
            if (tempResource != null && !tempResource.exists()) {
                try {
                    tempResource.refreshLocal(1, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            if (tempResource instanceof IFile) {
                try {
                    UniversalFileTransferUtility.setIFileProperties((IFile)tempResource, rmtFile, srcFS);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++r;
        }
        return resultSet;
    }

    public static void discardReplicasOfDeletedFiles(IRemoteFileSubSystem ss, IContainer folder) {
        try {
            IResource[] members = folder.members();
            int i = members.length - 1;
            while (i >= 0) {
                IResource member = members[i];
                if (member instanceof IFile) {
                    SystemIFileProperties properties = new SystemIFileProperties(member);
                    String path = properties.getRemoteFilePath();
                    if (path != null) {
                        IRemoteFile remoteFile = null;
                        if (ss instanceof RemoteFileSubSystem && (remoteFile = ((RemoteFileSubSystem)ss).getCachedRemoteFile(path)) != null) {
                            remoteFile.markStale(true);
                        }
                        if ((remoteFile = ss.getRemoteFileObject(path, (IProgressMonitor)new NullProgressMonitor())) != null && !remoteFile.exists()) {
                            member.delete(true, (IProgressMonitor)new NullProgressMonitor());
                        }
                    }
                } else if (member instanceof IContainer) {
                    UniversalFileTransferUtility.discardReplicasOfDeletedFiles(ss, (IContainer)member);
                }
                --i;
            }
        }
        catch (Exception exception) {}
    }

    public static Object downloadResourceToWorkspace(File srcFileOrFolder, IProgressMonitor monitor) {
        if (!srcFileOrFolder.exists()) {
            String msgTxt = NLS.bind((String)FileResources.MSG_ERROR_FILE_NOTFOUND, (Object)srcFileOrFolder.getAbsolutePath(), (Object)"LOCALHOST");
            SimpleSystemMessage errorMessage = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEG1106", 4, msgTxt);
            return errorMessage;
        }
        if (srcFileOrFolder.isFile()) {
            IFile tempFile = UniversalFileTransferUtility.downloadFileToWorkspace(srcFileOrFolder, monitor);
            if (!tempFile.exists()) {
                try {
                    if (PlatformUI.isWorkbenchRunning() && !tempFile.isSynchronized(0)) {
                        tempFile.refreshLocal(0, monitor);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((tempFile = (IFile)UniversalFileTransferUtility.getTempFileFor(srcFileOrFolder)).exists()) {
                try {
                    UniversalFileTransferUtility.setIFileProperties(tempFile, srcFileOrFolder, "LOCALHOST", System.getProperty("user.name"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return tempFile;
        }
        return null;
    }

    protected static IFile downloadFileToWorkspace(File srcFileOrFolder, IProgressMonitor monitor) {
        IResource tempResource;
        block11: {
            SystemIFileProperties properties;
            long storedModifiedStamp;
            tempResource = UniversalFileTransferUtility.getTempFileFor(srcFileOrFolder);
            IFile tempFile = (IFile)tempResource;
            if (tempFile.exists() && (storedModifiedStamp = (properties = new SystemIFileProperties((IResource)tempFile)).getRemoteFileTimeStamp()) > 0L) {
                long remoteModifiedStamp = srcFileOrFolder.lastModified();
                boolean usedBin = properties.getUsedBinaryTransfer();
                boolean shouldUseBin = RemoteFileUtility.getSystemFileTransferModeRegistry().isBinary(srcFileOrFolder);
                if (storedModifiedStamp == remoteModifiedStamp && usedBin == shouldUseBin) {
                    boolean readOnly = !srcFileOrFolder.canWrite();
                    UniversalFileTransferUtility.setReadOnly(tempFile, readOnly);
                    return tempFile;
                }
            }
            try {
                SystemUniversalTempFileListener listener = SystemUniversalTempFileListener.getListener();
                listener.addIgnoreFile(tempFile);
                String encoding = tempFile.getParent().getDefaultCharset();
                UniversalFileTransferUtility.download(srcFileOrFolder, tempFile, encoding, monitor);
                listener.removeIgnoreFile(tempFile);
                if (!tempFile.exists() && !tempFile.isSynchronized(0)) {
                    try {
                        tempFile.refreshLocal(0, null);
                    }
                    catch (Exception exception) {}
                }
                if (!tempFile.exists()) break block11;
                boolean readOnly = !srcFileOrFolder.canWrite();
                UniversalFileTransferUtility.setReadOnly(tempFile, readOnly);
                if (!RemoteFileUtility.getSystemFileTransferModeRegistry().isText(srcFileOrFolder)) break block11;
                try {
                    String cset;
                    if (!tempFile.isSynchronized(0)) {
                        tempFile.refreshLocal(0, null);
                    }
                    if (!(cset = tempFile.getCharset()).equals(encoding)) {
                        tempFile.setCharset(encoding, monitor);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                SystemBasePlugin.logError((String)("An exception occured " + e.getMessage()), (Throwable)e);
                return null;
            }
        }
        return (IFile)tempResource;
    }

    /*
     * Exception decompiling
     */
    protected static boolean download(File file, IFile tempFile, String hostEncoding, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Object downloadResourceToWorkspace(IRemoteFile srcFileOrFolder, IProgressMonitor monitor) {
        boolean ok = true;
        IRemoteFileSubSystem srcFS = srcFileOrFolder.getParentRemoteFileSubSystem();
        if (!srcFS.isConnected()) {
            return null;
        }
        if (!srcFileOrFolder.exists()) {
            String msgTxt = NLS.bind((String)FileResources.MSG_ERROR_FILE_NOTFOUND, (Object)srcFileOrFolder.getAbsolutePath(), (Object)srcFS.getHostAliasName());
            SimpleSystemMessage errorMessage = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEG1106", 4, msgTxt);
            return errorMessage;
        }
        if (srcFileOrFolder.isFile()) {
            IFile tempFile = UniversalFileTransferUtility.downloadFileToWorkspace(srcFileOrFolder, monitor);
            if (!tempFile.exists()) {
                try {
                    if (PlatformUI.isWorkbenchRunning() && !tempFile.isSynchronized(0)) {
                        tempFile.refreshLocal(0, monitor);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((tempFile = (IFile)UniversalFileTransferUtility.getTempFileFor(srcFileOrFolder)).exists() && ((Resource)tempFile).getPropertyManager() != null) {
                try {
                    UniversalFileTransferUtility.setIFileProperties(tempFile, srcFileOrFolder, srcFS);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return tempFile;
        }
        IResource tempFolder = null;
        boolean doSuperTransferProperty = UniversalFileTransferUtility.doSuperTransfer(srcFileOrFolder.getParentRemoteFileSubSystem());
        if (doSuperTransferProperty && !srcFileOrFolder.isRoot() && !srcFileOrFolder.getParentRemoteFileSubSystem().getHost().getSystemType().isLocal()) {
            try {
                tempFolder = UniversalFileTransferUtility.compressedDownloadToWorkspace(srcFileOrFolder, monitor);
            }
            catch (Exception e) {
                e.printStackTrace();
                ok = false;
            }
            boolean bl = ok = tempFolder != null;
            if (ok) {
                return tempFolder;
            }
        } else {
            int i;
            tempFolder = UniversalFileTransferUtility.getTempFileFor(srcFileOrFolder);
            IRemoteFile[] children = null;
            try {
                children = srcFS.list(srcFileOrFolder, monitor);
            }
            catch (SystemMessageException e) {
                e.printStackTrace();
            }
            IResource[] childResources = null;
            if (children != null) {
                childResources = new IResource[children.length];
                if (children.length == 0) {
                    File tempFolderFile = tempFolder.getLocation().toFile();
                    tempFolderFile.mkdirs();
                }
                i = 0;
                while (i < children.length && ok) {
                    IRemoteFile child = children[i];
                    Object childResource = null;
                    childResource = child.isFile() ? UniversalFileTransferUtility.downloadFileToWorkspace(child, monitor) : (IResource)UniversalFileTransferUtility.downloadResourceToWorkspace(child, monitor);
                    if (childResource == null) {
                        ok = false;
                    }
                    if (monitor != null && monitor.isCanceled()) {
                        ok = false;
                    }
                    childResources[i] = childResource;
                    ++i;
                }
            }
            if (ok) {
                UniversalFileTransferUtility.refreshResourceInWorkspace(tempFolder);
                if (tempFolder.exists() && children != null && childResources != null) {
                    i = 0;
                    while (i < childResources.length) {
                        IResource tempFile = childResources[i];
                        if (tempFile.exists() && tempFile instanceof IFile) {
                            IRemoteFile child = children[i];
                            UniversalFileTransferUtility.setIFileProperties((IFile)tempFile, child, srcFS);
                        }
                        ++i;
                    }
                }
                return tempFolder;
            }
        }
        return null;
    }

    private static IRemoteFileSubSystem getLocalFileSubSystem() {
        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
        IHost[] connections = registry.getHosts();
        int i = 0;
        while (i < connections.length) {
            IHost connection = connections[i];
            IRemoteFileSubSystem anFS = RemoteFileUtility.getFileSubSystem((IHost)connection);
            if (anFS.getHost().getSystemType().isLocal()) {
                return anFS;
            }
            ++i;
        }
        return null;
    }

    public static Object uploadResourceFromWorkspace(IResource srcFileOrFolder, IRemoteFile targetFolder, IProgressMonitor monitor) {
        return UniversalFileTransferUtility.uploadResourceFromWorkspace(srcFileOrFolder, targetFolder, monitor, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SystemRemoteResourceSet uploadResourcesFromWorkspace(SystemWorkspaceResourceSet workspaceSet, IRemoteFile targetFolder, IProgressMonitor monitor, boolean checkForCollisions) {
        IRemoteFileSubSystem targetFS = targetFolder.getParentRemoteFileSubSystem();
        boolean doSuperTransferPreference = UniversalFileTransferUtility.doSuperTransfer(targetFS);
        SystemRemoteResourceSet resultSet = new SystemRemoteResourceSet((ISubSystem)targetFS);
        if (targetFolder.isStale()) {
            try {
                targetFolder = targetFS.getRemoteFileObject(targetFolder.getAbsolutePath(), monitor);
            }
            catch (Exception exception) {}
        }
        if (!targetFolder.canWrite()) {
            String msgTxt = FileResources.FILEMSG_SECURITY_ERROR;
            String msgDetails = NLS.bind((String)FileResources.FILEMSG_SECURITY_ERROR_DETAILS, (Object)targetFS.getHostAliasName());
            SimpleSystemMessage errorMsg = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEF1001", 4, msgTxt, msgDetails);
            resultSet.setMessage((SystemMessage)errorMsg);
            return resultSet;
        }
        if (!targetFS.isConnected()) {
            return null;
        }
        boolean isTargetArchive = targetFolder.isArchive();
        boolean isTargetVirtual = ArchiveHandlerManager.isVirtual((String)targetFolder.getAbsolutePath());
        if (isTargetArchive && !targetFolder.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemConfiguration().supportsArchiveManagement()) {
            return null;
        }
        StringBuffer newPathBuf = new StringBuffer(targetFolder.getAbsolutePath());
        if (isTargetArchive) {
            newPathBuf.append("#virtual#/");
        } else if (isTargetVirtual) {
            newPathBuf.append("/");
        } else {
            int newPathBufLenth = newPathBuf.length();
            if (newPathBufLenth > 0 && newPathBuf.charAt(newPathBufLenth - 1) != targetFolder.getSeparatorChar()) {
                newPathBuf.append(targetFolder.getSeparatorChar());
            }
        }
        List resources = workspaceSet.getResourceSet();
        ArrayList<String> newFilePathList = new ArrayList<String>();
        int n = 0;
        while (n < resources.size()) {
            IResource srcFileOrFolder = (IResource)resources.get(n);
            newFilePathList.add(String.valueOf(newPathBuf.toString()) + srcFileOrFolder.getName());
            ++n;
        }
        SystemRemoteResourceSet existingFiles = null;
        try {
            String[] folderAndFilePaths = newFilePathList.toArray(new String[newFilePathList.size()]);
            Object[] results = targetFS.getRemoteFileObjects(folderAndFilePaths, monitor);
            existingFiles = new SystemRemoteResourceSet((ISubSystem)targetFS, results);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        newFilePathList.clear();
        ArrayList<IResource> copyFilesOrFolders = new ArrayList<IResource>();
        ArrayList<Object> existingFilesOrFolders = new ArrayList<Object>();
        int i = 0;
        while (i < resources.size() && !resultSet.hasMessage()) {
            String oldPath;
            if (monitor != null && monitor.isCanceled()) {
                try {
                    Object[] results = targetFS.getRemoteFileObjects(newFilePathList.toArray(new String[newFilePathList.size()]), monitor);
                    resultSet = new SystemRemoteResourceSet((ISubSystem)targetFS, results);
                    if (!workspaceSet.hasMessage()) return resultSet;
                    resultSet.setMessage(workspaceSet.getMessage());
                    return resultSet;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return resultSet;
            }
            IResource srcFileOrFolder = (IResource)resources.get(i);
            String name = srcFileOrFolder.getName();
            if (srcFileOrFolder instanceof IFile) {
                oldPath = String.valueOf(newPathBuf.toString()) + name;
                if (checkForCollisions && existingFiles != null && UniversalFileTransferUtility.checkForCollision(existingFiles, targetFolder, oldPath)) {
                    existingFilesOrFolders.add(existingFiles.get(oldPath));
                }
                copyFilesOrFolders.add(srcFileOrFolder);
            } else if (srcFileOrFolder instanceof IContainer) {
                oldPath = String.valueOf(newPathBuf.toString()) + name;
                if (checkForCollisions && existingFiles != null && UniversalFileTransferUtility.checkForCollision(existingFiles, targetFolder, oldPath)) {
                    existingFilesOrFolders.add(existingFiles.get(oldPath));
                }
                copyFilesOrFolders.add(srcFileOrFolder);
            }
            ++i;
        }
        boolean overwrite = false;
        if (existingFilesOrFolders.size() > 0) {
            CopyRunnable cr = new CopyRunnable(existingFilesOrFolders);
            Display.getDefault().syncExec((Runnable)cr);
            overwrite = cr.getOk();
        }
        if (existingFilesOrFolders.size() == 0 || overwrite) {
            int i2 = 0;
            while (i2 < copyFilesOrFolders.size() && !resultSet.hasMessage()) {
                IResource srcFileOrFolder = (IResource)copyFilesOrFolders.get(i2);
                String name = srcFileOrFolder.getName();
                String newPath = String.valueOf(newPathBuf.toString()) + name;
                if (srcFileOrFolder instanceof IFile) {
                    try {
                        String srcCharSet = null;
                        try {
                            srcCharSet = ((IFile)srcFileOrFolder).getCharset(false);
                            if (srcCharSet == null || srcCharSet.length() == 0) {
                                srcCharSet = srcFileOrFolder.getWorkspace().getRoot().getDefaultCharset();
                            }
                        }
                        catch (CoreException coreException) {
                            srcCharSet = SystemEncodingUtil.ENCODING_UTF_8;
                        }
                        String srcFileLocation = srcFileOrFolder.getLocation().toOSString();
                        String remoteEncoding = targetFolder.getEncoding();
                        targetFS.getRemoteEncoding();
                        targetFS.upload(srcFileLocation, srcCharSet, newPath, remoteEncoding, monitor);
                        newFilePathList.add(newPath);
                        if (RSEUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.rse.subsystems.files.core.preferences.preservetimestamps")) {
                            SystemIFileProperties properties = new SystemIFileProperties(srcFileOrFolder);
                            try {
                                IRemoteFile newFile = targetFS.getRemoteFileObject(newPath, monitor);
                                targetFS.setLastModified(newFile, properties.getRemoteFileTimeStamp(), monitor);
                            }
                            catch (SystemUnsupportedOperationException e) {
                                SystemBasePlugin.logError((String)"Unable to set last modified", (Throwable)e);
                            }
                        }
                    }
                    catch (RemoteFileIOException e) {
                        resultSet.setMessage(e.getSystemMessage());
                    }
                    catch (SystemMessageException e) {
                        resultSet.setMessage(e.getSystemMessage());
                    }
                    if (resultSet.hasMessage()) {
                        return resultSet;
                    }
                }
                if (srcFileOrFolder instanceof IContainer) {
                    IContainer directory = (IContainer)srcFileOrFolder;
                    if (!directory.exists()) {
                        try {
                            directory.refreshLocal(1, monitor);
                        }
                        catch (Exception exception) {}
                    }
                    try {
                        if (existingFiles != null) {
                            boolean destInArchive;
                            IRemoteFile newTargetFolder = (IRemoteFile)existingFiles.get(newPath);
                            if (newTargetFolder == null) {
                                newTargetFolder = targetFS.getRemoteFileObject(newPath, monitor);
                            }
                            if (newTargetFolder != null && !newTargetFolder.exists()) {
                                newTargetFolder = targetFS.createFolder(newTargetFolder, monitor);
                            }
                            boolean isTargetLocal = newTargetFolder.getParentRemoteFileSubSystem().getHost().getSystemType().isLocal();
                            boolean bl = destInArchive = newTargetFolder instanceof IVirtualRemoteFile || newTargetFolder.isArchive();
                            if (doSuperTransferPreference && !destInArchive && !isTargetLocal) {
                                UniversalFileTransferUtility.compressedUploadFromWorkspace(directory, newTargetFolder, monitor);
                            } else {
                                directory.refreshLocal(1, monitor);
                                IResource[] children = directory.members();
                                SystemWorkspaceResourceSet childSet = new SystemWorkspaceResourceSet(children);
                                SystemRemoteResourceSet childResults = UniversalFileTransferUtility.uploadResourcesFromWorkspace(childSet, newTargetFolder, monitor, false);
                                if (childResults == null) {
                                    return null;
                                }
                                if (childResults.hasMessage()) {
                                    resultSet.setMessage(childResults.getMessage());
                                }
                            }
                            newFilePathList.add(newPath);
                        }
                    }
                    catch (SystemMessageException e) {
                        workspaceSet.setMessage(e.getSystemMessage());
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++i2;
            }
        }
        try {
            Object[] results = targetFS.getRemoteFileObjects(newFilePathList.toArray(new String[newFilePathList.size()]), monitor);
            resultSet = new SystemRemoteResourceSet((ISubSystem)targetFS, results);
            if (!workspaceSet.hasMessage()) return resultSet;
            resultSet.setMessage(workspaceSet.getMessage());
            return resultSet;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object uploadResourceFromWorkspace(IResource srcFileOrFolder, IRemoteFile targetFolder, IProgressMonitor monitor, boolean checkForCollisions) {
        String name;
        IRemoteFileSubSystem targetFS;
        Object result;
        block40: {
            result = null;
            targetFS = targetFolder.getParentRemoteFileSubSystem();
            if (targetFolder.isStale()) {
                try {
                    targetFolder = targetFS.getRemoteFileObject(targetFolder.getAbsolutePath(), monitor);
                }
                catch (Exception exception) {}
            }
            if (!targetFolder.canWrite()) {
                String msgTxt = FileResources.FILEMSG_SECURITY_ERROR;
                String msgDetails = NLS.bind((String)FileResources.FILEMSG_SECURITY_ERROR_DETAILS, (Object)targetFS.getHostAliasName());
                return new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEF1001", 4, msgTxt, msgDetails);
            }
            if (!targetFS.isConnected()) {
                return null;
            }
            name = srcFileOrFolder.getName();
            if (!(srcFileOrFolder instanceof IFile)) break block40;
            if (checkForCollisions && (name = UniversalFileTransferUtility.checkForCollision(targetFolder, name)) == null) {
                return null;
            }
            boolean isTargetArchive = targetFolder.isArchive();
            if (isTargetArchive && !targetFolder.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemConfiguration().supportsArchiveManagement()) {
                return null;
            }
            StringBuffer newPathBuf = new StringBuffer(targetFolder.getAbsolutePath());
            if (isTargetArchive) {
                newPathBuf.append("#virtual#/");
            } else {
                newPathBuf.append(targetFolder.getSeparatorChar());
            }
            newPathBuf.append(name);
            String newPath = newPathBuf.toString();
            try {
                IRemoteFile copiedFile;
                block39: {
                    IPath location;
                    String srcCharSet;
                    block41: {
                        srcCharSet = null;
                        boolean isText = RemoteFileUtility.getSystemFileTransferModeRegistry().isText(newPath);
                        if (isText) {
                            try {
                                srcCharSet = ((IFile)srcFileOrFolder).getCharset(false);
                                if (srcCharSet == null || srcCharSet.length() == 0) {
                                    srcCharSet = srcFileOrFolder.getWorkspace().getRoot().getDefaultCharset();
                                }
                            }
                            catch (CoreException coreException) {
                                srcCharSet = SystemEncodingUtil.ENCODING_UTF_8;
                            }
                        }
                        location = srcFileOrFolder.getLocation();
                        copiedFile = null;
                        if (location != null) break block41;
                        if (srcFileOrFolder instanceof IFile) {
                            try {
                                InputStream inStream = ((IFile)srcFileOrFolder).getContents();
                                if (targetFS instanceof FileServiceSubSystem) {
                                    IFileService fileService = ((FileServiceSubSystem)targetFS).getFileService();
                                    String remoteEncoding = targetFolder.getEncoding();
                                    fileService.upload(inStream, targetFolder.getAbsolutePath(), name, !isText, remoteEncoding, monitor);
                                }
                                break block39;
                            }
                            catch (Exception exception) {}
                        }
                        break block39;
                    }
                    String srcFileLocation = location.toOSString();
                    String remoteEncoding = targetFolder.getEncoding();
                    targetFS.upload(srcFileLocation, srcCharSet, newPath, remoteEncoding, monitor);
                }
                copiedFile = targetFS.getRemoteFileObject(targetFolder, name, monitor);
                if (!RSEUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.rse.subsystems.files.core.preferences.preservetimestamps")) return copiedFile;
                SystemIFileProperties properties = new SystemIFileProperties(srcFileOrFolder);
                long timestamp = properties.getRemoteFileTimeStamp();
                if (timestamp == 0L) {
                    timestamp = srcFileOrFolder.getLocalTimeStamp();
                }
                try {
                    targetFS.setLastModified(copiedFile, timestamp, monitor);
                    return copiedFile;
                }
                catch (SystemUnsupportedOperationException e) {
                    SystemBasePlugin.logError((String)"Unable to set last modified", (Throwable)e);
                }
                return copiedFile;
            }
            catch (RemoteFileIOException e) {
                SystemMessageDialog.displayMessage((SystemMessageException)((Object)e));
                return e.getSystemMessage();
            }
            catch (SystemMessageException e) {
                SystemMessageDialog.displayMessage((SystemMessageException)e);
                return e.getSystemMessage();
            }
        }
        if (!(srcFileOrFolder instanceof IContainer)) return result;
        if (checkForCollisions && (name = UniversalFileTransferUtility.checkForCollision(targetFolder, name)) == null) {
            return null;
        }
        boolean isTargetArchive = targetFolder.isArchive();
        StringBuffer newPathBuf = new StringBuffer(targetFolder.getAbsolutePath());
        if (isTargetArchive) {
            newPathBuf.append("#virtual#/");
        } else {
            newPathBuf.append(targetFolder.getSeparatorChar());
        }
        newPathBuf.append(name);
        String newPath = newPathBuf.toString();
        IContainer directory = (IContainer)srcFileOrFolder;
        try {
            IRemoteFile newTargetFolder = targetFS.getRemoteFileObject(newPath, monitor);
            if (!newTargetFolder.exists()) {
                targetFS.createFolder(newTargetFolder, monitor);
                newTargetFolder.markStale(true);
                newTargetFolder = targetFS.getRemoteFileObject(newPath, monitor);
            }
            if (!directory.isSynchronized(1)) {
                try {
                    directory.refreshLocal(1, monitor);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            boolean isTargetLocal = newTargetFolder.getParentRemoteFileSubSystem().getHost().getSystemType().isLocal();
            boolean destInArchive = newTargetFolder instanceof IVirtualRemoteFile || newTargetFolder.isArchive();
            boolean doSuperTransferPreference = UniversalFileTransferUtility.doSuperTransfer(targetFS);
            if (doSuperTransferPreference && !destInArchive && !isTargetLocal) {
                UniversalFileTransferUtility.compressedUploadFromWorkspace(directory, newTargetFolder, monitor);
                return newTargetFolder;
            }
            IResource[] children = directory.members();
            int i = 0;
            while (true) {
                if (i >= children.length) {
                    return newTargetFolder;
                }
                if (monitor.isCanceled()) {
                    return null;
                }
                IResource child = children[i];
                if (UniversalFileTransferUtility.uploadResourceFromWorkspace(child, newTargetFolder, monitor, false) == null) {
                    return null;
                }
                ++i;
            }
        }
        catch (SystemMessageException e) {
            SystemMessageDialog.displayMessage((SystemMessageException)e);
            return null;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static void compressedUploadFromWorkspace(IContainer directory, IRemoteFile newTargetFolder, IProgressMonitor monitor) throws Exception {
        block21: {
            if (!newTargetFolder.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemConfiguration().supportsArchiveManagement()) {
                return;
            }
            if (ArchiveHandlerManager.isVirtual((String)newTargetFolder.getAbsolutePath())) {
                return;
            }
            destinationArchive = null;
            newPath = null;
            targetFS = null;
            remoteArchive = null;
            monitor.beginTask(FileResources.RESID_SUPERTRANSFER_PROGMON_MAIN, -1);
            monitor.subTask(FileResources.RESID_SUPERTRANSFER_PROGMON_SUBTASK_CREATE);
            destinationArchive = UniversalFileTransferUtility.getLocalFileSubSystem().getRemoteFileObject(File.createTempFile("supertransfer", UniversalFileTransferUtility.getArchiveExtensionFromProperties()).getAbsolutePath(), monitor);
            localSS = (FileServiceSubSystem)UniversalFileTransferUtility.getLocalFileSubSystem();
            try {
                localSS.delete(destinationArchive, monitor);
            }
            catch (Exception v0) {}
            localSS.createFile(destinationArchive, monitor);
            if (destinationArchive != null) break block21;
            while (true) {
                if (newPath == null) {
                    UniversalFileTransferUtility.cleanup(destinationArchive, null);
                } else {
                    UniversalFileTransferUtility.cleanup(destinationArchive, new File(newPath));
                }
                if (remoteArchive != null && remoteArchive.exists()) {
                    targetFS.delete(remoteArchive, null);
                }
                monitor.done();
                return;
            }
        }
        try {
            try {
                if (!destinationArchive.isArchive()) ** continue;
                newTargetParent = newTargetFolder.getParentRemoteFile();
                monitor.subTask(FileResources.RESID_SUPERTRANSFER_PROGMON_SUBTASK_POPULATE);
                sourceDir = localSS.getRemoteFileObject(directory.getLocation().toOSString(), monitor);
                targetFS = newTargetFolder.getParentRemoteFileSubSystem();
                localSS.copy(sourceDir, destinationArchive, sourceDir.getName(), monitor);
                monitor.subTask(FileResources.RESID_SUPERTRANSFER_PROGMON_SUBTASK_TRANSFER);
                newPath = String.valueOf(newTargetParent.getAbsolutePath()) + targetFS.getSeparator() + destinationArchive.getName();
                targetFS.upload(destinationArchive.getAbsolutePath(), SystemEncodingUtil.ENCODING_UTF_8, newPath, System.getProperty("file.encoding"), monitor);
                remoteArchive = targetFS.getRemoteFileObject(newPath, monitor);
                monitor.subTask(FileResources.RESID_SUPERTRANSFER_PROGMON_SUBTASK_EXTRACT);
                compressedFolderPath = String.valueOf(newPath) + "#virtual#/" + directory.getName();
                compressedFolder = targetFS.getRemoteFileObject(compressedFolderPath, monitor);
                targetFS.copy(compressedFolder, newTargetParent, newTargetFolder.getName(), monitor);
            }
            catch (SystemMessageException e) {
                if (monitor.isCanceled() && newTargetFolder.exists()) {
                    targetFS.delete(newTargetFolder, null);
                }
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        catch (Throwable var12_14) {
            if (newPath == null) {
                UniversalFileTransferUtility.cleanup(destinationArchive, null);
            } else {
                UniversalFileTransferUtility.cleanup(destinationArchive, new File(newPath));
            }
            if (remoteArchive != null && remoteArchive.exists()) {
                targetFS.delete(remoteArchive, null);
            }
            monitor.done();
            throw var12_14;
        }
        if (newPath == null) {
            UniversalFileTransferUtility.cleanup(destinationArchive, null);
        } else {
            UniversalFileTransferUtility.cleanup(destinationArchive, new File(newPath));
        }
        if (remoteArchive != null && remoteArchive.exists()) {
            targetFS.delete(remoteArchive, null);
        }
        monitor.done();
    }

    protected static void setReadOnly(IFile file, boolean flag) {
        ResourceAttributes attrs = file.getResourceAttributes();
        attrs.setReadOnly(flag);
        try {
            file.setResourceAttributes(attrs);
        }
        catch (CoreException coreException) {}
    }

    public static void transferProperties(IResource source, IRemoteFile target, IProgressMonitor monitor) throws CoreException, RemoteFileSecurityException, RemoteFileIOException, SystemMessageException {
        if (monitor.isCanceled()) {
            return;
        }
        if (source instanceof IFile) {
            SystemIFileProperties properties = new SystemIFileProperties(source);
            try {
                target.getParentRemoteFileSubSystem().setLastModified(target, properties.getRemoteFileTimeStamp(), monitor);
            }
            catch (SystemUnsupportedOperationException e) {
                SystemBasePlugin.logError((String)"Unable to set last modified", (Throwable)e);
            }
        } else if (source instanceof IContainer) {
            source.refreshLocal(1, null);
            IResource[] children = ((IContainer)source).members();
            int i = 0;
            while (i < children.length) {
                if (monitor.isCanceled()) {
                    return;
                }
                IResource child = children[i];
                IRemoteFile newtarget = target.getParentRemoteFileSubSystem().getRemoteFileObject(target, child.getName(), monitor);
                if (!newtarget.exists()) {
                    return;
                }
                UniversalFileTransferUtility.transferProperties(child, newtarget, monitor);
                ++i;
            }
        }
    }

    protected static String getArchiveExtensionFromProperties() {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        String archiveType = store.getString("org.eclipse.rse.subsystems.files.core.preferences.supertransfer.archivetype");
        archiveType = archiveType == null || !ArchiveHandlerManager.getInstance().isRegisteredArchive("test." + archiveType) ? ".zip" : "." + archiveType;
        return archiveType;
    }

    public static IResource compressedDownloadToWorkspace(IRemoteFile directory, IProgressMonitor monitor) throws Exception {
        FileServiceSubSystem localSS;
        IResource targetResource;
        File dest;
        IRemoteFile cpdest;
        IRemoteFile destinationArchive;
        block29: {
            block28: {
                if (!directory.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemConfiguration().supportsArchiveManagement()) {
                    return null;
                }
                destinationArchive = null;
                cpdest = null;
                dest = null;
                targetResource = null;
                localSS = (FileServiceSubSystem)UniversalFileTransferUtility.getLocalFileSubSystem();
                monitor.beginTask(FileResources.RESID_SUPERTRANSFER_PROGMON_MAIN, -1);
                monitor.subTask(FileResources.RESID_SUPERTRANSFER_PROGMON_SUBTASK_CREATE);
                File file = File.createTempFile("supertransfer", UniversalFileTransferUtility.getArchiveExtensionFromProperties());
                file.delete();
                String separator = "";
                IRemoteFile destinationParent = directory.getParentRemoteFile();
                if (!destinationParent.getAbsolutePath().endsWith(directory.getSeparator())) {
                    separator = directory.getSeparator();
                }
                if (destinationParent.canWrite()) {
                    try {
                        String destArchPath = String.valueOf(destinationParent.getAbsolutePath()) + separator + file.getName();
                        destinationArchive = directory.getParentRemoteFileSubSystem().getRemoteFileObject(destArchPath, monitor);
                        if (destinationArchive.exists()) {
                            directory.getParentRemoteFileSubSystem().delete(destinationArchive, monitor);
                        }
                        directory.getParentRemoteFileSubSystem().createFile(destinationArchive, monitor);
                    }
                    catch (RemoteFileSecurityException remoteFileSecurityException) {}
                }
                if (destinationArchive == null) {
                    String homeFolder = directory.getParentRemoteFileSubSystem().getRemoteFileObject("./", monitor).getAbsolutePath();
                    String destArchPath = String.valueOf(homeFolder) + separator + file.getName();
                    destinationArchive = directory.getParentRemoteFileSubSystem().getRemoteFileObject(destArchPath, monitor);
                    if (destinationArchive.exists()) {
                        directory.getParentRemoteFileSubSystem().delete(destinationArchive, monitor);
                    }
                    destinationArchive = directory.getParentRemoteFileSubSystem().createFile(destinationArchive, monitor);
                }
                targetResource = UniversalFileTransferUtility.getTempFileFor(directory);
                if (destinationArchive != null) break block28;
                return null;
            }
            if (destinationArchive.isArchive()) break block29;
            return null;
        }
        try {
            IRemoteFileSubSystem sourceFS;
            block30: {
                monitor.subTask(FileResources.RESID_SUPERTRANSFER_PROGMON_SUBTASK_POPULATE);
                sourceFS = directory.getParentRemoteFileSubSystem();
                IRemoteFile sourceDir = sourceFS.getRemoteFileObject(directory.getAbsolutePath(), monitor);
                try {
                    sourceFS.copy(sourceDir, destinationArchive, sourceDir.getName(), monitor);
                }
                catch (SystemMessageException systemMessageException) {
                    if (!monitor.isCanceled()) break block30;
                    UniversalFileTransferUtility.cleanup(destinationArchive, null);
                    return targetResource;
                }
            }
            destinationArchive.markStale(true);
            cpdest = destinationArchive = destinationArchive.getParentRemoteFileSubSystem().getRemoteFileObject(destinationArchive.getAbsolutePath(), monitor);
            monitor.subTask(FileResources.RESID_SUPERTRANSFER_PROGMON_SUBTASK_TRANSFER);
            String name = destinationArchive.getName();
            dest = new File(String.valueOf(targetResource.getParent().getLocation().toOSString()) + File.separator + name);
            sourceFS.download(cpdest, dest.getAbsolutePath(), System.getProperty("file.encoding"), monitor);
            ISystemArchiveHandler handler = ArchiveHandlerManager.getInstance().getRegisteredHandler(dest);
            VirtualChild[] arcContents = handler.getVirtualChildrenList(null);
            monitor.beginTask(FileResources.RESID_SUPERTRANSFER_PROGMON_SUBTASK_EXTRACT, arcContents.length);
            int i = 0;
            while (i < arcContents.length) {
                if (!arcContents[i].isDirectory || handler.getVirtualChildren(arcContents[i].fullName, null) != null) {
                    String currentTargetPath = String.valueOf(targetResource.getParent().getLocation().toOSString()) + localSS.getSeparator() + UniversalFileTransferUtility.useLocalSeparator(arcContents[i].fullName);
                    IRemoteFile currentTarget = localSS.getRemoteFileObject(currentTargetPath, monitor);
                    boolean replace = false;
                    if (currentTarget != null && currentTarget.exists()) {
                        IContainer currentTargetResource = SystemBasePlugin.getWorkspaceRoot().getContainerForLocation((IPath)new Path(currentTarget.getAbsolutePath()));
                        SystemIFileProperties properties = new SystemIFileProperties((IResource)currentTargetResource);
                        if (properties.getRemoteFileTimeStamp() != arcContents[i].getTimeStamp()) {
                            replace = true;
                        }
                    } else {
                        replace = true;
                    }
                    if (replace && !monitor.isCanceled()) {
                        IRemoteFile[] children;
                        String currentSourcePath = String.valueOf(dest.getAbsolutePath()) + "#virtual#/" + arcContents[i].fullName;
                        IRemoteFile currentSource = localSS.getRemoteFileObject(currentSourcePath, monitor);
                        boolean shouldExtract = currentSource.isFile();
                        if (!(shouldExtract || (children = localSS.list(currentSource, monitor)) != null && children.length != 0)) {
                            shouldExtract = true;
                        }
                        if (shouldExtract) {
                            String msgTxt = NLS.bind((String)FileResources.MSG_EXTRACT_PROGRESS, (Object)currentSource.getName());
                            monitor.subTask(msgTxt);
                            boolean canWrite = true;
                            if (currentTarget != null) {
                                IContainer currentTargetResource = SystemBasePlugin.getWorkspaceRoot().getContainerForLocation((IPath)new Path(currentTarget.getAbsolutePath()));
                                if (currentTargetResource != null && currentTargetResource.exists()) {
                                    try {
                                        currentTargetResource.delete(false, monitor);
                                    }
                                    catch (Exception exception) {
                                        canWrite = false;
                                    }
                                }
                                if (canWrite) {
                                    localSS.copy(currentSource, currentTarget.getParentRemoteFile(), currentSource.getName(), monitor);
                                    SystemIFileProperties properties = new SystemIFileProperties((IResource)currentTargetResource);
                                    properties.setRemoteFileTimeStamp(arcContents[i].getTimeStamp());
                                    monitor.worked(1);
                                }
                            }
                        }
                    }
                }
                ++i;
            }
        }
        catch (SystemMessageException e) {
            SystemMessageDialog.displayMessage((SystemMessageException)e);
            UniversalFileTransferUtility.cleanup(cpdest, dest);
        }
        catch (Exception e) {
            e.printStackTrace();
            UniversalFileTransferUtility.cleanup(cpdest, dest);
            throw e;
        }
        UniversalFileTransferUtility.cleanup(cpdest, dest);
        monitor.done();
        return targetResource;
    }

    protected static void cleanup(IRemoteFile arc1, File arc2) throws RemoteFileIOException, RemoteFileSecurityException, RemoteFolderNotEmptyException {
        if (arc1 != null) {
            try {
                arc1.getParentRemoteFileSubSystem().delete(arc1, null);
            }
            catch (SystemMessageException e) {
                SystemMessageDialog.displayMessage((SystemMessageException)e);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (arc2 != null && arc2.exists()) {
            arc2.delete();
        }
    }

    protected static String useLocalSeparator(String virtualPath) {
        return virtualPath.replace('/', UniversalFileTransferUtility.getLocalFileSubSystem().getSeparatorChar());
    }

    public static IResource getTempFileFor(IRemoteFile srcFileOrFolder) {
        Path remote;
        int colonIndex;
        SystemRemoteEditManager editMgr = SystemRemoteEditManager.getInstance();
        if (!editMgr.doesRemoteEditProjectExist()) {
            editMgr.getRemoteEditProject();
        }
        char separator = '/';
        StringBuffer path = new StringBuffer(editMgr.getRemoteEditProjectLocation().makeAbsolute().toOSString());
        String actualHost = UniversalFileTransferUtility.getActualHostFor(srcFileOrFolder.getParentRemoteFileSubSystem(), srcFileOrFolder.getAbsolutePath());
        path = path.append(String.valueOf(separator) + actualHost + separator);
        String absolutePath = srcFileOrFolder.getAbsolutePath();
        if (srcFileOrFolder.getHost().getSystemType().isLocal()) {
            absolutePath = editMgr.getWorkspacePathFor(actualHost, srcFileOrFolder.getAbsolutePath(), srcFileOrFolder.getParentRemoteFileSubSystem());
        }
        if ((colonIndex = (absolutePath = SystemFileNameHelper.getEscapedPath((remote = new Path(absolutePath)).toOSString())).indexOf(58)) != -1) {
            absolutePath = colonIndex == 0 ? absolutePath.substring(1) : (colonIndex == absolutePath.length() - 1 ? absolutePath.substring(0, colonIndex) : String.valueOf(absolutePath.substring(0, colonIndex).toLowerCase()) + absolutePath.substring(colonIndex + 1));
        }
        path = path.append(absolutePath);
        String pathstr = UniversalFileTransferUtility.normalizePath(path.toString(), srcFileOrFolder.getParentRemoteFileSubSystem().getSeparatorChar());
        IPath workspacePath = UniversalFileTransferUtility.getLocalPathObject(pathstr);
        Object result = null;
        result = srcFileOrFolder.isDirectory() ? SystemBasePlugin.getWorkspaceRoot().getContainerForLocation(workspacePath) : SystemBasePlugin.getWorkspaceRoot().getFileForLocation(workspacePath);
        return result;
    }

    protected static String normalizePath(String localpath, char rmtSeparator) {
        char localSeparator = File.separatorChar;
        if (localSeparator != rmtSeparator) {
            return localpath.replace(rmtSeparator, localSeparator);
        }
        return localpath;
    }

    public static IResource getTempFileFor(File srcFileOrFolder) {
        SystemRemoteEditManager editMgr = SystemRemoteEditManager.getInstance();
        if (!editMgr.doesRemoteEditProjectExist()) {
            editMgr.getRemoteEditProject();
        }
        char separator = '/';
        StringBuffer path = new StringBuffer(editMgr.getRemoteEditProjectLocation().makeAbsolute().toOSString());
        String actualHost = "LOCALHOST";
        path = path.append(String.valueOf(separator) + actualHost + separator);
        String absolutePath = editMgr.getWorkspacePathFor(actualHost, srcFileOrFolder.getAbsolutePath(), null);
        int colonIndex = absolutePath.indexOf(58);
        if (colonIndex != -1) {
            absolutePath = colonIndex == 0 ? absolutePath.substring(1) : (colonIndex == absolutePath.length() - 1 ? absolutePath.substring(0, colonIndex) : String.valueOf(absolutePath.substring(0, colonIndex).toLowerCase()) + absolutePath.substring(colonIndex + 1));
        }
        path = path.append(absolutePath);
        IPath workspacePath = UniversalFileTransferUtility.getLocalPathObject(path.toString());
        Object result = null;
        result = srcFileOrFolder.isDirectory() ? SystemBasePlugin.getWorkspaceRoot().getContainerForLocation(workspacePath) : SystemBasePlugin.getWorkspaceRoot().getFileForLocation(workspacePath);
        return result;
    }

    private static IPath getLocalPathObject(String localPath) {
        IPath actualPath = null;
        Path expectedPath = new Path(localPath);
        Path rootPath = new Path(_rootPath);
        IContainer container = SystemBasePlugin.getWorkspaceRoot().getContainerForLocation((IPath)rootPath);
        if (container != null && container.exists()) {
            IResource lastMatch = null;
            int i = rootPath.segmentCount();
            while (i < expectedPath.segmentCount() - 1) {
                String expectedFolder = expectedPath.segment(i).toLowerCase();
                IResource match = null;
                try {
                    IResource[] resources = container.members();
                    int r = 0;
                    while (r < resources.length && match == null) {
                        String resName;
                        IResource resource = resources[r];
                        if (resource instanceof IContainer && expectedFolder.equals(resName = resource.getName().toLowerCase())) {
                            lastMatch = match = resource;
                        }
                        ++r;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (match == null) {
                    if (lastMatch != null) {
                        IPath newPath = lastMatch.getLocation();
                        while (i < expectedPath.segmentCount()) {
                            newPath = newPath.append(expectedPath.segment(i));
                            ++i;
                        }
                        return newPath;
                    }
                    return expectedPath;
                }
                container = (IContainer)match;
                ++i;
            }
            String fileName = expectedPath.segment(expectedPath.segmentCount() - 1);
            actualPath = container.getLocation().append(fileName);
            return actualPath;
        }
        return expectedPath;
    }

    public static String getActualHostFor(IRemoteFileSubSystem subsystem, String remotePath) {
        String hostname = subsystem.getHost().getHostName();
        if (subsystem.getHost().getSystemType().isLocal()) {
            String result = SystemRemoteEditManager.getInstance().getActualHostFor(hostname, remotePath, subsystem);
            return result;
        }
        return hostname;
    }

    public static String getActualHostFor(String hostname, String remotePath, IRemoteFileSubSystem subsystem) {
        return SystemRemoteEditManager.getInstance().getActualHostFor(hostname, remotePath, subsystem);
    }

    private static void refreshResourceInWorkspace(IResource parent) {
        if (!parent.exists()) {
            UniversalFileTransferUtility.refreshResourceInWorkspace((IResource)parent.getParent());
        } else {
            try {
                parent.refreshLocal(2, null);
            }
            catch (Exception exception) {}
        }
    }

    protected static boolean isRemoteFileMounted(ISubSystem subsystem, String remotePath) {
        String result;
        String hostname = subsystem.getHost().getHostName();
        return subsystem.getHost().getSystemType().isLocal() && !(result = SystemRemoteEditManager.getInstance().getActualHostFor(hostname, remotePath, (IRemoteFileSubSystem)subsystem)).equals(hostname);
    }

    protected static boolean isRemoteFileMounted(String hostname, String remotePath, IRemoteFileSubSystem subsystem) {
        String result = SystemRemoteEditManager.getInstance().getActualHostFor(hostname, remotePath, subsystem);
        return !result.equals(hostname);
    }

    protected static String getWorkspaceRemotePath(IRemoteFileSubSystem subsystem, String remotePath) {
        if (subsystem != null) {
            return SystemRemoteEditManager.getInstance().getWorkspacePathFor(subsystem.getHost().getHostName(), remotePath, subsystem);
        }
        return remotePath;
    }

    protected static String getWorkspaceRemotePath(String hostname, String remotePath, IRemoteFileSubSystem subsystem) {
        return SystemRemoteEditManager.getInstance().getWorkspacePathFor(hostname, remotePath, subsystem);
    }

    protected static RenameStatus checkForCollision(SystemRemoteResourceSet existingFiles, IRemoteFile targetFolder, String oldName, String oldPath) {
        return UniversalFileTransferUtility.checkForCollision(existingFiles, targetFolder, oldName, oldPath, null);
    }

    protected static RenameStatus checkForCollision(SystemRemoteResourceSet existingFiles, IRemoteFile targetFolder, String oldName, String oldPath, List NamesInUse) {
        String newName = oldName;
        IRemoteFile targetFileOrFolder = (IRemoteFile)existingFiles.get(oldPath);
        RenameStatus status = new RenameStatus(0, Activator.getDefault().getBundle().getSymbolicName(), 0, newName, null);
        if (targetFileOrFolder != null && targetFileOrFolder.exists()) {
            RenameRunnable rr = new RenameRunnable(targetFileOrFolder, NamesInUse);
            Display.getDefault().syncExec((Runnable)rr);
            newName = rr.getNewName();
            if (newName == null) {
                int state = rr.getCancelStatus();
                if (state == RenameRunnable.RENAME_DIALOG_CANCELLED_ALL) {
                    status = new RenameStatus(8, Activator.getDefault().getBundle().getSymbolicName(), 16, "", null);
                } else if (state == RenameRunnable.RENAME_DIALOG_CANCELLED) {
                    status = new RenameStatus(8, Activator.getDefault().getBundle().getSymbolicName(), 8, "", null);
                }
            } else {
                status = new RenameStatus(0, Activator.getDefault().getBundle().getSymbolicName(), 0, newName, null);
            }
        }
        return status;
    }

    protected static boolean checkForCollision(SystemRemoteResourceSet existingFiles, IRemoteFile targetFolder, String oldPath) {
        IRemoteFile targetFileOrFolder = (IRemoteFile)existingFiles.get(oldPath);
        return targetFileOrFolder != null && targetFileOrFolder.exists();
    }

    protected static String checkForCollision(IRemoteFile targetFolder, String oldName) {
        final String[] newName = new String[]{oldName};
        try {
            IRemoteFileSubSystem ss = targetFolder.getParentRemoteFileSubSystem();
            final IRemoteFile targetFileOrFolder = ss.getRemoteFileObject(targetFolder, oldName, (IProgressMonitor)new NullProgressMonitor());
            if (targetFileOrFolder.exists()) {
                UniversalFileTransferUtility.runInDisplayThread(new Runnable(){

                    public void run() {
                        ISystemValidator validator = null;
                        SystemRenameSingleDialog dlg = new SystemRenameSingleDialog(SystemBasePlugin.getActiveWorkbenchShell(), true, (Object)targetFileOrFolder, validator);
                        dlg.open();
                        newName[0] = !dlg.wasCancelled() ? dlg.getNewName() : null;
                    }
                });
            }
        }
        catch (SystemMessageException e) {
            SystemBasePlugin.logError((String)"SystemCopyRemoteFileAction.checkForCollision()", (Throwable)e);
        }
        return newName[0];
    }

    private static void runInDisplayThread(Runnable runnable) {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if (Thread.currentThread() == display.getThread()) {
            runnable.run();
        } else {
            display.syncExec(runnable);
        }
    }

    protected static IFile copyRemoteFileToWorkspace(IRemoteFile srcFileOrFolder, IProgressMonitor monitor) {
        return UniversalFileTransferUtility.downloadFileToWorkspace(srcFileOrFolder, monitor);
    }

    public static SystemWorkspaceResourceSet copyRemoteResourcesToWorkspaceMultiple(SystemRemoteResourceSet remoteSet, IProgressMonitor monitor) {
        return UniversalFileTransferUtility.downloadResourcesToWorkspaceMultiple(remoteSet, monitor);
    }

    public static SystemWorkspaceResourceSet copyRemoteResourcesToWorkspace(SystemRemoteResourceSet remoteSet, IProgressMonitor monitor) {
        return UniversalFileTransferUtility.downloadResourcesToWorkspace(remoteSet, monitor);
    }

    public static Object copyRemoteResourceToWorkspace(File srcFileOrFolder, IProgressMonitor monitor) {
        return UniversalFileTransferUtility.downloadResourceToWorkspace(srcFileOrFolder, monitor);
    }

    protected static IFile copyRemoteFileToWorkspace(File srcFileOrFolder, IProgressMonitor monitor) {
        return UniversalFileTransferUtility.downloadFileToWorkspace(srcFileOrFolder, monitor);
    }

    public static Object copyRemoteResourceToWorkspace(IRemoteFile srcFileOrFolder, IProgressMonitor monitor) {
        return UniversalFileTransferUtility.downloadResourceToWorkspace(srcFileOrFolder, monitor);
    }

    public static Object copyWorkspaceResourceToRemote(IResource srcFileOrFolder, IRemoteFile targetFolder, IProgressMonitor monitor) {
        return UniversalFileTransferUtility.uploadResourceFromWorkspace(srcFileOrFolder, targetFolder, monitor);
    }

    public static SystemRemoteResourceSet copyWorkspaceResourcesToRemote(SystemWorkspaceResourceSet workspaceSet, IRemoteFile targetFolder, IProgressMonitor monitor, boolean checkForCollisions) {
        return UniversalFileTransferUtility.uploadResourcesFromWorkspace(workspaceSet, targetFolder, monitor, checkForCollisions);
    }

    public static Object copyWorkspaceResourceToRemote(IResource srcFileOrFolder, IRemoteFile targetFolder, IProgressMonitor monitor, boolean checkForCollisions) {
        return UniversalFileTransferUtility.uploadResourceFromWorkspace(srcFileOrFolder, targetFolder, monitor, checkForCollisions);
    }

    public static void compressedCopyWorkspaceResourceToRemote(IContainer directory, IRemoteFile newTargetFolder, IProgressMonitor monitor) throws Exception {
        UniversalFileTransferUtility.compressedUploadFromWorkspace(directory, newTargetFolder, monitor);
    }

    public static IResource compressedCopyRemoteResourceToWorkspace(IRemoteFile directory, IProgressMonitor monitor) throws Exception {
        return UniversalFileTransferUtility.compressedDownloadToWorkspace(directory, monitor);
    }

    public static class RenameRunnable
    implements Runnable {
        private IRemoteFile _targetFileOrFolder;
        private String _newName;
        private List _namesInUse = new ArrayList();
        private int cancelStatus;
        public static int RENAME_DIALOG_NOT_CANCELLED = -1;
        public static int RENAME_DIALOG_CANCELLED = 0;
        public static int RENAME_DIALOG_CANCELLED_ALL = 1;

        public RenameRunnable(IRemoteFile targetFileOrFolder) {
            this._targetFileOrFolder = targetFileOrFolder;
            this.cancelStatus = RENAME_DIALOG_NOT_CANCELLED;
        }

        public RenameRunnable(IRemoteFile targetFileOrFolder, List namesInUse) {
            this._targetFileOrFolder = targetFileOrFolder;
            this.cancelStatus = RENAME_DIALOG_NOT_CANCELLED;
            this._namesInUse = namesInUse;
        }

        public void run() {
            ISystemValidator validator = null;
            SystemRenameSingleDialog dlg = this._namesInUse != null && this._namesInUse.size() > 0 ? new SystemRenameSingleDialog(null, true, (Object)this._targetFileOrFolder, validator, this._namesInUse) : new SystemRenameSingleDialog(null, true, (Object)this._targetFileOrFolder, validator);
            dlg.setShowCancelAllButton(true);
            dlg.open();
            if (!dlg.wasCancelled() && !dlg.wasCancelledAll()) {
                this._newName = dlg.getNewName();
            } else {
                this._newName = null;
                this.cancelStatus = dlg.wasCancelledAll() ? RENAME_DIALOG_CANCELLED_ALL : RENAME_DIALOG_CANCELLED;
            }
        }

        public String getNewName() {
            return this._newName;
        }

        public int getCancelStatus() {
            return this.cancelStatus;
        }
    }

    public static class RenameStatus
    extends Status {
        private static final int CANCEL_ALL = 16;

        public RenameStatus(int severity, String pluginId, int code, String message, Throwable exception) {
            super(severity, pluginId, code, message, exception);
        }
    }
}

