/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.dstore.shells;

import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.rse.internal.services.dstore.shells.DStoreShellOutputReader;
import org.eclipse.rse.internal.services.dstore.shells.DStoreShellThread;
import org.eclipse.rse.services.dstore.util.DStoreStatusMonitor;
import org.eclipse.rse.services.shells.AbstractHostShell;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IHostShellOutputReader;

public class DStoreHostShell
extends AbstractHostShell
implements IHostShell {
    private DStoreShellThread _shellThread;
    private IHostShellOutputReader _stdoutHandler;
    private IHostShellOutputReader _stderrHandler;
    private DataElement _status;
    private DStoreStatusMonitor _statusMonitor;

    public DStoreHostShell(DStoreStatusMonitor statusMonitor, DataStore dataStore, String initialWorkingDirectory, String invocation, String encoding, String[] environment) {
        this._shellThread = new DStoreShellThread(dataStore, initialWorkingDirectory, invocation, encoding, environment);
        this._status = this._shellThread.getStatus();
        this._stdoutHandler = new DStoreShellOutputReader(this, this._status, false);
        this._stderrHandler = new DStoreShellOutputReader(this, this._status, true);
        this._statusMonitor = statusMonitor;
    }

    public boolean isActive() {
        return !this._statusMonitor.determineStatusDone(this._status);
    }

    public void writeToShell(String command) {
        this._shellThread.writeToShell(command);
    }

    public IHostShellOutputReader getStandardOutputReader() {
        return this._stdoutHandler;
    }

    public IHostShellOutputReader getStandardErrorReader() {
        return this._stderrHandler;
    }

    public DataElement getStatus() {
        return this._status;
    }

    public void exit() {
        DataElement cmdDescriptor;
        DataElement command = this._status.getParent();
        DataStore dataStore = command.getDataStore();
        DataElement cancelDescriptor = dataStore.localDescriptorQuery(cmdDescriptor = command.getDescriptor(), "C_CANCEL");
        if (cancelDescriptor != null) {
            dataStore.command(cancelDescriptor, command);
        } else {
            this.writeToShell("exit");
        }
        this._status.setAttribute(3, "done");
        this._stdoutHandler.finish();
        this._stderrHandler.finish();
    }
}

