/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.core.miners;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.model.Handler;
import org.eclipse.dstore.core.model.IExternalLoader;
import org.eclipse.dstore.core.model.ISchemaExtender;
import org.eclipse.dstore.core.server.SystemServiceManager;

public abstract class Miner
extends Handler
implements ISchemaExtender {
    public DataElement _minerElement;
    public DataElement _minerData;
    public DataElement _minerTransient;
    private boolean _initialized = false;
    private boolean _connected = false;
    private IExternalLoader _loader;
    protected String _name = null;
    protected String _value = null;
    protected ArrayList _dependencies;
    protected List _commandQueue = new ArrayList();
    protected ResourceBundle _resourceBundle = null;

    protected Miner() {
    }

    public final ArrayList getMinerDependencies() {
        if (this._dependencies == null) {
            this._dependencies = this.getDependencies();
        }
        return this._dependencies;
    }

    protected ArrayList getDependencies() {
        return new ArrayList();
    }

    public final boolean isInitialized() {
        return this._initialized;
    }

    public final boolean isConnected() {
        return this._connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        if (this._dataStore.getClient() != null) {
            this._dataStore.getClient().getLogger().logInfo(this.getClass().toString(), "Miner.finish()");
        }
        List list = this._commandQueue;
        synchronized (list) {
            this._commandQueue.clear();
        }
        DataElement root = this._dataStore.getMinerRoot();
        this._minerData.removeNestedData();
        this._minerElement.removeNestedData();
        if (root != null && root.getNestedData() != null) {
            root.getNestedData().remove(this._minerElement);
            root.setExpanded(false);
            root.setUpdated(false);
        }
        super.finish();
    }

    public ResourceBundle getResourceBundle() {
        return null;
    }

    protected void load() {
    }

    protected void load(DataElement status) {
        this.load();
    }

    protected void updateMinerInfo() {
    }

    public final String getMinerName() {
        if (this._name == null) {
            this._name = this.getClass().getName();
        }
        return this._name;
    }

    public final String getValue() {
        if (this._value == null) {
            String name = this.getMinerName();
            int indexOfValue = name.lastIndexOf(".");
            this._value = name.substring(indexOfValue + 1, name.length());
        }
        return this._value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handle() {
        while (!this._commandQueue.isEmpty()) {
            try {
                DataElement cmd = null;
                List list = this._commandQueue;
                synchronized (list) {
                    cmd = (DataElement)this._commandQueue.remove(0);
                }
                if (cmd == null) continue;
                this.command(cmd);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void requestCommand(DataElement command) {
        List list = this._commandQueue;
        synchronized (list) {
            this._commandQueue.add(command);
        }
        this.notifyInput();
    }

    public final void initMiner(DataElement status) {
        try {
            if (!this._initialized) {
                this.load(status);
                this._initialized = true;
            }
            this.updateMinerInfo();
            DataElement minerRoot = this._dataStore.getMinerRoot();
            this._dataStore.refresh(minerRoot);
            if (status.getAttribute(3).equals("incomplete")) {
                this._dataStore.refresh(status);
            } else {
                status.setAttribute(3, "done");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected final DataElement command(DataElement command) {
        DataElement status;
        block7: {
            String name = this.getCommandName(command);
            status = this.getCommandStatus(command);
            if (status == null) {
                this._dataStore.trace("bad command: ");
                this._dataStore.trace("\tcmd=" + command);
                this._dataStore.trace("\tparent=" + command.getParent());
                return null;
            }
            if (status.getAttribute(2).equals("start")) {
                status.setAttribute(2, "working");
            }
            if (name.equals("C_INIT_MINERS")) {
                this.initMiner(status);
            } else {
                try {
                    status = this.handleCommand(command);
                }
                catch (Exception e) {
                    this._dataStore.trace(e);
                    status.setAttribute(3, "Failed with Exception:" + this.getStack(e));
                    status.setAttribute(2, "done");
                    this._dataStore.refresh(status);
                    String exc = null;
                    exc = e.getMessage() != null ? e.getMessage() : "Exception";
                    this._dataStore.createObject(status, "error", exc);
                }
                catch (Error er) {
                    er.printStackTrace();
                    this._dataStore.trace(er);
                    this._dataStore.finish();
                    if (SystemServiceManager.getInstance().getSystemService() != null) break block7;
                    System.exit(-1);
                }
            }
        }
        this._dataStore.refresh(status);
        return status;
    }

    private String getStack(Throwable e) {
        StringBuffer buf = new StringBuffer();
        StackTraceElement[] stack = e.getStackTrace();
        int i = 0;
        while (i < stack.length) {
            buf.append(String.valueOf(stack[i].getClassName()) + ":" + stack[i].getMethodName() + ":" + stack[i].getLineNumber());
            buf.append(",");
            ++i;
        }
        return buf.toString();
    }

    public final void setDataStore(DataStore dataStore) {
        super.setDataStore(dataStore);
        this._dataStore = dataStore;
        DataElement root = this._dataStore.getMinerRoot();
        String name = this.getMinerName();
        String value = this.getValue();
        this._resourceBundle = this.getResourceBundle();
        this._minerElement = this._dataStore.find(root, 2, name, 1);
        if (this._minerElement == null || this._minerElement.isDeleted()) {
            this._minerElement = this._dataStore.createObject(root, "miner", name, name);
            this._minerElement.setAttribute(3, value);
            this._minerElement.setAttribute(4, this.getVersion());
            this._minerData = this._dataStore.createObject(this._minerElement, "data", "Data", name);
            this._minerTransient = this._dataStore.createObject(this._minerElement, "transient", "Transient Objects", name);
        } else {
            this._minerData = this._dataStore.find(this._minerElement, 2, "Data", 1);
            if (this._minerData == null || this._minerData.isDeleted()) {
                this._minerData = this._dataStore.createObject(this._minerElement, "data", "Data", name);
            }
            this._minerTransient = this._dataStore.find(this._minerElement, 2, "Transient Objects", 1);
            if (this._minerTransient == null || this._minerData.isDeleted()) {
                this._minerTransient = this._dataStore.createObject(this._minerElement, "transient", "Transient Objects", name);
            }
        }
        this._dataStore.refresh(root, true);
        this._dataStore.refresh(this._minerElement);
        this._connected = true;
    }

    public final DataElement createAbstractCommandDescriptor(DataElement descriptor, String name, String value) {
        return this._dataStore.createAbstractCommandDescriptor(descriptor, name, this.getMinerName(), value);
    }

    public final DataElement createCommandDescriptor(DataElement descriptor, String name, String value) {
        return this.createCommandDescriptor(descriptor, name, value, true);
    }

    public final DataElement createCommandDescriptor(DataElement descriptor, String name, String value, boolean visible) {
        DataElement cmdD = this._dataStore.createCommandDescriptor(descriptor, name, this.getMinerName(), value);
        if (!visible) {
            cmdD.setDepth(0);
        }
        return cmdD;
    }

    public final DataElement createAbstractObjectDescriptor(DataElement descriptor, String name) {
        return this._dataStore.createAbstractObjectDescriptor(descriptor, name);
    }

    public final DataElement createAbstractObjectDescriptor(DataElement descriptor, String name, String source) {
        return this._dataStore.createAbstractObjectDescriptor(descriptor, name, source);
    }

    public final DataElement createObjectDescriptor(DataElement descriptor, String name) {
        return this._dataStore.createObjectDescriptor(descriptor, name);
    }

    public final DataElement createObjectDescriptor(DataElement descriptor, String name, String source) {
        return this._dataStore.createObjectDescriptor(descriptor, name, source);
    }

    public final DataElement createRelationDescriptor(DataElement descriptor, String name) {
        return this._dataStore.createRelationDescriptor(descriptor, name);
    }

    public final DataElement createAbstractRelationship(DataElement from, DataElement to) {
        return this._dataStore.createReference(from, to, "abstracts", "abstracted by");
    }

    public final DataElement createReference(DataElement from, DataElement to) {
        return this._dataStore.createReference(from, to);
    }

    public final DataElement getMinerElement() {
        return this._minerElement;
    }

    public final DataElement getMinerData() {
        return this._minerData;
    }

    public final DataElement getMinerTransient() {
        return this._minerTransient;
    }

    public final void makeTransient(DataElement objectDescriptor) {
        this._dataStore.createReference(this._minerTransient, objectDescriptor);
    }

    public final String getCommandName(DataElement command) {
        return command.getAttribute(2);
    }

    public final DataElement getCommandStatus(DataElement command) {
        return command.get(command.getNestedSize() - 1);
    }

    public final int getNumberOfCommandArguments(DataElement command) {
        return command.getNestedSize();
    }

    public final DataElement getCommandArgument(DataElement command, int arg) {
        DataElement argument;
        if (command.getNestedSize() > 0 && (argument = command.get(arg)) != null) {
            return argument.dereference();
        }
        return null;
    }

    public final DataElement getSchemaRoot() {
        return this._dataStore.getDescriptorRoot();
    }

    public void setExternalLoader(IExternalLoader loader) {
        this._loader = loader;
    }

    public IExternalLoader getExternalLoader() {
        return this._loader;
    }

    public synchronized void waitForInput() {
        if (this._commandQueue.size() == 0) {
            super.waitForInput();
        }
    }

    public abstract DataElement handleCommand(DataElement var1) throws Exception;

    public abstract String getVersion();
}

