/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.internal.core.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.Stack;
import org.eclipse.dstore.core.java.IRemoteClassInstance;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.internal.core.util.XMLparser;

public class XMLgenerator {
    private int _state;
    private StringBuffer _document;
    private int _indent;
    private Stack _tagStack;
    private PrintStream _fileWriter;
    private BufferedWriter _dataWriter;
    private int _bufferSize;
    private boolean _generateBuffer;
    private boolean _ignoreDeleted;
    private DataStore _dataStore;
    public static final int EMPTY = 0;
    public static final int OPEN = 1;
    public static final int CLOSE = 2;
    public static final int BODY = 3;

    public XMLgenerator(DataStore dataStore) {
        this._dataStore = dataStore;
        this._state = 0;
        this._bufferSize = 200000;
        this._document = new StringBuffer(this._bufferSize);
        this._indent = 0;
        this._generateBuffer = true;
        this._ignoreDeleted = false;
        this._tagStack = new Stack();
    }

    public void setIgnoreDeleted(boolean flag) {
        this._ignoreDeleted = flag;
    }

    public void setFileWriter(PrintStream writer) {
        this._fileWriter = writer;
    }

    public void setDataWriter(BufferedWriter writer) {
        this._dataWriter = writer;
    }

    public void setBufferSize(int size) {
        this._bufferSize = size;
    }

    public void setGenerateBuffer(boolean flag) {
        this._generateBuffer = flag;
    }

    private void append(char c) {
        this._document.append(c);
    }

    private void append(String buffer) {
        this._document.append(buffer);
    }

    private void append(StringBuffer buffer) {
        this._document.append(buffer);
    }

    private void nextLine() {
        if (this._dataWriter != null) {
            this._document.append('\n');
            int length = this._document.length();
            if (length + 1000 > this._bufferSize) {
                this.flushData();
            }
        }
    }

    public void flushData() {
        if (this._document.length() > 0 && this._dataWriter != null) {
            try {
                this._dataWriter.write(this._document.toString(), 0, this._document.length());
                this._dataWriter.write(10);
                this._dataWriter.flush();
                this._document.setLength(0);
            }
            catch (Exception e) {
                this._dataStore.trace(e);
                this._dataWriter = null;
            }
        }
    }

    private void indent() {
        int i = 0;
        while (i < this._indent) {
            this.append(' ');
            ++i;
        }
    }

    private void startTag(String name) {
        if (this._state == 1) {
            this.append('>');
            ++this._indent;
        }
        if (this._state == 2) {
            --this._indent;
        }
        if (this._state == 3) {
            this.nextLine();
        }
        this.indent();
        if (this._document == null) {
            this.append('<');
            this.append(name);
        } else {
            this.append('<');
            this.append(name);
        }
        this._tagStack.push(name);
        this._state = 1;
    }

    private void endTag(String name) {
        String top = (String)this._tagStack.pop();
        if (this._state != 2) {
            if (this._state == 1) {
                if (top == name) {
                    this.append("/>");
                    this._state = this._tagStack.empty() ? 2 : 3;
                }
            } else if (this._state == 3 && top == name) {
                this.nextLine();
                --this._indent;
                this.indent();
                this.append("</");
                this.append(name);
                this.append('>');
                if (this._tagStack.empty()) {
                    this._state = 2;
                }
            }
        }
    }

    private void addAttribute(String name, String value) {
        StringBuffer niceValue = null;
        if (value != null) {
            niceValue = XMLgenerator.prepareStringForXML(value);
            this.append(' ');
            this.append(name);
            this.append("=\"");
            this.append(niceValue);
            this.append('\"');
        } else {
            this.append(' ');
            this.append(name);
            this.append("=\"\"");
        }
    }

    private void addReferenceTypeAttribute(DataElement object) {
        if (object.isSpirit()) {
            this.addAttribute("refType", "spirit");
        } else if (object.isReference()) {
            if (this._dataStore.getReferenceTag() != null && this._dataStore.getReferenceTag().equals("refType")) {
                this.addAttribute("refType", "reference");
            } else {
                this.addAttribute("refType", "true");
            }
        } else if (this._dataStore.getReferenceTag() != null && this._dataStore.getReferenceTag().equals("refType")) {
            this.addAttribute("refType", "value");
        } else {
            this.addAttribute("refType", "false");
        }
    }

    private void addFile(byte[] bytes, int size, boolean binary) {
        if (this._state == 1) {
            this.append('>');
            ++this._indent;
            this._state = 3;
        }
        if (this._state == 3) {
            this.flushData();
            if (binary) {
                this._fileWriter.write(bytes, 0, size);
                this._fileWriter.flush();
            } else {
                try {
                    this._dataWriter.write(new String(bytes), 0, size);
                    this._dataWriter.flush();
                }
                catch (IOException e) {
                    this._dataStore.trace(e);
                }
            }
        } else if (this._state != 0) {
            // empty if block
        }
    }

    private void addData(StringBuffer data) {
        if (this._state == 1) {
            this.append('>');
            ++this._indent;
            this._state = 3;
        }
        if (this._state == 3) {
            if (this._generateBuffer && data != null && data.length() > 0) {
                StringBuffer text = XMLgenerator.prepareStringForXML(data);
                if (text != null && text.length() > 0) {
                    this.nextLine();
                    this.indent();
                    this.append("<Buffer>");
                    this.nextLine();
                    this.append(text.toString());
                    this.nextLine();
                    this.append("</Buffer>");
                }
            } else {
                this.append("");
            }
        } else if (this._state != 0) {
            // empty if block
        }
    }

    public StringBuffer document() {
        return this._document;
    }

    public void empty() {
        this._indent = 0;
        this._document.delete(0, this._document.length());
    }

    public static StringBuffer prepareStringForXML(StringBuffer input) {
        StringBuffer output = new StringBuffer();
        int idx = 0;
        while (idx < input.length()) {
            char currChar = input.charAt(idx);
            switch (currChar) {
                case '&': {
                    output.append(XMLparser.STR_AMP);
                    break;
                }
                case '\"': {
                    output.append(XMLparser.STR_QUOTE);
                    break;
                }
                case '\'': {
                    output.append(XMLparser.STR_APOS);
                    break;
                }
                case '<': {
                    output.append(XMLparser.STR_LT);
                    break;
                }
                case '>': {
                    output.append(XMLparser.STR_GT);
                    break;
                }
                case ';': {
                    output.append(XMLparser.STR_SEMI);
                    break;
                }
                case '\n': {
                    output.append(XMLparser.STR_NL);
                    break;
                }
                case '\r': {
                    output.append(XMLparser.STR_CR);
                    break;
                }
                case '\u0000': {
                    output.append(XMLparser.STR_EOL);
                    break;
                }
                default: {
                    output.append(currChar);
                }
            }
            ++idx;
        }
        return output;
    }

    public static StringBuffer prepareStringForXML(String input) {
        StringBuffer output = new StringBuffer();
        int idx = 0;
        while (idx < input.length()) {
            char currChar = input.charAt(idx);
            switch (currChar) {
                case '&': {
                    output.append(XMLparser.STR_AMP);
                    break;
                }
                case '\"': {
                    output.append(XMLparser.STR_QUOTE);
                    break;
                }
                case '\'': {
                    output.append(XMLparser.STR_APOS);
                    break;
                }
                case '<': {
                    output.append(XMLparser.STR_LT);
                    break;
                }
                case '>': {
                    output.append(XMLparser.STR_GT);
                    break;
                }
                case ';': {
                    output.append(XMLparser.STR_SEMI);
                    break;
                }
                case '\n': {
                    output.append(XMLparser.STR_NL);
                    break;
                }
                case '\r': {
                    output.append(XMLparser.STR_CR);
                    break;
                }
                case '\u0000': {
                    output.append(XMLparser.STR_EOL);
                    break;
                }
                default: {
                    output.append(currChar);
                }
            }
            ++idx;
        }
        return output;
    }

    public synchronized void generate(DataElement object, byte[] bytes, int size, boolean isAppend, boolean binary) {
        if (this._dataStore != null && (this._dataStore.isVirtual() || this._dataStore.isConnected())) {
            String tagType = XMLparser.STR_FILE;
            if (isAppend) {
                tagType = String.valueOf(tagType) + ".Append";
            }
            if (binary) {
                tagType = String.valueOf(tagType) + ".Binary";
            }
            if (object != null) {
                this.startTag(tagType);
                this.addAttribute("type", object.getAttribute(0));
                this.addAttribute("id", object.getAttribute(1));
                this.addAttribute("name", object.getAttribute(2));
                this.addAttribute("value", object.getAttribute(3));
                this.addAttribute("sourcefile", object.getAttribute(4));
                this.addAttribute("sourcelocation", object.getAttribute(5));
                this.addReferenceTypeAttribute(object);
                this.addAttribute("depth", "" + size);
                this.addFile(bytes, size, binary);
                this.endTag(tagType);
            }
        }
    }

    public synchronized void generate(DataElement object, byte[] bytes, int size) {
        if (this._dataStore != null && (this._dataStore.isVirtual() || this._dataStore.isConnected())) {
            String tagType = XMLparser.STR_CLASS;
            if (object != null) {
                this.startTag(tagType);
                this.addAttribute("type", object.getAttribute(0));
                this.addAttribute("id", object.getAttribute(1));
                this.addAttribute("name", object.getAttribute(2));
                this.addAttribute("value", object.getAttribute(3));
                this.addAttribute("sourcefile", object.getAttribute(4));
                this.addAttribute("sourcelocation", object.getAttribute(5));
                this.addReferenceTypeAttribute(object);
                this.addAttribute("depth", "" + size);
                this.addFile(bytes, size, true);
                this.endTag(tagType);
            }
        }
    }

    public void generate(DataElement object, int depth) {
        if (object != null && depth >= 0 && this._dataStore != null && (this._dataStore.isVirtual() || this._dataStore.isConnected())) {
            String tagType = XMLparser.STR_DATAELEMENT;
            if (!(object.isUpdated() && !object.isPendingTransfer() || object.isDeleted() && this._ignoreDeleted)) {
                object.setPendingTransfer(false);
                this.startTag(tagType);
                this.addAttribute("type", object.getAttribute(0));
                this.addAttribute("id", object.getAttribute(1));
                this.addAttribute("name", object.getAttribute(2));
                this.addAttribute("value", object.getAttribute(3));
                this.addAttribute("sourcefile", object.getAttribute(4));
                this.addAttribute("sourcelocation", object.getAttribute(5));
                this.addReferenceTypeAttribute(object);
                this.addAttribute("depth", "" + object.depth());
                this.addData(object.getBuffer());
                object.setUpdated(true);
                if (!object.isReference() && depth >= 0) {
                    int i = 0;
                    while (i < object.getNestedSize()) {
                        this.generate(object.get(i), depth - 1);
                        ++i;
                    }
                }
                this.endTag(tagType);
            }
        }
    }

    public void generateClassRequest(DataElement object) {
        String tagType = XMLparser.STR_REQUEST_CLASS;
        if (object != null) {
            this.startTag(tagType);
            this.addAttribute("type", object.getAttribute(0));
            this.addAttribute("id", object.getAttribute(1));
            this.addAttribute("name", object.getAttribute(2));
            this.addAttribute("value", object.getAttribute(3));
            this.addAttribute("sourcefile", object.getAttribute(4));
            this.addAttribute("sourcelocation", object.getAttribute(5));
            this.addReferenceTypeAttribute(object);
            this._state = 3;
            this.endTag(tagType);
        }
    }

    public void generateSerializedObject(DataElement object, IRemoteClassInstance runnable) {
        String tagType = XMLparser.STR_SERIALIZED;
        if (object != null) {
            this.startTag(tagType);
            this.addAttribute("type", object.getAttribute(0));
            this.addAttribute("id", object.getAttribute(1));
            this.addAttribute("name", object.getAttribute(2));
            this.addAttribute("value", object.getAttribute(3));
            this.addAttribute("sourcefile", object.getAttribute(4));
            this.addAttribute("sourcelocation", object.getAttribute(5));
            this.addReferenceTypeAttribute(object);
            try {
                PipedInputStream pin = new PipedInputStream();
                PipedOutputStream pout = new PipedOutputStream(pin);
                ObjectOutputStream outStream = new ObjectOutputStream(pout);
                outStream.writeObject(runnable);
                int size = pin.available();
                byte[] bytes = new byte[size];
                int nRead = pin.read(bytes, 0, size);
                this.addAttribute("depth", "" + nRead);
                this.addFile(bytes, nRead, true);
                outStream.close();
                pin.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.endTag(tagType);
        }
    }
}

