/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.efs;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rse.internal.efs.Activator;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.UIJob;

public class RemoteEditorManager
implements ISaveParticipant,
IResourceChangeListener,
IWorkbenchListener {
    public static final String PREFERENCE_EDITOR_LIST = "org.eclipse.rse.internal.efs.EditorSaver.preferenceEditorList";
    private static RemoteEditorManager defaultInstance;
    private Map projectNameToUriMap = null;

    private RemoteEditorManager() {
    }

    public static synchronized RemoteEditorManager getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new RemoteEditorManager();
        }
        return defaultInstance;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        String pref = RSEUIPlugin.getDefault().getPreferenceStore().getString(PREFERENCE_EDITOR_LIST);
        Map projectNameToUriMap = this.getProjectNameToUriMap(pref);
        if (projectNameToUriMap.isEmpty()) {
            return;
        }
        IResourceDelta[] children = event.getDelta().getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            List uris;
            IProject project;
            IResourceDelta delta = children[i];
            if ((delta.getFlags() & 0x4000) != 0 && (project = delta.getResource().getProject()).isOpen() && (uris = (List)projectNameToUriMap.remove(project.getName())) != null) {
                Iterator iter = uris.iterator();
                while (iter.hasNext()) {
                    final String uriString = (String)iter.next();
                    UIJob job = new UIJob("Restore Remote Editor"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (monitor.isCanceled()) {
                                return Status.OK_STATUS;
                            }
                            try {
                                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                                IFileStore fileStore = EFS.getStore((URI)new URI(uriString));
                                IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                            }
                            catch (URISyntaxException e) {
                                return Activator.errorStatus(e);
                            }
                            catch (PartInitException e) {
                                return Activator.errorStatus(e);
                            }
                            catch (CoreException e) {
                                return Activator.errorStatus(e);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }
            }
            ++i;
        }
    }

    public synchronized void saveRemoteEditors() {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = wb.getWorkbenchWindows();
        if (windows.length > 0) {
            String list = this.generateEditorList();
            RSEUIPlugin.getDefault().getPreferenceStore().putValue(PREFERENCE_EDITOR_LIST, list);
        }
        this.projectNameToUriMap = null;
    }

    private Map getProjectNameToUriMap(String raw) {
        if (this.projectNameToUriMap == null) {
            int i;
            this.projectNameToUriMap = new HashMap();
            if (raw == null || raw.length() == 0) {
                return this.projectNameToUriMap;
            }
            int index = 0;
            while ((i = raw.indexOf(47, index)) >= 0) {
                String projectName = raw.substring(index, i);
                index = i + 1;
                if ((i = raw.indexOf(32, index)) < 0) break;
                String uriString = raw.substring(index, i);
                index = i + 1;
                LinkedList<String> uris = (LinkedList<String>)this.projectNameToUriMap.get(projectName);
                if (uris == null) {
                    uris = new LinkedList<String>();
                    this.projectNameToUriMap.put(projectName, uris);
                }
                uris.add(uriString);
            }
        }
        return this.projectNameToUriMap;
    }

    private String generateEditorList() {
        final StringBuffer sb = new StringBuffer();
        RemoteEditorManager.forEachOpenRemoteEditor(new IEditorCallback(){

            public void apply(IWorkbenchPage page, IEditorPart editor, IFile file) {
                IProject project = file.getProject();
                URI uri = file.getLocationURI();
                sb.append(project.getName());
                sb.append('/');
                sb.append(uri);
                sb.append(' ');
            }
        });
        return sb.toString();
    }

    private static void forEachOpenRemoteEditor(IEditorCallback callback) {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = wb.getWorkbenchWindows();
        int w = 0;
        while (w < windows.length) {
            IWorkbenchWindow win = windows[w];
            IWorkbenchPage[] pages = win.getPages();
            int p = 0;
            while (p < pages.length) {
                IWorkbenchPage page = pages[p];
                IEditorReference[] activeReferences = page.getEditorReferences();
                int er = 0;
                while (er < activeReferences.length) {
                    IEditorReference editorReference = activeReferences[er];
                    try {
                        IFile file;
                        URI uri;
                        IEditorInput input = editorReference.getEditorInput();
                        if (input instanceof FileEditorInput && (uri = (file = ((FileEditorInput)input).getFile()).getLocationURI()) != null && uri.getScheme() != null && "rse".equals(uri.getScheme())) {
                            IEditorPart editor = editorReference.getEditor(false);
                            callback.apply(page, editor, file);
                        }
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                    ++er;
                }
                ++p;
            }
            ++w;
        }
    }

    public boolean closeRemoteEditors() {
        boolean result = true;
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = wb.getWorkbenchWindows();
        int w = 0;
        while (w < windows.length) {
            IWorkbenchWindow win = windows[w];
            IWorkbenchPage[] pages = win.getPages();
            int p = 0;
            while (p < pages.length && result) {
                IWorkbenchPage page = pages[p];
                IEditorReference[] activeReferences = page.getEditorReferences();
                int er = 0;
                while (er < activeReferences.length) {
                    IEditorReference editorReference = activeReferences[er];
                    try {
                        IFile file;
                        URI uri;
                        IEditorInput input = editorReference.getEditorInput();
                        if (input instanceof FileEditorInput && (uri = (file = ((FileEditorInput)input).getFile()).getLocationURI()) != null && uri.getScheme() != null && "rse".equals(uri.getScheme())) {
                            IEditorPart editor = editorReference.getEditor(false);
                            result = page.closeEditor(editor, true);
                        }
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                    ++er;
                }
                ++p;
            }
            ++w;
        }
        return result;
    }

    public void saving(ISaveContext context) throws CoreException {
        this.saveRemoteEditors();
    }

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
    }

    public void postShutdown(IWorkbench workbench) {
    }

    public boolean preShutdown(IWorkbench workbench, boolean forced) {
        RemoteEditorManager.getDefault().saveRemoteEditors();
        return RemoteEditorManager.getDefault().closeRemoteEditors();
    }

    private static interface IEditorCallback {
        public void apply(IWorkbenchPage var1, IEditorPart var2, IFile var3);
    }
}

