/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.clientserver;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.services.clientserver.archiveutils.AbsoluteVirtualPath;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.java.BasicClassFileParser;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;

public class SystemFileClassifier {
    private static SystemFileClassifier instance;

    private SystemFileClassifier() {
    }

    public static SystemFileClassifier getInstance() {
        if (instance == null) {
            instance = new SystemFileClassifier();
        }
        return instance;
    }

    public String classifyFile(String absolutePath) {
        boolean isVirtual = ArchiveHandlerManager.isVirtual(absolutePath);
        if (isVirtual) {
            return this.classifyVirtual(absolutePath);
        }
        return this.classifyNonVirtual(absolutePath);
    }

    protected String classifyVirtual(String absolutePath) {
        AbsoluteVirtualPath avp = new AbsoluteVirtualPath(absolutePath);
        String archivePath = avp.getContainingArchiveString();
        String virtualPath = avp.getVirtualPart();
        File archiveFile = new File(archivePath);
        try {
            return ArchiveHandlerManager.getInstance().getClassification(archiveFile, virtualPath);
        }
        catch (SystemMessageException systemMessageException) {
            return "file";
        }
    }

    protected String classifyNonVirtual(String absolutePath) {
        String type = "file";
        File file = new File(absolutePath);
        if (!file.exists()) {
            return type;
        }
        boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("win");
        if (isWindows) {
            if ((absolutePath = absolutePath.toLowerCase()).endsWith(".class")) {
                type = this.classifyClassFile(absolutePath);
            } else if (absolutePath.endsWith(".exe")) {
                type = "executable(binary)";
            } else if (absolutePath.endsWith(".dll")) {
                type = "module";
            }
            return type;
        }
        String encoding = System.getProperty("dstore.stdin.encoding");
        if (encoding == null || encoding.equals("")) {
            encoding = System.getProperty("file.encoding");
        }
        String[] args = new String[]{"sh", "-c", "file " + PathUtility.enQuoteUnix(absolutePath)};
        BufferedReader poutReader = null;
        try {
            Process childProcess = Runtime.getRuntime().exec(args);
            InputStreamReader reader = new InputStreamReader(childProcess.getInputStream(), encoding);
            poutReader = new BufferedReader(reader);
            String line = poutReader.readLine();
            if (line != null) {
                line = line.trim();
                type = this.getClassification(absolutePath, line);
                poutReader.close();
                if (type.equals("link")) {
                    String canonicalPath = file.getCanonicalPath();
                    return String.valueOf(type) + "(" + this.classifyNonVirtual(canonicalPath) + ")" + ":" + canonicalPath;
                }
                return type;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return type;
        }
        catch (IOException iOException) {
            return type;
        }
        return type;
    }

    protected String getClassification(String absolutePath, String line) {
        boolean matchesScript;
        String type = "file";
        String name = line;
        String fulltype = "";
        int colon = line.indexOf(58);
        if (colon >= 0) {
            name = line.substring(0, colon);
            fulltype = line.substring(colon + 1, line.length()).trim();
        }
        if (name.endsWith(".class")) {
            type = this.classifyClassFile(absolutePath);
        }
        boolean matchesLib = fulltype.indexOf("shared object") > -1 || fulltype.indexOf("object module") > -1 || fulltype.indexOf("archive") > -1;
        boolean matchesExe = fulltype.indexOf("executable") > -1;
        boolean bl = matchesScript = fulltype.indexOf("script") > -1;
        if (matchesLib) {
            if (name.endsWith(".a") || name.endsWith(".so") || name.indexOf(".so.") > 0) {
                type = "module";
            }
        } else if (matchesScript) {
            type = matchesExe ? "executable(script)" : "script";
        } else if (matchesExe) {
            type = "executable(binary)";
        } else if (fulltype.indexOf("OS/400 object") > -1) {
            type = "OS/400 object";
        } else if (fulltype.startsWith("symbolic link to")) {
            type = "link";
        }
        return type;
    }

    protected String classifyClassFile(String absolutePath) {
        String type = "file";
        FileInputStream stream = null;
        BasicClassFileParser parser = null;
        boolean isExecutable = false;
        try {
            stream = new FileInputStream(absolutePath);
            parser = new BasicClassFileParser(stream);
            parser.parse();
            isExecutable = parser.isExecutable();
        }
        catch (IOException iOException) {
            isExecutable = false;
            return type;
        }
        if (isExecutable) {
            type = "executable(java";
            String qualifiedClassName = parser.getQualifiedClassName();
            if (qualifiedClassName != null) {
                type = String.valueOf(type) + ":" + qualifiedClassName;
            }
            type = String.valueOf(type) + ")";
        }
        return type;
    }
}

