/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.clientserver.archiveutils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.eclipse.rse.internal.services.clientserver.archiveutils.SystemArchiveUtil;
import org.eclipse.rse.internal.services.clientserver.archiveutils.SystemUniversalZipEntry;
import org.eclipse.rse.services.clientserver.ISystemFileTypes;
import org.eclipse.rse.services.clientserver.ISystemOperationMonitor;
import org.eclipse.rse.services.clientserver.SystemEncodingUtil;
import org.eclipse.rse.services.clientserver.SystemReentrantMutex;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.archiveutils.ISystemArchiveHandler;
import org.eclipse.rse.services.clientserver.archiveutils.VirtualChild;
import org.eclipse.rse.services.clientserver.java.BasicClassFileParser;
import org.eclipse.rse.services.clientserver.messages.SystemLockTimeoutException;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.clientserver.messages.SystemOperationCancelledException;
import org.eclipse.rse.services.clientserver.messages.SystemOperationFailedException;
import org.eclipse.rse.services.clientserver.messages.SystemUnexpectedErrorException;
import org.eclipse.rse.services.clientserver.search.SystemSearchLineMatch;
import org.eclipse.rse.services.clientserver.search.SystemSearchStringMatchLocator;
import org.eclipse.rse.services.clientserver.search.SystemSearchStringMatcher;

public class SystemZipHandler
implements ISystemArchiveHandler {
    protected ZipFile _zipfile;
    protected HashMap _virtualFS;
    protected File _file;
    protected long _vfsLastModified;
    protected boolean _exists;
    protected SystemReentrantMutex _mutex;

    public SystemZipHandler(File file) throws IOException {
        this._file = file;
        this._vfsLastModified = this._file.lastModified();
        boolean zipFileOpen = false;
        if (this._file.exists()) {
            try {
                this.openZipFile();
                zipFileOpen = true;
            }
            catch (IOException iOException) {}
        }
        if (zipFileOpen) {
            this.buildTree();
            this.closeZipFile();
            this._exists = true;
        } else {
            this._exists = false;
        }
        this._mutex = new SystemReentrantMutex();
    }

    protected void buildTree() {
        this._virtualFS = new HashMap();
        Enumeration<? extends ZipEntry> entries = this._zipfile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry next = entries.nextElement();
            this.fillBranch(next);
        }
    }

    protected void updateTreeAfterRename(HashMap newOldName, VirtualChild[] renameList) {
        Enumeration<? extends ZipEntry> entries = this._zipfile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry next = entries.nextElement();
            String oldName = null;
            if (newOldName.containsKey(next.getName())) {
                oldName = (String)newOldName.get(next.getName());
            }
            this.fillBranchAfterRename(next, oldName);
        }
        if (renameList == null) {
            return;
        }
        int i = 0;
        while (i < renameList.length) {
            String fullName;
            if (renameList[i].isDirectory && this._virtualFS.containsKey(fullName = renameList[i].fullName)) {
                this._virtualFS.remove(fullName);
            }
            ++i;
        }
    }

    protected void fillBranch(ZipEntry next) {
        HashMap itsDirectory;
        if (next.getName().equals("/")) {
            return;
        }
        VirtualChild nextChild = null;
        String pathNameToSearchInVFS = null;
        String nameToSearchInVFS = null;
        SystemUniversalZipEntry nextEntry = new SystemUniversalZipEntry(next);
        pathNameToSearchInVFS = nextEntry.getFullPath();
        nameToSearchInVFS = nextEntry.getName();
        if (this._virtualFS.containsKey(pathNameToSearchInVFS) && (itsDirectory = (HashMap)this._virtualFS.get(pathNameToSearchInVFS)).containsKey(nameToSearchInVFS)) {
            nextChild = (VirtualChild)itsDirectory.get(nameToSearchInVFS);
        }
        if (nextChild == null) {
            nextChild = new VirtualChild(this, nextEntry.getFullName());
        } else {
            nextChild.renameTo(nextEntry.getFullName());
        }
        if (next.isDirectory()) {
            nextChild.isDirectory = true;
            if (!this._virtualFS.containsKey(nextChild.fullName)) {
                this._virtualFS.put(nextChild.fullName, new HashMap());
            }
        }
        nextChild.setComment(next.getComment());
        nextChild.setCompressedSize(next.getCompressedSize());
        Integer methodIntValue = new Integer(next.getMethod());
        nextChild.setCompressionMethod(methodIntValue.toString());
        nextChild.setSize(next.getSize());
        nextChild.setTimeStamp(next.getTime());
        if (!this._virtualFS.containsKey(nextChild.path)) {
            this.recursivePopulate(nextChild.path, nextChild);
        } else {
            HashMap hm = (HashMap)this._virtualFS.get(nextChild.path);
            hm.put(nextChild.name, nextChild);
        }
    }

    protected void fillBranchAfterRename(ZipEntry next, String oldName) {
        HashMap itsDirectory;
        if (next.getName().equals("/")) {
            return;
        }
        VirtualChild nextChild = null;
        String pathNameToSearchInVFS = null;
        String nameToSearchInVFS = null;
        boolean replace = oldName != null;
        SystemUniversalZipEntry nextEntry = new SystemUniversalZipEntry(next);
        if (oldName != null) {
            int endOfPathPosition = oldName.lastIndexOf("/");
            if (endOfPathPosition != -1) {
                if (endOfPathPosition == oldName.length() - 1) {
                    String nameWithoutLastSlash = oldName.substring(0, endOfPathPosition);
                    int endOfPathPosNameWithoutLastSlash = nameWithoutLastSlash.lastIndexOf("/");
                    if (endOfPathPosNameWithoutLastSlash != -1) {
                        pathNameToSearchInVFS = oldName.substring(0, endOfPathPosNameWithoutLastSlash);
                        nameToSearchInVFS = oldName.substring(endOfPathPosNameWithoutLastSlash + 1, endOfPathPosition);
                    } else {
                        pathNameToSearchInVFS = "";
                        nameToSearchInVFS = oldName.substring(0, endOfPathPosition);
                    }
                } else {
                    pathNameToSearchInVFS = oldName.substring(0, endOfPathPosition);
                    nameToSearchInVFS = oldName.substring(endOfPathPosition + 1);
                }
            } else {
                pathNameToSearchInVFS = "";
                nameToSearchInVFS = oldName;
            }
        } else {
            pathNameToSearchInVFS = nextEntry.getFullPath();
            nameToSearchInVFS = nextEntry.getName();
        }
        if (this._virtualFS.containsKey(pathNameToSearchInVFS) && (itsDirectory = (HashMap)this._virtualFS.get(pathNameToSearchInVFS)).containsKey(nameToSearchInVFS)) {
            nextChild = (VirtualChild)itsDirectory.get(nameToSearchInVFS);
            if (replace) {
                itsDirectory.remove(nameToSearchInVFS);
            }
        }
        if (nextChild == null) {
            nextChild = new VirtualChild(this, nextEntry.getFullName());
        } else {
            nextChild.renameTo(nextEntry.getFullName());
        }
        if (next.isDirectory()) {
            nextChild.isDirectory = true;
            if (!this._virtualFS.containsKey(nextChild.fullName)) {
                this._virtualFS.put(nextChild.fullName, new HashMap());
            }
        }
        nextChild.setComment(next.getComment());
        nextChild.setCompressedSize(next.getCompressedSize());
        Integer methodIntValue = new Integer(next.getMethod());
        nextChild.setCompressionMethod(methodIntValue.toString());
        nextChild.setSize(next.getSize());
        nextChild.setTimeStamp(next.getTime());
        if (!this._virtualFS.containsKey(nextChild.path)) {
            this.populate(nextChild.path, nextChild);
        } else {
            HashMap hm = (HashMap)this._virtualFS.get(nextChild.path);
            hm.put(nextChild.name, nextChild);
        }
    }

    protected void recursivePopulate(String key, VirtualChild value) {
        if (this._virtualFS.containsKey(key)) {
            HashMap hm = (HashMap)this._virtualFS.get(key);
            hm.put(value.name, value);
            return;
        }
        HashMap<String, VirtualChild> newValue = new HashMap<String, VirtualChild>();
        newValue.put(value.name, value);
        this._virtualFS.put(key, newValue);
        if (key.equals("")) {
            return;
        }
        int i = key.lastIndexOf("/");
        if (i == -1) {
            VirtualChild nextValue = new VirtualChild(this, key);
            nextValue.isDirectory = true;
            this.recursivePopulate("", nextValue);
            return;
        }
        String newKey = key.substring(0, i);
        VirtualChild nextValue = new VirtualChild(this, key);
        nextValue.isDirectory = true;
        this.recursivePopulate(newKey, nextValue);
    }

    protected void populate(String key, VirtualChild value) {
        if (this._virtualFS.containsKey(key)) {
            HashMap hm = (HashMap)this._virtualFS.get(key);
            hm.put(value.name, value);
            return;
        }
        HashMap<String, VirtualChild> newValue = new HashMap<String, VirtualChild>();
        newValue.put(value.name, value);
        this._virtualFS.put(key, newValue);
        if (key.equals("")) {
            return;
        }
        int i = key.lastIndexOf("/");
        if (i == -1) {
            VirtualChild nextValue = new VirtualChild(this, key);
            nextValue.isDirectory = true;
            this.recursivePopulate("", nextValue);
            return;
        }
        String newKey = key.substring(0, i);
        VirtualChild nextValue = new VirtualChild(this, key);
        nextValue.isDirectory = true;
        this.recursivePopulate(newKey, nextValue);
    }

    public VirtualChild[] getVirtualChildrenList(ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        return this.getVirtualChildrenList(true, archiveOperationMonitor);
    }

    public VirtualChild[] getVirtualChildrenList(boolean closeZipFile, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        block14: {
            if (!this._exists) {
                return new VirtualChild[0];
            }
            if (!this.updateVirtualFSIfNecessary(archiveOperationMonitor)) {
                return new VirtualChild[0];
            }
            int mutexLockStatus = 0;
            try {
                mutexLockStatus = this._mutex.waitForLock(archiveOperationMonitor, Long.MAX_VALUE);
                if (mutexLockStatus != 0) {
                    if (this.openZipFile()) {
                        Vector<VirtualChild> children = new Vector<VirtualChild>();
                        Enumeration<? extends ZipEntry> entries = this._zipfile.entries();
                        while (entries.hasMoreElements()) {
                            ZipEntry next = entries.nextElement();
                            SystemUniversalZipEntry nextEntry = new SystemUniversalZipEntry(next);
                            VirtualChild nextChild = new VirtualChild(this, nextEntry.getFullName());
                            nextChild.isDirectory = next.isDirectory();
                            children.add(nextChild);
                        }
                        VirtualChild[] retVal = new VirtualChild[children.size()];
                        int i = 0;
                        while (i < children.size()) {
                            retVal[i] = (VirtualChild)children.get(i);
                            ++i;
                        }
                        if (closeZipFile) {
                            this.closeZipFile();
                        }
                        VirtualChild[] virtualChildArray = retVal;
                        return virtualChildArray;
                    }
                    break block14;
                }
                try {
                    throw new SystemLockTimeoutException("org.eclipse.rse.services");
                }
                catch (Exception e) {
                    if (closeZipFile) {
                        this.closeZipFile();
                    }
                    throw new SystemOperationFailedException("org.eclipse.rse.services", e);
                }
            }
            finally {
                this.releaseMutex(mutexLockStatus);
            }
        }
        return new VirtualChild[0];
    }

    public VirtualChild[] getVirtualChildrenList(String parent, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        return this.getVirtualChildrenList(parent, true, archiveOperationMonitor);
    }

    public VirtualChild[] getVirtualChildrenList(String parent, boolean closeZipFile, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        if (!this._exists) {
            return new VirtualChild[0];
        }
        if (!this.updateVirtualFSIfNecessary(archiveOperationMonitor)) {
            return new VirtualChild[0];
        }
        int mutexLockStatus = 0;
        try {
            mutexLockStatus = this._mutex.waitForLock(archiveOperationMonitor, Long.MAX_VALUE);
            if (mutexLockStatus != 0) {
                if (this.openZipFile()) {
                    parent = ArchiveHandlerManager.cleanUpVirtualPath(parent);
                    Vector<VirtualChild> children = new Vector<VirtualChild>();
                    Enumeration<? extends ZipEntry> entries = this._zipfile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry next = entries.nextElement();
                        String nextName = ArchiveHandlerManager.cleanUpVirtualPath(next.getName());
                        if (!nextName.startsWith(parent) || nextName.equals(String.valueOf(parent) + "/")) continue;
                        SystemUniversalZipEntry nextEntry = new SystemUniversalZipEntry(next);
                        VirtualChild nextChild = new VirtualChild(this, nextEntry.getFullName());
                        nextChild.isDirectory = next.isDirectory();
                        children.add(nextChild);
                    }
                    VirtualChild[] retVal = new VirtualChild[children.size()];
                    int i = 0;
                    while (i < children.size()) {
                        retVal[i] = (VirtualChild)children.get(i);
                        ++i;
                    }
                    if (closeZipFile) {
                        this.closeZipFile();
                    }
                    VirtualChild[] virtualChildArray = retVal;
                    return virtualChildArray;
                }
                VirtualChild[] virtualChildArray = new VirtualChild[]{};
                return virtualChildArray;
            }
            VirtualChild[] virtualChildArray = new VirtualChild[]{};
            return virtualChildArray;
        }
        catch (Exception e) {
            if (closeZipFile) {
                this.closeZipFile();
            }
            throw new SystemOperationFailedException("org.eclipse.rse.services", e);
        }
        finally {
            this.releaseMutex(mutexLockStatus);
        }
    }

    public VirtualChild[] getVirtualChildren(String fullVirtualName, ISystemOperationMonitor archiveOperationMonitor) {
        if (!this._exists) {
            return null;
        }
        if (!this.updateVirtualFSIfNecessary(archiveOperationMonitor)) {
            return null;
        }
        fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
        VirtualChild[] values = null;
        if (this._virtualFS.containsKey(fullVirtualName)) {
            HashMap hm = (HashMap)this._virtualFS.get(fullVirtualName);
            Object[] valueArray = hm.values().toArray();
            values = new VirtualChild[hm.size()];
            int i = 0;
            while (i < hm.size()) {
                values[i] = (VirtualChild)valueArray[i];
                ++i;
            }
        }
        return values;
    }

    public VirtualChild[] getVirtualChildFolders(String fullVirtualName, ISystemOperationMonitor archiveOperationMonitor) {
        if (!this._exists) {
            return null;
        }
        if (!this.updateVirtualFSIfNecessary(archiveOperationMonitor)) {
            return null;
        }
        fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
        Vector<Object> folders = new Vector<Object>();
        VirtualChild[] values = null;
        if (this._virtualFS.containsKey(fullVirtualName)) {
            HashMap hm = (HashMap)this._virtualFS.get(fullVirtualName);
            Object[] valueArray = hm.values().toArray();
            int i = 0;
            while (i < hm.size()) {
                if (((VirtualChild)valueArray[i]).isDirectory) {
                    folders.add(valueArray[i]);
                }
                ++i;
            }
            values = new VirtualChild[folders.size()];
            i = 0;
            while (i < folders.size()) {
                values[i] = (VirtualChild)folders.get(i);
                ++i;
            }
        }
        return values;
    }

    public VirtualChild getVirtualFile(String fullVirtualName, ISystemOperationMonitor archiveOperationMonitor) {
        String name;
        String path;
        if (!this._exists) {
            return new VirtualChild(this, fullVirtualName);
        }
        if (!this.updateVirtualFSIfNecessary(archiveOperationMonitor)) {
            return new VirtualChild(this, fullVirtualName);
        }
        if ((fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName)) == "" || fullVirtualName == null) {
            return new VirtualChild(this);
        }
        int i = fullVirtualName.lastIndexOf("/");
        if (i == -1) {
            path = "";
            name = fullVirtualName;
        } else {
            path = fullVirtualName.substring(0, i);
            name = fullVirtualName.substring(i + 1);
        }
        HashMap hm = (HashMap)this._virtualFS.get(path);
        if (hm == null) {
            return new VirtualChild(this, fullVirtualName);
        }
        VirtualChild vc = (VirtualChild)hm.get(name);
        if (vc == null) {
            return new VirtualChild(this, fullVirtualName);
        }
        return vc;
    }

    public boolean exists(String fullVirtualName, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        if (!this._exists) {
            return false;
        }
        if ((fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName)) == "" || fullVirtualName == null) {
            return false;
        }
        if (this._vfsLastModified == this._file.lastModified()) {
            String name;
            String path;
            int i = fullVirtualName.lastIndexOf("/");
            if (i == -1) {
                path = "";
                name = fullVirtualName;
            } else {
                path = fullVirtualName.substring(0, i);
                name = fullVirtualName.substring(i + 1);
            }
            HashMap hm = (HashMap)this._virtualFS.get(path);
            if (hm == null) {
                return false;
            }
            return hm.get(name) != null;
        }
        boolean retval = false;
        boolean keepOpen = this._zipfile != null;
        try {
            this.openZipFile();
        }
        catch (IOException ioe) {
            throw new SystemOperationFailedException("org.eclipse.rse.services", "Could not open the ZipFile " + this._file.toString(), ioe);
        }
        try {
            this.safeGetEntry(fullVirtualName);
            retval = true;
        }
        catch (IOException iOException) {
            try {
                this.safeGetEntry(String.valueOf(fullVirtualName) + "/");
                retval = true;
            }
            catch (IOException iOException2) {
                retval = false;
            }
        }
        this.buildTree();
        this._vfsLastModified = this._file.lastModified();
        if (!keepOpen) {
            this.closeZipFile();
        }
        return retval;
    }

    public File getArchive() {
        return this._file;
    }

    public long getTimeStampFor(String fullVirtualName) throws SystemMessageException {
        return this.getTimeStampFor(fullVirtualName, true);
    }

    public long getTimeStampFor(String fullVirtualName, boolean closeZipFile) throws SystemMessageException {
        if (!this._exists) {
            return 0L;
        }
        try {
            this.openZipFile();
            fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
            ZipEntry entry = null;
            entry = this.safeGetEntry(fullVirtualName);
            if (closeZipFile) {
                this.closeZipFile();
            }
            return entry.getTime();
        }
        catch (IOException iOException) {
            if (closeZipFile) {
                this.closeZipFile();
            }
            return this._file.lastModified();
        }
    }

    public long getSizeFor(String fullVirtualName) throws SystemMessageException {
        return this.getSizeFor(fullVirtualName, true);
    }

    public long getSizeFor(String fullVirtualName, boolean closeZipFile) throws SystemMessageException {
        if (!this._exists) {
            return 0L;
        }
        try {
            this.openZipFile();
            fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
            ZipEntry entry = null;
            entry = this.safeGetEntry(fullVirtualName);
            if (closeZipFile) {
                this.closeZipFile();
            }
            return entry.getSize();
        }
        catch (IOException e) {
            if (closeZipFile) {
                this.closeZipFile();
            }
            throw new SystemOperationFailedException("org.eclipse.rse.services", (Exception)e);
        }
    }

    public void extractVirtualFile(String fullVirtualName, File destination, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        this.extractVirtualFile(fullVirtualName, destination, true, SystemEncodingUtil.ENCODING_UTF_8, false, archiveOperationMonitor);
    }

    public void extractVirtualFile(String fullVirtualName, File destination, String sourceEncoding, boolean isText, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        this.extractVirtualFile(fullVirtualName, destination, true, sourceEncoding, isText, archiveOperationMonitor);
    }

    /*
     * Unable to fully structure code
     */
    public void extractVirtualFile(String fullVirtualName, File destination, boolean closeZipFile, String sourceEncoding, boolean isText, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        block17: {
            block15: {
                block16: {
                    if (!this._exists) {
                        throw new SystemUnexpectedErrorException("org.eclipse.rse.services");
                    }
                    mutexLockStatus = this._mutex.waitForLock(archiveOperationMonitor, 0x7FFFFFFFFFFFFFFFL);
                    if (mutexLockStatus == 0) break block17;
                    entry = null;
                    if (!this.openZipFile()) ** GOTO lbl57
                    entry = this.safeGetEntry(fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName));
                    if (!entry.isDirectory()) break block15;
                    destination.delete();
                    destination.mkdirs();
                    destination.setLastModified(entry.getTime());
                    if (!closeZipFile) break block16;
                    this.closeZipFile();
                }
lbl20:
                // 6 sources

                return;
            }
            try {
                try {
                    block18: {
                        is = this._zipfile.getInputStream(entry);
                        if (is != null) break block18;
                        destination.setLastModified(entry.getTime());
                        if (closeZipFile) {
                            this.closeZipFile();
                        }
                        ** GOTO lbl20
                    }
                    reader = new BufferedInputStream(is);
                    if (!destination.exists()) {
                        parentFile = destination.getParentFile();
                        if (!parentFile.exists()) {
                            parentFile.mkdirs();
                        }
                        destination.createNewFile();
                    }
                    writer = new BufferedOutputStream(new FileOutputStream(destination));
                    buf = new byte[1024];
                    numRead = reader.read(buf);
                    while (numRead > 0) {
                        if (isText) {
                            bufString = new String(buf, 0, numRead, sourceEncoding);
                            convertedBuf = bufString.getBytes();
                            newSize = convertedBuf.length;
                            writer.write(convertedBuf, 0, newSize);
                        } else {
                            writer.write(buf, 0, numRead);
                        }
                        numRead = reader.read(buf);
                    }
                    writer.close();
                    reader.close();
lbl57:
                    // 2 sources

                    destination.setLastModified(entry.getTime());
                    if (!closeZipFile) ** GOTO lbl20
                    this.closeZipFile();
                    ** GOTO lbl20
                }
                catch (IOException e) {
                    block19: {
                        if (!this._virtualFS.containsKey(fullVirtualName)) break block19;
                        destination.delete();
                        destination.mkdirs();
                        destination.setLastModified(this._file.lastModified());
                        if (!closeZipFile) ** GOTO lbl20
                        this.closeZipFile();
                        ** continue;
                    }
                    if (closeZipFile) {
                        this.closeZipFile();
                    }
                    throw new SystemOperationFailedException("org.eclipse.rse.services", (Exception)e);
                }
            }
            catch (Throwable var17_18) {
                throw var17_18;
            }
            finally {
                this.releaseMutex(mutexLockStatus);
            }
        }
        throw new SystemLockTimeoutException("org.eclipse.rse.services");
    }

    public void extractVirtualDirectory(String dir, File destinationParent, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        this.extractVirtualDirectory(dir, destinationParent, null, SystemEncodingUtil.ENCODING_UTF_8, false, archiveOperationMonitor);
    }

    public void extractVirtualDirectory(String dir, File destinationParent, String sourceEncoding, boolean isText, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        this.extractVirtualDirectory(dir, destinationParent, null, sourceEncoding, isText, archiveOperationMonitor);
    }

    public void extractVirtualDirectory(String dir, File destinationParent, File destination, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        this.extractVirtualDirectory(dir, destinationParent, destination, SystemEncodingUtil.ENCODING_UTF_8, false, archiveOperationMonitor);
    }

    public void extractVirtualDirectory(String dir, File destinationParent, File destination, String sourceEncoding, boolean isText, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        VirtualChild[] newChildren;
        String name;
        int charsToTrim;
        if (!this._exists) {
            throw new SystemUnexpectedErrorException("org.eclipse.rse.services");
        }
        if (!destinationParent.isDirectory()) {
            throw new SystemUnexpectedErrorException("org.eclipse.rse.services");
        }
        if (!this._virtualFS.containsKey(dir = ArchiveHandlerManager.cleanUpVirtualPath(dir))) {
            throw new SystemUnexpectedErrorException("org.eclipse.rse.services");
        }
        int j = dir.lastIndexOf("/");
        if (j == -1) {
            charsToTrim = 0;
            name = dir;
        } else {
            charsToTrim = dir.substring(0, j).length() + 1;
            name = dir.substring(j + 1);
        }
        if (destination == null) {
            destination = dir.equals("") ? destinationParent : new File(destinationParent, name);
        }
        if (destination != destinationParent) {
            if (destination.isFile() && destination.exists() && !SystemArchiveUtil.delete(destination)) {
                throw new SystemOperationFailedException("org.eclipse.rse.services", "Could not overwrite directory " + destination);
            }
            if (!destination.exists() && !destination.mkdirs()) {
                throw new SystemOperationFailedException("org.eclipse.rse.services", "Could not overwrite directory " + destination);
            }
        }
        File topFile = destination;
        String topFilePath = topFile.getAbsolutePath().replace('\\', '/');
        String lastPortionOfDir = null;
        int lastSlashIndex = dir.lastIndexOf(47);
        lastPortionOfDir = -1 == lastSlashIndex ? dir : dir.substring(lastSlashIndex + 1);
        if (!topFilePath.endsWith(lastPortionOfDir)) {
            this.rename(dir, topFile.getName(), archiveOperationMonitor);
            dir = topFile.getName();
        }
        if ((newChildren = this.getVirtualChildrenList(dir, archiveOperationMonitor)).length == 0) {
            throw new SystemUnexpectedErrorException("org.eclipse.rse.services");
        }
        this.extractVirtualFile(String.valueOf(dir) + '/', topFile, sourceEncoding, isText, archiveOperationMonitor);
        int i = 0;
        while (i < newChildren.length) {
            String newName = newChildren[i].fullName.substring(charsToTrim);
            char separator = File.separatorChar;
            File nextFile = new File(destinationParent, newName = newName.replace('/', separator));
            if (!nextFile.exists()) {
                if (newChildren[i].isDirectory) {
                    if (!nextFile.mkdirs()) {
                        throw new SystemOperationFailedException("org.eclipse.rse.services", "Could not create folder " + nextFile.toString());
                    }
                } else {
                    this.createFile(nextFile);
                }
                if (newChildren[i].isDirectory) {
                    this.extractVirtualFile(String.valueOf(newChildren[i].fullName) + '/', nextFile, sourceEncoding, isText, archiveOperationMonitor);
                } else {
                    this.extractVirtualFile(newChildren[i].fullName, nextFile, sourceEncoding, isText, archiveOperationMonitor);
                }
            }
            ++i;
        }
    }

    protected void createFile(File file) throws SystemMessageException {
        try {
            if (!file.createNewFile()) {
                throw new SystemOperationFailedException("org.eclipse.rse.services", "File already exists: " + file.toString());
            }
            return;
        }
        catch (IOException iOException) {
            if (file.getParentFile().exists() || !file.getParentFile().mkdirs()) {
                throw new SystemOperationFailedException("org.eclipse.rse.services", "Could not create " + file.toString());
            }
            this.createFile(file);
            return;
        }
    }

    public void add(File file, String virtualPath, String name, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        this.add(file, virtualPath, name, SystemEncodingUtil.ENCODING_UTF_8, SystemEncodingUtil.ENCODING_UTF_8, false, archiveOperationMonitor);
    }

    public void add(InputStream stream, String virtualPath, String name, String sourceEncoding, String targetEncoding, boolean isText, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        block12: {
            if (!this._exists) {
                throw new SystemUnexpectedErrorException("org.eclipse.rse.services");
            }
            if (this.exists(String.valueOf(virtualPath = ArchiveHandlerManager.cleanUpVirtualPath(virtualPath)) + "/" + name, archiveOperationMonitor)) {
                this.replace(String.valueOf(virtualPath) + "/" + name, stream, name, sourceEncoding, targetEncoding, isText, archiveOperationMonitor);
            }
            int mutexLockStatus = 0;
            try {
                try {
                    mutexLockStatus = this._mutex.waitForLock(archiveOperationMonitor, Long.MAX_VALUE);
                    if (mutexLockStatus != 0) {
                        if (!this.openZipFile()) break block12;
                        virtualPath = ArchiveHandlerManager.cleanUpVirtualPath(virtualPath);
                        try {
                            boolean isCancelled;
                            File outputTempFile = new File(String.valueOf(this._file.getAbsolutePath()) + "temp");
                            ZipOutputStream dest = new ZipOutputStream(new FileOutputStream(outputTempFile));
                            dest.setMethod(8);
                            VirtualChild[] vcList = this.getVirtualChildrenList(false, archiveOperationMonitor);
                            if ((vcList.length != 1 || !vcList[0].fullName.equals("")) && (isCancelled = this.recreateZipDeleteEntries(vcList, dest, null, archiveOperationMonitor))) {
                                dest.close();
                                if (outputTempFile != null) {
                                    outputTempFile.delete();
                                }
                                this.closeZipFile();
                                throw new SystemOperationCancelledException();
                            }
                            ZipEntry newEntry = this.appendBytes(stream, dest, virtualPath, name, sourceEncoding, targetEncoding, isText);
                            this.fillBranch(newEntry);
                            dest.close();
                            this.replaceOldZip(outputTempFile);
                        }
                        catch (IOException e) {
                            this.closeZipFile();
                            throw new SystemOperationFailedException("org.eclipse.rse.services", "Could not add a file.", e);
                        }
                        this.closeZipFile();
                        break block12;
                    }
                    throw new SystemLockTimeoutException("org.eclipse.rse.services");
                }
                catch (Exception e) {
                    throw new SystemOperationFailedException("org.eclipse.rse.services", e);
                }
            }
            finally {
                this.releaseMutex(mutexLockStatus);
            }
        }
    }

    public void add(File[] files, String virtualPath, String[] names, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        String[] encodings = new String[files.length];
        boolean[] isTexts = new boolean[files.length];
        int i = 0;
        while (i < files.length) {
            encodings[i] = SystemEncodingUtil.ENCODING_UTF_8;
            isTexts[i] = false;
            ++i;
        }
        this.add(files, virtualPath, names, encodings, encodings, isTexts, true, archiveOperationMonitor);
    }

    public void add(File[] files, String virtualPath, String[] names, String[] sourceEncodings, String[] targetEncodings, boolean[] isText, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        this.add(files, virtualPath, names, sourceEncodings, targetEncodings, isText, true, archiveOperationMonitor);
    }

    public void add(File[] files, String virtualPath, String[] names, String[] sourceEncodings, String[] targetEncodings, boolean[] isText, boolean closeZipFile, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        block21: {
            if (!this._exists) {
                throw new SystemUnexpectedErrorException("org.eclipse.rse.services");
            }
            int mutexLockStatus = 0;
            try {
                try {
                    mutexLockStatus = this._mutex.waitForLock(archiveOperationMonitor, Long.MAX_VALUE);
                    if (mutexLockStatus != 0) {
                        if (this.openZipFile()) {
                            boolean isCancelled;
                            virtualPath = ArchiveHandlerManager.cleanUpVirtualPath(virtualPath);
                            int numFiles = files.length;
                            int i = 0;
                            while (i < numFiles) {
                                if (archiveOperationMonitor != null && archiveOperationMonitor.isCancelled()) {
                                    this.closeZipFile();
                                    throw new SystemOperationCancelledException();
                                }
                                if (!files[i].exists() || !files[i].canRead()) {
                                    throw new SystemOperationFailedException("org.eclipse.rse.services", "Cannot read: " + files[i]);
                                }
                                String fullVirtualName = SystemZipHandler.getFullVirtualName(virtualPath, names[i]);
                                if (this.exists(fullVirtualName, archiveOperationMonitor)) {
                                    this.replace(fullVirtualName, files[i], names[i], archiveOperationMonitor);
                                }
                                ++i;
                            }
                            File outputTempFile = new File(String.valueOf(this._file.getAbsolutePath()) + "temp");
                            ZipOutputStream dest = new ZipOutputStream(new FileOutputStream(outputTempFile));
                            dest.setMethod(8);
                            VirtualChild[] vcList = this.getVirtualChildrenList(false, archiveOperationMonitor);
                            if ((vcList.length != 1 || !vcList[0].fullName.equals("")) && (isCancelled = this.recreateZipDeleteEntries(vcList, dest, null, archiveOperationMonitor))) {
                                dest.close();
                                if (outputTempFile != null) {
                                    outputTempFile.delete();
                                }
                                if (closeZipFile) {
                                    this.closeZipFile();
                                }
                                throw new SystemOperationCancelledException();
                            }
                            ZipEntry[] newEntriesAdded = new ZipEntry[numFiles];
                            int i2 = 0;
                            while (i2 < numFiles) {
                                ZipEntry newEntry;
                                if (archiveOperationMonitor != null && archiveOperationMonitor.isCancelled()) {
                                    dest.close();
                                    if (outputTempFile != null) {
                                        outputTempFile.delete();
                                    }
                                    this.closeZipFile();
                                    throw new SystemOperationCancelledException();
                                }
                                newEntriesAdded[i2] = newEntry = this.appendFile(files[i2], dest, virtualPath, names[i2], sourceEncodings[i2], targetEncodings[i2], isText[i2]);
                                ++i2;
                            }
                            dest.close();
                            this.replaceOldZip(outputTempFile);
                            i2 = 0;
                            while (i2 < numFiles) {
                                this.fillBranch(newEntriesAdded[i2]);
                                ++i2;
                            }
                            if (closeZipFile) {
                                this.closeZipFile();
                            }
                        }
                        break block21;
                    }
                    throw new SystemLockTimeoutException("org.eclipse.rse.services");
                }
                catch (IOException ioe) {
                    throw new SystemOperationFailedException("org.eclipse.rse.services", (Exception)ioe);
                }
            }
            finally {
                if (closeZipFile) {
                    this.closeZipFile();
                }
                this.releaseMutex(mutexLockStatus);
            }
        }
    }

    public static boolean listAllFiles(File parent, HashSet found, ISystemOperationMonitor archiveOperationMonitor) {
        File[] children = parent.listFiles();
        if (children == null) {
            found.remove(parent);
            return false;
        }
        int i = 0;
        while (i < children.length) {
            if (archiveOperationMonitor != null && archiveOperationMonitor.isCancelled()) {
                return true;
            }
            if (!found.contains(children[i]) && children[i].canRead()) {
                found.add(children[i]);
                if (children[i].isDirectory()) {
                    SystemZipHandler.listAllFiles(children[i], found, archiveOperationMonitor);
                }
            }
            ++i;
        }
        return false;
    }

    protected boolean recreateZipDeleteEntries(VirtualChild[] vcList, ZipOutputStream dest, HashSet omitChildren, ISystemOperationMonitor archiveOperationMonitor) throws IOException {
        if (omitChildren != null && vcList.length == omitChildren.size()) {
            ZipEntry entry = new ZipEntry("/");
            dest.putNextEntry(entry);
            dest.closeEntry();
            return false;
        }
        int i = 0;
        while (i < vcList.length) {
            if (archiveOperationMonitor != null && archiveOperationMonitor.isCancelled()) {
                return true;
            }
            if (omitChildren == null || !omitChildren.contains(vcList[i].fullName)) {
                ZipEntry nextEntry;
                if (vcList[i].isDirectory) {
                    nextEntry = this.safeGetEntry(String.valueOf(vcList[i].fullName) + "/");
                    dest.putNextEntry(nextEntry);
                    dest.closeEntry();
                } else {
                    nextEntry = this.safeGetEntry(vcList[i].fullName);
                    BufferedInputStream source = new BufferedInputStream(this._zipfile.getInputStream(nextEntry));
                    nextEntry.setCompressedSize(-1L);
                    dest.putNextEntry(nextEntry);
                    byte[] buf = new byte[1024];
                    int numRead = source.read(buf);
                    while (numRead > 0) {
                        dest.write(buf, 0, numRead);
                        numRead = source.read(buf);
                    }
                    dest.closeEntry();
                    source.close();
                }
            }
            ++i;
        }
        return false;
    }

    protected boolean recreateZipRenameEntries(VirtualChild[] vcList, ZipOutputStream dest, HashMap names, ISystemOperationMonitor archiveOperationMonitor) throws IOException {
        int i = 0;
        while (i < vcList.length) {
            ZipEntry newEntry;
            ZipEntry nextEntry;
            if (archiveOperationMonitor != null && archiveOperationMonitor.isCancelled()) {
                return true;
            }
            if (names.containsKey(vcList[i].getArchiveStandardName())) {
                String oldName = vcList[i].getArchiveStandardName();
                String newName = (String)names.get(oldName);
                vcList[i].renameTo(newName);
                nextEntry = this.safeGetEntry(oldName);
                newEntry = this.createSafeZipEntry(newName);
                newEntry.setComment(nextEntry.getComment());
                newEntry.setExtra(nextEntry.getExtra());
                newEntry.setTime(nextEntry.getTime());
            } else {
                newEntry = nextEntry = this.safeGetEntry(vcList[i].getArchiveStandardName());
            }
            if (nextEntry.isDirectory()) {
                dest.putNextEntry(newEntry);
                dest.closeEntry();
            } else {
                BufferedInputStream source = new BufferedInputStream(this._zipfile.getInputStream(nextEntry));
                newEntry.setCompressedSize(-1L);
                dest.putNextEntry(newEntry);
                byte[] buf = new byte[1024];
                int numRead = source.read(buf);
                while (numRead > 0) {
                    dest.write(buf, 0, numRead);
                    numRead = source.read(buf);
                }
                dest.closeEntry();
                source.close();
            }
            ++i;
        }
        return false;
    }

    protected ZipEntry appendFile(File file, ZipOutputStream dest, String virtualPath, String name, String sourceEncoding, String targetEncoding, boolean isText) throws IOException {
        ZipEntry newEntry;
        if (file.isDirectory()) {
            String fullName = String.valueOf(virtualPath) + "/" + name;
            if (!fullName.endsWith("/")) {
                fullName = String.valueOf(fullName) + "/";
            }
            newEntry = this.createSafeZipEntry(fullName);
        } else {
            newEntry = this.createSafeZipEntry(String.valueOf(virtualPath) + "/" + name);
        }
        newEntry.setTime(file.lastModified());
        dest.putNextEntry(newEntry);
        if (!file.isDirectory()) {
            BufferedInputStream source = new BufferedInputStream(new FileInputStream(file));
            byte[] buf = new byte[1024];
            int numRead = source.read(buf);
            long fileSize = file.length();
            long totalRead = 0L;
            while (numRead > 0 && totalRead < fileSize) {
                totalRead += (long)numRead;
                if (isText) {
                    String bufString = new String(buf, 0, numRead, sourceEncoding);
                    byte[] convertedBuf = bufString.getBytes(targetEncoding);
                    int newSize = convertedBuf.length;
                    dest.write(convertedBuf, 0, newSize);
                } else {
                    dest.write(buf, 0, numRead);
                }
                long maxRead = 1024L;
                long deltaLeft = fileSize - totalRead;
                numRead = deltaLeft > 1024L ? source.read(buf, 0, (int)maxRead) : source.read(buf, 0, (int)deltaLeft);
            }
            dest.closeEntry();
            source.close();
        }
        return newEntry;
    }

    protected ZipEntry appendBytes(InputStream stream, ZipOutputStream dest, String virtualPath, String name, String sourceEncoding, String targetEncoding, boolean isText) throws IOException {
        ZipEntry newEntry = this.createSafeZipEntry(String.valueOf(virtualPath) + "/" + name);
        dest.putNextEntry(newEntry);
        BufferedInputStream source = new BufferedInputStream(stream);
        byte[] buf = new byte[1024];
        int numRead = source.read(buf);
        long totalRead = 0L;
        while (numRead > 0 && source.available() > 0) {
            totalRead += (long)numRead;
            if (isText) {
                String bufString = new String(buf, 0, numRead, sourceEncoding);
                byte[] convertedBuf = bufString.getBytes(targetEncoding);
                int newSize = convertedBuf.length;
                dest.write(convertedBuf, 0, newSize);
            } else {
                dest.write(buf, 0, numRead);
            }
            long maxRead = 1024L;
            long deltaLeft = source.available();
            numRead = deltaLeft > 1024L ? source.read(buf, 0, (int)maxRead) : source.read(buf, 0, (int)deltaLeft);
        }
        dest.closeEntry();
        source.close();
        return newEntry;
    }

    protected void replaceOldZip(File outputTempFile) throws IOException {
        String oldName = this._file.getAbsolutePath();
        this._zipfile.close();
        File oldFile = new File(String.valueOf(oldName) + "old");
        if (!this._file.renameTo(oldFile)) {
            throw new IOException("Failed to rename " + oldFile);
        }
        if (!outputTempFile.renameTo(this._file)) {
            throw new IOException("Failed to rename " + this._file);
        }
        this._vfsLastModified = this._file.lastModified();
        this._zipfile = new ZipFile(this._file);
        oldFile.delete();
    }

    public boolean delete(String fullVirtualName, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        boolean returnCode = this.delete(fullVirtualName, true, archiveOperationMonitor);
        this.setArchiveOperationMonitorStatusDone(archiveOperationMonitor);
        return returnCode;
    }

    public boolean delete(String fullVirtualName, boolean closeZipFile, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        block25: {
            if (!this._exists) {
                return false;
            }
            File outputTempFile = null;
            int mutexLockStatus = 0;
            try {
                mutexLockStatus = this._mutex.waitForLock(archiveOperationMonitor, Long.MAX_VALUE);
                if (mutexLockStatus != 0) {
                    if (this.openZipFile()) {
                        fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
                        VirtualChild vc = this.getVirtualFile(fullVirtualName, archiveOperationMonitor);
                        VirtualChild[] vcOmmit = new VirtualChild[1];
                        if (!vc.exists()) {
                            if (closeZipFile) {
                                this.closeZipFile();
                            }
                            return false;
                        }
                        if (vc.isDirectory) {
                            vcOmmit = this.getVirtualChildrenList(fullVirtualName, false, archiveOperationMonitor);
                        }
                        outputTempFile = new File(String.valueOf(this._file.getAbsolutePath()) + "temp");
                        ZipOutputStream dest = new ZipOutputStream(new FileOutputStream(outputTempFile));
                        dest.setMethod(8);
                        VirtualChild[] vcList = this.getVirtualChildrenList(false, archiveOperationMonitor);
                        HashSet<String> omissions = new HashSet<String>();
                        if (vc.isDirectory) {
                            int i = 0;
                            while (i < vcOmmit.length) {
                                omissions.add(vcOmmit[i].fullName);
                                ++i;
                            }
                            try {
                                this.safeGetEntry(vc.fullName);
                                omissions.add(vc.fullName);
                            }
                            catch (IOException iOException) {}
                        } else {
                            omissions.add(fullVirtualName);
                        }
                        boolean isCancelled = this.recreateZipDeleteEntries(vcList, dest, omissions, archiveOperationMonitor);
                        if (isCancelled) {
                            dest.close();
                            if (outputTempFile != null) {
                                outputTempFile.delete();
                            }
                            if (closeZipFile) {
                                this.closeZipFile();
                            }
                            throw new SystemOperationCancelledException();
                        }
                        dest.close();
                        this.replaceOldZip(outputTempFile);
                        HashMap hm = (HashMap)this._virtualFS.get(vc.path);
                        hm.remove(vc.name);
                        if (vc.isDirectory) {
                            this.delTree(vc);
                        }
                        if (closeZipFile) {
                            this.closeZipFile();
                        }
                        this.setArchiveOperationMonitorStatusDone(archiveOperationMonitor);
                        return true;
                    }
                    break block25;
                }
                try {
                    throw new SystemLockTimeoutException("org.eclipse.rse.services");
                }
                catch (IOException e) {
                    if (outputTempFile != null) {
                        outputTempFile.delete();
                    }
                    if (closeZipFile) {
                        this.closeZipFile();
                    }
                    throw new SystemOperationFailedException("org.eclipse.rse.services", "Could not delete " + fullVirtualName, e);
                }
            }
            finally {
                this.releaseMutex(mutexLockStatus);
            }
        }
        this.setArchiveOperationMonitorStatusDone(archiveOperationMonitor);
        return false;
    }

    protected void delTree(VirtualChild vc) {
        HashMap hm = (HashMap)this._virtualFS.get(vc.fullName);
        Object[] children = hm.values().toArray();
        int i = 0;
        while (i < children.length) {
            VirtualChild next = (VirtualChild)children[i];
            hm.remove(next.name);
            if (next.isDirectory) {
                this.delTree(next);
            }
            ++i;
        }
    }

    public void replace(String fullVirtualName, File file, String name, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        this.replace(fullVirtualName, file, name, true, archiveOperationMonitor);
    }

    public void replace(String fullVirtualName, File file, String name, boolean closeZipFile, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        if (!this._exists) {
            throw new SystemUnexpectedErrorException("org.eclipse.rse.services");
        }
        if (!file.exists() || !file.canRead()) {
            throw new SystemOperationFailedException("org.eclipse.rse.services", "Cannot read: " + file);
        }
        if (!this.exists(fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName), archiveOperationMonitor)) {
            this.add(file, fullVirtualName, name, archiveOperationMonitor);
        }
        File outputTempFile = null;
        try {
            this.openZipFile();
            outputTempFile = new File(String.valueOf(this._file.getAbsolutePath()) + "temp");
            ZipOutputStream dest = new ZipOutputStream(new FileOutputStream(outputTempFile));
            dest.setMethod(8);
            VirtualChild[] vcList = this.getVirtualChildrenList(false, archiveOperationMonitor);
            HashSet<String> omissions = new HashSet<String>();
            omissions.add(fullVirtualName);
            boolean isCancelled = this.recreateZipDeleteEntries(vcList, dest, omissions, archiveOperationMonitor);
            if (isCancelled) {
                dest.close();
                if (outputTempFile != null) {
                    outputTempFile.delete();
                }
                if (closeZipFile) {
                    this.closeZipFile();
                }
                throw new SystemOperationCancelledException();
            }
            int i = fullVirtualName.lastIndexOf("/");
            String virtualPath = i == -1 ? "" : fullVirtualName.substring(0, i);
            ZipEntry newEntry = this.appendFile(file, dest, virtualPath, name, SystemEncodingUtil.ENCODING_UTF_8, SystemEncodingUtil.ENCODING_UTF_8, false);
            this.fillBranch(newEntry);
            dest.close();
            this.replaceOldZip(outputTempFile);
        }
        catch (IOException e) {
            if (outputTempFile != null) {
                outputTempFile.delete();
            }
            if (closeZipFile) {
                this.closeZipFile();
            }
            throw new SystemOperationFailedException("org.eclipse.rse.services", "Could not replace " + file.getName(), e);
        }
        if (closeZipFile) {
            this.closeZipFile();
        }
    }

    public void replace(String fullVirtualName, InputStream stream, String name, String sourceEncoding, String targetEncoding, boolean isText, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        if (!this._exists) {
            throw new SystemUnexpectedErrorException("org.eclipse.rse.services");
        }
        if (!this.exists(fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName), archiveOperationMonitor)) {
            this.add(stream, fullVirtualName, name, sourceEncoding, targetEncoding, isText, archiveOperationMonitor);
        }
        File outputTempFile = null;
        try {
            this.openZipFile();
            outputTempFile = new File(String.valueOf(this._file.getAbsolutePath()) + "temp");
            ZipOutputStream dest = new ZipOutputStream(new FileOutputStream(outputTempFile));
            dest.setMethod(8);
            VirtualChild[] vcList = this.getVirtualChildrenList(false, archiveOperationMonitor);
            HashSet<String> omissions = new HashSet<String>();
            omissions.add(fullVirtualName);
            boolean isCancelled = this.recreateZipDeleteEntries(vcList, dest, omissions, archiveOperationMonitor);
            if (isCancelled) {
                dest.close();
                if (outputTempFile != null) {
                    outputTempFile.delete();
                }
                this.closeZipFile();
                throw new SystemOperationCancelledException();
            }
            int i = fullVirtualName.lastIndexOf("/");
            String virtualPath = i == -1 ? "" : fullVirtualName.substring(0, i);
            this.appendBytes(stream, dest, virtualPath, name, sourceEncoding, targetEncoding, isText);
            dest.close();
            this.replaceOldZip(outputTempFile);
        }
        catch (IOException e) {
            if (outputTempFile != null) {
                outputTempFile.delete();
            }
            this.closeZipFile();
            throw new SystemOperationFailedException("org.eclipse.rse.services", "Could not replace " + fullVirtualName, e);
        }
        this.closeZipFile();
    }

    public void fullRename(String fullVirtualName, String newFullVirtualName, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        this.fullRename(fullVirtualName, newFullVirtualName, true, archiveOperationMonitor);
    }

    public void fullRename(String fullVirtualName, String newFullVirtualName, boolean closeZipFile, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        block19: {
            if (!this._exists) {
                throw new SystemUnexpectedErrorException("org.eclipse.rse.services");
            }
            fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
            newFullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(newFullVirtualName);
            VirtualChild vc = this.getVirtualFile(fullVirtualName, archiveOperationMonitor);
            if (!vc.exists()) {
                throw new SystemOperationFailedException("org.eclipse.rse.services", "The virtual file " + fullVirtualName + " does not exist.");
            }
            File outputTempFile = null;
            int mutexLockStatus = 0;
            try {
                try {
                    mutexLockStatus = this._mutex.waitForLock(archiveOperationMonitor, Long.MAX_VALUE);
                    if (mutexLockStatus != 0) {
                        outputTempFile = new File(String.valueOf(this._file.getAbsolutePath()) + "temp");
                        ZipOutputStream dest = new ZipOutputStream(new FileOutputStream(outputTempFile));
                        dest.setMethod(8);
                        VirtualChild[] vcList = this.getVirtualChildrenList(false, archiveOperationMonitor);
                        VirtualChild[] renameList = null;
                        HashMap<String, String> oldNewNames = new HashMap<String, String>();
                        HashMap<String, String> newOldNames = new HashMap<String, String>();
                        if (vc.isDirectory) {
                            renameList = this.getVirtualChildrenList(fullVirtualName, false, archiveOperationMonitor);
                            int i = 0;
                            while (i < renameList.length) {
                                int j = fullVirtualName.length();
                                String suffix = renameList[i].fullName.substring(j);
                                String newName = String.valueOf(newFullVirtualName) + suffix;
                                if (renameList[i].isDirectory) {
                                    newName = String.valueOf(newName) + "/";
                                    oldNewNames.put(String.valueOf(renameList[i].fullName) + "/", newName);
                                    newOldNames.put(newName, String.valueOf(renameList[i].fullName) + "/");
                                } else {
                                    oldNewNames.put(renameList[i].fullName, newName);
                                    newOldNames.put(newName, renameList[i].fullName);
                                }
                                ++i;
                            }
                            oldNewNames.put(String.valueOf(fullVirtualName) + "/", String.valueOf(newFullVirtualName) + "/");
                            newOldNames.put(String.valueOf(newFullVirtualName) + "/", String.valueOf(fullVirtualName) + "/");
                        } else {
                            oldNewNames.put(fullVirtualName, newFullVirtualName);
                            newOldNames.put(newFullVirtualName, fullVirtualName);
                        }
                        boolean isCancelled = this.recreateZipRenameEntries(vcList, dest, oldNewNames, archiveOperationMonitor);
                        dest.close();
                        if (isCancelled) {
                            if (outputTempFile != null) {
                                outputTempFile.delete();
                            }
                            if (closeZipFile) {
                                this.closeZipFile();
                            }
                            throw new SystemOperationCancelledException();
                        }
                        this.replaceOldZip(outputTempFile);
                        this.updateTreeAfterRename(newOldNames, renameList);
                        if (closeZipFile) {
                            this.closeZipFile();
                        }
                        break block19;
                    }
                    throw new SystemLockTimeoutException("org.eclipse.rse.services");
                }
                catch (IOException e) {
                    if (outputTempFile != null) {
                        outputTempFile.delete();
                    }
                    if (closeZipFile) {
                        this.closeZipFile();
                    }
                    throw new SystemOperationFailedException("org.eclipse.rse.services", "Could not rename " + fullVirtualName, e);
                }
            }
            finally {
                this.releaseMutex(mutexLockStatus);
            }
        }
    }

    public void move(String fullVirtualName, String destinationVirtualPath, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
        destinationVirtualPath = ArchiveHandlerManager.cleanUpVirtualPath(destinationVirtualPath);
        int i = fullVirtualName.lastIndexOf("/");
        if (i == -1) {
            this.fullRename(fullVirtualName, String.valueOf(destinationVirtualPath) + "/" + fullVirtualName, archiveOperationMonitor);
        }
        String name = fullVirtualName.substring(i);
        this.fullRename(fullVirtualName, String.valueOf(destinationVirtualPath) + name, archiveOperationMonitor);
    }

    public void rename(String fullVirtualName, String newName, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        int i = (fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName)).lastIndexOf("/");
        if (i == -1) {
            this.fullRename(fullVirtualName, newName, archiveOperationMonitor);
        } else {
            String fullNewName = String.valueOf(fullVirtualName.substring(0, i + 1)) + newName;
            this.fullRename(fullVirtualName, fullNewName, archiveOperationMonitor);
            this.setArchiveOperationMonitorStatusDone(archiveOperationMonitor);
        }
    }

    public File[] getFiles(String[] fullNames, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        if (!this._exists) {
            return new File[0];
        }
        File[] files = new File[fullNames.length];
        int i = 0;
        while (i < fullNames.length) {
            String fullName = fullNames[i];
            int j = (fullName = ArchiveHandlerManager.cleanUpVirtualPath(fullName)).lastIndexOf("/");
            String name = j == -1 ? fullName : fullName.substring(j + 1);
            try {
                files[i] = File.createTempFile(name, "virtual");
                files[i].deleteOnExit();
                this.extractVirtualFile(fullNames[i], files[i], archiveOperationMonitor);
            }
            catch (IOException e) {
                throw new SystemOperationFailedException("org.eclipse.rse.services", "Could not extract virtual file: " + fullNames[i], e);
            }
            ++i;
        }
        return files;
    }

    public void createFolder(String name, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        name = ArchiveHandlerManager.cleanUpVirtualPath(name);
        name = String.valueOf(name) + "/";
        this.createVirtualObject(name, true, archiveOperationMonitor);
        this.setArchiveOperationMonitorStatusDone(archiveOperationMonitor);
    }

    public void createFile(String name, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        name = ArchiveHandlerManager.cleanUpVirtualPath(name);
        this.createVirtualObject(name, true, archiveOperationMonitor);
        this.setArchiveOperationMonitorStatusDone(archiveOperationMonitor);
    }

    protected boolean createVirtualObject(String name, boolean closeZipFile, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        block15: {
            if (!this._exists) {
                throw new SystemUnexpectedErrorException("org.eclipse.rse.services");
            }
            if (this.exists(name, archiveOperationMonitor)) {
                return false;
            }
            int mutexLockStatus = 0;
            try {
                mutexLockStatus = this._mutex.waitForLock(archiveOperationMonitor, Long.MAX_VALUE);
                if (mutexLockStatus != 0) {
                    if (this.openZipFile()) {
                        boolean isCancelled;
                        File outputTempFile = new File(String.valueOf(this._file.getAbsolutePath()) + "temp");
                        ZipOutputStream dest = new ZipOutputStream(new FileOutputStream(outputTempFile));
                        dest.setMethod(8);
                        VirtualChild[] vcList = this.getVirtualChildrenList(false, archiveOperationMonitor);
                        if ((vcList.length != 1 || !vcList[0].fullName.equals("")) && (isCancelled = this.recreateZipDeleteEntries(vcList, dest, null, archiveOperationMonitor))) {
                            dest.close();
                            if (outputTempFile != null) {
                                outputTempFile.delete();
                            }
                            if (closeZipFile) {
                                this.closeZipFile();
                            }
                            throw new SystemOperationCancelledException();
                        }
                        ZipEntry newEntry = this.appendEmptyFile(dest, name);
                        this.fillBranch(newEntry);
                        dest.close();
                        this.replaceOldZip(outputTempFile);
                        if (closeZipFile) {
                            this.closeZipFile();
                        }
                        return true;
                    }
                    break block15;
                }
                try {
                    throw new SystemLockTimeoutException("org.eclipse.rse.services");
                }
                catch (IOException e) {
                    System.out.println();
                    System.out.println(e.getMessage());
                    if (closeZipFile) {
                        this.closeZipFile();
                    }
                    throw new SystemOperationFailedException("org.eclipse.rse.services", "Could not add a file.", e);
                }
            }
            finally {
                this.releaseMutex(mutexLockStatus);
            }
        }
        return false;
    }

    protected ZipEntry appendEmptyFile(ZipOutputStream dest, String name) throws IOException {
        boolean isDirectory = name.endsWith("/");
        ZipEntry newEntry = this.createSafeZipEntry(name);
        dest.putNextEntry(newEntry);
        if (!isDirectory) {
            dest.write(new byte[0], 0, 0);
            dest.closeEntry();
        }
        return newEntry;
    }

    protected ZipEntry createSafeZipEntry(String name) {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        return new ZipEntry(name);
    }

    public String getStandardName(VirtualChild vc) {
        if (vc.isDirectory) {
            return String.valueOf(vc.fullName) + "/";
        }
        return vc.fullName;
    }

    protected boolean openZipFile() throws IOException {
        if (this._zipfile != null) {
            this.closeZipFile();
        }
        this._zipfile = new ZipFile(this._file);
        return true;
    }

    protected boolean closeZipFile() {
        try {
            this._zipfile.close();
        }
        catch (IOException e) {
            System.out.println("Could not close zipfile: " + this._file);
            System.out.println(e.getMessage());
            return false;
        }
        return true;
    }

    protected boolean updateVirtualFSIfNecessary(ISystemOperationMonitor archiveOperationMonitor) {
        if (this._vfsLastModified != this._file.lastModified()) {
            int mutexLockStatus = 0;
            try {
                mutexLockStatus = this._mutex.waitForLock(archiveOperationMonitor, Long.MAX_VALUE);
                if (mutexLockStatus != 0) {
                    if (this.openZipFile()) {
                        this.buildTree();
                        this._vfsLastModified = this._file.lastModified();
                        this.closeZipFile();
                        return true;
                    }
                    return false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.closeZipFile();
            }
            finally {
                this.releaseMutex(mutexLockStatus);
            }
        }
        return true;
    }

    protected ZipEntry safeGetEntry(String name) throws IOException {
        ZipEntry entry = this._zipfile.getEntry(name);
        if (entry == null) {
            entry = this._zipfile.getEntry("/" + name);
        }
        if (entry == null) {
            throw new IOException("SystemZipHandler.safeGetEntry(): The ZipEntry " + name + " cannot be found in " + this._file.toString());
        }
        return entry;
    }

    public void create() throws SystemMessageException {
        try {
            ZipOutputStream dest = new ZipOutputStream(new FileOutputStream(this._file));
            dest.setMethod(8);
            VirtualChild[] vcList = new VirtualChild[]{};
            HashSet omissions = new HashSet();
            this.recreateZipDeleteEntries(vcList, dest, omissions, null);
            dest.close();
            this.openZipFile();
            this.buildTree();
            this.closeZipFile();
        }
        catch (IOException e) {
            throw new SystemOperationFailedException("org.eclipse.rse.services", (Exception)e);
        }
        this._exists = true;
    }

    public SystemSearchLineMatch[] search(String fullVirtualName, SystemSearchStringMatcher matcher, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        if (matcher.isSearchStringEmpty() || matcher.isSearchStringAsterisk()) {
            return new SystemSearchLineMatch[0];
        }
        VirtualChild vc = this.getVirtualFile(fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName), archiveOperationMonitor);
        if (!vc.exists() || vc.isDirectory) {
            return new SystemSearchLineMatch[0];
        }
        ZipEntry entry = null;
        SystemSearchLineMatch[] matches = null;
        try {
            this.openZipFile();
            entry = this.safeGetEntry(fullVirtualName);
            InputStream is = this._zipfile.getInputStream(entry);
            if (is == null) {
                return new SystemSearchLineMatch[0];
            }
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader bufReader = new BufferedReader(isr);
            SystemSearchStringMatchLocator locator = new SystemSearchStringMatchLocator(bufReader, matcher);
            matches = locator.locateMatches();
        }
        catch (IOException e) {
            throw new SystemOperationFailedException("org.eclipse.rse.services", (Exception)e);
        }
        this.closeZipFile();
        if (matches == null) {
            return new SystemSearchLineMatch[0];
        }
        return matches;
    }

    public boolean exists() {
        return this._exists;
    }

    public String getCommentFor(String fullVirtualName) throws SystemMessageException {
        return this.getCommentFor(fullVirtualName, true);
    }

    public String getCommentFor(String fullVirtualName, boolean closeZipFile) throws SystemMessageException {
        String comment;
        if (!this._exists) {
            return "";
        }
        ZipEntry entry = null;
        try {
            this.openZipFile();
            fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
            entry = this.safeGetEntry(fullVirtualName);
        }
        catch (IOException e) {
            if (closeZipFile) {
                this.closeZipFile();
            }
            throw new SystemOperationFailedException("org.eclipse.rse.services", (Exception)e);
        }
        if (closeZipFile) {
            this.closeZipFile();
        }
        if ((comment = entry.getComment()) == null) {
            return "";
        }
        return comment;
    }

    public long getCompressedSizeFor(String fullVirtualName) throws SystemMessageException {
        return this.getCompressedSizeFor(fullVirtualName, true);
    }

    public long getCompressedSizeFor(String fullVirtualName, boolean closeZipFile) throws SystemMessageException {
        if (!this._exists) {
            return 0L;
        }
        ZipEntry entry = null;
        try {
            this.openZipFile();
            fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
            entry = this.safeGetEntry(fullVirtualName);
        }
        catch (IOException e) {
            if (closeZipFile) {
                this.closeZipFile();
            }
            throw new SystemOperationFailedException("org.eclipse.rse.services", (Exception)e);
        }
        if (closeZipFile) {
            this.closeZipFile();
        }
        return entry.getCompressedSize();
    }

    public String getCompressionMethodFor(String fullVirtualName) throws SystemMessageException {
        return this.getCompressionMethodFor(fullVirtualName, true);
    }

    public String getCompressionMethodFor(String fullVirtualName, boolean closeZipFile) throws SystemMessageException {
        if (!this._exists) {
            return "";
        }
        ZipEntry entry = null;
        try {
            this.openZipFile();
            fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
            entry = this.safeGetEntry(fullVirtualName);
        }
        catch (IOException e) {
            if (closeZipFile) {
                this.closeZipFile();
            }
            throw new SystemOperationFailedException("org.eclipse.rse.services", (Exception)e);
        }
        if (closeZipFile) {
            this.closeZipFile();
        }
        return new Integer(entry.getMethod()).toString();
    }

    public String getArchiveComment() {
        return "";
    }

    public String getClassification(String fullVirtualName) throws SystemMessageException {
        return this.getClassification(fullVirtualName, true);
    }

    public String getClassification(String fullVirtualName, boolean closeZipFile) throws SystemMessageException {
        String type = "file";
        if (!this._exists) {
            return type;
        }
        if (!(fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName)).endsWith(".class")) {
            return type;
        }
        BasicClassFileParser parser = null;
        boolean isExecutable = false;
        InputStream stream = null;
        try {
            this.openZipFile();
            ZipEntry entry = this.safeGetEntry(fullVirtualName);
            stream = this._zipfile.getInputStream(entry);
            parser = new BasicClassFileParser(stream);
            parser.parse();
            isExecutable = parser.isExecutable();
            if (closeZipFile) {
                this.closeZipFile();
            }
        }
        catch (IOException iOException) {
            if (closeZipFile) {
                this.closeZipFile();
            }
            return type;
        }
        if (isExecutable && parser != null) {
            type = "executable(java";
            String qualifiedClassName = parser.getQualifiedClassName();
            if (qualifiedClassName != null) {
                type = String.valueOf(type) + ":" + qualifiedClassName;
            }
            type = String.valueOf(type) + ")";
        }
        return type;
    }

    public void add(File file, String virtualPath, String name, String sourceEncoding, String targetEncoding, ISystemFileTypes registry, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        if (!this._exists) {
            this.setArchiveOperationMonitorStatusDone(archiveOperationMonitor);
            throw new SystemUnexpectedErrorException("org.eclipse.rse.services");
        }
        virtualPath = ArchiveHandlerManager.cleanUpVirtualPath(virtualPath);
        if (!file.isDirectory()) {
            if (this.exists(String.valueOf(virtualPath) + "/" + name, archiveOperationMonitor)) {
                this.replace(String.valueOf(virtualPath) + "/" + name, file, name, archiveOperationMonitor);
                this.setArchiveOperationMonitorStatusDone(archiveOperationMonitor);
                return;
            }
            File[] files = new File[]{file};
            String[] names = new String[]{name};
            String[] sourceEncodings = new String[]{sourceEncoding};
            String[] targetEncodings = new String[]{targetEncoding};
            boolean[] isTexts = new boolean[]{registry.isText(file)};
            this.add(files, virtualPath, names, sourceEncodings, targetEncodings, isTexts, archiveOperationMonitor);
            this.setArchiveOperationMonitorStatusDone(archiveOperationMonitor);
        } else {
            HashSet children = new HashSet();
            boolean isCancelled = SystemZipHandler.listAllFiles(file, children, archiveOperationMonitor);
            if (isCancelled) {
                throw new SystemOperationCancelledException();
            }
            File[] sources = new File[children.size() + 1];
            String[] newNames = new String[children.size() + 1];
            Object[] kids = children.toArray();
            String[] sourceEncodings = new String[children.size() + 1];
            String[] targetEncodings = new String[children.size() + 1];
            boolean[] isTexts = new boolean[children.size() + 1];
            int charsToTrim = file.getParentFile().getAbsolutePath().length() + 1;
            if (file.getParentFile().getAbsolutePath().endsWith(File.separator)) {
                --charsToTrim;
            }
            int i = 0;
            while (i < children.size()) {
                sources[i] = (File)kids[i];
                newNames[i] = sources[i].getAbsolutePath().substring(charsToTrim);
                newNames[i] = newNames[i].replace('\\', '/');
                if (sources[i].isDirectory() && !newNames[i].endsWith("/")) {
                    newNames[i] = String.valueOf(newNames[i]) + "/";
                }
                sourceEncodings[i] = sourceEncoding;
                targetEncodings[i] = targetEncoding;
                isTexts[i] = registry.isText(sources[i]);
                ++i;
            }
            sources[children.size()] = file;
            newNames[children.size()] = name;
            sourceEncodings[children.size()] = sourceEncoding;
            targetEncodings[children.size()] = targetEncoding;
            isTexts[children.size()] = registry.isText(file);
            if (!newNames[children.size()].endsWith("/")) {
                newNames[children.size()] = String.valueOf(newNames[children.size()]) + "/";
            }
            this.add(sources, virtualPath, newNames, sourceEncodings, targetEncodings, isTexts, archiveOperationMonitor);
            this.setArchiveOperationMonitorStatusDone(archiveOperationMonitor);
        }
    }

    public void add(File file, String virtualPath, String name, String sourceEncoding, String targetEncoding, boolean isText, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        block16: {
            if (!this._exists) {
                this.setArchiveOperationMonitorStatusDone(archiveOperationMonitor);
                throw new SystemUnexpectedErrorException("org.eclipse.rse.services");
            }
            virtualPath = ArchiveHandlerManager.cleanUpVirtualPath(virtualPath);
            int mutexLockStatus = 0;
            try {
                try {
                    mutexLockStatus = this._mutex.waitForLock(archiveOperationMonitor, Long.MAX_VALUE);
                    if (mutexLockStatus != 0) {
                        if (!file.isDirectory()) {
                            String fullVirtualName = SystemZipHandler.getFullVirtualName(virtualPath, name);
                            if (this.exists(fullVirtualName, archiveOperationMonitor)) {
                                this.replace(fullVirtualName, file, name, archiveOperationMonitor);
                                this.setArchiveOperationMonitorStatusDone(archiveOperationMonitor);
                            } else {
                                File[] files = new File[]{file};
                                String[] names = new String[]{name};
                                String[] sourceEncodings = new String[]{sourceEncoding};
                                String[] targetEncodings = new String[]{targetEncoding};
                                boolean[] isTexts = new boolean[]{isText};
                                this.add(files, virtualPath, names, sourceEncodings, targetEncodings, isTexts, archiveOperationMonitor);
                                this.setArchiveOperationMonitorStatusDone(archiveOperationMonitor);
                            }
                        } else {
                            HashSet children = new HashSet();
                            boolean isCancelled = SystemZipHandler.listAllFiles(file, children, archiveOperationMonitor);
                            if (isCancelled) {
                                throw new SystemOperationCancelledException();
                            }
                            File[] sources = new File[children.size() + 1];
                            String[] newNames = new String[children.size() + 1];
                            Object[] kids = children.toArray();
                            String[] sourceEncodings = new String[children.size() + 1];
                            String[] targetEncodings = new String[children.size() + 1];
                            boolean[] isTexts = new boolean[children.size() + 1];
                            int charsToTrim = file.getParentFile().getAbsolutePath().length() + 1;
                            if (file.getParentFile().getAbsolutePath().endsWith(File.separator)) {
                                --charsToTrim;
                            }
                            int i = 0;
                            while (i < children.size()) {
                                sources[i] = (File)kids[i];
                                newNames[i] = sources[i].getAbsolutePath().substring(charsToTrim);
                                newNames[i] = newNames[i].replace('\\', '/');
                                if (sources[i].isDirectory() && !newNames[i].endsWith("/")) {
                                    newNames[i] = String.valueOf(newNames[i]) + "/";
                                }
                                sourceEncodings[i] = sourceEncoding;
                                targetEncodings[i] = targetEncoding;
                                isTexts[i] = isText;
                                ++i;
                            }
                            sources[children.size()] = file;
                            newNames[children.size()] = name;
                            sourceEncodings[children.size()] = sourceEncoding;
                            targetEncodings[children.size()] = targetEncoding;
                            isTexts[children.size()] = isText;
                            if (!newNames[children.size()].endsWith("/")) {
                                newNames[children.size()] = String.valueOf(newNames[children.size()]) + "/";
                            }
                            this.add(sources, virtualPath, newNames, sourceEncodings, targetEncodings, isTexts, archiveOperationMonitor);
                            this.setArchiveOperationMonitorStatusDone(archiveOperationMonitor);
                        }
                        break block16;
                    }
                    throw new SystemLockTimeoutException("org.eclipse.rse.services");
                }
                catch (Exception exception) {
                    this.releaseMutex(mutexLockStatus);
                }
            }
            finally {
                this.releaseMutex(mutexLockStatus);
            }
        }
    }

    private static String getFullVirtualName(String virtualPath, String name) {
        String fullVirtualName = null;
        fullVirtualName = virtualPath == null || virtualPath.length() == 0 ? name : String.valueOf(virtualPath) + "/" + name;
        return fullVirtualName;
    }

    private void releaseMutex(int mutexLockStatus) {
        if (1 == mutexLockStatus) {
            this._mutex.release();
        }
    }

    private void setArchiveOperationMonitorStatusDone(ISystemOperationMonitor archiveOperationMonitor) {
        if (archiveOperationMonitor != null && !archiveOperationMonitor.isCancelled()) {
            archiveOperationMonitor.setDone(true);
        }
    }
}

