/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.files;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.eclipse.rse.services.clientserver.SystemEncodingUtil;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.files.IFileServiceCodePageConverter;

public class DefaultFileServiceCodePageConverter
implements IFileServiceCodePageConverter {
    public byte[] convertClientStringToRemoteBytes(String remotePath, String clientString, String remoteEncoding, IFileService fs) {
        try {
            return clientString.getBytes(remoteEncoding);
        }
        catch (Exception exception) {
            return clientString.getBytes();
        }
    }

    public void convertFileFromRemoteEncoding(String remotePath, File file, String remoteEncoding, String localEncoding, IFileService fs) {
        FileInputStream inputStream = null;
        FileOutputStream outStream = null;
        try {
            try {
                Charset rmtCharset = Charset.forName(remoteEncoding);
                CharsetDecoder rmtDecoder = rmtCharset.newDecoder();
                inputStream = new FileInputStream(file);
                int fileLength = (int)file.length();
                BufferedInputStream bufInputStream = new BufferedInputStream(inputStream, fileLength);
                String utf8Encoding = SystemEncodingUtil.ENCODING_UTF_8;
                boolean convertToUFT8 = localEncoding.equalsIgnoreCase(utf8Encoding);
                if (fileLength > 0) {
                    int MAX_READ = 10000;
                    if (fileLength <= MAX_READ) {
                        byte[] buffer = new byte[fileLength];
                        bufInputStream.read(buffer, 0, fileLength);
                        bufInputStream.close();
                        inputStream.close();
                        ByteBuffer rmtBuf = ByteBuffer.wrap(buffer, 0, fileLength);
                        CharBuffer decodedBuf = null;
                        decodedBuf = rmtDecoder.decode(rmtBuf);
                        outStream = new FileOutputStream(file);
                        if (!convertToUFT8) {
                            Charset charset = Charset.forName(localEncoding);
                            CharsetEncoder encoder = charset.newEncoder();
                            byte[] localBuffer = null;
                            ByteBuffer lclBuf = encoder.encode(decodedBuf);
                            localBuffer = lclBuf.array();
                            outStream.write(localBuffer, 0, lclBuf.limit());
                        } else {
                            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outStream, utf8Encoding);
                            writer.write(decodedBuf.array(), 0, decodedBuf.limit());
                            writer.flush();
                        }
                    } else {
                        int inOffset = 0;
                        int outOffset = 0;
                        File altFile = new File(String.valueOf(file.getAbsolutePath()) + "~");
                        outStream = new FileOutputStream(altFile);
                        OutputStreamWriter writer = null;
                        if (convertToUFT8) {
                            writer = new OutputStreamWriter((OutputStream)outStream, utf8Encoding);
                        }
                        while (inOffset < fileLength) {
                            int readSize = MAX_READ;
                            if (inOffset + MAX_READ > fileLength) {
                                readSize = fileLength - inOffset;
                            }
                            byte[] buffer = new byte[readSize];
                            inputStream.read(buffer, 0, readSize);
                            inOffset += readSize;
                            ByteBuffer rmtBuf = ByteBuffer.wrap(buffer, 0, readSize);
                            CharBuffer decodedBuf = null;
                            decodedBuf = rmtDecoder.decode(rmtBuf);
                            if (!convertToUFT8) {
                                Charset charset = Charset.forName(localEncoding);
                                CharsetEncoder encoder = charset.newEncoder();
                                byte[] localBuffer = null;
                                ByteBuffer lclBuf = encoder.encode(decodedBuf);
                                localBuffer = lclBuf.array();
                                int writeSize = lclBuf.limit();
                                outStream.write(localBuffer, 0, writeSize);
                                outOffset += writeSize;
                                continue;
                            }
                            writer.write(decodedBuf.array(), 0, decodedBuf.limit());
                            writer.flush();
                        }
                        inputStream.close();
                        outStream.close();
                        if (!altFile.renameTo(file) && file.exists()) {
                            file.delete();
                            altFile.renameTo(file);
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (outStream != null) {
            try {
                outStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public boolean isServerEncodingSupported(String remoteEncoding, IFileService fs) {
        return true;
    }

    public int getPriority(String remoteEString, IFileService fs) {
        return 1000;
    }
}

