/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.files.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.files.ui.FileResources;
import org.eclipse.rse.internal.files.ui.actions.SystemCopyRemoteFileAction;
import org.eclipse.rse.internal.ui.dialogs.CopyRunnable;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.validators.IValidatorRemoteSelection;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SystemMoveRemoteFileAction
extends SystemCopyRemoteFileAction
implements IValidatorRemoteSelection {
    private SystemMessage targetEqualsSrcMsg = null;
    private SystemMessage targetEqualsParentSrcMsg = null;
    private SystemMessage targetDescendsFromSrcMsg = null;
    private SystemMessage invalidFilterMsg = null;
    protected Vector movedFiles = new Vector();
    protected Vector movedFileNames = new Vector();

    public SystemMoveRemoteFileAction(Shell shell) {
        super(shell, 1);
        this.setHelp("org.eclipse.rse.ui.actn0111");
        this.setDialogHelp("org.eclipse.rse.ui.dmrf0000");
    }

    protected void reset() {
        this.movedFiles.clear();
        super.reset();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        SystemMessage moveMessage = this.getCopyingMessage();
        moveMessage.makeSubstitution((Object)"");
        MoveRemoteFileJob moveRemoteFileJob = new MoveRemoteFileJob(moveMessage.getLevelOneText());
        moveRemoteFileJob.schedule();
    }

    protected boolean doCopy(Object targetContainer, Object oldObject, String newName, IProgressMonitor monitor) throws Exception {
        IRemoteFile targetFolder = (IRemoteFile)targetContainer;
        IRemoteFile srcFileOrFolder = (IRemoteFile)oldObject;
        IRemoteFileSubSystem ss = targetFolder.getParentRemoteFileSubSystem();
        ss.move(srcFileOrFolder, targetFolder, newName, monitor);
        String sep = targetFolder.getSeparator();
        String targetFolderName = targetFolder.getAbsolutePath();
        String resultPath = null;
        resultPath = !targetFolderName.endsWith(sep) ? String.valueOf(targetFolderName) + sep + newName : String.valueOf(targetFolderName) + newName;
        this.copiedFiles.addElement(resultPath);
        this.movedFiles.add(srcFileOrFolder);
        return true;
    }

    public SystemMessage isValid(IHost selectedConnection, Object[] selectedObjects, ISystemRemoteElementAdapter[] remoteAdaptersForSelectedObjects) {
        ISystemFilterReference filter;
        String[] filterStrings;
        String firstFilterString;
        IRemoteFile[] files = this.getSelectedFiles();
        Object selectedObject = selectedObjects[0];
        if (!(selectedObject instanceof IRemoteFile) && !(selectedObject instanceof ISystemFilterReference) || files == null) {
            return null;
        }
        if (selectedObject instanceof IRemoteFile) {
            IRemoteFile selectedFolder = (IRemoteFile)selectedObject;
            String selectedFolderPath = selectedFolder.getAbsolutePath();
            int i = 0;
            while (i < files.length) {
                IRemoteFile selectedFile = files[i];
                if (selectedFile != null && selectedFile.getParentRemoteFile() != null) {
                    IRemoteFile selectedParentFile = selectedFile.getParentRemoteFile();
                    if (selectedFolderPath.equals(selectedParentFile.getAbsolutePath())) {
                        if (this.targetEqualsParentSrcMsg == null) {
                            this.targetEqualsParentSrcMsg = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEF1314", 4, FileResources.FILEMSG_MOVE_TARGET_EQUALS_PARENT_OF_SOURCE, FileResources.FILEMSG_MOVE_TARGET_EQUALS_PARENT_OF_SOURCE_DETAILS);
                        }
                        return this.targetEqualsParentSrcMsg;
                    }
                    if (selectedFolderPath.equals(selectedFile.getAbsolutePath())) {
                        if (this.targetEqualsSrcMsg == null) {
                            this.targetEqualsSrcMsg = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEF1308", 4, FileResources.FILEMSG_MOVE_TARGET_EQUALS_SOURCE, FileResources.FILEMSG_MOVE_TARGET_EQUALS_SOURCE_DETAILS);
                        }
                        return this.targetEqualsSrcMsg;
                    }
                    if (selectedFolder.isDescendantOf(selectedFile)) {
                        if (this.targetDescendsFromSrcMsg == null) {
                            this.targetDescendsFromSrcMsg = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEF1312", 4, FileResources.FILEMSG_MOVE_TARGET_DESCENDS_FROM_SOURCE, FileResources.FILEMSG_MOVE_TARGET_DESCENDS_FROM_SOURCE_DETAILS);
                        }
                        return this.targetDescendsFromSrcMsg;
                    }
                }
                ++i;
            }
        } else if (selectedObject instanceof ISystemFilterReference && ((firstFilterString = (filterStrings = (filter = (ISystemFilterReference)selectedObject).getReferencedFilter().getFilterStrings())[0]).equals("*") || firstFilterString.equals("/*"))) {
            if (this.invalidFilterMsg == null) {
                this.invalidFilterMsg = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEF1313", 4, FileResources.FILEMSG_MOVE_FILTER_NOT_VALID, FileResources.FILEMSG_MOVE_FILTER_NOT_VALID_DETAILS);
            }
            return this.invalidFilterMsg;
        }
        return null;
    }

    public void copyComplete(String operation) {
        IRemoteFileSubSystem fileSS = this.targetFolder.getParentRemoteFileSubSystem();
        if (operation == null) {
            operation = "MOVE";
        }
        Viewer originatingViewer = this.getViewer();
        RSECorePlugin.getTheSystemRegistry().fireRemoteResourceChangeEvent(operation, 2, (Object)this.movedFiles, (Object)this.firstSelectionParent.getAbsolutePath(), (ISubSystem)fileSS, this.getOldAbsoluteNames(), (Object)originatingViewer);
        super.copyComplete(operation);
    }

    static /* synthetic */ SystemMessage access$0(SystemMoveRemoteFileAction systemMoveRemoteFileAction) {
        return systemMoveRemoteFileAction.getCopyingMessage();
    }

    static /* synthetic */ Object[] access$1(SystemMoveRemoteFileAction systemMoveRemoteFileAction) {
        return systemMoveRemoteFileAction.oldObjects;
    }

    static /* synthetic */ void access$2(SystemMoveRemoteFileAction systemMoveRemoteFileAction, boolean bl) {
        systemMoveRemoteFileAction.copiedOk = bl;
    }

    static /* synthetic */ String[] access$3(SystemMoveRemoteFileAction systemMoveRemoteFileAction) {
        return systemMoveRemoteFileAction.oldNames;
    }

    static /* synthetic */ void access$4(SystemMoveRemoteFileAction systemMoveRemoteFileAction, String[] stringArray) {
        systemMoveRemoteFileAction.newNames = stringArray;
    }

    static /* synthetic */ boolean access$5(SystemMoveRemoteFileAction systemMoveRemoteFileAction) {
        return systemMoveRemoteFileAction.copiedOk;
    }

    static /* synthetic */ Object access$6(SystemMoveRemoteFileAction systemMoveRemoteFileAction) {
        return systemMoveRemoteFileAction.targetContainer;
    }

    static /* synthetic */ SystemMessage access$7(SystemMoveRemoteFileAction systemMoveRemoteFileAction, String string) {
        return systemMoveRemoteFileAction.getCopyingMessage(string);
    }

    static /* synthetic */ String[] access$8(SystemMoveRemoteFileAction systemMoveRemoteFileAction) {
        return systemMoveRemoteFileAction.newNames;
    }

    static /* synthetic */ Shell access$9(SystemMoveRemoteFileAction systemMoveRemoteFileAction) {
        return systemMoveRemoteFileAction.shell;
    }

    private class MoveRemoteFileJob
    extends WorkspaceJob {
        public MoveRemoteFileJob(String message) {
            super(message);
            this.setUser(true);
        }

        /*
         * Unable to fully structure code
         */
        public IStatus runInWorkspace(IProgressMonitor monitor) {
            block12: {
                msg = SystemMoveRemoteFileAction.access$0(SystemMoveRemoteFileAction.this);
                status = Status.OK_STATUS;
                existing = new ArrayList<Object>();
                toCopy = new ArrayList<Object>();
                overwrite = false;
                steps = SystemMoveRemoteFileAction.access$1(SystemMoveRemoteFileAction.this).length;
                monitor.beginTask(msg.getLevelOneText(), steps);
                SystemMoveRemoteFileAction.access$2(SystemMoveRemoteFileAction.this, true);
                oldName = null;
                newName = null;
                oldObject = null;
                SystemMoveRemoteFileAction.access$4(SystemMoveRemoteFileAction.this, new String[SystemMoveRemoteFileAction.access$3(SystemMoveRemoteFileAction.this).length]);
                idx = 0;
                while (SystemMoveRemoteFileAction.access$5(SystemMoveRemoteFileAction.this) && idx < steps) {
                    oldName = SystemMoveRemoteFileAction.access$3(SystemMoveRemoteFileAction.this)[idx];
                    oldObject = SystemMoveRemoteFileAction.access$1(SystemMoveRemoteFileAction.this)[idx];
                    if (SystemMoveRemoteFileAction.this.checkForCollision(SystemMoveRemoteFileAction.this.getShell(), monitor, SystemMoveRemoteFileAction.access$6(SystemMoveRemoteFileAction.this), oldName)) {
                        existing.add(oldObject);
                    }
                    toCopy.add(oldObject);
                    ++idx;
                }
                if (existing.size() > 0) {
                    cr = new CopyRunnable(existing);
                    Display.getDefault().syncExec((Runnable)cr);
                    overwrite = cr.getOk();
                    if (!overwrite) {
                        status = Status.CANCEL_STATUS;
                    }
                }
                if (existing.size() == 0 || overwrite) {
                    block11: {
                        try {
                            idx = 0;
                            while (SystemMoveRemoteFileAction.access$5(SystemMoveRemoteFileAction.this) && idx < steps) {
                                newName = SystemMoveRemoteFileAction.access$3(SystemMoveRemoteFileAction.this)[idx];
                                oldObject = SystemMoveRemoteFileAction.access$1(SystemMoveRemoteFileAction.this)[idx];
                                monitor.subTask(SystemMoveRemoteFileAction.access$7(SystemMoveRemoteFileAction.this, newName).getLevelOneText());
                                SystemMoveRemoteFileAction.access$2(SystemMoveRemoteFileAction.this, SystemMoveRemoteFileAction.this.doCopy(SystemMoveRemoteFileAction.access$6(SystemMoveRemoteFileAction.this), oldObject, newName, monitor));
                                monitor.worked(1);
                                SystemMoveRemoteFileAction.access$8((SystemMoveRemoteFileAction)SystemMoveRemoteFileAction.this)[idx] = newName;
                                SystemMoveRemoteFileAction.this.movedFileNames.add(newName);
                                monitor.done();
                                ++idx;
                            }
                        }
                        catch (SystemMessageException exc) {
                            SystemMoveRemoteFileAction.access$2(SystemMoveRemoteFileAction.this, false);
                            if (!monitor.isCanceled() || SystemMoveRemoteFileAction.this.movedFileNames.size() <= 0) break block11;
                            movedFileNamesList = (String)SystemMoveRemoteFileAction.this.movedFileNames.get(0);
                            i = 1;
                            ** while (i < SystemMoveRemoteFileAction.this.movedFileNames.size())
                        }
lbl-1000:
                        // 1 sources

                        {
                            movedFileNamesList = String.valueOf(movedFileNamesList) + "\n" + (String)SystemMoveRemoteFileAction.this.movedFileNames.get(i);
                            ++i;
                            continue;
                        }
lbl55:
                        // 1 sources

                        msgTxt = FileResources.FILEMSG_MOVE_INTERRUPTED;
                        msgDetails = NLS.bind((String)FileResources.FILEMSG_MOVE_INTERRUPTED_DETAILS, (Object)movedFileNamesList);
                        thisMessage = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEG1245", 4, msgTxt, msgDetails);
                        SystemMessageDialog.displayErrorMessage((Shell)SystemMoveRemoteFileAction.access$9(SystemMoveRemoteFileAction.this), (SystemMessage)thisMessage);
                        status = Status.CANCEL_STATUS;
                        break block12;
                    }
                    SystemMessageDialog.displayErrorMessage((Shell)SystemMoveRemoteFileAction.access$9(SystemMoveRemoteFileAction.this), (SystemMessage)exc.getSystemMessage());
                    break block12;
                    catch (Exception exc) {
                        SystemMoveRemoteFileAction.access$2(SystemMoveRemoteFileAction.this, false);
                        exc.printStackTrace();
                    }
                }
            }
            if (SystemMoveRemoteFileAction.this.movedFiles.size() > 0) {
                SystemMoveRemoteFileAction.this.copyComplete("MOVE");
            }
            return status;
        }
    }
}

