/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.subsystems.shells;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.shells.HostShellProcessAdapter;
import org.eclipse.rse.services.shells.IHostOutput;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IHostShellOutputListener;
import org.eclipse.rse.services.shells.IShellService;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.IShellServiceSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.ShellServiceSubSystem;
import org.eclipse.rse.tests.core.connection.RSEBaseConnectionTestCase;
import org.eclipse.rse.tests.subsystems.shells.ShellOutputListener;

public class ShellServiceTest
extends RSEBaseConnectionTestCase {
    protected String fPropertiesFileName;
    public static String fDefaultPropertiesFile = "localConnection.properties";
    protected IShellServiceSubSystem shellSubSystem;
    protected IShellService shellService;
    protected IProgressMonitor mon = new NullProgressMonitor();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ShellServiceTest(String name) {
        this(name, fDefaultPropertiesFile);
    }

    public ShellServiceTest(String name, String propertiesFileName) {
        super(name);
        this.fPropertiesFileName = propertiesFileName;
        if (propertiesFileName != null) {
            int idx = propertiesFileName.indexOf("Connection.properties");
            String targetName = propertiesFileName.substring(0, idx);
            this.setTargetName(targetName);
        }
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.shells.ShellServiceTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String baseName = clazz.getName();
        TestSuite suite = new TestSuite(baseName);
        String[] connTypes = new String[]{"local", "ssh", "telnet"};
        int i = 0;
        while (i < connTypes.length) {
            String suiteName = connTypes[i];
            String propFileName = connTypes[i] == null ? null : String.valueOf(connTypes[i]) + "Connection.properties";
            TestSuite subSuite = new TestSuite(String.valueOf(baseName) + "." + suiteName);
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.rse.tests.subsystems.shells.ShellServiceTest");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Method[] m = clazz2.getMethods();
            int j = 0;
            while (j < m.length) {
                String testName = m[j].getName();
                if (testName.startsWith("test")) {
                    subSuite.addTest((Test)new ShellServiceTest(testName, propFileName));
                }
                ++j;
            }
            suite.addTest((Test)subSuite);
            ++i;
        }
        return suite;
    }

    protected IShellServiceSubSystem getShellServiceSubSystem() {
        if (this.fPropertiesFileName == null) {
            return null;
        }
        IHost host = this.getHost(this.fPropertiesFileName);
        ISystemRegistry iSystemRegistry = RSECorePlugin.getTheSystemRegistry();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.rse.services.shells.IShellService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISubSystem[] ss = iSystemRegistry.getServiceSubSystems(host, (Class)clazz);
        int i = 0;
        while (i < ss.length) {
            if (ss[i] instanceof ShellServiceSubSystem) {
                return (ShellServiceSubSystem)ss[i];
            }
            ++i;
        }
        return null;
    }

    public void setUp() throws Exception {
        super.setUp();
        this.initShellService();
    }

    protected void initShellService() throws SystemMessageException {
        this.shellSubSystem = this.getShellServiceSubSystem();
        this.shellService = this.shellSubSystem.getShellService();
        this.shellSubSystem.checkIsConnected(this.getDefaultProgressMonitor());
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public boolean isWindows() {
        return this.shellSubSystem.getHost().getSystemType().isWindows();
    }

    public void testLaunchShell() throws Exception {
        Object[] allOutput = this.launchShell("", "echo test", this.shellService.getHostEnvironment());
        boolean matchFound = false;
        int i = 0;
        while (i < allOutput.length) {
            matchFound = ((IHostOutput)allOutput[i]).getString().equals("test");
            if (matchFound) break;
            ++i;
        }
        ShellServiceTest.assertTrue((String)("Missing output of \"echo test\": " + Arrays.asList(allOutput)), (boolean)matchFound);
        allOutput = this.launchShell("/", "echo test", this.shellService.getHostEnvironment());
        matchFound = false;
        i = 0;
        while (i < allOutput.length) {
            matchFound = ((IHostOutput)allOutput[i]).getString().equals("test");
            if (matchFound) break;
            ++i;
        }
        ShellServiceTest.assertTrue((String)("Missing output of \"echo test\": " + Arrays.asList(allOutput)), (boolean)matchFound);
    }

    public Object[] launchShell(String workingDirectory, String cmd, String[] env) throws SystemMessageException, InterruptedException {
        IHostShell hostShell = this.shellService.launchShell(workingDirectory, env, this.mon);
        ShellServiceTest.assertNotNull((Object)hostShell);
        ShellServiceTest.assertNotNull((Object)hostShell.getStandardOutputReader());
        ShellOutputListener outputListener = new ShellOutputListener();
        hostShell.addOutputListener((IHostShellOutputListener)outputListener);
        hostShell.writeToShell(cmd);
        hostShell.writeToShell("exit");
        while (hostShell.isActive()) {
            Thread.sleep(1000L);
        }
        Object[] allOutput = outputListener.getAllOutput();
        return allOutput;
    }

    public void testRunCommand() throws Exception {
        Object[] allOutput = this.runCommand("", "echo test", new String[0]);
        boolean matchFound = false;
        int i = 0;
        while (i < allOutput.length) {
            System.out.println(((IHostOutput)allOutput[i]).getString());
            matchFound = ((IHostOutput)allOutput[i]).getString().equals("test");
            if (matchFound) break;
            ++i;
        }
        ShellServiceTest.assertTrue((String)"Failed without changing initial working directory", (boolean)matchFound);
        allOutput = this.runCommand("/", "echo test", new String[0]);
        matchFound = false;
        i = 0;
        while (i < allOutput.length) {
            System.out.println(((IHostOutput)allOutput[i]).getString());
            matchFound = ((IHostOutput)allOutput[i]).getString().equals("test");
            if (matchFound) break;
            ++i;
        }
        ShellServiceTest.assertTrue((String)"Failed with changing initial working directory", (boolean)matchFound);
    }

    public Object[] runCommand(String workingDirectory, String cmd, String[] env) throws SystemMessageException, InterruptedException {
        IHostShell hostShell = null;
        hostShell = this.shellService.runCommand(workingDirectory, cmd, env, this.mon);
        ShellOutputListener outputListener = new ShellOutputListener();
        hostShell.addOutputListener((IHostShellOutputListener)outputListener);
        hostShell.writeToShell("exit");
        ShellServiceTest.assertNotNull((Object)hostShell);
        ShellServiceTest.assertNotNull((Object)hostShell.getStandardOutputReader());
        while (hostShell.isActive()) {
            Thread.sleep(1000L);
        }
        Object[] allOutput = outputListener.getAllOutput();
        return allOutput;
    }

    public void testRunCommandViaHostShellProcessAdapter() throws Exception {
        IHostShell hostShell = null;
        String commandSeparator = this.shellSubSystem != null ? this.shellSubSystem.getParentRemoteCmdSubSystemConfiguration().getCommandSeparator() : "\r\n";
        hostShell = this.shellService.runCommand("", "echo test" + commandSeparator + " exit", new String[0], this.mon);
        HostShellProcessAdapter p = null;
        try {
            p = new HostShellProcessAdapter(hostShell);
        }
        catch (Exception e) {
            ShellServiceTest.fail((String)e.getMessage());
            return;
        }
        BufferedReader bufferReader = new BufferedReader(new InputStreamReader(p.getInputStream()));
        boolean matchFound = false;
        try {
            String nextLine;
            while ((nextLine = bufferReader.readLine()) != null) {
                System.out.println(nextLine);
                matchFound = nextLine.equals("test");
                if (matchFound) break;
            }
            bufferReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            ShellServiceTest.fail((String)e.getMessage());
        }
        ShellServiceTest.assertTrue((boolean)matchFound);
    }
}

