/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.subsystems.files;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.SystemStartHere;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.efs.RSEFileStore;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.tests.subsystems.files.FileServiceBaseTest;
import org.eclipse.rse.tests.subsystems.files.FileServiceHelper;

public class FileOutputStreamTestCase
extends FileServiceBaseTest {
    private IHost host = null;
    private IRemoteFile tempDirectory;
    static /* synthetic */ Class class$0;

    public FileOutputStreamTestCase(String name) {
        super(name);
    }

    private IRemoteFileSubSystem getRemoteFileSubSystem(IHost host) {
        IRemoteFileSubSystem fss = null;
        ISystemRegistry sr = SystemStartHere.getSystemRegistry();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.services.files.IFileService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISubSystem[] ss = sr.getServiceSubSystems(host, (Class)clazz);
        int i = 0;
        while (i < ss.length) {
            if (ss[i] instanceof FileServiceSubSystem) {
                fss = (IRemoteFileSubSystem)ss[i];
                return fss;
            }
            ++i;
        }
        return null;
    }

    public void testRSEFileStoreAppendOutputStreamLocal() throws Exception {
        this.host = this.getLocalSystemConnection();
        if (this.isTestDisabled()) {
            return;
        }
        this.outputStreamFileWriting(1);
    }

    public void testRSEFileStoreAppendOutputStreamFTP() throws Exception {
        this.host = this.getFTPHost();
        if (this.isTestDisabled()) {
            return;
        }
        this.outputStreamFileWriting(1);
    }

    public void testRSEFileStoreAppendOutputStreamLinux() throws Exception {
        this.host = this.getLinuxHost();
        if (this.isTestDisabled()) {
            return;
        }
        this.outputStreamFileWriting(1);
    }

    public void testRSEFileStoreAppendOutputStreamWindows() throws Exception {
        this.host = this.getWindowsHost();
        if (this.isTestDisabled()) {
            return;
        }
        this.outputStreamFileWriting(1);
    }

    public void testRSEFileStoreAppendOutputStreamSSH() throws Exception {
        this.host = this.getSSHHost();
        if (this.isTestDisabled()) {
            return;
        }
        this.outputStreamFileWriting(1);
    }

    public void testRSEFileStoreOverwriteOutputStreamLocal() throws Exception {
        this.host = this.getLocalSystemConnection();
        if (this.isTestDisabled()) {
            return;
        }
        this.outputStreamFileWriting(0);
    }

    public void testRSEFileStoreOverwriteOutputStreamFTP() throws Exception {
        this.host = this.getFTPHost();
        if (this.isTestDisabled()) {
            return;
        }
        this.outputStreamFileWriting(0);
    }

    public void testRSEFileStoreOverwriteOutputStreamLinux() throws Exception {
        this.host = this.getLinuxHost();
        if (this.isTestDisabled()) {
            return;
        }
        this.outputStreamFileWriting(0);
    }

    public void testRSEFileStoreOverwriteOutputStreamWindows() throws Exception {
        this.host = this.getWindowsHost();
        if (this.isTestDisabled()) {
            return;
        }
        this.outputStreamFileWriting(0);
    }

    public void testRSEFileStoreOverwriteOutputStreamSSH() throws Exception {
        this.host = this.getSSHHost();
        if (this.isTestDisabled()) {
            return;
        }
        this.outputStreamFileWriting(0);
    }

    public void outputStreamFileWriting(int options) throws Exception {
        IRemoteFile targetDir;
        OutputStream outputStream = null;
        InputStream inputStream = null;
        FileServiceSubSystem inputFss = (FileServiceSubSystem)this.getRemoteFileSubSystem(this.host);
        inputFss.connect((IProgressMonitor)new NullProgressMonitor(), false);
        IRemoteFile homeDirectory = inputFss.getRemoteFileObject(".", (IProgressMonitor)new NullProgressMonitor());
        String baseFolderName = "rsetest";
        String homeFolderName = homeDirectory.getAbsolutePath();
        String testFolderName = FileServiceHelper.getRandomLocation((IFileServiceSubSystem)inputFss, homeFolderName, baseFolderName, (IProgressMonitor)new NullProgressMonitor());
        this.tempDirectory = targetDir = this.createFileOrFolder((IFileServiceSubSystem)inputFss, homeFolderName, testFolderName, true);
        String path = targetDir.getAbsolutePath();
        String systemType = this.host.getSystemType().getLabel();
        if (this.host.getSystemType().isWindows()) {
            path = path.replace('\\', '/');
        }
        path = this.fixPathForURI(path);
        URI uri = new URI("rse", this.host.getHostName(), path, null);
        RSEFileStore parentFS = RSEFileStore.getInstance((URI)uri);
        this.createDir((IFileStore)parentFS, true);
        IFileStore childFS = parentFS.getChild("append.txt");
        outputStream = childFS.openOutputStream(options, (IProgressMonitor)new NullProgressMonitor());
        String contents = this.getRandomString();
        byte[] readBytes = new byte[contents.length()];
        outputStream.write(contents.getBytes());
        outputStream.close();
        inputStream = childFS.openInputStream(0, (IProgressMonitor)new NullProgressMonitor());
        inputStream.read(readBytes);
        String input = new String(readBytes);
        inputStream.close();
        FileOutputStreamTestCase.assertTrue((String)(String.valueOf(systemType) + ": Contents incorrect writing to an empty file.  Expected Contents: " + contents + " Actual Contents: " + input), (boolean)contents.equals(input));
        outputStream = childFS.openOutputStream(options, (IProgressMonitor)new NullProgressMonitor());
        String write = " " + this.getRandomString();
        contents = (options & 1) != 0 ? String.valueOf(contents) + write : write;
        outputStream.write(write.getBytes());
        outputStream.close();
        readBytes = new byte[contents.length()];
        inputStream = childFS.openInputStream(0, (IProgressMonitor)new NullProgressMonitor());
        inputStream.read(readBytes);
        input = new String(readBytes);
        inputStream.close();
        FileOutputStreamTestCase.assertTrue((String)(String.valueOf(systemType) + ": Contents incorrect writing to a non-empty file.  Expected Contents: " + contents + " Actual Contents: " + input), (boolean)contents.equals(input));
        this.cleanup();
    }

    private String fixPathForURI(String path) {
        String sep = PathUtility.getSeparator((String)path);
        if (!sep.equals("/")) {
            path = path.replace(sep.charAt(0), '/');
        }
        int length = path.length();
        StringBuffer pathBuf = new StringBuffer(length + 3);
        if (length > 0 && path.charAt(0) != '/') {
            pathBuf.append('/');
        }
        if (path.startsWith("//")) {
            pathBuf.append('/').append('/');
        }
        pathBuf.append(path);
        return pathBuf.toString();
    }

    public void cleanup() throws Exception {
        if (this.host != null) {
            if (this.tempDirectory != null) {
                IRemoteFileSubSystem fss = this.getRemoteFileSubSystem(this.host);
                fss.delete(this.tempDirectory, (IProgressMonitor)new NullProgressMonitor());
                fss.disconnect();
                this.tempDirectory = null;
            }
            this.getConnectionManager().removeConnection(this.host.getSystemProfile().getName(), this.host.getName());
            this.host = null;
        }
    }

    public void tearDown() throws Exception {
        this.cleanup();
        super.tearDown();
    }
}

