/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.core.filters;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterContainer;
import org.eclipse.rse.core.filters.ISystemFilterContainerReference;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolReference;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManagerProvider;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.model.IRSEPersistableContainer;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.internal.core.filters.SystemFilterContainerReferenceCommonMethods;
import org.eclipse.rse.internal.references.SystemPersistableReferencingObject;

public class SystemFilterPoolReference
extends SystemPersistableReferencingObject
implements ISystemFilterPoolReference,
ISystemFilterContainerReference,
IAdaptable {
    private SystemFilterContainerReferenceCommonMethods containerHelper = new SystemFilterContainerReferenceCommonMethods(this);
    private ISystemFilterPoolManager filterPoolManager = null;
    public static final String DELIMITER = "___";
    public static final int DELIMITER_LENGTH = 3;

    private SystemFilterPoolReference() {
    }

    public SystemFilterPoolReference(ISystemFilterPool filterPool) {
        this();
        this.setReferenceToFilterPool(filterPool);
    }

    public SystemFilterPoolReference(String filterPoolName) {
        this();
        this.setReferencedObjectName(filterPoolName);
    }

    public ISystemFilterPoolReferenceManager getFilterPoolReferenceManager() {
        return (ISystemFilterPoolReferenceManager)this.getParentReferenceManager();
    }

    public ISystemFilterPoolReferenceManagerProvider getProvider() {
        ISystemFilterPoolReferenceManager mgr = this.getFilterPoolReferenceManager();
        if (mgr != null) {
            return mgr.getProvider();
        }
        return null;
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public String getReferencedFilterPoolName() {
        String savedName = this.getReferencedObjectName();
        String[] parts = savedName.split(DELIMITER, 2);
        String result = parts[0];
        if (parts.length == 2) {
            result = parts[1];
        }
        return result;
    }

    public String getReferencedFilterPoolManagerName() {
        String result = null;
        String savedName = this.getReferencedObjectName();
        String[] parts = savedName.split(DELIMITER, 2);
        if (parts.length == 2) {
            result = parts[0];
        } else {
            ISystemFilterPoolReferenceManagerProvider provider = this.getProvider();
            if (provider instanceof ISubSystem) {
                ISubSystem subsystem = (ISubSystem)provider;
                ISystemProfile profile = subsystem.getSystemProfile();
                result = profile.getName();
            }
        }
        if (result == null) {
            RSECorePlugin.getDefault().getLogger().logWarning("Unexpected condition: filter pool manager name not found.", null);
        }
        return result;
    }

    public void resetReferencedFilterPoolName(String newName) {
        super.setReferencedObjectName(newName);
    }

    public void setReferenceToFilterPool(ISystemFilterPool pool) {
        super.setReferencedObject(pool);
    }

    public ISystemFilterPool getReferencedFilterPool() {
        ISystemFilterPool filterPool = (ISystemFilterPool)this.getReferencedObject();
        if (filterPool == null) {
            String filterPoolName = this.getReferencedFilterPoolName();
            String profileName = this.getReferencedFilterPoolManagerName();
            ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
            ISystemProfile profile = registry.getSystemProfile(profileName);
            if (profile != null) {
                ISubSystem subsystem = (ISubSystem)this.getProvider();
                ISubSystemConfiguration config = subsystem.getSubSystemConfiguration();
                this.filterPoolManager = config.getFilterPoolManager(profile);
                filterPool = this.filterPoolManager.getSystemFilterPool(filterPoolName);
                if (filterPool == null) {
                    ISystemFilterPool[] candidatePools = profile.getFilterPools();
                    int i = 0;
                    while (i < candidatePools.length) {
                        ISystemFilterPool candidatePool = candidatePools[i];
                        String candidatePoolName = candidatePool.getName();
                        if (candidatePoolName.equals(filterPoolName)) {
                            filterPool = candidatePool;
                            break;
                        }
                        ++i;
                    }
                }
            }
            if (filterPool != null) {
                this.setReferenceToFilterPool(filterPool);
                this.setReferenceBroken(false);
            } else {
                this.setReferenceBroken(true);
            }
        }
        return filterPool;
    }

    public ISystemFilterContainer getReferencedSystemFilterContainer() {
        return this.getReferencedFilterPool();
    }

    public ISystemFilterReference[] getSystemFilterReferences(ISubSystem subSystem) {
        List references = this.containerHelper.getSystemFilterReferences(subSystem);
        ISystemFilterReference[] result = new ISystemFilterReference[references.size()];
        references.toArray(result);
        return result;
    }

    public ISystemFilterReference getSystemFilterReference(ISubSystem subSystem, ISystemFilter filter) {
        return this.containerHelper.generateAndRecordFilterReference(subSystem, filter);
    }

    public ISystemFilterReference getExistingSystemFilterReference(ISubSystem subSystem, ISystemFilter filter) {
        return this.containerHelper.getExistingSystemFilterReference(subSystem, filter);
    }

    public boolean hasFilters() {
        return this.containerHelper.hasFilters();
    }

    public int getFilterCount() {
        return this.containerHelper.getFilterCount();
    }

    public String getName() {
        return this.getReferencedFilterPoolName();
    }

    public String getFullName() {
        return this.getReferencedObjectName();
    }

    public boolean commit() {
        return false;
    }

    public IRSEPersistableContainer getPersistableParent() {
        IRSEPersistableContainer parent = null;
        ISystemFilterPoolReferenceManagerProvider provider = this.getProvider();
        if (provider instanceof IRSEPersistableContainer) {
            parent = (IRSEPersistableContainer)((Object)provider);
        }
        return parent;
    }

    public IRSEPersistableContainer[] getPersistableChildren() {
        return IRSEPersistableContainer.NO_CHILDREN;
    }
}

