/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.files.core.subsystems;

import java.util.Vector;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileFilterString;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileContext;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;

public class RemoteFileContext
implements IRemoteFileContext {
    protected IRemoteFileSubSystem subsystem;
    protected IRemoteFile parentFile;
    protected RemoteFileFilterString filterString;
    protected Vector allFilterStrings;

    public RemoteFileContext(IRemoteFileSubSystem subsystem, IRemoteFile parentFileObject, RemoteFileFilterString filterString) {
        this.subsystem = subsystem;
        this.parentFile = parentFileObject;
        this.filterString = filterString;
    }

    public RemoteFileContext() {
    }

    public void setParentRemoteFileSubSystem(IRemoteFileSubSystem subsystem) {
        this.subsystem = subsystem;
    }

    public void setParentRemoteFile(IRemoteFile parentFileObject) {
        this.parentFile = parentFileObject;
    }

    public void setFilterString(RemoteFileFilterString filterString) {
        this.filterString = filterString;
        this.allFilterStrings = null;
    }

    public void addFilterString(RemoteFileFilterString additionalFilterString) {
        if (this.allFilterStrings == null) {
            this.allFilterStrings = new Vector();
            if (this.filterString != null) {
                this.allFilterStrings.addElement(this.filterString);
            }
        }
        boolean match = false;
        String newfs = additionalFilterString.toString();
        int idx = 0;
        while (!match && idx < this.allFilterStrings.size()) {
            RemoteFileFilterString prevfs = (RemoteFileFilterString)this.allFilterStrings.elementAt(idx);
            if (newfs.equals(prevfs.toString())) {
                match = true;
            }
            ++idx;
        }
        if (!match) {
            this.allFilterStrings.addElement(additionalFilterString);
        }
    }

    public IRemoteFileSubSystem getParentRemoteFileSubSystem() {
        return this.subsystem;
    }

    public IRemoteFile getParentRemoteFile() {
        return this.parentFile;
    }

    public RemoteFileFilterString getFilterString() {
        return this.filterString;
    }

    public RemoteFileFilterString[] getAllFilterStrings() {
        if (this.allFilterStrings == null) {
            return new RemoteFileFilterString[]{this.filterString};
        }
        RemoteFileFilterString[] all = new RemoteFileFilterString[this.allFilterStrings.size()];
        int idx = 0;
        while (idx < all.length) {
            all[idx] = (RemoteFileFilterString)this.allFilterStrings.elementAt(idx);
            ++idx;
        }
        return all;
    }
}

